#!/usr/bin/perl

die "usage: ptype.pl <file.c>" unless ($#ARGV >= 0);

$file = $ARGV[0];
($hdr = $file) =~ s/\.c$/\.h/;

open (FILE, "$file") or die "cannot open $file";

while (<FILE>) {
   next unless (/^([a-zA-Z][a-zA-Z\s\t]+)\s+([\*\w]+)\s*\((.*)\)\s+\{/);
   
   next if ($1 =~ /static/);
   next if ($2 =~ /preferences_button_cb/);
   
   push @funcs, "$1|$2|$3";
}

close FILE;

open (HDR, "$hdr") or die "cannot open $hdr";

$ptype = 0;
while (<HDR>) {
   chomp;
   
   $line = $_;
 
   $ptype = 0 if ($line =~ /^\/\* \!prototypes \*\/$/);
   
   next if ($ptype);
   
   $ptype = 1 if ($line =~ /^\/\* prototypes \*\/$/);
   
   push @stuff, $line;
}

close HDR;

open (HDR, ">$hdr~") or die "cannot open $hdr~";

foreach $s (@stuff) {
   print HDR "$s\n";
   
   if ($s =~ /^\/\* prototypes \*\/$/) {
       foreach $func (@funcs) {
          printf HDR "%s %s(%s);\n", split(/\|/, $func);
       }
   }
}

close HDR;

rename("$hdr~", "$hdr");
