#include "gnapster.h"

extern UserInfo user_info;

#ifndef HAVE_GNOME
extern GtkItemFactory *search_popup_menu;
#else
static GnomeUIInfo search_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Download"), NULL, search_download_cb,
			  GNOME_STOCK_MENU_NEW),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_ITEM_STOCK(N_("Whois user"), NULL, whois_user_menu_cb,
			  GNOME_STOCK_MENU_INDEX),
   GNOMEUIINFO_END,
};
#endif /* ! HAVE_GNOME */

extern GnapsterMain *gmain;

void searchtab_load_history(GtkWidget *w, void *data) {
   char *s;
   GList *m, *results;
   int pos;
   
   d_assert(data != NULL);
   
   s = data;
   
   d_free(GET_DATA(gmain->st->history, "lsearch"));
   SET_DATA(gmain->st->history, "lsearch", d_strdup(s));
   
   gtk_clist_clear(GTK_CLIST(gmain->st->clist));
   
   m = g_list_find_custom(gmain->sresults, s, search_find);
   d_assert(m != NULL);
   
   pos = g_list_position(gmain->sresults, m);
   results = g_list_nth_data(gmain->sdata, pos);
   g_list_foreach(results, searchtab_load_result, NULL);
   
/*   gtk_option_menu_set_history(GTK_OPTION_MENU(gmain->st->history),
			       pos);*/
   
   search_sort_results(gmain->st->clist);
}

void searchtab_free_result(void *data, void *ud) {
   Search *s;
   
   d_assert(data != NULL);
   
   s = data;
   j_free(N_SEARCH, s);
}

void searchtab_load_result(void *data, void *ud) {
   Search *s;
   
   d_assert(data != NULL);
   
   s = data;
   insert_search_result(gmain->st, search_copy(s), 0);
}

SearchTab *create_search_tab(GtkWidget *notebook) {
   int w;   
   char *titles[] = { _("Filename"), _("Connection"), _("User"), _("Size"), _("Length"), _("Kbps"), NULL };
   SearchTab *st;
   
   w = j_config_get_int("/gnapster/Geometry/w");
   
   st = d_new(SEARCH_TAB);

   st->vbox = gtk_vbox_new(FALSE, 5);

   st->hbox = j_line_new(st->vbox, 0, 0);
   
   st->label = gtk_label_new(_("Search: "));
   j_box_pack(st->hbox, st->label, 0, 0, 0);
   
   st->entry = j_entry_new("gnapster_search");
   st->gtk_entry = j_entry_gtk_entry(st->entry);
   gtk_signal_connect(GTK_OBJECT(st->gtk_entry), "activate",
		      GTK_SIGNAL_FUNC(search_activate_cb), NULL);
   j_box_pack(st->hbox, st->entry, 1, 1, 0);
   
   st->not_label = gtk_label_new(_(" NOT "));
   j_box_pack(st->hbox, st->not_label, 0, 0, 0);
/*   gtk_widget_hide(st->not_label);*/

   st->not_entry = j_entry_new("gnapster_notsearch");
   st->gtk_not_entry = j_entry_gtk_entry(st->not_entry);
   gtk_signal_connect(GTK_OBJECT(st->gtk_not_entry), "activate",
		      GTK_SIGNAL_FUNC(search_activate_cb), NULL);
   gtk_box_pack_start(GTK_BOX(st->hbox), st->not_entry,
		      TRUE, TRUE, 0);
/*   gtk_widget_hide(st->not_entry);*/
   
   st->ext_entry = gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY(st->ext_entry), "mp3");
   gtk_signal_connect(GTK_OBJECT(st->ext_entry), "activate",
		      GTK_SIGNAL_FUNC(search_activate_cb), NULL);
   j_box_pack(st->hbox, st->ext_entry, 0, 0, 0);

   st->search_btn = gtk_button_new_with_label(_("Search"));
   gtk_signal_connect(GTK_OBJECT(st->search_btn), "clicked",
		      GTK_SIGNAL_FUNC(search_click_cb), NULL);
   gtk_box_pack_start(GTK_BOX(st->hbox), st->search_btn,
		      FALSE, FALSE, 0);
   
   st->cancel_btn = gtk_button_new_with_label(_("Cancel"));
   gtk_signal_connect(GTK_OBJECT(st->cancel_btn), "clicked",
		      GTK_SIGNAL_FUNC(cancel_search_cb), NULL);
/*   j_box_pack(st->hbox, st->cancel_btn, 0, 0, 0);*/
   
   st->hbox = j_line_new(st->vbox, 0, 0);

   j_label_new(st->hbox, _("History: "));
   
   st->history = gtk_option_menu_new();
   st->hist_menu = gtk_menu_new();
   gtk_widget_set_usize(st->history, 200, -1);
/*   gtk_option_menu_set_menu(GTK_OPTION_MENU(st->history), st->hist_menu);*/
   j_box_pack(st->hbox, st->history, 1, 1, 0);
   
/*   st->broadcast = gtk_check_button_new_with_label(_("Broadcast"));
   config_toggle_widget(st->broadcast, "broadcast", NULL);
   j_box_pack(st->hbox, st->broadcast, 0, 0, 0);*/

   st->line_speed_switch = gtk_check_button_new_with_label("Line Speed:");
   j_box_pack(st->hbox, st->line_speed_switch, 0, 0, 0);
   
   st->line_speed_cmp = j_combo_new(0, "At least", "Equal to", "At best", NULL);
   gtk_widget_set_usize(st->line_speed_cmp, 75, -1);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(st->line_speed_cmp)->entry),
		      listint_to_str(user_info.conf[LINE_SPEED_CMP], 0));
   config_combo_widget(st->line_speed_cmp, "line_speed_cmp");
   j_box_pack(st->hbox, st->line_speed_cmp, 0, 0, 0);

   st->line_speed = j_combo_new(0, "Unknown", "14.4", "28.8", "33.6",
				"56k", "64k ISDN", "128k ISDN", "Cable",
				"DSL", "T1", "T3+", NULL);
   gtk_widget_set_usize(st->line_speed, 100, -1);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(st->line_speed)->entry),
		      listint_to_str(user_info.conf[LINE_SPEED], 1));
   config_combo_widget(st->line_speed, "line_speed");
   j_box_pack(st->hbox, st->line_speed, 0, 0, 0);   

   config_toggle_widget(st->line_speed_switch, "line_speed_switch",
			st->line_speed_cmp, st->line_speed, NULL);
   
   st->bitrate_switch = gtk_check_button_new_with_label("Bitrate:");
   j_box_pack(st->hbox, st->bitrate_switch, 0, 0, 0);

   st->bitrate_cmp = j_combo_new(0, "At least", "Equal to", "At best",
					NULL);
   gtk_widget_set_usize(st->bitrate_cmp, 75, -1);
   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(st->bitrate_cmp)->entry),
		      (user_info.conf[BITRATE_CMP] == 0) ? "At least" : 
		      (user_info.conf[BITRATE_CMP] == 1) ? "Equal to" :
		      "At best");
   config_combo_widget(st->bitrate_cmp, "bitrate_cmp");
   j_box_pack(st->hbox, st->bitrate_cmp, 0, 0, 0);
   
   st->bitrate = j_combo_new(0, "96", "112", "128", "160", "192", NULL);
   gtk_widget_set_usize(st->bitrate, 50, -1);
     {
	char *array[] = { "96", "112", "128", "160", "192", NULL };
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(st->bitrate)->entry),
			   array[user_info.conf[BITRATE]]);
     }
   config_combo_widget(st->bitrate, "bitrate");
   j_box_pack(st->hbox, st->bitrate, 0, 0, 0);
   
   config_toggle_widget(st->bitrate_switch, "bitrate_switch",
			st->bitrate_cmp, st->bitrate, NULL);

/*   st->local_only = gtk_check_button_new_with_label("Search local server only");
   config_toggle_widget(st->local_only, "search_local", NULL);
   j_box_pack(st->hbox, st->local_only, 0, 0, 0);*/
   
   st->hbox = j_line_new(st->vbox, 1, 1);
   
   st->scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(st->scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(st->hbox), st->scroller,
		      TRUE, TRUE, 0);
   
   st->clist = gtk_clist_new_with_titles(6, titles);
   gtk_clist_set_compare_func(GTK_CLIST(st->clist),
			      (GtkCListCompareFunc)compare_connection);
   gtk_clist_set_sort_column(GTK_CLIST(st->clist), 1);
   gtk_clist_set_selection_mode(GTK_CLIST(st->clist),
				GTK_SELECTION_EXTENDED);
   gtk_clist_set_column_width(GTK_CLIST(st->clist), 0, 310 + (w - DEFAULT_WIDTH));
   gtk_clist_set_column_width(GTK_CLIST(st->clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(st->clist), 3, 40);
/*   GTK_CLIST(st->clist)->button_actions[2] = GTK_BUTTON_SELECTS;*/
   gtk_container_add(GTK_CONTAINER(st->scroller), st->clist);
   gtk_signal_connect(GTK_OBJECT(st->clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), search_popup_menu);
   gtk_signal_connect(GTK_OBJECT(st->clist), "click-column",
		      GTK_SIGNAL_FUNC(search_sort), NULL);

   gtk_widget_set_sensitive(st->line_speed_cmp, user_info.conf[LINE_SPEED_SWITCH]);
   gtk_widget_set_sensitive(st->line_speed, user_info.conf[LINE_SPEED_SWITCH]);
   gtk_widget_set_sensitive(st->bitrate_cmp, user_info.conf[BITRATE_SWITCH]);
   gtk_widget_set_sensitive(st->bitrate, user_info.conf[BITRATE_SWITCH]);

   gtk_container_set_border_width(GTK_CONTAINER(st->vbox), 5);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			    st->vbox, gtk_label_new(_("Search")));
   
   return st;
}

