#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <stdlib.h>

#include "gnapster.h"
#include "upload.h"
#include "commands.h"
#include "download.h"
#include "queue.h"
#include "napigator.h"

#include "servers.h"

extern BrowseDlg browse_dlg;
extern AddDlg add_dlg;
extern EditDlg edit_dlg;
extern RefreshDlg refresh_dlg;


void server_links_cb() {
   STab *stab;
   
   stab = get_current_stab();
   d_assert(stab != NULL);
   
   napster_send(stab->ci->sock, CMDS_SERVERLINKS, NULL);
}

/* this logic is kinda fuzzy.  if we have a checksum supplied (non-opennap)
 * the routines using this will require size & md5 match, if we are on opennap
 * only a size match is required */
int match_checksum(char *it, char *md5) {
   int zero;
   char *ptr;
   
   for(zero=0, ptr=it; *ptr && (*ptr == '0'); ptr++)
     zero++;
   
   /* if the md5 is zero'd (opennap) then we matched */
   if (zero == strlen(it))
     return 1;
   
   return (strcmp(it, md5) == 0);
}

void browse_opennap_cb() {
   if (dialog_open(browse_dlg.window))
     return;
   
   create_browse_dlg();
}

void browse_dlg_connect_cb(GtkWidget *w, void *data) {
   GtkCList *clist;
   Server *nsrv;
   ConnInfo *ci;
   Account *acnt;
   STab *stab;
   
   stab = get_current_stab();
   ci = stab->ci;

   clist = GTK_CLIST(browse_dlg.ctree);

   if (w) {
      nsrv = gnapster_get_ctree_selection_data(GTK_WIDGET(clist), NULL);
      
      if (!nsrv)
	return;

      if (connected(ci) || connecting(ci)) {
	 already_connected(stab, nsrv);
	 return;
      }
   } else
     nsrv = data;

   if (!nsrv)
     return;
   
   acnt = get_account(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(browse_dlg.account)->entry)));
   if (!acnt)
     return;
   
   set_conn_info(stab, nsrv->ip, nsrv->port, nsrv->desc, acnt);
   
   ci->state |= CONNECTING_MASK;
   ci->state &= ~CONNECTED_MASK;

   update_status(1, stab, _("Connecting to server..."), 1);
   
   napster_connect(stab, ci->ip, ci->port);

/*   browse_dlg_cancel_cb();*/
}

void browse_dlg_cancel_cb() {
   gtk_clist_clear(GTK_CLIST(browse_dlg.ctree));
/*   gtk_clist_clear(GTK_CLIST(browse_dlg.ctree_mem));*/
   j_dialog_close(browse_dlg.window);
}

void browse_dlg_add() {
   if (dialog_open(add_dlg.window))
     return;
   
   create_add_dlg();
   j_dialog_run(add_dlg.window, 0);
}

void browse_dlg_edit() {
   Server *nsrv;
   
   if (dialog_open(edit_dlg.window))
     return;

   nsrv = gnapster_get_ctree_selection_data(browse_dlg.ctree, NULL);
   if (!nsrv)
     return;

   create_edit_dlg(nsrv, nsrv->desc);
   j_dialog_run(edit_dlg.window, 0);
}

void browse_dlg_delete(GtkWidget *w, int *data) {
   FILE *f;
   char *ipport, *dptr, cmp[1024];
   GList *ptr, *felem;
   FileEntry *fent;
   Server *nsrv;
   
   f = open_servers("r");
   if (!f)
     return;
   
   nsrv = gnapster_get_ctree_selection_data(browse_dlg.ctree, NULL);
   
   if (!nsrv)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   f = open_servers("w");
   
   g_snprintf(cmp, sizeof(cmp), "%s:%i",
	      nsrv->ip, nsrv->port);
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      ipport = next_arg(dptr, &dptr);
      
      NA_ERR_HANDLE_CONTINUE();
      
      if (strcmp(ipport, cmp))
	fprintf(f, "%s %s\n", ipport, last_arg(dptr, &dptr));
   }
   
   fclose(f);

   read_file_free(felem);
   
   if (!data)
     populate_browse_dlg_clist();
}

GtkCTreeNode *server_find(GtkWidget *widget, Server *nsrv) {
   GtkCTreeNode *node;
   char *buf;
   
   node = GTK_CTREE_NODE(GTK_CLIST(widget)->row_list);
   
   while(node) {
      buf = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
      if (!strcmp(buf, nsrv->network))
	return node;
      
      node = GTK_CTREE_ROW(node)->sibling;
   }
   
   return NULL;
}

void add_server_stats(GtkWidget *ctree, GtkCTreeNode *node, Server *nsrv) {
   Server *network;
   
   network = gtk_ctree_node_get_row_data(GTK_CTREE(ctree), node);
   
   network->users += nsrv->users;
   network->files += nsrv->files;
   network->gigs += nsrv->gigs;
}

void server_show_avg(GtkWidget *widget) {
   GtkCTreeNode *node, *child;
   Server *network;
   char *s;
   int count = 0;
   
   for(node=GTK_CTREE_NODE(GTK_CLIST(widget)->row_list);
       node; node=GTK_CTREE_ROW(node)->sibling) {
      network = gtk_ctree_node_get_row_data(GTK_CTREE(widget), node);
      
      count = 0;
      
      if (GTK_CTREE_ROW(node)->children) {
	 for(child=GTK_CTREE_ROW(node)->children;
	     child; child=GTK_CTREE_ROW(child)->sibling)
	   count++;
      }
      
      if (!count)
	count++;
      
      d_msprintf(&s, "%i", network->users / count);      
      gtk_ctree_node_set_text(GTK_CTREE(widget), node, 2, s);
      d_free(s);
      
      d_msprintf(&s, "%i", network->files / count);
      gtk_ctree_node_set_text(GTK_CTREE(widget), node, 3, s);
      d_free(s);
      
      d_msprintf(&s, "%i", network->gigs / count);
      gtk_ctree_node_set_text(GTK_CTREE(widget), node, 4, s);
      d_free(s);
   }
}

void server_show(GtkWidget *widget, Server *nsrv) {
   GtkCTreeNode *node = NULL;
   Server *network = NULL;
   char *text[6];
   int leaf;
   
   memset(text, 0, sizeof(text));
   
   node = server_find(widget, nsrv);
   
   leaf = node ? 1 : 0;
   
   if (leaf) {
      text[0] = nsrv->desc;
      text[1] = nsrv->ip;
      d_msprintf(&text[2], "%lu", nsrv->users);
      d_msprintf(&text[3], "%lu", nsrv->files);
      d_msprintf(&text[4], "%lu", nsrv->gigs);
      
      add_server_stats(widget, node, nsrv);
   } else
     text[0] = nsrv->network;
   
   node = gtk_ctree_insert_node(GTK_CTREE(widget), node, NULL, text, 0, NULL, 
				NULL, NULL, NULL, leaf, 0);
   
   if (!leaf)
     network = d_new(SERVER);
   
   gtk_ctree_node_set_row_data_full(GTK_CTREE(widget),
				    node, network ? network : nsrv,
				    (GtkDestroyNotify)gnapster_destroy);
   
   if (!leaf)
     server_show(widget, nsrv);
   
   d_free(text[2]);
   d_free(text[3]);
   d_free(text[4]);
}

/*void show_networks() {
   GtkCTreeNode *node, *work;
   Server *srv, *new_srv;
   char *buf;
   
   if (!network)
     return;
   
   gtk_clist_clear(GTK_CLIST(browse_dlg.ctree));
   
   node = GTK_CTREE_NODE(GTK_CLIST(browse_dlg.ctree)->row_list);
   while(node) {
      buf = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;

      for(work=GTK_CTREE_ROW(node)->children;
	  work; work=GTK_CTREE_ROW(work)->sibling) {	 
	 srv = GTK_CTREE_ROW(work)->row.data;
	 if (!srv)
	   continue;
	 
	 new_srv = d_new(SERVER);
	    
	 new_srv->ip = d_strdup(srv->ip);
	 new_srv->port = srv->port;
	 new_srv->desc = d_strdup(srv->desc);
	 new_srv->network = d_strdup(srv->network);
	 new_srv->users = srv->users;
	 new_srv->files = srv->files;
	 new_srv->gigs = srv->gigs;
	 
	 server_show(browse_dlg.ctree, new_srv);
      }
      
      node = GTK_CTREE_ROW(node)->sibling;
   }
}*/

/*void network_changed(GtkWidget *widget, void *data) {
   char *network;
   
   network = 
     gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(browse_dlg.show_network)->entry));
   
   if (!network || !strlen(network))
     return;

   j_config_set_string("/gnapster/Options/network_pref", network);
   j_config_sync();

   show_network(network);
}*/

/*void network_list_free(GList *networks) {
   GList *ptr;
   char *dptr;
   
   for(ptr=networks; ptr; ptr=ptr->next) {
      dptr = ptr->data;
      if (!dptr)
	continue;
      
      d_free(dptr);
   }
   
   g_list_free(networks);
}*/

/*void network_add(GList *networks) {
   char *network_pref;

   network_pref = d_config_get_string("/gnapster/Options/network_pref=All");
   
   gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(browse_dlg.show_network)->entry),
			  0);
   gtk_combo_set_popdown_strings(GTK_COMBO(browse_dlg.show_network),
				 networks);

   gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(browse_dlg.show_network)->entry),
		      network_pref);
   
   d_free(network_pref);

   network_list_free(networks);
}

GList *network_add_list(GList *list, char *network) {
   GList *ptr;
   char *dptr;
   
   if (!network)
     return list;
   
   for(ptr=list; ptr; ptr=ptr->next) {
      dptr = ptr->data;
      if (!dptr)
	continue;
      
      if (!strcmp(dptr, network))
	return list;
   }
   
   list = g_list_append(list, d_strdup(network));
   
   return list;
}

int network_reconnect(void *data) {
   browse_dlg.show_network_id =
     gtk_signal_connect(GTK_OBJECT(GTK_COMBO(browse_dlg.show_network)->entry), "changed",
			GTK_SIGNAL_FUNC(network_changed), NULL);
   
   return 0;
}*/

void populate_browse_dlg_clist() {
   FILE *f;
   char *ip, *port, *title, *network, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   Server *nsrv;
   unsigned long users, files, gigs;
   
   f = open_servers("r");
   if (!f)
     return;
   
/*   gtk_list_clear_items(GTK_LIST(GTK_COMBO(browse_dlg.show_network)->list), 
			0, -1);*/

   gtk_clist_clear(GTK_CLIST(browse_dlg.ctree));

/*   networks = NULL;
   
   networks = network_add_list(networks, "All");*/
   
   felem = read_file(f);
   
   fclose(f);
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      ip = next_arg_full(dptr, &dptr, ':');
      port = next_arg(dptr, &dptr);
      network = next_arg(dptr, &dptr);
      title = next_arg(dptr, &dptr);
      convert(next_arg(dptr, &dptr), "%lu", &users);
      convert(next_arg(dptr, &dptr), "%lu", &files);
      convert(next_arg(dptr, &dptr), "%lu", &gigs);
      
      NA_ERR_HANDLE_CONTINUE();
      
/*      networks = network_add_list(networks, network);*/

      nsrv = d_new(SERVER);

      nsrv->ip = d_strdup(ip);
      nsrv->port = my_atoi(port);
      nsrv->desc = d_strdup(title);
      nsrv->network = network[0] ? d_strdup(network) : d_strdup("No Network");
      nsrv->users = users;
      nsrv->files = files;
      nsrv->gigs = gigs;
      
      server_show(browse_dlg.ctree, nsrv);
   }

   read_file_free(felem);

   server_show_avg(browse_dlg.ctree);

/*   networks = g_list_sort(networks, (GCompareFunc)d_strcmp);
   
   network_add(networks);*/

   gtk_clist_sort(GTK_CLIST(browse_dlg.ctree));
}

void browse_dlg_button_cb(GtkWidget *widget, GdkEventButton *event, gpointer data) {
   Server *srv;
   
   srv = gnapster_get_ctree_selection_data(widget, NULL);
   if (!srv || !srv->ip)
     return;
   
/*   gtk_clist_get_selection_info(GTK_CLIST(widget), event->x, event->y,
				&row, &col);*/

   if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
     browse_dlg_connect_cb(widget, srv);
}

void swap_serverlist() {
   char *o, *n;
   
   o = local_path("servers", NULL);
   n = local_path("servers.old", NULL);
   
   rename(o, n);
   
   d_free(n);
   d_free(o);
}

void rev_serverlist() {
   char *o, *n;
   
   o = local_path("servers", NULL);
   
   if (file_exists(o)) {
      d_free(o);
      return;
   }
   
   n = local_path("servers.old", NULL);
   
   rename(n, o);
   
   d_free(n);
   d_free(o);
}

void browse_dlg_refresh(GtkWidget *w, char *data) {
   int cmp;
   
   if (dialog_open(refresh_dlg.window))
     return;
   
   cmp = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(browse_dlg.trefresh));

   if (cmp)
     swap_serverlist();
   
   napigator_connect();   
   create_refresh_dlg();
   j_dialog_run(refresh_dlg.window, 0);
   
   if (cmp)
     rev_serverlist();
}

void refresh_dlg_cb(GtkWidget *w, void *data) {
   STab *stab;
   
   stab = get_current_stab();
 
   INPUT_REMOVE(stab->ci->napigator_input);
   CLOSE(stab->ci->napigator_sock);
   
   j_dialog_close(refresh_dlg.window);
}

void add_dlg_cb(GtkWidget *w, char *data) {
   if (!data)
     return;
   
   if (!strcmp(data, "ok")) {
      char *server, *port, *title, *network;
      
      server = gtk_entry_get_text(GTK_ENTRY(add_dlg.server));
      port = gtk_entry_get_text(GTK_ENTRY(add_dlg.port));
      title = gtk_entry_get_text(GTK_ENTRY(add_dlg.desc));
      network = gtk_entry_get_text(GTK_ENTRY(add_dlg.network));
      if (!strlen(server) || !strlen(port) || !strlen(title))
	return;
      
      append_server_entry(server, port, title, network[0] ? network : NULL, 0, 0, 0);
      
      populate_browse_dlg_clist();
   }
   
   j_dialog_close(add_dlg.window);
}

void edit_dlg_cb(GtkWidget *w, Server *data) {
   if (data) {
      char *server, *port, *title, *network;
      
      server = gtk_entry_get_text(GTK_ENTRY(edit_dlg.server));
      port = gtk_entry_get_text(GTK_ENTRY(edit_dlg.port));
      title = gtk_entry_get_text(GTK_ENTRY(edit_dlg.desc));
      network = gtk_entry_get_text(GTK_ENTRY(edit_dlg.network));
      if (!strlen(server) || !strlen(port) || !strlen(title))
	return;
      
      modify_server_entry(data->ip, data->port, server, port, network, title);
      
      populate_browse_dlg_clist();
   }
   
   j_dialog_close(edit_dlg.window);
}

FILE *open_servers(char *flags) {
   FILE *f;
   char *conf;

   conf = local_path("servers", NULL);
   
   f = fopen(conf, flags);

   if (!f)
     j_error("fopen", conf, NULL);

   d_free(conf);
   
   return f;
}

void modify_server_entry(char *oip, unsigned short int oport, char *ip, char *port, char *network, char *title) {
   FILE *f;
   char *lip, *lport, *lnetwork, *ltitle, *dptr;
   GList *ptr, *felem;
   FileEntry *fent;
   
   f = open_servers("r");
   if (!f)
     return;
   
   felem = read_file(f);
   
   fclose(f);
   
   f = open_servers("w");

   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      lip = next_arg_full(dptr, &dptr, ':');
      lport = next_arg(dptr, &dptr);
      lnetwork = next_arg(dptr, &dptr);
      ltitle = last_arg(dptr, &dptr);
      
      NA_ERR_HANDLE_CONTINUE();
      
      if (!strcmp(oip, lip) && oport == my_atoi(lport))
	fprintf(f, "%s:%s \"%s\" %s\n", ip, port, network, title);
      else
	fprintf(f, "%s:%s \"%s\" %s\n", lip, lport, lnetwork, ltitle);
   }
   
   read_file_free(felem);
   
   fclose(f);
}

void append_server_entry(char *ip, char *port, char *server, char *network, unsigned long users, unsigned long files, unsigned long gigs) {
   FILE *f;
   
   if (!ip || !port || !server)
     return;
   
   f = open_servers("a");
   if (!f)
     return;

   fprintf(f,"%s:%s \"%s\" %s %lu %lu %lu\n",
	   ip, port, network ? network : "", server, users, files, gigs);
   
   fclose(f);
}

int check_server_match(char *ip, char *port) {
   FILE *f;
   GList *ptr, *felem;
   FileEntry *fent;
   char *dptr;
   char *mip, *mport;
   int x = 0;
   
   f = open_servers("r");
   if (!f)
     return 0;
   
   felem = read_file(f);
   
   fclose(f);
   
   for(ptr=felem; ptr; ptr=ptr->next) {
      fent = ptr->data;
      if (!fent)
	continue;
      
      dptr = fent->lptr;
      
      mip = next_arg_full(dptr, &dptr, ':');
      mport = next_arg(dptr, &dptr);
      
      NA_ERR_HANDLE_CONTINUE();
      
      if (!strcmp(ip, mip) && !strcmp(port, mport))
	x = 1;
      
      if (x)
	break;
   }
   
   read_file_free(felem);
   
   return x;
}

