#include "gnapster.h"

extern UserInfo user_info;

#ifndef HAVE_GNOME
extern GtkItemFactory *upload_popup_menu;
#else
static GnomeUIInfo upload_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Browse user's mp3s"), NULL, browse_user_menu_cb,
			  GNOME_STOCK_MENU_OPEN),
   GNOMEUIINFO_ITEM_STOCK(N_("Whois user"), NULL, whois_user_menu_cb,
			  GNOME_STOCK_MENU_INDEX),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Cancel upload"), NULL, cancel_upload_cb,
			  GNOME_STOCK_MENU_TRASH),
   GNOMEUIINFO_END,
};
#endif /* ! HAVE_GNOME */

UploadTab *create_upload_tab(GtkWidget *notebook) {
   int w;
   char *titles[] = { _("Filename"), _("Connection"), _("User"), _("Info"), NULL };
   UploadTab *ut;
   GtkWidget *disable_ul;
   
   w = j_config_get_int("/gnapster/Geometry/w");
   
   ut = d_new(UPLOAD_TAB);
   
   ut->vbox = gtk_vbox_new(FALSE, 5);
   
   ut->hbox = j_line_new(ut->vbox, 0, 0);
   
   disable_ul = gtk_check_button_new_with_label(_("Disable Uploads"));
   config_toggle_widget(disable_ul, "disable_ul", NULL);
   gtk_signal_connect(GTK_OBJECT(disable_ul), "clicked", 
		      GTK_SIGNAL_FUNC(disable_ul_cb), NULL);
   j_box_pack(ut->hbox, disable_ul, 0, 0, 0);
   
   ut->max_uploads_switch = gtk_check_button_new_with_label(_("Max uploads:"));
   j_box_pack(ut->hbox, ut->max_uploads_switch, 0, 0, 0);
   
   ut->max_uploads = gtk_spin_button_new((GtkAdjustment *)gtk_adjustment_new(5.0, 0.0, 50.0, 1.0, 5.0, 0.0),
						0, 0);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(ut->max_uploads),
			     user_info.conf[MAX_UPLOADS]);
   config_combo_widget(ut->max_uploads,	"max_uploads");
   j_box_pack(ut->hbox, ut->max_uploads, 0, 0, 0);
   
   config_toggle_widget(ut->max_uploads_switch, "max_uploads_switch",
			ut->max_uploads, NULL);

   ut->max_peruser_uploads_switch =
     gtk_check_button_new_with_label(_("Max per user uploads:"));
   j_box_pack(ut->hbox, ut->max_peruser_uploads_switch, 0, 0, 0);
   
   ut->max_peruser_uploads =
     gtk_spin_button_new((GtkAdjustment *)gtk_adjustment_new(2.0, 0.0, 50.0, 1.0, 5.0, 0.0),
			 0, 0);
   gtk_spin_button_set_value(GTK_SPIN_BUTTON(ut->max_peruser_uploads),
			     user_info.conf[MAX_PERUSER_UPLOADS]);
   config_combo_widget(ut->max_peruser_uploads,	"max_peruser_uploads");
   j_box_pack(ut->hbox, ut->max_peruser_uploads, 0, 0, 0);
   
   config_toggle_widget(ut->max_peruser_uploads_switch,
			"max_peruser_uploads_switch",
			ut->max_peruser_uploads, NULL);
   
   ut->label = gtk_label_new("");
   j_box_pack(ut->hbox, ut->label, 0, 0, 0);

   ut->hbox = j_line_new(ut->vbox, 1, 1);
   
   ut->scroller = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ut->scroller),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_box_pack_start(GTK_BOX(ut->hbox), ut->scroller,
		      TRUE, TRUE, 0);
   
   ut->clist = gtk_clist_new_with_titles(4, titles);
   gtk_clist_set_column_width(GTK_CLIST(ut->clist), 0, 235 + (w - DEFAULT_WIDTH));
   gtk_clist_set_column_width(GTK_CLIST(ut->clist), 2, 75);
   gtk_clist_set_column_width(GTK_CLIST(ut->clist), 3, 50);
/*   GTK_CLIST(ut->clist)->button_actions[2] = GTK_BUTTON_SELECTS;*/
   gtk_container_add(GTK_CONTAINER(ut->scroller), ut->clist);
   gtk_signal_connect(GTK_OBJECT(ut->clist), "button_press_event",
		      GTK_SIGNAL_FUNC(menu_popup_cb), upload_popup_menu);
   
   ut->hbox = j_line_new(ut->vbox, 0, 0);
   
   gtk_widget_set_sensitive(ut->max_uploads, user_info.conf[MAX_UPLOADS_SWITCH]);
   gtk_widget_set_sensitive(ut->max_peruser_uploads, user_info.conf[MAX_PERUSER_UPLOADS_SWITCH]);
   
   gtk_container_set_border_width(GTK_CONTAINER(ut->vbox), 5);
   
   gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			    ut->vbox, gtk_label_new(_("Upload")));
   
   return ut;
}


