------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--               G N A T . S O C K E T S . C O N S T A N T S                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.7 $
--                                                                          --
--              Copyright (C) 2001 Ada Core Technologies, Inc.              --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT is maintained by Ada Core Technologies Inc (http://www.gnat.com).   --
--                                                                          --
------------------------------------------------------------------------------

--  This package is for a MINGW32 NT environment.

package GNAT.Sockets.Constants is

   AF_INET        : constant := 2;
   AF_INET6       : constant := 3;
   PF_INET        : constant := 2;
   SOCK_DGRAM     : constant := 2;
   SOCK_STREAM    : constant := 1;

   SOL_SOCKET     : constant := 16#ffff#;
   SO_REUSEADDR   : constant := 16#0004#;
   SO_KEEPALIVE   : constant := 16#0008#;
   SO_SNDBUF      : constant := 16#1001#;
   SO_RCVBUF      : constant := 16#1002#;
   SO_BROADCAST   : constant := 16#0020#;
   SO_LINGER      : constant := 16#0080#;
   SO_ERROR       : constant := 16#1007#;

   EWOULDBLOCK    : constant := 10035;
   EINPROGRESS    : constant := 10036;
   EALREADY       : constant := 10037;
   EISCONN        : constant := 10056;
   ECONNREFUSED   : constant := 10061;
   HOST_NOT_FOUND : constant := 11001;
   TRY_AGAIN      : constant := 11002;
   NO_RECOVERY    : constant := 11003;
   NO_DATA        : constant := 11004;
   NO_ADDRESS     : constant := 11004;

   EINTR          : constant := 4;
   EAGAIN         : constant := 11;
   SIGTERM        : constant := 15;

   FIOASYNC       : constant := 16#8004667d#;
   FASYNC         : constant := FIOASYNC;

   O_RDONLY       : constant := 0;
   O_WRONLY       : constant := 1;
   O_RDWR         : constant := 2;

   SHUT_RD        : constant := 0;
   SHUT_WR        : constant := 1;
   SHUT_RDWR      : constant := 2;

   TCP_NODELAY    : constant := 1;

   FIONBIO        : constant := -2147195266;
   FIONREAD       : constant := 16#4004667f#;

   IPPROTO_IP           : constant := 16#0000#;
   IPPROTO_UDP          : constant := 16#0011#;
   IPPROTO_TCP          : constant := 16#0006#;

   IP_ADD_MEMBERSHIP    : constant := 16#0005#;
   IP_DROP_MEMBERSHIP   : constant := 16#0006#;
   IP_MULTICAST_TTL     : constant := 16#0003#;
   IP_MULTICAST_LOOP    : constant := 16#0004#;

end GNAT.Sockets.Constants;
