/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#ifndef __GNOME_CMD_DATA_H__
#define __GNOME_CMD_DATA_H__

typedef struct _GnomeCmdData GnomeCmdData;
typedef struct _GnomeCmdDataPrivate GnomeCmdDataPrivate;


struct _GnomeCmdData
{
	GnomeCmdDataPrivate *priv;
};

typedef struct
{
	GdkColor *sel_fg, *sel_bg;
	GdkColor *norm_fg, *norm_bg;
	GdkColor *curs_fg, *curs_bg;
	GdkColor *term_fg, *term_bg;
} GnomeCmdLayoutColors;

typedef struct
{
	GdkColor *modified;
	GdkColor *updated;
	GdkColor *unknown;
	GdkColor *added;
	GdkColor *removed;
	GdkColor *conflict;
} GnomeCmdCvsUpdateColors;

typedef enum
{
	RIGHT_BUTTON_POPUPS_MENU,
	RIGHT_BUTTON_SELECTS
} GnomeCmdRightMouseButtonMode;


GnomeCmdData*
gnome_cmd_data_new                       (void);

void
gnome_cmd_data_free                      (void);

void
gnome_cmd_data_save                      (void);

void
gnome_cmd_data_load                      (void);

void
gnome_cmd_data_add_ftp_server            (GnomeCmdFtpServer *server);

void
gnome_cmd_data_remove_ftp_server         (GnomeCmdFtpServer *server);

GList*
gnome_cmd_data_get_ftp_servers           (void);

void
gnome_cmd_data_set_ftp_servers           (GList *servers);

const gchar *
gnome_cmd_data_get_ftp_anonymous_password (void);

void
gnome_cmd_data_set_ftp_anonymous_password (const gchar *pw);

GnomeCmdSizeDispMode
gnome_cmd_data_get_size_disp_mode        (void);

void
gnome_cmd_data_set_size_disp_mode        (GnomeCmdSizeDispMode mode);

GnomeCmdDateFormat
gnome_cmd_data_get_date_format           (void);

void
gnome_cmd_data_set_date_format           (GnomeCmdDateFormat format);

GnomeCmdLayout
gnome_cmd_data_get_layout                (void);

void
gnome_cmd_data_set_layout                (GnomeCmdLayout layout);

GnomeCmdCvsUpdateColors*
gnome_cmd_data_get_cvs_update_colors    (void);

GnomeCmdLayoutColors*
gnome_cmd_data_get_layout_colors    (void);

void
gnome_cmd_data_set_type_filter          (GnomeVFSFileType type,
										 gboolean value);

gboolean
gnome_cmd_data_get_type_filter          (GnomeVFSFileType type);

void
gnome_cmd_data_set_hidden_filter        (gboolean value);

gboolean
gnome_cmd_data_get_hidden_filter        (void);

/*
void
gnome_cmd_data_add_cvs_server           (GnomeCmdCvsServer *cvs_server);

void
gnome_cmd_data_remove_cvs_server        (GnomeCmdCvsServer *cvs_server);

GList*
gnome_cmd_data_get_cvs_servers          (void);
*/

void
gnome_cmd_data_set_position             (gint width, gint height);

void
gnome_cmd_data_get_position             (gint *width, gint *height);

void
gnome_cmd_data_save_position            (void);

void
gnome_cmd_data_set_viewer               (const gchar *command);

void
gnome_cmd_data_set_editor               (const gchar *command);

void
gnome_cmd_data_set_differ               (const gchar *command);

void
gnome_cmd_data_set_cvs_differ           (const gchar *command);

const gchar *
gnome_cmd_data_get_viewer               (void); 

const gchar *
gnome_cmd_data_get_editor               (void); 

const gchar *
gnome_cmd_data_get_differ               (void); 

const gchar *
gnome_cmd_data_get_cvs_differ           (void); 

gboolean
gnome_cmd_data_get_case_sens_sort       (void); 

void
gnome_cmd_data_set_case_sens_sort       (gboolean value);

const gchar *
gnome_cmd_data_get_font                 (void);

void
gnome_cmd_data_set_font                 (const gchar *font);

void
gnome_cmd_data_set_cvsroot              (const gchar *cvsroot);

void
gnome_cmd_data_set_cvs_over_ssh         (gboolean value);

const gchar*
gnome_cmd_data_get_cvsroot              (void);

gboolean
gnome_cmd_data_get_cvs_over_ssh         (void);

void
gnome_cmd_data_set_right_mouse_button_mode (GnomeCmdRightMouseButtonMode mode);

GnomeCmdRightMouseButtonMode
gnome_cmd_data_get_right_mouse_button_mode (void);

void
gnome_cmd_data_set_term                (const gchar *shell);

const gchar *
gnome_cmd_data_get_term                (void);

gint
gnome_cmd_data_get_embterm_height      (void);

void
gnome_cmd_data_set_embterm_height      (gint height);

void
gnome_cmd_data_set_show_toolbar        (gboolean value);

gboolean
gnome_cmd_data_get_show_toolbar        (void);

gboolean
gnome_cmd_data_get_use_mime            (void);

void
gnome_cmd_data_set_use_mime            (gboolean value);

guint
gnome_cmd_data_get_mime_icon_size      (void);

void
gnome_cmd_data_set_mime_icon_size      (guint size);

GdkInterpType
gnome_cmd_data_get_mime_scale_quality  (void);

void
gnome_cmd_data_set_mime_scale_quality  (GdkInterpType quality);

const gchar *
gnome_cmd_data_get_mime_icon_dir       (void); 

void
gnome_cmd_data_set_mime_icon_dir       (const gchar *dir);

#endif //__GNOME_CMD_DATA_H__
