/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"



struct _GnomeCmdFtpServerPrivate {	
	gchar *alias   ;
	gchar *host_name;
	gint host_port;
	gchar *user_name;
};


GnomeCmdFtpServer*
gnome_cmd_ftp_server_new ()
{
	GnomeCmdFtpServer *server = g_malloc (sizeof (GnomeCmdFtpServer));
	server->priv = g_malloc (sizeof (GnomeCmdFtpServerPrivate));
	server->priv->alias = NULL;
	server->priv->host_name = NULL;
	server->priv->host_port = 21;
	server->priv->user_name = g_strdup ("anonymous");
	
	return server;
}


GnomeCmdFtpServer*
gnome_cmd_ftp_server_new_with_values     (const gchar *alias,
										  const gchar *host_name, 
										  gint host_port,
										  const gchar *user_name)
{
	GnomeCmdFtpServer *server = gnome_cmd_ftp_server_new ();

	gnome_cmd_ftp_server_set_alias (server, alias);
	gnome_cmd_ftp_server_set_host_name (server, host_name);
	gnome_cmd_ftp_server_set_host_port (server, host_port);
	gnome_cmd_ftp_server_set_user_name (server, user_name);

	return server;
}


void
gnome_cmd_ftp_server_free                (GnomeCmdFtpServer *server)
{
	g_return_if_fail (server != NULL);
	g_return_if_fail (server->priv != NULL);
	
	if (server->priv->alias)
		g_free (server->priv->alias);
	if (server->priv->host_name)
		g_free (server->priv->host_name);
	if (server->priv->user_name)
		g_free (server->priv->user_name);

	g_free (server);
}


void
gnome_cmd_ftp_server_set_alias           (GnomeCmdFtpServer *server,
										  const gchar *alias)
{
	g_return_if_fail (server != NULL);
	g_return_if_fail (server->priv != NULL);
	
	if (server->priv->alias)
		g_free (server->priv->alias);
	
	server->priv->alias = g_strdup (alias);
}


void
gnome_cmd_ftp_server_set_host_name       (GnomeCmdFtpServer *server,
										  const gchar *host_name)
{
	g_return_if_fail (server != NULL);
	g_return_if_fail (server->priv != NULL);
	
	if (server->priv->host_name)
		g_free (server->priv->host_name);
	
	server->priv->host_name = g_strdup (host_name);
}


void
gnome_cmd_ftp_server_set_host_port       (GnomeCmdFtpServer *server,
										  gint host_port)
{
	g_return_if_fail (server != NULL);
	g_return_if_fail (server->priv != NULL);
	
	server->priv->host_port = host_port;
}


void
gnome_cmd_ftp_server_set_user_name       (GnomeCmdFtpServer *server,
										  const gchar *user_name)
{
	g_return_if_fail (server != NULL);
	g_return_if_fail (server->priv != NULL);
	
	if (server->priv->user_name)
		g_free (server->priv->user_name);
	
	server->priv->user_name = g_strdup (user_name);
}


const gchar *
gnome_cmd_ftp_server_get_alias           (GnomeCmdFtpServer *server)
{
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (server->priv != NULL, NULL);

	return server->priv->alias;
}


const gchar *
gnome_cmd_ftp_server_get_host_name       (GnomeCmdFtpServer *server)
{
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (server->priv != NULL, NULL);

	return server->priv->host_name;
}


gint
gnome_cmd_ftp_server_get_host_port       (GnomeCmdFtpServer *server)
{
	g_return_val_if_fail (server != NULL, -1);
	g_return_val_if_fail (server->priv != NULL, -1);

	return server->priv->host_port;
}


const gchar *
gnome_cmd_ftp_server_get_user_name       (GnomeCmdFtpServer *server)
{
	g_return_val_if_fail (server != NULL, NULL);
	g_return_val_if_fail (server->priv != NULL, NULL);

	return server->priv->user_name;
}


