/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"


struct _GnomeCmdStringDialogPrivate
{
	GnomeStringCallback ok_cb;
	GtkSignalFunc cancel_cb;
	gpointer data;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *entry;
	GtkWidget *dialog;	
	GtkWidget *pixmap;
};


static GnomeDialogClass *parent_class = NULL;


static void
on_ok (GtkButton *button, GnomeCmdStringDialog *dialog)
{
	GnomeCmdStringDialogPrivate *priv = dialog->priv;
	
	if (priv->ok_cb)
		priv->ok_cb (gtk_entry_get_text (GTK_ENTRY (priv->entry)), priv->data);
	
	gtk_widget_hide (GTK_WIDGET (dialog));
}


static void
on_cancel (GtkButton *button, GnomeCmdStringDialog *dialog)
{
	GnomeCmdStringDialogPrivate *priv = dialog->priv;
	
	if (priv->cancel_cb)
		priv->cancel_cb (button, priv->data);
	
	gtk_widget_hide (GTK_WIDGET (dialog));
}





/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}


static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdStringDialogClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gnome_dialog_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdStringDialog *string_dialog)
{
	GtkWidget *dialog = GTK_WIDGET (string_dialog);
	GtkWidget *dialog_vbox1;
	GtkWidget *button4;
	GtkWidget *button6;

	string_dialog->priv = g_new (GnomeCmdStringDialogPrivate, 1);
	string_dialog->priv->ok_cb = NULL;
	string_dialog->priv->cancel_cb = NULL;
	string_dialog->priv->data = NULL;
	string_dialog->priv->pixmap = NULL;
	
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, FALSE, FALSE);
	gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

	dialog_vbox1 = GNOME_DIALOG (dialog)->vbox;
	gtk_object_set_data (GTK_OBJECT (dialog),
						 "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	
	string_dialog->priv->hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_ref (string_dialog->priv->hbox);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "hbox", string_dialog->priv->hbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (string_dialog->priv->hbox);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), string_dialog->priv->hbox, TRUE, TRUE, 0);

	
	string_dialog->priv->label = gtk_label_new ("");
	gtk_widget_ref (string_dialog->priv->label);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "label", string_dialog->priv->label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (string_dialog->priv->label);
	gtk_misc_set_alignment (GTK_MISC (string_dialog->priv->label), 0.00f, 0.50f);
	gtk_box_pack_end (GTK_BOX (string_dialog->priv->hbox), string_dialog->priv->label, TRUE, TRUE, 0);

	
	string_dialog->priv->entry = gtk_entry_new ();
	gtk_widget_ref (string_dialog->priv->entry);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "entry", string_dialog->priv->entry,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (string_dialog->priv->entry);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), string_dialog->priv->entry, FALSE, FALSE, 0);


	
	gnome_dialog_append_button (GNOME_DIALOG (dialog),
								GNOME_STOCK_BUTTON_OK);
	button4 = GTK_WIDGET (g_list_last (
		GNOME_DIALOG (dialog)->buttons)->data);
	gtk_widget_ref (button4);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "button4", button4,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button4);
	GTK_WIDGET_SET_FLAGS (button4, GTK_CAN_DEFAULT);

	
	gnome_dialog_append_button (GNOME_DIALOG (dialog),
								GNOME_STOCK_BUTTON_CANCEL);
	button6 = GTK_WIDGET (g_list_last (
		GNOME_DIALOG (dialog)->buttons)->data);
	gtk_widget_ref (button6);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "button6", button6,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button6);
	GTK_WIDGET_SET_FLAGS (button6, GTK_CAN_DEFAULT);
	
	
	gnome_dialog_set_default (GNOME_DIALOG (dialog), 0);
	gtk_widget_grab_focus (string_dialog->priv->entry);
	gnome_dialog_editable_enters(GNOME_DIALOG(dialog), GTK_EDITABLE(string_dialog->priv->entry));

	
	gtk_signal_connect (GTK_OBJECT (button4), "clicked",
						GTK_SIGNAL_FUNC (on_ok), string_dialog);
	gtk_signal_connect (GTK_OBJECT (button6), "clicked",
						GTK_SIGNAL_FUNC (on_cancel), string_dialog);	


}




/***********************************
 * Public functions
 ***********************************/

GtkType
gnome_cmd_string_dialog_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdStringDialog",
			sizeof (GnomeCmdStringDialog),
			sizeof (GnomeCmdStringDialogClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gnome_dialog_get_type (), &dlg_info);
	}
	return dlg_type;
}





GtkWidget* 
gnome_cmd_string_dialog_new_with_cancel (gboolean hidden,
										 const gchar *title,
										 const gchar *prompt,
										 Pixmap pixmap_id,
										 GnomeStringCallback ok_cb,
										 GtkSignalFunc cancel_cb,
										 gpointer userdata)
{
	GnomeCmdStringDialog *dialog = gtk_type_new (gnome_cmd_string_dialog_get_type ());

	gnome_cmd_string_dialog_set_hidden (dialog, hidden);
	gnome_cmd_string_dialog_set_title (dialog, title);
	gnome_cmd_string_dialog_set_prompt (dialog, prompt);
	gnome_cmd_string_dialog_set_pixmap (dialog, pixmap_id);
	gnome_cmd_string_dialog_set_userdata (dialog, userdata);
	gnome_cmd_string_dialog_set_ok_cb (dialog, ok_cb);
	gnome_cmd_string_dialog_set_cancel_cb (dialog, cancel_cb);
	
	return GTK_WIDGET (dialog);
}


GtkWidget* 
gnome_cmd_string_dialog_new (gboolean hidden,
							 const gchar *title,
							 const gchar *prompt,
							 Pixmap pixmap_id,
							 GnomeStringCallback ok_cb,
							 gpointer userdata)
{
	return gnome_cmd_string_dialog_new_with_cancel (
		hidden, title, prompt, pixmap_id, ok_cb, NULL, userdata);
}


void
gnome_cmd_string_dialog_set_hidden (GnomeCmdStringDialog *dialog, gboolean hidden)
{
	gtk_entry_set_visibility (GTK_ENTRY (dialog->priv->entry), !hidden);	
}


void
gnome_cmd_string_dialog_set_pixmap (GnomeCmdStringDialog *dialog, Pixmap pixmap_id)
{
	if (dialog->priv->pixmap)
	{
		gtk_container_remove (GTK_CONTAINER (dialog->priv->hbox), dialog->priv->pixmap);
		gtk_widget_hide (dialog->priv->pixmap);
		gtk_widget_unref (dialog->priv->pixmap);
	}
	
	dialog->priv->pixmap = gtk_pixmap_new (
		IMAGE_get_pixmap (pixmap_id),
		IMAGE_get_mask (pixmap_id));
	gtk_widget_ref (dialog->priv->pixmap);
	gtk_object_set_data_full (GTK_OBJECT (dialog),
							  "pixmap", dialog->priv->pixmap,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (dialog->priv->pixmap);
	gtk_box_pack_start (GTK_BOX (dialog->priv->hbox), dialog->priv->pixmap, FALSE, FALSE, 0);
}


void
gnome_cmd_string_dialog_set_title (GnomeCmdStringDialog *dialog, const gchar *title)
{
	gtk_window_set_title (GTK_WINDOW (dialog), title);
}


void
gnome_cmd_string_dialog_set_prompt (GnomeCmdStringDialog *dialog, const gchar *prompt)
{
	gtk_label_set_text (GTK_LABEL (dialog->priv->label), prompt);
}


void
gnome_cmd_string_dialog_set_userdata (GnomeCmdStringDialog *dialog, gpointer userdata)
{
	dialog->priv->data = userdata;
}


void
gnome_cmd_string_dialog_set_ok_cb (GnomeCmdStringDialog *dialog, GnomeStringCallback ok_cb)
{
	dialog->priv->ok_cb = ok_cb;
}


void
gnome_cmd_string_dialog_set_cancel_cb (GnomeCmdStringDialog *dialog, GtkSignalFunc cancel_cb)
{
	dialog->priv->cancel_cb = cancel_cb;
}



