/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <config.h>
#include "gnome-cmd-includes.h"

static GtkWindowClass *parent_class = NULL;




/******************************
 * Callbacks
 ******************************/
static void
on_cancel (GtkButton *btn, gpointer user_data)
{
	GnomeCmdXferProgressWin *xferwin = GNOME_CMD_XFER_PROGRESS_WIN (user_data);

	xferwin->cancel_pressed = TRUE;
}


/*******************************
 * Gtk class implementation
 *******************************/

static void
destroy (GtkObject *object)
{
	if (GTK_OBJECT_CLASS (parent_class)->destroy)
		(*GTK_OBJECT_CLASS (parent_class)->destroy) (object);
}


static void
map (GtkWidget *widget)
{
	if (GTK_WIDGET_CLASS (parent_class)->map != NULL)
		GTK_WIDGET_CLASS (parent_class)->map (widget);
}


static void
class_init (GnomeCmdXferProgressWinClass *class)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = GTK_OBJECT_CLASS (class);
	widget_class = GTK_WIDGET_CLASS (class);

	parent_class = gtk_type_class (gtk_window_get_type ());
	object_class->destroy = destroy;
	widget_class->map = map;
}


static void
init (GnomeCmdXferProgressWin *win)
{
	GtkWidget *vbox;
	GtkWidget *hbuttonbox1;
	GtkWidget *cancel_button;


	win->cancel_pressed = FALSE;
	
	gtk_window_set_title (GTK_WINDOW (win), _("Progress"));
	gtk_window_set_policy (GTK_WINDOW (win), FALSE, FALSE, FALSE);
	gtk_widget_set_usize (GTK_WIDGET (win), 300, -1);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_ref (vbox);
	gtk_object_set_data_full (GTK_OBJECT (win), "vbox", vbox,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (win), vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);

	win->msg_label = gtk_label_new ("");
	gtk_widget_ref (win->msg_label);
	gtk_object_set_data_full (GTK_OBJECT (win), "win->msg_label", win->msg_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (win->msg_label);
	gtk_box_pack_start (GTK_BOX (vbox), win->msg_label, TRUE, TRUE, 2);
	gtk_misc_set_alignment (GTK_MISC (win->msg_label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (win->msg_label), GTK_JUSTIFY_LEFT);
	
	win->fileprog_label = gtk_label_new ("");
	gtk_widget_ref (win->fileprog_label);
	gtk_object_set_data_full (GTK_OBJECT (win), "win->fileprog_label", win->fileprog_label,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (win->fileprog_label);
	gtk_box_pack_start (GTK_BOX (vbox), win->fileprog_label, TRUE, TRUE, 2);
	gtk_misc_set_alignment (GTK_MISC (win->fileprog_label), 0.0, 0.5);
	gtk_label_set_justify (GTK_LABEL (win->fileprog_label), GTK_JUSTIFY_LEFT);
	
	win->fileprog = gtk_progress_bar_new ();
	gtk_widget_ref (win->fileprog);
	gtk_object_set_data_full (GTK_OBJECT (win), "win->fileprog", win->fileprog,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (win->fileprog);
	gtk_box_pack_start (GTK_BOX (vbox), win->fileprog, FALSE, FALSE, 2);

	win->totalprog = gtk_progress_bar_new ();
	gtk_widget_ref (win->totalprog);
	gtk_object_set_data_full (GTK_OBJECT (win), "win->totalprog", win->totalprog,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (win->totalprog);
	gtk_box_pack_start (GTK_BOX (vbox), win->totalprog, FALSE, FALSE, 2);

	hbuttonbox1 = gtk_hbutton_box_new ();
	gtk_widget_ref (hbuttonbox1);
	gtk_object_set_data_full (GTK_OBJECT (win), "hbuttonbox1", hbuttonbox1,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hbuttonbox1);
	gtk_box_pack_start (GTK_BOX (vbox), hbuttonbox1, FALSE, FALSE, 0);

	cancel_button = gtk_button_new_with_label (_("Cancel"));
	gtk_widget_ref (cancel_button);
	gtk_object_set_data_full (GTK_OBJECT (win), "cancel_button", cancel_button,
							  (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (cancel_button);
	gtk_container_add (GTK_CONTAINER (hbuttonbox1), cancel_button);
	GTK_WIDGET_SET_FLAGS (cancel_button, GTK_CAN_DEFAULT);

	gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
						GTK_SIGNAL_FUNC (on_cancel), win);
}




/***********************************
 * Public functions
 ***********************************/

GtkWidget*
gnome_cmd_xfer_progress_win_new ()
{	
	GnomeCmdXferProgressWin *win = gtk_type_new (gnome_cmd_xfer_progress_win_get_type ());

	return GTK_WIDGET (win);
}



GtkType
gnome_cmd_xfer_progress_win_get_type         (void)
{
	static GtkType dlg_type = 0;

	if (dlg_type == 0)
	{
		GtkTypeInfo dlg_info =
		{
			"GnomeCmdXferProgressWin",
			sizeof (GnomeCmdXferProgressWin),
			sizeof (GnomeCmdXferProgressWinClass),
			(GtkClassInitFunc) class_init,
			(GtkObjectInitFunc) init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL
		};

		dlg_type = gtk_type_unique (gtk_window_get_type (), &dlg_info);
	}
	return dlg_type;
}


void
gnome_cmd_xfer_progress_win_set_file_progress (GnomeCmdXferProgressWin *win,
											   GnomeVFSFileSize bytes_copied,
											   GnomeVFSFileSize bytes_total)
{
	gchar text[128];
	gchar buf1[32];
	gchar buf2[32];
	gfloat prog = -1.0f;

	if (bytes_total > 0)
		prog = (gfloat)bytes_copied / (gfloat)bytes_total;

	size2string(bytes_copied, buf1, 32, GNOME_CMD_SIZE_DISP_MODE_POWERED);
	size2string(bytes_total, buf2, 32, GNOME_CMD_SIZE_DISP_MODE_POWERED);
	
	g_snprintf (text, 128, "%d%% %s / %s",
				(int)(prog*100.0f), buf1, buf2);

	gtk_progress_set_percentage (GTK_PROGRESS (win->fileprog), prog);
	gtk_label_set_text (GTK_LABEL (win->fileprog_label), text);
}



void
gnome_cmd_xfer_progress_win_set_total_progress (GnomeCmdXferProgressWin *win,
												GnomeVFSFileSize bytes_copied,
												GnomeVFSFileSize bytes_total)
{
	gfloat prog = -1;

	if (bytes_total > 0)
		prog = (gfloat)bytes_copied / (gfloat)bytes_total;
	
	gtk_progress_set_percentage (GTK_PROGRESS (win->totalprog), prog);
}


void
gnome_cmd_xfer_progress_win_set_msg (GnomeCmdXferProgressWin *win,
									 const gchar *string)
{
	gtk_label_set_text (GTK_LABEL (win->msg_label), string);
}


void
gnome_cmd_xfer_progress_win_set_action (GnomeCmdXferProgressWin *win,
										const gchar *string)
{
	gtk_window_set_title (GTK_WINDOW (win), string);
}

