/* IDBusSchedule.c generated by valac 0.15.2.10-1402f-dirty, the Vala compiler
 * generated from IDBusSchedule.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define DVB_TYPE_EVENT_INFO (dvb_event_info_get_type ())
typedef struct _DVBEventInfo DVBEventInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ID_BUS_SCHEDULE (dvb_id_bus_schedule_get_type ())
#define DVB_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusSchedule))
#define DVB_IS_ID_BUS_SCHEDULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCHEDULE))
#define DVB_ID_BUS_SCHEDULE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCHEDULE, DVBIDBusScheduleIface))

typedef struct _DVBIDBusSchedule DVBIDBusSchedule;
typedef struct _DVBIDBusScheduleIface DVBIDBusScheduleIface;

#define DVB_TYPE_ID_BUS_SCHEDULE_PROXY (dvb_id_bus_schedule_proxy_get_type ())
typedef GDBusProxy DVBIDBusScheduleProxy;
typedef GDBusProxyClass DVBIDBusScheduleProxyClass;

struct _DVBEventInfo {
	guint32 id;
	guint32 next;
	gchar* name;
	guint duration;
	gchar* short_description;
};

struct _DVBIDBusScheduleIface {
	GTypeInterface parent_iface;
	guint32* (*GetAllEvents) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	DVBEventInfo* (*GetAllEventInfos) (DVBIDBusSchedule* self, int* result_length1, GError** error);
	gboolean (*GetInformations) (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
	guint32 (*NowPlaying) (DVBIDBusSchedule* self, GError** error);
	guint32 (*Next) (DVBIDBusSchedule* self, guint32 event_id, GError** error);
	gboolean (*GetName) (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
	gboolean (*GetShortDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetExtendedDescription) (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
	gboolean (*GetDuration) (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
	gboolean (*GetLocalStartTime) (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
	gboolean (*GetLocalStartTimestamp) (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
	gboolean (*IsRunning) (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
	gboolean (*IsScrambled) (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
};



GType dvb_event_info_get_type (void) G_GNUC_CONST;
DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self);
void dvb_event_info_free (DVBEventInfo* self);
void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest);
void dvb_event_info_destroy (DVBEventInfo* self);
GType dvb_id_bus_schedule_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_schedule_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_schedule_get_type (void) G_GNUC_CONST;
guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1, GError** error);
DVBEventInfo* dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1, GError** error);
gboolean dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, GError** error);
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id, GError** error);
gboolean dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
gboolean dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
gboolean dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
gboolean dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
gboolean dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
gboolean dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_id_bus_schedule_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static guint32* dvb_id_bus_schedule_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1, GError** error);
static DVBEventInfo* dvb_id_bus_schedule_proxy_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetInformations (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error);
static guint32 dvb_id_bus_schedule_proxy_NowPlaying (DVBIDBusSchedule* self, GError** error);
static guint32 dvb_id_bus_schedule_proxy_Next (DVBIDBusSchedule* self, guint32 event_id, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error);
static gboolean dvb_id_bus_schedule_proxy_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error);
static gboolean dvb_id_bus_schedule_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error);
static gboolean dvb_id_bus_schedule_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error);
static void dvb_id_bus_schedule_proxy_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface* iface);
static void _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length);
static void _dbus_dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void dvb_id_bus_schedule_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dvb_id_bus_schedule_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dvb_id_bus_schedule_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dvb_id_bus_schedule_unregister_object (gpointer user_data);

static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_result = {-1, "result", "au"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetAllEvents = {-1, "GetAllEvents", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetAllEvents_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_result = {-1, "result", "a(uusus)"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetAllEventInfos = {-1, "GetAllEventInfos", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetAllEventInfos_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetInformations_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetInformations_event_info = {-1, "event_info", "(uusus)"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetInformations_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetInformations_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetInformations_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetInformations_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetInformations_event_info, &_dvb_id_bus_schedule_dbus_arg_info_GetInformations_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetInformations = {-1, "GetInformations", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetInformations_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetInformations_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_NowPlaying_result = {-1, "result", "u"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_NowPlaying_in[] = {NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_NowPlaying_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_NowPlaying_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_NowPlaying = {-1, "NowPlaying", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_NowPlaying_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_NowPlaying_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_Next_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_Next_result = {-1, "result", "u"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_Next_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_Next_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_Next_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_Next_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_Next = {-1, "Next", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_Next_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_Next_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetName_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetName_name = {-1, "name", "s"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetName_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetName_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetName_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetName_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetName_name, &_dvb_id_bus_schedule_dbus_arg_info_GetName_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetName = {-1, "GetName", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetName_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetName_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_description = {-1, "description", "s"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_description, &_dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetShortDescription = {-1, "GetShortDescription", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetShortDescription_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_description = {-1, "description", "s"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_description, &_dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetExtendedDescription = {-1, "GetExtendedDescription", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetExtendedDescription_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetDuration_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetDuration_duration = {-1, "duration", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetDuration_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetDuration_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetDuration_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetDuration_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetDuration_duration, &_dvb_id_bus_schedule_dbus_arg_info_GetDuration_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetDuration = {-1, "GetDuration", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetDuration_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetDuration_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_start_time = {-1, "start_time", "au"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_start_time, &_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetLocalStartTime = {-1, "GetLocalStartTime", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTime_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_timestamp = {-1, "timestamp", "x"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_timestamp, &_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_GetLocalStartTimestamp = {-1, "GetLocalStartTimestamp", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_GetLocalStartTimestamp_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsRunning_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsRunning_running = {-1, "running", "b"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsRunning_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_IsRunning_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_IsRunning_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_IsRunning_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_IsRunning_running, &_dvb_id_bus_schedule_dbus_arg_info_IsRunning_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_IsRunning = {-1, "IsRunning", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_IsRunning_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_IsRunning_out)};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsScrambled_event_id = {-1, "event_id", "u"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsScrambled_scrambled = {-1, "scrambled", "b"};
static const GDBusArgInfo _dvb_id_bus_schedule_dbus_arg_info_IsScrambled_result = {-1, "result", "b"};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_IsScrambled_in[] = {&_dvb_id_bus_schedule_dbus_arg_info_IsScrambled_event_id, NULL};
static const GDBusArgInfo * const _dvb_id_bus_schedule_dbus_arg_info_IsScrambled_out[] = {&_dvb_id_bus_schedule_dbus_arg_info_IsScrambled_scrambled, &_dvb_id_bus_schedule_dbus_arg_info_IsScrambled_result, NULL};
static const GDBusMethodInfo _dvb_id_bus_schedule_dbus_method_info_IsScrambled = {-1, "IsScrambled", (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_IsScrambled_in), (GDBusArgInfo **) (&_dvb_id_bus_schedule_dbus_arg_info_IsScrambled_out)};
static const GDBusMethodInfo * const _dvb_id_bus_schedule_dbus_method_info[] = {&_dvb_id_bus_schedule_dbus_method_info_GetAllEvents, &_dvb_id_bus_schedule_dbus_method_info_GetAllEventInfos, &_dvb_id_bus_schedule_dbus_method_info_GetInformations, &_dvb_id_bus_schedule_dbus_method_info_NowPlaying, &_dvb_id_bus_schedule_dbus_method_info_Next, &_dvb_id_bus_schedule_dbus_method_info_GetName, &_dvb_id_bus_schedule_dbus_method_info_GetShortDescription, &_dvb_id_bus_schedule_dbus_method_info_GetExtendedDescription, &_dvb_id_bus_schedule_dbus_method_info_GetDuration, &_dvb_id_bus_schedule_dbus_method_info_GetLocalStartTime, &_dvb_id_bus_schedule_dbus_method_info_GetLocalStartTimestamp, &_dvb_id_bus_schedule_dbus_method_info_IsRunning, &_dvb_id_bus_schedule_dbus_method_info_IsScrambled, NULL};
static const GDBusSignalInfo * const _dvb_id_bus_schedule_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _dvb_id_bus_schedule_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dvb_id_bus_schedule_dbus_interface_info = {-1, "org.gnome.DVB.Schedule", (GDBusMethodInfo **) (&_dvb_id_bus_schedule_dbus_method_info), (GDBusSignalInfo **) (&_dvb_id_bus_schedule_dbus_signal_info), (GDBusPropertyInfo **) (&_dvb_id_bus_schedule_dbus_property_info)};
static const GDBusInterfaceVTable _dvb_id_bus_schedule_dbus_interface_vtable = {dvb_id_bus_schedule_dbus_interface_method_call, dvb_id_bus_schedule_dbus_interface_get_property, dvb_id_bus_schedule_dbus_interface_set_property};

void dvb_event_info_copy (const DVBEventInfo* self, DVBEventInfo* dest) {
	guint32 _tmp0_;
	guint32 _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	_tmp0_ = (*self).id;
	(*dest).id = _tmp0_;
	_tmp1_ = (*self).next;
	(*dest).next = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	_tmp4_ = (*self).duration;
	(*dest).duration = _tmp4_;
	_tmp5_ = (*self).short_description;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 ((*dest).short_description);
	(*dest).short_description = _tmp6_;
}


void dvb_event_info_destroy (DVBEventInfo* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).short_description);
}


DVBEventInfo* dvb_event_info_dup (const DVBEventInfo* self) {
	DVBEventInfo* dup;
	dup = g_new0 (DVBEventInfo, 1);
	dvb_event_info_copy (self, dup);
	return dup;
}


void dvb_event_info_free (DVBEventInfo* self) {
	dvb_event_info_destroy (self);
	g_free (self);
}


GType dvb_event_info_get_type (void) {
	static volatile gsize dvb_event_info_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_event_info_type_id__volatile)) {
		GType dvb_event_info_type_id;
		dvb_event_info_type_id = g_boxed_type_register_static ("DVBEventInfo", (GBoxedCopyFunc) dvb_event_info_dup, (GBoxedFreeFunc) dvb_event_info_free);
		g_once_init_leave (&dvb_event_info_type_id__volatile, dvb_event_info_type_id);
	}
	return dvb_event_info_type_id__volatile;
}


guint32* dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetAllEvents (self, result_length1, error);
}


DVBEventInfo* dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetAllEventInfos (self, result_length1, error);
}


gboolean dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetInformations (self, event_id, event_info, error);
}


/**
         * @returns: ID of currently running event
         */
guint32 dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, GError** error) {
	g_return_val_if_fail (self != NULL, 0U);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->NowPlaying (self, error);
}


/**
         * @returnns: ID of event that follows the given event
         */
guint32 dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, guint32 event_id, GError** error) {
	g_return_val_if_fail (self != NULL, 0U);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->Next (self, event_id, error);
}


gboolean dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetName (self, event_id, name, error);
}


gboolean dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetShortDescription (self, event_id, description, error);
}


gboolean dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetExtendedDescription (self, event_id, description, error);
}


gboolean dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetDuration (self, event_id, duration, error);
}


gboolean dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetLocalStartTime (self, event_id, start_time, start_time_length1, error);
}


gboolean dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->GetLocalStartTimestamp (self, event_id, timestamp, error);
}


gboolean dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsRunning (self, event_id, running, error);
}


gboolean dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DVB_ID_BUS_SCHEDULE_GET_INTERFACE (self)->IsScrambled (self, event_id, scrambled, error);
}


static void dvb_id_bus_schedule_base_init (DVBIDBusScheduleIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_id_bus_schedule_get_type (void) {
	static volatile gsize dvb_id_bus_schedule_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_id_bus_schedule_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusScheduleIface), (GBaseInitFunc) dvb_id_bus_schedule_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dvb_id_bus_schedule_type_id;
		dvb_id_bus_schedule_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSchedule", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_schedule_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dvb_id_bus_schedule_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dvb_id_bus_schedule_proxy_get_type);
		g_type_set_qdata (dvb_id_bus_schedule_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.DVB.Schedule");
		g_type_set_qdata (dvb_id_bus_schedule_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dvb_id_bus_schedule_register_object);
		g_once_init_leave (&dvb_id_bus_schedule_type_id__volatile, dvb_id_bus_schedule_type_id);
	}
	return dvb_id_bus_schedule_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusScheduleProxy, dvb_id_bus_schedule_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_SCHEDULE, dvb_id_bus_schedule_proxy_dvb_id_bus_schedule_interface_init) )
static void dvb_id_bus_schedule_proxy_class_init (DVBIDBusScheduleProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dvb_id_bus_schedule_proxy_g_signal;
}


static void dvb_id_bus_schedule_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void dvb_id_bus_schedule_proxy_init (DVBIDBusScheduleProxy* self) {
}


static guint32* dvb_id_bus_schedule_proxy_GetAllEvents (DVBIDBusSchedule* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32* _result;
	int _result_length1;
	GVariant* _tmp373_;
	guint32* _tmp374_;
	int _tmp374__length;
	int _tmp374__size;
	int _tmp374__length1;
	GVariantIter _tmp375_;
	GVariant* _tmp376_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetAllEvents");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp373_ = g_variant_iter_next_value (&_reply_iter);
	_tmp374_ = g_new (guint32, 5);
	_tmp374__length = 0;
	_tmp374__size = 4;
	_tmp374__length1 = 0;
	g_variant_iter_init (&_tmp375_, _tmp373_);
	for (; (_tmp376_ = g_variant_iter_next_value (&_tmp375_)) != NULL; _tmp374__length1++) {
		if (_tmp374__size == _tmp374__length) {
			_tmp374__size = 2 * _tmp374__size;
			_tmp374_ = g_renew (guint32, _tmp374_, _tmp374__size + 1);
		}
		_tmp374_[_tmp374__length++] = g_variant_get_uint32 (_tmp376_);
		g_variant_unref (_tmp376_);
	}
	_result_length1 = _tmp374__length1;
	_result = _tmp374_;
	g_variant_unref (_tmp373_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static DVBEventInfo* dvb_id_bus_schedule_proxy_GetAllEventInfos (DVBIDBusSchedule* self, int* result_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBEventInfo* _result;
	int _result_length1;
	GVariant* _tmp377_;
	DVBEventInfo* _tmp378_;
	int _tmp378__length;
	int _tmp378__size;
	int _tmp378__length1;
	GVariantIter _tmp379_;
	GVariant* _tmp380_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetAllEventInfos");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp377_ = g_variant_iter_next_value (&_reply_iter);
	_tmp378_ = g_new (DVBEventInfo, 5);
	_tmp378__length = 0;
	_tmp378__size = 4;
	_tmp378__length1 = 0;
	g_variant_iter_init (&_tmp379_, _tmp377_);
	for (; (_tmp380_ = g_variant_iter_next_value (&_tmp379_)) != NULL; _tmp378__length1++) {
		DVBEventInfo _tmp381_;
		GVariantIter _tmp382_;
		GVariant* _tmp383_;
		GVariant* _tmp384_;
		GVariant* _tmp385_;
		GVariant* _tmp386_;
		GVariant* _tmp387_;
		if (_tmp378__size == _tmp378__length) {
			_tmp378__size = 2 * _tmp378__size;
			_tmp378_ = g_renew (DVBEventInfo, _tmp378_, _tmp378__size + 1);
		}
		g_variant_iter_init (&_tmp382_, _tmp380_);
		_tmp383_ = g_variant_iter_next_value (&_tmp382_);
		_tmp381_.id = g_variant_get_uint32 (_tmp383_);
		g_variant_unref (_tmp383_);
		_tmp384_ = g_variant_iter_next_value (&_tmp382_);
		_tmp381_.next = g_variant_get_uint32 (_tmp384_);
		g_variant_unref (_tmp384_);
		_tmp385_ = g_variant_iter_next_value (&_tmp382_);
		_tmp381_.name = g_variant_dup_string (_tmp385_, NULL);
		g_variant_unref (_tmp385_);
		_tmp386_ = g_variant_iter_next_value (&_tmp382_);
		_tmp381_.duration = g_variant_get_uint32 (_tmp386_);
		g_variant_unref (_tmp386_);
		_tmp387_ = g_variant_iter_next_value (&_tmp382_);
		_tmp381_.short_description = g_variant_dup_string (_tmp387_, NULL);
		g_variant_unref (_tmp387_);
		_tmp378_[_tmp378__length++] = _tmp381_;
		g_variant_unref (_tmp380_);
	}
	_result_length1 = _tmp378__length1;
	_result = _tmp378_;
	g_variant_unref (_tmp377_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetInformations (DVBIDBusSchedule* self, guint32 event_id, DVBEventInfo* event_info, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	DVBEventInfo _vala_event_info;
	GVariant* _tmp388_;
	DVBEventInfo _tmp389_;
	GVariantIter _tmp390_;
	GVariant* _tmp391_;
	GVariant* _tmp392_;
	GVariant* _tmp393_;
	GVariant* _tmp394_;
	GVariant* _tmp395_;
	gboolean _result;
	GVariant* _tmp396_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetInformations");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp388_ = g_variant_iter_next_value (&_reply_iter);
	g_variant_iter_init (&_tmp390_, _tmp388_);
	_tmp391_ = g_variant_iter_next_value (&_tmp390_);
	_tmp389_.id = g_variant_get_uint32 (_tmp391_);
	g_variant_unref (_tmp391_);
	_tmp392_ = g_variant_iter_next_value (&_tmp390_);
	_tmp389_.next = g_variant_get_uint32 (_tmp392_);
	g_variant_unref (_tmp392_);
	_tmp393_ = g_variant_iter_next_value (&_tmp390_);
	_tmp389_.name = g_variant_dup_string (_tmp393_, NULL);
	g_variant_unref (_tmp393_);
	_tmp394_ = g_variant_iter_next_value (&_tmp390_);
	_tmp389_.duration = g_variant_get_uint32 (_tmp394_);
	g_variant_unref (_tmp394_);
	_tmp395_ = g_variant_iter_next_value (&_tmp390_);
	_tmp389_.short_description = g_variant_dup_string (_tmp395_, NULL);
	g_variant_unref (_tmp395_);
	_vala_event_info = _tmp389_;
	g_variant_unref (_tmp388_);
	*event_info = _vala_event_info;
	_tmp396_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp396_);
	g_variant_unref (_tmp396_);
	g_object_unref (_reply_message);
	return _result;
}


static guint32 dvb_id_bus_schedule_proxy_NowPlaying (DVBIDBusSchedule* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result;
	GVariant* _tmp397_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "NowPlaying");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0U;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0U;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp397_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp397_);
	g_variant_unref (_tmp397_);
	g_object_unref (_reply_message);
	return _result;
}


static guint32 dvb_id_bus_schedule_proxy_Next (DVBIDBusSchedule* self, guint32 event_id, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result;
	GVariant* _tmp398_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "Next");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return 0U;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return 0U;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp398_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp398_);
	g_variant_unref (_tmp398_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetName (DVBIDBusSchedule* self, guint32 event_id, gchar** name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_name;
	GVariant* _tmp399_;
	gboolean _result;
	GVariant* _tmp400_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp399_ = g_variant_iter_next_value (&_reply_iter);
	_vala_name = g_variant_dup_string (_tmp399_, NULL);
	g_variant_unref (_tmp399_);
	*name = _vala_name;
	_tmp400_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp400_);
	g_variant_unref (_tmp400_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetShortDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_description;
	GVariant* _tmp401_;
	gboolean _result;
	GVariant* _tmp402_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetShortDescription");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp401_ = g_variant_iter_next_value (&_reply_iter);
	_vala_description = g_variant_dup_string (_tmp401_, NULL);
	g_variant_unref (_tmp401_);
	*description = _vala_description;
	_tmp402_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp402_);
	g_variant_unref (_tmp402_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetExtendedDescription (DVBIDBusSchedule* self, guint32 event_id, gchar** description, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _vala_description;
	GVariant* _tmp403_;
	gboolean _result;
	GVariant* _tmp404_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetExtendedDescription");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp403_ = g_variant_iter_next_value (&_reply_iter);
	_vala_description = g_variant_dup_string (_tmp403_, NULL);
	g_variant_unref (_tmp403_);
	*description = _vala_description;
	_tmp404_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp404_);
	g_variant_unref (_tmp404_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetDuration (DVBIDBusSchedule* self, guint32 event_id, guint* duration, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint _vala_duration;
	GVariant* _tmp405_;
	gboolean _result;
	GVariant* _tmp406_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetDuration");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp405_ = g_variant_iter_next_value (&_reply_iter);
	_vala_duration = g_variant_get_uint32 (_tmp405_);
	g_variant_unref (_tmp405_);
	*duration = _vala_duration;
	_tmp406_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp406_);
	g_variant_unref (_tmp406_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetLocalStartTime (DVBIDBusSchedule* self, guint32 event_id, guint** start_time, int* start_time_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint* _vala_start_time;
	int _vala_start_time_length1;
	GVariant* _tmp407_;
	guint* _tmp408_;
	int _tmp408__length;
	int _tmp408__size;
	int _tmp408__length1;
	GVariantIter _tmp409_;
	GVariant* _tmp410_;
	gboolean _result;
	GVariant* _tmp411_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetLocalStartTime");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_start_time_length1 = 0;
	_tmp407_ = g_variant_iter_next_value (&_reply_iter);
	_tmp408_ = g_new (guint, 5);
	_tmp408__length = 0;
	_tmp408__size = 4;
	_tmp408__length1 = 0;
	g_variant_iter_init (&_tmp409_, _tmp407_);
	for (; (_tmp410_ = g_variant_iter_next_value (&_tmp409_)) != NULL; _tmp408__length1++) {
		if (_tmp408__size == _tmp408__length) {
			_tmp408__size = 2 * _tmp408__size;
			_tmp408_ = g_renew (guint, _tmp408_, _tmp408__size + 1);
		}
		_tmp408_[_tmp408__length++] = g_variant_get_uint32 (_tmp410_);
		g_variant_unref (_tmp410_);
	}
	_vala_start_time_length1 = _tmp408__length1;
	_vala_start_time = _tmp408_;
	g_variant_unref (_tmp407_);
	*start_time = _vala_start_time;
	*start_time_length1 = _vala_start_time_length1;
	_tmp411_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp411_);
	g_variant_unref (_tmp411_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_GetLocalStartTimestamp (DVBIDBusSchedule* self, guint32 event_id, gint64* timestamp, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gint64 _vala_timestamp;
	GVariant* _tmp412_;
	gboolean _result;
	GVariant* _tmp413_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "GetLocalStartTimestamp");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp412_ = g_variant_iter_next_value (&_reply_iter);
	_vala_timestamp = g_variant_get_int64 (_tmp412_);
	g_variant_unref (_tmp412_);
	*timestamp = _vala_timestamp;
	_tmp413_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp413_);
	g_variant_unref (_tmp413_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_IsRunning (DVBIDBusSchedule* self, guint32 event_id, gboolean* running, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_running;
	GVariant* _tmp414_;
	gboolean _result;
	GVariant* _tmp415_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "IsRunning");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp414_ = g_variant_iter_next_value (&_reply_iter);
	_vala_running = g_variant_get_boolean (_tmp414_);
	g_variant_unref (_tmp414_);
	*running = _vala_running;
	_tmp415_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp415_);
	g_variant_unref (_tmp415_);
	g_object_unref (_reply_message);
	return _result;
}


static gboolean dvb_id_bus_schedule_proxy_IsScrambled (DVBIDBusSchedule* self, guint32 event_id, gboolean* scrambled, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gboolean _vala_scrambled;
	GVariant* _tmp416_;
	gboolean _result;
	GVariant* _tmp417_;
	G_DBUS_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.DVB.Schedule", "IsScrambled");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (event_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return FALSE;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return FALSE;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp416_ = g_variant_iter_next_value (&_reply_iter);
	_vala_scrambled = g_variant_get_boolean (_tmp416_);
	g_variant_unref (_tmp416_);
	*scrambled = _vala_scrambled;
	_tmp417_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_boolean (_tmp417_);
	g_variant_unref (_tmp417_);
	g_object_unref (_reply_message);
	return _result;
}


static void dvb_id_bus_schedule_proxy_dvb_id_bus_schedule_interface_init (DVBIDBusScheduleIface* iface) {
	iface->GetAllEvents = dvb_id_bus_schedule_proxy_GetAllEvents;
	iface->GetAllEventInfos = dvb_id_bus_schedule_proxy_GetAllEventInfos;
	iface->GetInformations = dvb_id_bus_schedule_proxy_GetInformations;
	iface->NowPlaying = dvb_id_bus_schedule_proxy_NowPlaying;
	iface->Next = dvb_id_bus_schedule_proxy_Next;
	iface->GetName = dvb_id_bus_schedule_proxy_GetName;
	iface->GetShortDescription = dvb_id_bus_schedule_proxy_GetShortDescription;
	iface->GetExtendedDescription = dvb_id_bus_schedule_proxy_GetExtendedDescription;
	iface->GetDuration = dvb_id_bus_schedule_proxy_GetDuration;
	iface->GetLocalStartTime = dvb_id_bus_schedule_proxy_GetLocalStartTime;
	iface->GetLocalStartTimestamp = dvb_id_bus_schedule_proxy_GetLocalStartTimestamp;
	iface->IsRunning = dvb_id_bus_schedule_proxy_IsRunning;
	iface->IsScrambled = dvb_id_bus_schedule_proxy_IsScrambled;
}


static void _dbus_dvb_id_bus_schedule_GetAllEvents (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32* result;
	int result_length1 = 0;
	guint32* _tmp418_;
	GVariantBuilder _tmp419_;
	int _tmp420_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_schedule_GetAllEvents (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp418_ = result;
	g_variant_builder_init (&_tmp419_, G_VARIANT_TYPE ("au"));
	for (_tmp420_ = 0; _tmp420_ < result_length1; _tmp420_++) {
		g_variant_builder_add_value (&_tmp419_, g_variant_new_uint32 (*_tmp418_));
		_tmp418_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp419_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _vala_DVBEventInfo_array_free (DVBEventInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_event_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_dvb_id_bus_schedule_GetAllEventInfos (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBEventInfo* result;
	int result_length1 = 0;
	DVBEventInfo* _tmp421_;
	GVariantBuilder _tmp422_;
	int _tmp423_;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_schedule_GetAllEventInfos (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp421_ = result;
	g_variant_builder_init (&_tmp422_, G_VARIANT_TYPE ("a(uusus)"));
	for (_tmp423_ = 0; _tmp423_ < result_length1; _tmp423_++) {
		GVariantBuilder _tmp424_;
		g_variant_builder_init (&_tmp424_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp424_, g_variant_new_uint32 ((*_tmp421_).id));
		g_variant_builder_add_value (&_tmp424_, g_variant_new_uint32 ((*_tmp421_).next));
		g_variant_builder_add_value (&_tmp424_, g_variant_new_string ((*_tmp421_).name));
		g_variant_builder_add_value (&_tmp424_, g_variant_new_uint32 ((*_tmp421_).duration));
		g_variant_builder_add_value (&_tmp424_, g_variant_new_string ((*_tmp421_).short_description));
		g_variant_builder_add_value (&_tmp422_, g_variant_builder_end (&_tmp424_));
		_tmp421_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp422_));
	result = (_vala_DVBEventInfo_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetInformations (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp425_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	DVBEventInfo event_info = {0};
	GVariantBuilder _tmp426_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp425_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp425_);
	g_variant_unref (_tmp425_);
	result = dvb_id_bus_schedule_GetInformations (self, event_id, &event_info, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_init (&_tmp426_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp426_, g_variant_new_uint32 (event_info.id));
	g_variant_builder_add_value (&_tmp426_, g_variant_new_uint32 (event_info.next));
	g_variant_builder_add_value (&_tmp426_, g_variant_new_string (event_info.name));
	g_variant_builder_add_value (&_tmp426_, g_variant_new_uint32 (event_info.duration));
	g_variant_builder_add_value (&_tmp426_, g_variant_new_string (event_info.short_description));
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp426_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	dvb_event_info_destroy (&event_info);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_NowPlaying (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, parameters);
	result = dvb_id_bus_schedule_NowPlaying (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_Next (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp427_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp427_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp427_);
	g_variant_unref (_tmp427_);
	result = dvb_id_bus_schedule_Next (self, event_id, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetName (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp428_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* name = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp428_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp428_);
	g_variant_unref (_tmp428_);
	result = dvb_id_bus_schedule_GetName (self, event_id, &name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (name);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetShortDescription (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp429_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* description = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp429_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp429_);
	g_variant_unref (_tmp429_);
	result = dvb_id_bus_schedule_GetShortDescription (self, event_id, &description, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (description));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (description);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetExtendedDescription (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp430_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* description = NULL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp430_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp430_);
	g_variant_unref (_tmp430_);
	result = dvb_id_bus_schedule_GetExtendedDescription (self, event_id, &description, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (description));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (description);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetDuration (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp431_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint duration = 0U;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp431_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp431_);
	g_variant_unref (_tmp431_);
	result = dvb_id_bus_schedule_GetDuration (self, event_id, &duration, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (duration));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetLocalStartTime (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp432_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* start_time = NULL;
	int start_time_length1 = 0;
	guint* _tmp433_;
	GVariantBuilder _tmp434_;
	int _tmp435_;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp432_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp432_);
	g_variant_unref (_tmp432_);
	result = dvb_id_bus_schedule_GetLocalStartTime (self, event_id, &start_time, &start_time_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp433_ = start_time;
	g_variant_builder_init (&_tmp434_, G_VARIANT_TYPE ("au"));
	for (_tmp435_ = 0; _tmp435_ < start_time_length1; _tmp435_++) {
		g_variant_builder_add_value (&_tmp434_, g_variant_new_uint32 (*_tmp433_));
		_tmp433_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp434_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	start_time = (g_free (start_time), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp436_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gint64 timestamp = 0LL;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp436_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp436_);
	g_variant_unref (_tmp436_);
	result = dvb_id_bus_schedule_GetLocalStartTimestamp (self, event_id, &timestamp, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_int64 (timestamp));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_IsRunning (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp437_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean running = FALSE;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp437_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp437_);
	g_variant_unref (_tmp437_);
	result = dvb_id_bus_schedule_IsRunning (self, event_id, &running, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (running));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_dvb_id_bus_schedule_IsScrambled (DVBIDBusSchedule* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 event_id = 0U;
	GVariant* _tmp438_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean scrambled = FALSE;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp438_ = g_variant_iter_next_value (&_arguments_iter);
	event_id = g_variant_get_uint32 (_tmp438_);
	g_variant_unref (_tmp438_);
	result = dvb_id_bus_schedule_IsScrambled (self, event_id, &scrambled, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (scrambled));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dvb_id_bus_schedule_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetAllEvents") == 0) {
		_dbus_dvb_id_bus_schedule_GetAllEvents (object, parameters, invocation);
	} else if (strcmp (method_name, "GetAllEventInfos") == 0) {
		_dbus_dvb_id_bus_schedule_GetAllEventInfos (object, parameters, invocation);
	} else if (strcmp (method_name, "GetInformations") == 0) {
		_dbus_dvb_id_bus_schedule_GetInformations (object, parameters, invocation);
	} else if (strcmp (method_name, "NowPlaying") == 0) {
		_dbus_dvb_id_bus_schedule_NowPlaying (object, parameters, invocation);
	} else if (strcmp (method_name, "Next") == 0) {
		_dbus_dvb_id_bus_schedule_Next (object, parameters, invocation);
	} else if (strcmp (method_name, "GetName") == 0) {
		_dbus_dvb_id_bus_schedule_GetName (object, parameters, invocation);
	} else if (strcmp (method_name, "GetShortDescription") == 0) {
		_dbus_dvb_id_bus_schedule_GetShortDescription (object, parameters, invocation);
	} else if (strcmp (method_name, "GetExtendedDescription") == 0) {
		_dbus_dvb_id_bus_schedule_GetExtendedDescription (object, parameters, invocation);
	} else if (strcmp (method_name, "GetDuration") == 0) {
		_dbus_dvb_id_bus_schedule_GetDuration (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLocalStartTime") == 0) {
		_dbus_dvb_id_bus_schedule_GetLocalStartTime (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLocalStartTimestamp") == 0) {
		_dbus_dvb_id_bus_schedule_GetLocalStartTimestamp (object, parameters, invocation);
	} else if (strcmp (method_name, "IsRunning") == 0) {
		_dbus_dvb_id_bus_schedule_IsRunning (object, parameters, invocation);
	} else if (strcmp (method_name, "IsScrambled") == 0) {
		_dbus_dvb_id_bus_schedule_IsScrambled (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dvb_id_bus_schedule_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dvb_id_bus_schedule_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint dvb_id_bus_schedule_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dvb_id_bus_schedule_dbus_interface_info), &_dvb_id_bus_schedule_dbus_interface_vtable, data, _dvb_id_bus_schedule_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _dvb_id_bus_schedule_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



