/* vi:set ts=8 sts=0 sw=8:
 * $Id: prefs.h,v 1.3 2001/01/25 06:02:38 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PREFS_H__
#define __PREFS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include "win.h"


enum prefs_id_e {
	Prefs_main_tbstyle,
	Prefs_fops_tbstyle,
	Prefs_adv_tbstyle,
	Prefs_mfile_tbstyle,
	Prefs_mdir_tbstyle,	/* 4 */
	Prefs_show_tabs,
	Prefs_tab_pos,

	Prefs_file_open,
	Prefs_file_delete,
	Prefs_file_copy,
	Prefs_file_print,
	Prefs_file_exec,	/* 11 */
	Prefs_file_shell,
	Prefs_cmd_prompting,

	Prefs_save_main_win,
	Prefs_save_mfile_win,
	Prefs_save_mdir_win,
	Prefs_save_results_win,
	Prefs_save_advopts_win,
	Prefs_save_prefs_win,	/* 19 */
	Prefs_save_builtin_win,

	Prefs_archive_fname,
	Prefs_archive_add,
	Prefs_archive_remove,
	Prefs_archive_list,	/* 24 */
	Prefs_archive_builtin,

	Prefs_tmpdir,
	Prefs_shell,
	Prefs_dnd,

	Prefs_main_win_h,
	Prefs_main_win_w,	/* 29 */
	Prefs_mfile_win_h,
	Prefs_mfile_win_w,
	Prefs_mdir_win_h,
	Prefs_mdir_win_w,
	Prefs_res_win_h,	/* 34 */
	Prefs_res_win_w,
	Prefs_adv_win_h,
	Prefs_adv_win_w,
	Prefs_prefs_win_h,
	Prefs_prefs_win_w,	/* 39 */
	Prefs_builtin_win_h,
	Prefs_builtin_win_w,
	Prefs_MAX
};
typedef enum prefs_id_e prefs_id_t;


extern void prefs_cb(GtkWidget *wgt, gpointer cbdata);
extern void prefs_init(void);
extern int prefs_int_get(prefs_id_t pref_id);
extern gboolean prefs_bool_get(prefs_id_t pref_id);
extern char *prefs_string_get(prefs_id_t pref_id);
extern void prefs_int_set(prefs_id_t pref_id, const int num);
extern void prefs_bool_set(prefs_id_t pref_id, const gboolean bval);
extern void prefs_string_set(prefs_id_t pref_id, const char *str);
extern void prefs_save(win_t *w);
extern void prefs_toolbar_set(int prefs_id, GtkWidget *tb);


/* the end */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __PREFS_H__ */
