/* vi:set ts=8 sts=0 sw=8:
 * $Id: results.h,v 1.2 2001/01/26 05:20:36 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __RESULTS_H__
#define __RESULTS_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <sys/stat.h>
#include <gnome.h>
#include "win.h"

extern void results_prefs_save(win_t *w);
extern void results_prefs_toolbar_set(win_t *w);
extern void results_widgets_setup(win_t *w);
extern void results_add(win_t *w, char *line, char *clist_text[],
			time_t mtime, struct stat *sb);
extern void results_errors_add(win_t *w, char *text);
extern void results_dialog_destroy(win_t *w);
extern void results_prev_show(win_t *w);
extern void results_dialog_show(win_t *w);
extern void results_found_set(win_t *w);
extern GtkWidget *results_clist_widget(win_t *w);
extern GtkProgress *results_progbar_widget(win_t *w);
extern GnomeAppBar *results_appbar_widget(win_t *w);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __RESULTS_H__ */
