# addWindow.py - UI code for adding a crontab record
# Copyright (C) 2004, 2005 Philip Van Hoof <me at pvanhoof dot be>
# Copyright (C) 2004, 2005 Gaute Hope <eg at gaute dot eu dot org>
# Copyright (C) 2004, 2005 Kristof Vansant <de_lupus at pandora dot be>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02110-1301, USA.

#pygtk modules
import gtk
import gobject
import gnome

#python modules
import re
import os

#custom modules
import config
import preset
import crontabEditorHelper


class CrontabEditor:
	def __init__(self, parent, backend, scheduler, defaultIcon):

		self.ParentClass = parent
		self.backend = backend
		self.scheduler = scheduler
		
		self.xml = self.ParentClass.xml
		self.widget = self.xml.get_widget("crontabEditor")
		self.widget.connect("delete-event", self.widget.hide_on_delete)
		
		
		# TODO: move to crontab?
		self.fieldRegex = re.compile('^(\*)$|^([0-9]+)$|^\*\/([0-9]+)$|^([0-9]+)-([0-9]+)$|(^([0-9]+[,])+([0-9]+)$)')
		self.nooutputRegex = re.compile('([^#\n$]*)>(\s|)/dev/null\s2>&1')
		
		
		self.defaultIcon = defaultIcon
		
		#self.editing = False
		self.noevents = False
		
		
		##simple tab	
		self.notebook = self.xml.get_widget("notebook")
		self.template_image = self.xml.get_widget ("template_image")
		self.template_image_size = gtk.icon_size_register ("cron_template_image_size", 48, 48)
		self.image_button = self.xml.get_widget ("image_button")
		self.template_label = self.xml.get_widget ("template_label")
		self.basic_table = self.xml.get_widget ("basic_table")
		
		self.save_button = self.xml.get_widget ("save_button")
		self.remove_button = self.xml.get_widget("remove_button")
		
		self.template_combobox = self.xml.get_widget ("template_combobox")
		self.template_combobox_model = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_PYOBJECT)
		self.template_combobox.set_model (self.template_combobox_model)
		
		self.title_entry = self.xml.get_widget ("title_entry")
		self.command_entry = self.xml.get_widget ("command_entry")
		self.nooutput_label = self.xml.get_widget ("nooutput_label")
		self.nooutput_label.set_label(" >/dev/null 2>&1")

		self.frequency_combobox = self.xml.get_widget ("frequency_combobox")
		self.frequency_combobox_model = gtk.ListStore (gobject.TYPE_STRING, gobject.TYPE_PYOBJECT)
		self.frequency_combobox_model.append([_("Use advanced"), None])
		self.frequency_combobox_model.append([_("Every minute"), ["*", "*", "*", "*", "*"]])
		self.frequency_combobox_model.append([_("Every hour"), ["0", "*", "*", "*", "*"]])
		self.frequency_combobox_model.append([_("Every day"), ["0", "0", "*", "*", "*"]])
		self.frequency_combobox_model.append([_("Every month"), ["0", "0", "1", "*", "*"]])
		self.frequency_combobox_model.append([_("Every week"), ["0", "0", "*", "*", "1"]])
		self.frequency_combobox.set_model (self.frequency_combobox_model)
		
		self.chkNoOutput = self.xml.get_widget("chkNoOutput")
				
		self.help_button = self.xml.get_widget ("cron_help_button")
		self.cancel_button = self.xml.get_widget ("cancel_button")
		self.ok_button = self.xml.get_widget ("ok_button")
		
		self.template_combobox.get_child().connect ("changed", self.on_template_combobox_entry_changed)
		
		self.xml.signal_connect("on_remove_button_clicked", self.on_remove_button_clicked)
		self.xml.signal_connect("on_cron_help_button_clicked", self.on_cron_help_button_clicked)
		self.xml.signal_connect("on_cancel_button_clicked", self.on_cancel_button_clicked)
		self.xml.signal_connect("on_ok_button_clicked", self.on_ok_button_clicked)
		self.xml.signal_connect("on_anyadvanced_entry_changed", self.on_anyadvanced_entry_changed)
		self.xml.signal_connect("on_anybasic_entry_changed", self.on_anybasic_entry_changed)
		self.xml.signal_connect("on_frequency_combobox_changed", self.on_frequency_combobox_changed)
		self.xml.signal_connect("on_chkNoOutput_toggled", self.on_anybasic_entry_changed)
		self.xml.signal_connect("on_image_button_clicked", self.on_image_button_clicked)
		self.xml.signal_connect("on_save_button_clicked", self.on_save_button_clicked)
		self.xml.signal_connect("on_fieldHelp_clicked", self.on_fieldHelp_clicked)
		self.xml.signal_connect("on_template_combobox_changed", self.on_template_combobox_changed)
		##
		
		##advanced tab
		self.minute_entry = self.xml.get_widget ("minute_entry")
		self.hour_entry = self.xml.get_widget ("hour_entry")
		self.day_entry = self.xml.get_widget ("day_entry")
		self.month_entry = self.xml.get_widget ("month_entry")
		self.weekday_entry = self.xml.get_widget ("weekday_entry")
				
		self.setting_label = self.xml.get_widget ("setting_label")
		##
		
		
		self.editorhelper = crontabEditorHelper.CrontabEditorHelper(self)
		self.backend.add_scheduler_type("crontab")
		
		
	def showadd (self, mode):
		self.__loadicon__ ()
		self.__reset__ ()
		self.__set_frequency_combo__()
		self.editing = False
		self.widget.set_title(_("Create a New Scheduled Task"))
		self.widget.set_transient_for(self.ParentClass.widget)
		self.widget.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
		self.widget.show ()
		self.__reload_templates__ ()
		self.chkNoOutput.set_active (True)
		
		#switch to advanced tab if required
		if mode == "advanced":
			self.notebook.set_current_page(1)
		else:
			self.notebook.set_current_page(0)
	
	
	def showedit (self, record, linenumber, iter, mode):
		self.__reload_templates__ ()
		self.editing = True
		self.linenumber = linenumber
		self.record = record
		(self.minute, self.hour, self.day, self.month, self.weekday, self.command, self.title, self.icon) = self.scheduler.parse (record)
		self.widget.set_title(_("Edit a Scheduled Task"))
		self.__update_textboxes__ ()
		self.__set_frequency_combo__ ()
		self.parentiter = iter
		self.widget.set_transient_for(self.ParentClass.widget)
		self.widget.set_position(gtk.WIN_POS_CENTER_ON_PARENT)
		self.widget.show ()
		
		m = self.nooutputRegex.match (self.command)
		if (m != None):
			self.nooutput_label.show ()
			self.command = m.groups()[0]
			self.command_entry.set_text (self.command)
			self.chkNoOutput.set_active (True)
			self.nooutput = True
		else:
			self.nooutput_label.hide ()
			self.chkNoOutput.set_active (False)
			self.nooutput = False

		#switch to advanced tab if required
		if mode == "advanced":
			self.notebook.set_current_page(1)
		else:
			self.notebook.set_current_page(0)

		self.template_combobox.set_active (0)


	def __reset__ (self):
		self.noevents = True
		self.minute = "*"
		self.hour = "*"
		self.day = "*"
		self.month = "*"
		self.weekday = "*"
		self.command = "ls"
		self.title = _("Untitled")
		self.nooutput = True
		self.nooutput_label.show ()
		self.chkNoOutput.set_active (True)
		self.__update_textboxes__ ()
		self.noevents = False


	def __reload_templates__ (self):
		#self.template_combobox.set_active (active)
		self.template_names = self.backend.gettemplatenames ("crontab")
		
		if not (self.template_names == None or len (self.template_names) <= 0):
			active = self.template_combobox.get_active ()
			if active == -1:
				active = 0
			
		self.template_combobox_model.clear ()
		self.template_combobox_model.append ([_("Don't use a preset"), None, None])

		if self.template_names == None or len (self.template_names) <= 0:
			active = 0
			# self.remove_button.set_sensitive (False)
			# self.save_button.set_sensitive (False)
			self.template_combobox.set_active (0)
			# self.template_combobox.set_sensitive (False)
			# self.template_label.set_sensitive (False)
		else:
			
			for template_name in self.template_names:
				thetemplate = self.backend.gettemplate ("crontab", template_name)
				icon_uri, command, frequency, title, name = thetemplate
				self.template_combobox_model.append([name, template_name, thetemplate])
						
			# self.remove_button.set_sensitive (True)
							
		self.template_combobox.set_active (active)

	# TODO: to gnome specific
	def __loadicon__ (self):
		try:
			pixbuf = gtk.gdk.pixbuf_new_from_file_at_size (self.defaultIcon, 48, 48)
			self.icon = self.defaultIcon
		except gobject.GError:
			pixbuf = gtk.Widget.render_icon (self.widget, gtk.STOCK_MISSING_IMAGE, self.template_image_size, None)
			self.icon = ""

		self.template_image.set_from_pixbuf(pixbuf)
			

	#save template
	def __SaveTemplate__ (self, template_name):
		try:
			# Type should not be translatable!
			#XXX do check in crontab savetemplate itself instead of here?
			self.__check_field_format__ (self.minute, "minute")
			self.__check_field_format__ (self.hour, "hour")
			self.__check_field_format__ (self.day, "day")
			self.__check_field_format__ (self.month, "month")
			self.__check_field_format__ (self.weekday, "weekday")
		except ValueError, ex:
			print ex
			x, y, z = ex
			self.__WrongRecordDialog__ (x, y, z)
			return

		if self.nooutput:
			space = " "
			if self.command[len(self.command)-1] == " ":
				space = ""
			self.command = self.command + space + self.scheduler.nooutputtag
			
		#record = self.minute + " " + self.hour + " " + self.day + " " + self.month + " " + self.weekday + " " + self.command
		self.frequency = self.minute + " " + self.hour + " " + self.day + " " + self.month + " " + self.weekday
		self.backend.savetemplate ("crontab",template_name, self.frequency, self.title, self.icon, self.command)
		

	#error dialog box 
	def __WrongRecordDialog__ (self, x, y, z):
		self.wrongdialog = gtk.MessageDialog(self.widget, gtk.DIALOG_MODAL|gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, (_("This is an invalid record! The problem could be in the %(field)s field. Reason: %(reason)s") % (y, z)))
		self.wrongdialog.run()
		self.wrongdialog.destroy()

		
	def __check_field_format__ (self, field, type):
		try:
			# Type should not be translatable!
			self.scheduler.checkfield (field, type)
		except ValueError, ex:
			raise ex

		
	def template_doesnot_exist (self, message):
		box = gtk.MessageDialog(self.widget, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, message)
		box.set_response_sensitive(gtk.RESPONSE_OK, True)
		run = box.run()
		box.hide()

	#remove template button
	def on_remove_button_clicked (self, *args):
		firstiter = self.template_combobox_model.get_iter_first()
		notemplate = self.template_combobox_model.get_value(firstiter,0)
		entry = self.template_combobox.get_child().get_text()
		if notemplate != entry:
			iter = self.template_combobox.get_active_iter ()
			if iter != None:
				template = self.template_combobox_model.get_value(iter, 2)
				icon_uri, command, frequency, title, template_name = template
				self.template_combobox.set_active (0)
				self.backend.removetemplate ("crontab",template_name)
			else: 
				self.template_doesnot_exist(_("The preset has not been saved"))
		else:
			self.template_doesnot_exist(_("To delete a preset, you first need to select one"))
		
	#save template	button
	def on_save_button_clicked (self, *args):
		firstiter = self.template_combobox_model.get_iter_first()
		notemplate = self.template_combobox_model.get_value(firstiter,0)
		entry = self.template_combobox.get_child().get_text()
		if notemplate != entry:
			self.__SaveTemplate__ (self.template_combobox.get_child().get_text())
		else:
			self.template_doesnot_exist(_("To save a preset, you first have to choose a name for it"))
		

	def gconfkey_changed (self, client, connection_id, entry, args):
		self.__reload_templates__ ()


	def on_image_button_clicked (self, *args):
		preview = gtk.Image()
		preview.show()
		iconopendialog = gtk.FileChooserDialog(_("Choose an Icon for this Scheduled Task"), self.widget, gtk.FILE_CHOOSER_ACTION_OPEN, (gtk.STOCK_OK, gtk.RESPONSE_ACCEPT, gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT), "")
		
		# Preview stuff appears to be highly unstable :-(
		# 2005-12-23, gauteh: seems to work ok now.
		
		iconopendialog.set_preview_widget(preview)
		iconopendialog.connect("update-preview", self.update_preview_cb, preview)
		
		res = iconopendialog.run()
		if res != gtk.RESPONSE_REJECT:
			self.icon = iconopendialog.get_filename()
		iconopendialog.destroy ()
		self.__update_textboxes__ ()

	def update_preview_cb(self, file_chooser, preview):
		filename = file_chooser.get_preview_filename()
		try:
			pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename, 128, 128)
			preview.set_from_pixbuf(pixbuf)
			have_preview = True
		except:
			have_preview = False
			
		file_chooser.set_preview_widget_active(have_preview)
		return


	def on_template_combobox_entry_changed (self, widget):
		pass
		#firstiter = self.template_combobox_model.get_iter_first()
		#notemplate = self.template_combobox_model.get_value(firstiter,0)
		#entry = self.template_combobox.get_child().get_text()
		#if notemplate != entry:
		#	self.save_button.set_sensitive (True)
		#else:
		#	self.save_button.set_sensitive (False)


	def on_template_combobox_changed (self, *args):
		if self.noevents == False:
			iter = self.template_combobox.get_active_iter ()
			if iter == None:
				return
			template = self.template_combobox_model.get_value(iter, 2)
			if template != None:
				# self.remove_button.set_sensitive (True)
				icon_uri, command, frequency, title, name = template
				#if self.ParentClass.saveWindow != None:
				#	self.ParentClass.saveWindow.save_entry.set_text (name)
				try:
					pixbuf = gtk.gdk.pixbuf_new_from_file_at_size (icon_uri, 48, 48)
					self.template_image.set_from_pixbuf(pixbuf)
					self.icon = icon_uri
				except (gobject.GError, TypeError):
					self.__loadicon__ ()
					
				if frequency != None and command != None:
					if title != None:
						record = frequency + " " + command + " # " + title
					else:
						record = frequency + " " + command
				else:
					if frequency == None:
						frequency = "* * * * *"
					if command == None:
						command = _("command")
					record = frequency + " " + command
			
				m = self.nooutputRegex.match (command)
				if (m != None):
					self.nooutput_label.show ()
					command = m.groups()[0]
					self.noevents = True
					self.chkNoOutput.set_active (True)
					self.noevents = False
					self.nooutput = True
				else:
					self.nooutput_label.hide ()
					self.chkNoOutput.set_active (False)
					self.nooutput = False


				self.minute, self.hour, self.day, self.month, self.weekday, self.command, self.title, icon_ = self.scheduler.parse (record)
				self.command = command
				self.__update_textboxes__ ()
			else:
				# self.remove_button.set_sensitive (False)
				# self.save_button.set_sensitive (False)
				self.__loadicon__ ()
				self.__reset__ ()


	def on_cron_help_button_clicked (self, *args):
		try:
			gnome.help_display_with_doc_id (
					self.ParentClass.gprogram, '',
					'gnome-schedule.xml',
					'myapp-adding-recurrent')
		except gobject.GError, error:
			dialog = gtk.MessageDialog (
					self.widget,
					gtk.DIALOG_DESTROY_WITH_PARENT,
					gtk.MESSAGE_ERROR, gtk.BUTTONS_CLOSE)
			dialog.set_markup ("<b>" + _("Could not display help") + "</b>")
			dialog.format_secondary_text ("%s" % error)
			dialog.run ()
			dialog.destroy ()


	def on_cancel_button_clicked (self, *args):
		self.widget.hide()
		#return True


	def on_ok_button_clicked (self, *args):
		try:
			# Type should not be translatable!
			self.__check_field_format__ (self.minute, "minute")
			self.__check_field_format__ (self.hour, "hour")
			self.__check_field_format__ (self.day, "day")
			self.__check_field_format__ (self.month, "month")
			self.__check_field_format__ (self.weekday, "weekday")
		except ValueError, ex:
			x, y, z = ex
			self.__WrongRecordDialog__ (x, y, z)
			return

		record = self.minute + " " + self.hour + " " + self.day + " " + self.month + " " + self.weekday + " " + self.command

		
		if self.editing != False:
			self.scheduler.update (self.minute, self.hour, self.day, self.month, self.weekday, self.command, self.linenumber, self.parentiter, self.nooutput, self.title, self.icon)
			
		else:
			self.scheduler.append (self.minute, self.hour, self.day, self.month, self.weekday, self.command, self.nooutput, self.title, self.icon)
			
		self.ParentClass.schedule_reload ("crontab")
	
		self.widget.hide ()


	def __set_frequency_combo__ (self):
		index = self.__getfrequency__ (self.minute, self.hour, self.day, self.month, self.weekday)
		self.frequency_combobox.set_active (index)

		
	def __getfrequency__ (self, minute, hour, day, month, weekday):
		# index = _("use advanced")
		index = 0

		# Must be translatable, it's the actual content of the combobox-entry
		if minute == "*" and hour == "*" and month == "*" and day == "*" and weekday == "*":
			# index = self.translate_frequency ("minute")
			index = 1
		if minute == "0" and hour == "*" and month == "*" and day == "*" and weekday == "*":
			# index = self.translate_frequency ("hour")
			index = 2
		if minute == "0" and hour == "0" and month == "*" and day == "*" and weekday == "*":
			# index = self.translate_frequency ("day")
			index = 3
		if minute == "0" and hour == "0" and month == "*" and day == "1" and weekday == "*":
			# index = self.translate_frequency ("month")
			index = 4
		if minute == "0" and hour == "0" and month == "*" and day == "*" and weekday == "0":
			# index = self.translate_frequency ("week")
			index = 5

		return index

		
	def __update_textboxes__ (self):
		self.noevents = True
		self.chkNoOutput.set_active (self.nooutput)
		self.command_entry.set_text (self.command)
		self.title_entry.set_text (self.title)
		self.minute_entry.set_text (self.minute)
		self.hour_entry.set_text (self.hour)
		self.day_entry.set_text (self.day)
		self.month_entry.set_text (self.month)
		self.weekday_entry.set_text (self.weekday)
		try:
			pixbuf = gtk.gdk.pixbuf_new_from_file_at_size (self.icon, 48, 48)
			self.template_image.set_from_pixbuf(pixbuf)
		except (gobject.GError, TypeError):
			self.__loadicon__ ()

		self.setting_label.set_text (self.minute + " " + self.hour + " " + self.day + " " + self.month + " " + self.weekday + " " + self.command)
		self.__set_frequency_combo__()
		self.noevents = False


	def on_anyadvanced_entry_changed (self, *args):
		if self.noevents == False:
			self.minute = self.minute_entry.get_text ()
			self.hour = self.hour_entry.get_text ()
			self.day = self.day_entry.get_text ()
			self.month = self.month_entry.get_text ()
			self.weekday = self.weekday_entry.get_text ()
			self.nooutput = self.chkNoOutput.get_active()
			# self.set_frequency_combo ()
			self.template_combobox.set_active (0)
			self.__update_textboxes__ ()


	def on_anybasic_entry_changed (self, *args):
		if self.noevents == False:
			self.command = self.command_entry.get_text ()
			self.title = self.title_entry.get_text ()
			self.nooutput = self.chkNoOutput.get_active()
			self.__update_textboxes__ ()

			if self.nooutput:
				self.nooutput_label.show ()
			else:
				self.nooutput_label.hide ()


	def on_frequency_combobox_changed (self, bin):
		iter = self.frequency_combobox.get_active_iter ()
		frequency = self.frequency_combobox_model.get_value(iter, 1)
		if frequency != None:
			self.minute, self.hour, self.day, self.month, self.weekday = frequency
			self.__update_textboxes__()


	def on_fieldHelp_clicked(self, widget, *args):
		name = widget.get_name()
		field = "minute"
		if name == "btnMinuteHelp" :
			field = "minute"
			expression = self.minute_entry.get_text()
		if name == "btnHourHelp" :
			field = "hour"
			expression = self.hour_entry.get_text()
		if name == "btnDayHelp" :
			field = "day"
			expression = self.day_entry.get_text()
		if name == "btnMonthHelp" :
			field = "month"
			expression = self.month_entry.get_text()
		if name == "btnWeekdayHelp" :
			field = "weekday"
			expression = self.weekday_entry.get_text()

		self.editorhelper.show (field, expression)
