/*********************************
 Change away message
 (c) 1999 Jeremy Wise
 GnomeICU
**********************************/

#include "common.h"
#include "awaymsglist.h"
#include "changeaway.h"
#include "gnomeicu.h"

static void change_away (GtkWidget *widget, gpointer data);

/*** Global functions ***/
void change_away( GtkWidget *widget, gpointer data )
{
#ifdef TRACE_FUNCTION
	g_print( "change_away\n" );
#endif

	/* Is this enough? where do we send this message to server? */
	g_free( Away_Message );
	Away_Message = g_strdup( gtk_editable_get_chars( GTK_EDITABLE( data ),
	                         0, -1 ) );
}

void change_away_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *frame1;
	GtkWidget *scrolledwindow1;
	GtkWidget *text;
	GtkWidget *button1;
	GtkWidget *msg_list;	/* Need the msg list deal */
	gint cx;

#ifdef TRACE_FUNCTION
	g_print( "change_away_window\n" );
#endif

	window = gnome_dialog_new (_("GnomeICU: Away Message"),
				   GNOME_STOCK_BUTTON_OK,
				   GNOME_STOCK_BUTTON_CLOSE, NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Away_Message", "GnomeICU");
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (window)->vbox;

	frame1 = gtk_frame_new (_("Set Away Message:"));
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolledwindow1);
	gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 4);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	text = gtk_text_new (NULL, NULL);
	gtk_widget_show (text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);
	gtk_text_set_editable (GTK_TEXT (text), TRUE);

	/* Following is to add a popup list of popular away messages */
	msg_list = gtk_button_new_with_label(_("Away Messages"));
	gtk_object_set_data(GTK_OBJECT (msg_list), "text", text);
	
	gtk_widget_show(msg_list);
	gtk_signal_connect(GTK_OBJECT(msg_list), "button_press_event",
			   GTK_SIGNAL_FUNC(popup_away_msgs),
			   NULL );

	gtk_widget_set_sensitive( msg_list, FALSE );
	for( cx = 0; cx < AWAY_MSGS_NUM; cx++ )
	{
		if( away_msgs[cx] != NULL && strlen( away_msgs[cx] ) )
			gtk_widget_set_sensitive( msg_list, TRUE );
	}
	
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), msg_list, TRUE,
			   TRUE, 0);
	/* End of the popup list away messages stuff */

	gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, Away_Message, -1 );

	gnome_dialog_set_default (GNOME_DIALOG (window), 0);
	gnome_dialog_set_close (GNOME_DIALOG (window), TRUE);

	gnome_dialog_editable_enters (GNOME_DIALOG (window),
				      GTK_EDITABLE (text));

	button1 = (GNOME_DIALOG (window)->buttons)->data;
	gtk_signal_connect (GTK_OBJECT (button1), "clicked",
			    GTK_SIGNAL_FUNC (change_away), text);

	gtk_window_set_focus (GTK_WINDOW (window), text);

	gtk_widget_show (window);
}
