/**********************************
 Configuration window (Options)
 (c) 1999 Jeremy Wise
 GnomeICU
***********************************/

#include "common.h"
#include "autohide.h"
#include "autoaway.h"
#include "awaymsglist.h"
#include "dirbrowser.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkconf.h"
#include "gtkspell.h"
#include "icons.h"
#include "response.h"
#include "showlist.h"
#include "tcp.h"
#include "v7send.h"

/*** Local function declarations ***/
void apply_changes (GnomePropertyBox *box, gint page);
static void color_set_online (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_offline (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_away (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_na (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_ffc (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_occ (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_dnd (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void color_set_inv (GnomeColorPicker *cp, guint pr, guint pg, guint pb);
static void toggle_switch (GtkWidget *widget, gboolean *toggle_me);
static void toggle_autoaccept (GtkWidget *widget, gboolean *toggle_me);
static void save_changes (GtkWidget *widget, gpointer data);
static void activate_changes (GtkWidget *widget, gpointer data);
static gint options_delete (GnomeDialog *widget, gpointer data);
static void entry_changed (GtkWidget *widget, gpointer data);
static gint Build_Main_Window (void);
static void theme_clist_select_row (GtkCList *clist, gint row, gint col,
                                    GdkEventButton *event, gpointer user_data);
static void url_show_themes (GtkWidget *widget, gpointer data);
static void autoaccept_dirbrowse (GtkWidget *widget, gpointer data);
static void autoaccept_setpath (gchar *path, gpointer data);

void spin_button_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton);
void spin_button4_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton);
void spin_button5_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton);
void spin_button6_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton);
void spin_button7_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton);

/* Away Msg List */
static void do_away_msgs (GtkWidget* main_window, GtkWidget*
		  away_frame, GtkWidget *away_msg_table, const int
			 num);
static void get_away_msg (GtkWidget *away_msg, gpointer data);
static gchar **temp_away_msgs = NULL; /* Local */
/* End Away Msg List */

/* Temporary values so changes are NOT saved unless "Save" is pressed */
_toggles *temp_toggles;

gint temp_autohide_time = 0;
gint temp_min_tcp_port = 0;
gint temp_max_tcp_port = 0;

GdkColor temp_color_online;
GdkColor temp_color_offline;
GdkColor temp_color_away;
GdkColor temp_color_na;
GdkColor temp_color_ffc;
GdkColor temp_color_occ;
GdkColor temp_color_dnd;
GdkColor temp_color_inv;

GdkColor color_online, color_offline, color_away, color_na, color_ffc, color_occ, color_dnd, color_inv;
int color_online_set = 0, color_offline_set = 0, color_away_set = 0, color_na_set = 0, color_ffc_set = 0, color_occ_set = 0, color_dnd_set = 0, color_inv_set = 0;

GtkWidget *GnomeICU_Options;
static gboolean Options_Open = FALSE;
GtkWidget *icqserver, *portnumber, *uin, *nick, *pass, *filesel;

GtkWidget *ext_prog_receive_message, *ext_prog_chat_request;
GtkWidget *ext_prog_receive_url, *ext_prog_file_request;
GtkWidget *ext_prog_user_online, *ext_prog_user_offline;
GtkWidget *ext_prog_auth, *ext_prog_auth_request;
GtkWidget *ext_prog_list_add, *ext_prog_contact_list;

GtkWidget *autoaway_entry, *autona_entry;

GtkWidget *autoaccept_enable, *autoaccept_path, *autoaccept_label, *autoaccept_browse;

/*** Global functions ***/
void init_colors (void)
{
#ifdef TRACE_FUNCTION
	g_print ("init_colors\n");
#endif

	/* Online is blue */
	if (color_online_set == FALSE)
	{
		color_online.red = 0;
		color_online.green = 0;
		color_online.blue = 30000;
		color_online.pixel = (gulong) (255);
	}

	/* Offline is dark gray */
	if (color_offline_set == FALSE)
	{
		color_offline.red = 30000;
		color_offline.green = 30000;
		color_offline.blue = 30000;
		color_offline.pixel = (gulong) (255*50000);
	}

	/* Away is green */
	if (color_away_set == FALSE)
	{
		color_away.red = 0;
		color_away.green = 30000;
		color_away.blue = 0;
		color_away.pixel = (gulong)255*256;
	}

	/* Not available is green also */
	if (color_na_set == FALSE)
	{
		color_na.red = 0;
		color_na.green = 30000;
		color_na.blue = 0;
		color_na.pixel = (gulong)255*256;
	}

	/* Free for chat is blue */
	if (color_ffc_set == FALSE)
	{
		color_ffc.red = 0;
		color_ffc.green = 0;
		color_ffc.blue = 30000;
		color_ffc.pixel = (gulong) (255);
	}

	/* Occupied is green */
	if (color_occ_set == FALSE)
	{
		color_occ.red = 0;
		color_occ.green = 30000;
		color_occ.blue = 0;
		color_occ.pixel = (gulong)255*256;
	}

	/* Do not disturb is green also */
	if (color_dnd_set == FALSE)
	{
		color_dnd.red = 0;
		color_dnd.green = 30000;
		color_dnd.blue = 0;
		color_dnd.pixel = (gulong)255*256;
	}

	/* Invisible is blue */
	if (color_inv_set == FALSE)
	{
		color_inv.red = 0;
		color_inv.green = 0;
		color_inv.blue = 30000;
		color_inv.pixel = (gulong) (255);
	}

	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_online);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_offline);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_away);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_na);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_ffc);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_occ);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_dnd);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_inv);
}

/* Based on populate_theme_list () from the Clock & Mail applet */
static GList *themes_fill_glist (GList *orig_theme_list, gchar *themepath)
{
	DIR *theme_dir;
	struct dirent *dir;
	struct stat ent_sbuf;
	GList *theme_list = NULL;

	theme_list = orig_theme_list;

	if ((theme_dir = opendir (themepath)) == NULL)	/* No such dir */
		return theme_list;

	while ((dir = readdir (theme_dir)) != NULL) {	/* Dir found */
		if (dir->d_ino > 0 && strcmp ("Default", dir->d_name)) {
			gchar *name;
			gchar *path;

			name = dir->d_name;
			path = g_strconcat (themepath, "/", name, NULL);

			if (stat (path, &ent_sbuf) >= 0
			    && S_ISDIR (ent_sbuf.st_mode)) {
				if (name[0] != '.')
					theme_list = g_list_insert (theme_list,
								    g_strdup
								    (name), -1);
			}
			g_free (path);
		}
	}
	closedir (theme_dir);

	return theme_list;
}

static void themes_fill_clist (GtkWidget *clist)
{
	gchar *buf[] = { "x", };
	gchar *themepath;
	gint row;
	GList *theme_list = NULL, *list;

	buf[0] = _("Default");
	gtk_clist_append (GTK_CLIST (clist), buf);
	gtk_clist_set_row_data (GTK_CLIST (clist), 0, "Default");

	/* Global themes */
	themepath = GNOMEICU_DATADIR "/gnomeicu/icons";
	theme_list = themes_fill_glist (theme_list, themepath);

	/* Local themes */
	themepath = g_strconcat (g_get_home_dir (), "/.icq/icons", NULL);
	theme_list = themes_fill_glist (theme_list, themepath);
	g_free (themepath);

	list = theme_list;
	while (list) {
		buf[0] = list->data;
		row = gtk_clist_append (GTK_CLIST (clist), buf);
		if (strcmp (buf[0], toggles->theme_name) == 0) {
			gtk_clist_select_row (GTK_CLIST (clist), row, 0);
			theme_clist_select_row (GTK_CLIST (clist), row, 0, NULL,
						NULL);
		}
		g_free (list->data);
		list = list->next;
	}

	g_list_free (theme_list);

	if (GTK_CLIST (clist)->selection == NULL)
		gtk_clist_select_row (GTK_CLIST (clist), 0, 0);

	gnome_property_box_set_state (GNOME_PROPERTY_BOX (GnomeICU_Options),
				      FALSE);

}

static void theme_clist_select_row (GtkCList *clist,
                                    gint row, gint col,
                                    GdkEventButton *event,
                                    gpointer user_data)
{
	gchar *selected_theme, *filename, *theme_info = NULL;
	struct stat flnf;
	gint fd;

	if (row > 0)
		gtk_clist_get_text (clist, row, col, &selected_theme);
	else
		selected_theme = "Default";

	g_free (temp_toggles->theme_name);
	temp_toggles->theme_name = g_strdup (selected_theme);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));

	/* Update the label with the theme info */
	filename = make_icon_path_theme ("gnomeicu-info", selected_theme);
	if (filename == NULL) {
		gtk_label_set_text (GTK_LABEL (gtk_object_get_data (GTK_OBJECT (clist), "label")), "");
		return;
	}
	stat (filename, &flnf);
	fd = open (filename, O_RDONLY);
	theme_info = (gchar *) g_malloc (flnf.st_size + 2);
	read (fd, theme_info, flnf.st_size);
	theme_info[flnf.st_size] = '\0';
	close (fd);
	g_free (filename);

	gtk_label_set_text (GTK_LABEL (gtk_object_get_data (GTK_OBJECT (clist), "label")),
			    theme_info);
	g_free (theme_info);
}

void configure_window (GtkWidget *widget, gpointer data)
{
	GtkWidget *notebook1;
	GtkWidget *interface_vbox;
	GtkWidget *colors_frame;
	GtkWidget *table1;
	GtkWidget *label;
	GtkWidget *alignment1;
	GtkWidget *alignment2;
	GtkWidget *alignment3;
	GtkWidget *alignment4;
	GtkWidget *alignment5;
	GtkWidget *alignment6;
	GtkWidget *alignment7;
	GtkWidget *alignment8;
	GtkWidget *picker_online;
	GtkWidget *picker_away;
	GtkWidget *picker_ffc;
	GtkWidget *picker_na;
	GtkWidget *picker_occ;
	GtkWidget *picker_dnd;
	GtkWidget *picker_inv;
	GtkWidget *picker_offline;
	GtkWidget *sound_frame;
	GtkWidget *vbox5;
	GtkWidget *beep_button;
#ifdef HAVE_ESD
	GtkWidget *sound_button;
#endif
#ifdef BUILD_APPLET
	GtkWidget *showappletborder_button;
	GtkWidget *tooltip_button;
#endif
	GtkWidget *showmain_button;
	GtkWidget *fullreply_button;
	GtkWidget *network_vbox;
	GtkWidget *packet_frame;
	GtkWidget *vbox7;
	GtkWidget *russian_button;
	GtkWidget *latin2_button;
#ifdef HAVE_ICONV
	GtkWidget *kanji_button;
#endif
	GtkWidget *dumptcp_button;
        GtkWidget *dumpudp_button;
	GtkWidget *dumpnew_button;
	GtkWidget *server_frame;
	GtkWidget *vbox8;
	GtkWidget *table3;
	GtkWidget *alignment9;
	GtkObject *portnumber_adj;
	GtkWidget *tcp_frame;
	GtkWidget *range_hbox;
	GtkObject *spinbutton4_adj;
	GtkWidget *spinbutton4;
	GtkObject *spinbutton5_adj;
	GtkWidget *spinbutton5;
	GtkWidget *misc_vbox;
	GtkWidget *frame6;
	GtkWidget *vbox10;
	GtkWidget *webpresence_button;
	GtkWidget *popup_button;
	GtkWidget *hbox2;
	GtkWidget *autohide_button;
	GtkWidget *connect_startup_button;
	GtkObject *spin_button_adj;
	GtkWidget *spin_button;
	GtkWidget *user_frame;
	GtkWidget *table25;
	GtkWidget *table4;
	GtkWidget *run_frame;
	GtkWidget *toggle1;
	GtkWidget *entry1;
	GtkWidget *event_vbox;
	GtkWidget *statusnotify_button;
	GtkWidget *toggle, *theme_frame, *vbox;
	GtkWidget *theme_clist;
	GtkWidget *scrolled_window;
	GtkWidget *theme_button;
	GtkWidget *auto_recon_forced_button;
	GtkWidget *debug_vbox;
	GtkWidget *debug_frame;

	/* Auto-Away/NA -- NH */
	GtkWidget *autoaway_frame;
	GtkWidget *autoaway_table;
	GtkObject *autoaway_spinbutton_adj;
	GtkWidget *autoaway_spinbutton;	
	GtkObject *autona_spinbutton_adj;
	GtkWidget *autona_spinbutton;
	/* End Auto-Away */

	gchar *tmp;

	int temp;
	GtkWidget *away_frame, *away_msg_table, *away_vbox;

	if (Options_Open == TRUE) return;

	temp_toggles = g_new0 (_toggles, 1);
	memcpy (temp_toggles, toggles, sizeof (_toggles));

	memcpy (&temp_color_online, &color_online, sizeof (GdkColor));
	memcpy (&temp_color_offline, &color_offline, sizeof (GdkColor));
	memcpy (&temp_color_away, &color_away, sizeof (GdkColor));
	memcpy (&temp_color_na, &color_na, sizeof (GdkColor));
	memcpy (&temp_color_ffc, &color_ffc, sizeof (GdkColor));
	memcpy (&temp_color_occ, &color_occ, sizeof (GdkColor));
	memcpy (&temp_color_dnd, &color_dnd, sizeof (GdkColor));
	memcpy (&temp_color_inv, &color_inv, sizeof (GdkColor));

	temp_autohide_time = autohide_time;
	temp_min_tcp_port = min_tcp_port;
	temp_max_tcp_port = max_tcp_port;

	GnomeICU_Options = gnome_property_box_new ();
	Options_Open = TRUE;
	gtk_window_set_title (GTK_WINDOW (GnomeICU_Options), _("GnomeICU: Preferences"));

	notebook1 = GNOME_PROPERTY_BOX (GnomeICU_Options)->notebook;
	gtk_object_set_data (GTK_OBJECT (GnomeICU_Options), "notebook1", notebook1);
	gtk_widget_show (notebook1);

	/* Networking tab */
	network_vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (network_vbox);
	gtk_container_add (GTK_CONTAINER (notebook1), network_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (network_vbox), 6);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label), _("_Networking"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), label);

	user_frame = gtk_frame_new (_("User Information"));
	gtk_widget_show (user_frame);
	gtk_box_pack_start (GTK_BOX (network_vbox), user_frame, FALSE, TRUE, 0);

	table25 = gtk_table_new (3, 2, FALSE);
	gtk_widget_show (table25);
	gtk_container_add (GTK_CONTAINER (user_frame), table25);
	gtk_container_set_border_width (GTK_CONTAINER (table25), 6);
	gtk_table_set_row_spacings (GTK_TABLE (table25), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table25), 4);

	uin = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (uin), (tmp=g_strdup_printf ("%u", our_info->uin)));
	g_free (tmp);
	gtk_widget_show (uin);
	gtk_table_attach (GTK_TABLE (table25), uin, 1, 2, 0, 1,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect (GTK_OBJECT (uin), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	nick = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (nick), our_info->nick);
	gtk_widget_show (nick);
	gtk_table_attach (GTK_TABLE (table25), nick, 1, 2, 1, 2,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect (GTK_OBJECT (nick), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	pass = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (pass), passwd);
	gtk_entry_set_visibility (GTK_ENTRY (pass), FALSE);
	gtk_widget_show (pass);
	gtk_table_attach (GTK_TABLE (table25), pass, 1, 2, 2, 3,
	                  (GtkAttachOptions) (0),
	                  (GtkAttachOptions) (0), 0, 0);

	gtk_signal_connect (GTK_OBJECT (pass), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	label = gtk_label_new (_("UIN:"));
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Nickname:"));
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 1, 2,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Password:"));
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table25), label, 0, 1, 2, 3,
	                  (GtkAttachOptions) (GTK_FILL),
	                  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	server_frame = gtk_frame_new (_("Server"));
	gtk_widget_show (server_frame);
	gtk_box_pack_start (GTK_BOX (network_vbox), server_frame, FALSE, TRUE, 0);

	vbox8 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox8);
	gtk_container_add (GTK_CONTAINER (server_frame), vbox8);
	gtk_container_set_border_width (GTK_CONTAINER (vbox8), 6);

	table3 = gtk_table_new (3, 4, FALSE);
	gtk_widget_show (table3);
	gtk_box_pack_start (GTK_BOX (vbox8), table3, TRUE, TRUE, 0);
	gtk_table_set_row_spacings (GTK_TABLE (table3), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table3), 4);

	label = gtk_label_new (_("ICQ Server:"));
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table3), label, 0, 1, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);

	label = gtk_label_new (_("Port Number:"));
	gtk_widget_show (label);
	gtk_table_attach (GTK_TABLE (table3), label, 2, 3, 0, 1,
	                  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (GTK_FILL), 0, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);

	icqserver = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (icqserver), server);
	gtk_widget_show (icqserver);
	gtk_table_attach_defaults (GTK_TABLE (table3), icqserver, 1, 2, 0, 1);
	gtk_signal_connect (GTK_OBJECT (icqserver), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	alignment9 = gtk_alignment_new (0, 0.5, 0.1, 1);
	gtk_widget_show (alignment9);
	gtk_table_attach_defaults (GTK_TABLE (table3), alignment9, 3, 4, 0, 1);

	portnumber_adj = gtk_adjustment_new (remote_port, 1024, 65536, 1, 10, 10);
	portnumber = gtk_spin_button_new (GTK_ADJUSTMENT (portnumber_adj), 1, 0);
	gtk_widget_show (portnumber);
	gtk_container_add (GTK_CONTAINER (alignment9), portnumber);

	connect_startup_button = gtk_check_button_new_with_label (_("Connect to server on startup"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (connect_startup_button), temp_toggles->connect_startup);
	gtk_widget_show (connect_startup_button);
	gtk_table_attach_defaults (GTK_TABLE (table3), connect_startup_button, 0, 4, 1, 2);

	auto_recon_forced_button = gtk_check_button_new_with_label (_("Automatically reconnect on forced disconnection"));
	gtk_widget_set_name (auto_recon_forced_button, "auto_recon_forced_button");
	gtk_widget_ref (auto_recon_forced_button);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), 
	                          "auto_recon_forced_button",
	                          auto_recon_forced_button,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (auto_recon_forced_button), 
	                             temp_toggles->auto_recon_forced);
	gtk_widget_show (auto_recon_forced_button);

	gtk_table_attach_defaults (GTK_TABLE (table3), auto_recon_forced_button, 0, 4, 2, 3);

	tcp_frame = gtk_frame_new (_("TCP Port Range"));
	gtk_widget_show (tcp_frame);
	gtk_box_pack_start (GTK_BOX (network_vbox), tcp_frame, FALSE, TRUE, 0);

	range_hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (range_hbox);
	gtk_container_add (GTK_CONTAINER (tcp_frame), range_hbox);
	gtk_container_set_border_width (GTK_CONTAINER (range_hbox), 6);

	label = gtk_label_new (_("Range: From "));
	gtk_widget_show (label);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);
	gtk_box_pack_start (GTK_BOX (range_hbox), label, FALSE, FALSE, 0);

	spinbutton4_adj = gtk_adjustment_new (temp_min_tcp_port, 1024, 65535, 1, 10, 10);
	spinbutton4 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton4_adj), 1, 0);
	gtk_widget_show (spinbutton4);
	gtk_box_pack_start (GTK_BOX (range_hbox), spinbutton4, FALSE, TRUE, 0);
	gtk_widget_set_usize (spinbutton4, 75, -2);

	label = gtk_label_new (_("   to   "));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (range_hbox), label, FALSE, FALSE, 0);

	spinbutton5_adj = gtk_adjustment_new (temp_max_tcp_port, 1024, 65535, 1, 10, 10);
	spinbutton5 = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton5_adj), 1, 0);
	gtk_widget_show (spinbutton5);
	gtk_box_pack_start (GTK_BOX (range_hbox), spinbutton5, FALSE, TRUE, 0);
	gtk_widget_set_usize (spinbutton5, 75, -2);

	packet_frame = gtk_frame_new (_("Packets"));
	gtk_widget_show (packet_frame);
	gtk_box_pack_start (GTK_BOX (network_vbox), packet_frame, FALSE, TRUE, 0);

	vbox7 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox7);
	gtk_container_add (GTK_CONTAINER (packet_frame), vbox7);
	gtk_container_set_border_width (GTK_CONTAINER (vbox7), 6);
 
 	/* Russian reencoding toggle button*/
 
 	russian_button = gtk_check_button_new_with_label (_("Cyrillic CP1251<->KOI8-U translation"));
 	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (russian_button), temp_toggles->russian);
 	gtk_widget_show (russian_button);
 	gtk_box_pack_start (GTK_BOX (vbox7), russian_button, FALSE, FALSE, 0);

	latin2_button = gtk_check_button_new_with_label (_("CP1250 <-> ISO-8859-2 translation"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (latin2_button), temp_toggles->latin2);
	gtk_widget_show (latin2_button);
	gtk_box_pack_start (GTK_BOX (vbox7), latin2_button, FALSE, FALSE, 0);

#ifdef HAVE_ICONV
 	/* Kanji reencoding toggle button*/
 	kanji_button = gtk_check_button_new_with_label (_("Kanji Locale<->SJIS translation"));
 	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (kanji_button), temp_toggles->kanji);
 	gtk_widget_show (kanji_button);
 	gtk_box_pack_start (GTK_BOX (vbox7), kanji_button, FALSE, FALSE, 0);
#endif


	dumpnew_button = gtk_check_button_new_with_label (_("Refuse packets from unknown contacts"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dumpnew_button), temp_toggles->no_new_users);
	gtk_widget_show (dumpnew_button);
	gtk_box_pack_start (GTK_BOX (vbox7), dumpnew_button, FALSE, FALSE, 0);

	/* Event feedback tab */

	event_vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (event_vbox);
	gtk_container_add (GTK_CONTAINER (notebook1), event_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (event_vbox), 6);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
			       _("_Event feedback"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 1), label);

	sound_frame = gtk_frame_new (_("Sounds"));
	gtk_widget_show (sound_frame);
	gtk_box_pack_start (GTK_BOX (event_vbox), sound_frame, FALSE, TRUE, 0);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox5);
	gtk_container_add (GTK_CONTAINER (sound_frame), vbox5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox5), 6);

#ifdef HAVE_ESD
	sound_button = gtk_check_button_new_with_label (_("Enable sounds"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (sound_button), temp_toggles->sound);
	gtk_widget_show (sound_button);
	gtk_box_pack_start (GTK_BOX (vbox5), sound_button, FALSE, FALSE, 0);

	toggle = gtk_check_button_new_with_label (_("Enable sounds only when online"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle), temp_toggles->sound_onlyonline);
	gtk_widget_show (toggle);
	gtk_box_pack_start (GTK_BOX (vbox5), toggle, FALSE, FALSE, 0);
	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->sound_onlyonline);
#endif

	beep_button = gtk_check_button_new_with_label (_("Enable beeps"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (beep_button), temp_toggles->beep);
	gtk_widget_show (beep_button);
	gtk_box_pack_start (GTK_BOX (vbox5), beep_button, FALSE, FALSE, 0);

	run_frame = gtk_frame_new (_("Run Program On Event"));
	gtk_widget_show (run_frame);
	gtk_box_pack_start (GTK_BOX (event_vbox), run_frame, FALSE, TRUE, 0);

	table4 = gtk_table_new (11, 2, FALSE);
	gtk_widget_show (table4);
	gtk_container_add (GTK_CONTAINER (run_frame), table4);
	gtk_container_set_border_width (GTK_CONTAINER (table4), 6);

	toggle1 = gtk_check_button_new_with_label (_("Receive Message"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_receive_message);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_receive_message);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 0, 1);

	entry1 = gtk_entry_new ();
	ext_prog_receive_message = entry1;
	if (programs->receive_message)
		gtk_entry_set_text (GTK_ENTRY (entry1), programs->receive_message);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 0, 1);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Chat Request"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_chat_request);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_chat_request);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 1, 2);

	entry1 = gtk_entry_new ();
	ext_prog_chat_request = entry1;
	if (programs->chat_request)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->chat_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 1, 2);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Receive URL"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_receive_url);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_receive_url);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 2, 3);

	entry1 = gtk_entry_new ();
	ext_prog_receive_url = entry1;
	if (programs->receive_url)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->receive_url);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 2, 3);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("File Request"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_file_request);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_file_request);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 3, 4);

	entry1 = gtk_entry_new ();
	ext_prog_file_request = entry1;
	if (programs->file_request)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->file_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 3, 4);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("User Online"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_user_online);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_user_online);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 4, 5);

	entry1 = gtk_entry_new ();
	ext_prog_user_online = entry1;
	if (programs->user_online)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->user_online);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 4, 5);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("User Offline"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_user_offline);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_user_offline);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 5, 6);

	entry1 = gtk_entry_new ();
	ext_prog_user_offline = entry1;
	if (programs->user_offline)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->user_offline);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 5, 6);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Authorized By User"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_auth);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_auth);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 6, 7);

	entry1 = gtk_entry_new ();
	ext_prog_auth = entry1;
	if (programs->auth)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->auth);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 6, 7);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Authorization Request"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_auth_request);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_auth_request);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 7, 8);

	entry1 = gtk_entry_new ();
	ext_prog_auth_request = entry1;
	if (programs->auth_request)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->auth_request);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 7, 8);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Added to Users List"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_list_add);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_list_add);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 8, 9);

	entry1 = gtk_entry_new ();
	ext_prog_list_add = entry1;
	if (programs->list_add)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->list_add);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 8, 9);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	toggle1 = gtk_check_button_new_with_label (_("Contact List"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (toggle1),
				     temp_toggles->program_on_contact_list);
	gtk_widget_show (toggle1);
	gtk_signal_connect (GTK_OBJECT (toggle1), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->program_on_contact_list);
	gtk_table_attach_defaults (GTK_TABLE (table4), toggle1, 0, 1, 9, 10);

	entry1 = gtk_entry_new ();
	ext_prog_contact_list = entry1;
	if (programs->contact_list)
		gtk_entry_set_text (GTK_ENTRY (entry1),
				    programs->contact_list);
	gtk_widget_show (entry1);
	gtk_table_attach_defaults (GTK_TABLE (table4), entry1, 1, 2, 9, 10);
	gtk_signal_connect (GTK_OBJECT (entry1), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	label = gtk_label_new (_("Application will be run with 3 arguments:\nYour current status, contact's UIN, Contact's nickname"));
	gtk_table_attach_defaults (GTK_TABLE (table4), label, 0, 2, 10, 11);
	gtk_widget_show (label);

	/* Away tab */
	away_vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (away_vbox);
	gtk_container_add (GTK_CONTAINER (notebook1), away_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (away_vbox), 6);
	
	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label), _("_Away Messages"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 2), label);

	away_frame = gtk_frame_new (_("Away Messages"));
	gtk_widget_show (away_frame);
	gtk_box_pack_start (GTK_BOX (away_vbox), away_frame, FALSE, TRUE, 0);

	away_msg_table = gtk_table_new (10, 2, FALSE);
	gtk_widget_show (away_msg_table);
	gtk_container_add (GTK_CONTAINER (away_frame), away_msg_table);
	gtk_container_set_border_width (GTK_CONTAINER (away_msg_table), 6);
	/* If it's the first time, we have to set up our copy of the
	   away message list for the whole "change but don't apply
	   changes" fun */
	if (temp_away_msgs == NULL) { /* It's the 1st time */
	  temp_away_msgs = g_new (gchar*, AWAY_MSGS_NUM);
	  for (temp = 0; temp < AWAY_MSGS_NUM; temp++)
	    temp_away_msgs[temp] = NULL;
	}
	/* Now, we set up each away message (10 total) */
	for (temp = 0; temp < AWAY_MSGS_NUM; temp++) {
	  do_away_msgs (GnomeICU_Options, away_frame, away_msg_table,
		       temp);
	  g_free (temp_away_msgs[temp]);
	  temp_away_msgs[temp] = g_strdup (get_away_msg_from_list (temp));
	}
	/* End of Away Message Stuff */

	/* AutoAway/NA Timeout */
	autoaway_frame = gtk_frame_new (_("Auto Away"));
	gtk_widget_show (autoaway_frame);
	gtk_box_pack_start (GTK_BOX (away_vbox), autoaway_frame, FALSE, TRUE, 0);

	autoaway_table = gtk_table_new (2, 2, FALSE);
	gtk_container_add (GTK_CONTAINER (autoaway_frame), autoaway_table);
	gtk_container_set_border_width (GTK_CONTAINER (autoaway_table), 6);
	gtk_widget_show (autoaway_table);

	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_show (hbox2);
	gtk_table_attach_defaults (GTK_TABLE (autoaway_table), hbox2, 1, 2, 0, 1);

	toggle = gtk_check_button_new ();
	label = gtk_label_new (_("Auto away time out is "));
	gtk_widget_show (toggle);
	gtk_table_attach_defaults (GTK_TABLE (autoaway_table), toggle, 0, 1, 0, 1);

	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), temp_toggles->use_autoaway);

	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->use_autoaway);

	autoaway_spinbutton_adj = gtk_adjustment_new (temp_toggles->auto_away, 0, 3600, 1, 10, 10);
	autoaway_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (autoaway_spinbutton_adj), 1, 0);
	gtk_widget_set_sensitive (autoaway_spinbutton, GTK_TOGGLE_BUTTON (toggle)->active);
	gtk_widget_show (autoaway_spinbutton);
	gtk_box_pack_start (GTK_BOX (hbox2), autoaway_spinbutton, FALSE, TRUE, 0);
	gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (autoaway_spinbutton), GTK_UPDATE_IF_VALID);

	gtk_signal_connect (GTK_OBJECT (autoaway_spinbutton_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button6_changed_cb),
	                    autoaway_spinbutton);
	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    (GtkSignalFunc) set_sensitive,
	                    autoaway_spinbutton);

	label = gtk_label_new (_("minutes"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_show (hbox2);
	gtk_table_attach_defaults (GTK_TABLE (autoaway_table), hbox2, 1, 2, 1, 2);

	autoaway_entry = gtk_entry_new ();
	gtk_widget_show (autoaway_entry);

	gtk_entry_set_text (GTK_ENTRY (autoaway_entry), auto_away_message);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "autoaway_message", auto_away_message, NULL);
	

	gtk_signal_connect (GTK_OBJECT (autoaway_entry), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);
	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    (GtkSignalFunc) set_sensitive,
	                    autoaway_entry);

	label = gtk_label_new (_("Auto away message: "));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (hbox2), autoaway_entry, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_show (hbox2);

	gtk_table_attach_defaults (GTK_TABLE (autoaway_table), hbox2, 1, 2, 2, 3);

	label = gtk_label_new (_("Auto N/A time out is "));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	autona_spinbutton_adj = gtk_adjustment_new (temp_toggles->auto_na, 0, 3600, 1, 10, 10);
	autona_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (autona_spinbutton_adj), 1, 0);
	gtk_widget_set_sensitive (autona_spinbutton, GTK_TOGGLE_BUTTON (toggle)->active);
	gtk_widget_show (autona_spinbutton);
	gtk_box_pack_start (GTK_BOX (hbox2), autona_spinbutton, FALSE, TRUE, 0);
	gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (autona_spinbutton), GTK_UPDATE_IF_VALID);

	gtk_signal_connect (GTK_OBJECT (autona_spinbutton_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button7_changed_cb),
	                    autona_spinbutton);

	label = gtk_label_new (_("minutes"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);


	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    (GtkSignalFunc) set_sensitive,
	                    autona_spinbutton);
	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_show (hbox2);


	gtk_table_attach_defaults (GTK_TABLE (autoaway_table), hbox2, 1, 2, 3, 4);

	autona_entry = gtk_entry_new ();
	gtk_widget_show (autona_entry);

	gtk_entry_set_text (GTK_ENTRY (autona_entry), auto_na_message);
	gtk_object_set_data_full (GTK_OBJECT (GnomeICU_Options), "autona_message", auto_na_message, NULL);
	

	gtk_signal_connect (GTK_OBJECT (autona_entry), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    (GtkSignalFunc) set_sensitive,
	                    autona_entry);

	label = gtk_label_new (_("Auto N/A message: "));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	gtk_box_pack_start (GTK_BOX (hbox2), autona_entry, FALSE, FALSE, 0);

	/* Interface tab */
	interface_vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (interface_vbox);
	gtk_container_add (GTK_CONTAINER (notebook1), interface_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (interface_vbox), 6);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
	                       _("_Interface"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 3), label);

	colors_frame = gtk_frame_new (_("Colors"));
	gtk_widget_show (colors_frame);
	gtk_box_pack_start (GTK_BOX (interface_vbox), colors_frame, FALSE, TRUE, 0);

	table1 = gtk_table_new (4, 4, TRUE);
	gtk_widget_show (table1);
	gtk_container_add (GTK_CONTAINER (colors_frame), table1);
	gtk_container_set_border_width (GTK_CONTAINER (table1), 6);
	gtk_table_set_row_spacings (GTK_TABLE (table1), 4);
	gtk_table_set_col_spacings (GTK_TABLE (table1), 4);

	label = gtk_label_new (_("Online"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 0, 1, 0, 1);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Away"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 0, 1, 1, 2);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Not Available"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 0, 1, 2, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Free For Chat"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 0, 1, 3, 4);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	alignment1 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment1);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment1, 1, 2, 0, 1);

	picker_online = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_online),
	           temp_color_online.red,
	           temp_color_online.green,
	           temp_color_online.blue,
	           0);

	gtk_widget_show (picker_online);
	gtk_container_add (GTK_CONTAINER (alignment1), picker_online);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_online), _("GnomeICU: Online Color"));

	alignment2 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment2);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment2, 1, 2, 1, 2);

	picker_away = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_away),
	           temp_color_away.red,
	           temp_color_away.green,
	           temp_color_away.blue,
	           0);

	gtk_widget_show (picker_away);
	gtk_container_add (GTK_CONTAINER (alignment2), picker_away);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_away), _("GnomeICU: Away Color"));

	alignment3 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment3);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment3, 1, 2, 2, 3);

	picker_na = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_na),
	           temp_color_na.red,
	           temp_color_na.green,
	           temp_color_na.blue,
	           0);

	gtk_widget_show (picker_na);
	gtk_container_add (GTK_CONTAINER (alignment3), picker_na);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_na), _("GnomeICU: Not Available Color"));

	alignment4 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment4);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment4, 1, 2, 3, 4);

	picker_ffc = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_ffc),
	           temp_color_ffc.red,
	           temp_color_ffc.green,
	           temp_color_ffc.blue,
	           0);

	gtk_widget_show (picker_ffc);
	gtk_container_add (GTK_CONTAINER (alignment4), picker_ffc);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_ffc), _("GnomeICU: Free for Chat Color"));

	label = gtk_label_new (_("Occupied"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 2, 3, 0, 1);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Do not Disturb"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 2, 3, 1, 2);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Invisible"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 2, 3, 2, 3);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	label = gtk_label_new (_("Offline"));
	gtk_widget_show (label);
	gtk_table_attach_defaults (GTK_TABLE (table1), label, 2, 3, 3, 4);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_RIGHT);
	gtk_misc_set_alignment (GTK_MISC (label), 1, 0.5);

	alignment5 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment5);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment5, 3, 4, 0, 1);

	picker_occ = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_occ),
	           temp_color_occ.red,
	           temp_color_occ.green,
	           temp_color_occ.blue,
	           0);

	gtk_widget_show (picker_occ);
	gtk_container_add (GTK_CONTAINER (alignment5), picker_occ);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_occ), _("GnomeICU: Occupied Color"));

	alignment6 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment6);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment6, 3, 4, 1, 2);

	picker_dnd = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_dnd),
	           temp_color_dnd.red,
	           temp_color_dnd.green,
	           temp_color_dnd.blue,
	           0);

	gtk_widget_show (picker_dnd);
	gtk_container_add (GTK_CONTAINER (alignment6), picker_dnd);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_dnd), _("GnomeICU: Do not Disturb Color"));

	alignment7 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment7);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment7, 3, 4, 2, 3);

	picker_inv = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_inv),
	           temp_color_inv.red,
	           temp_color_inv.green,
	           temp_color_inv.blue,
	           0);

	gtk_widget_show (picker_inv);
	gtk_container_add (GTK_CONTAINER (alignment7), picker_inv);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_inv), _("GnomeICU: Invisible Color"));

	alignment8 = gtk_alignment_new (0, 0.5, 0, 1);
	gtk_widget_show (alignment8);
	gtk_table_attach_defaults (GTK_TABLE (table1), alignment8, 3, 4, 3, 4);

	picker_offline = gnome_color_picker_new ();

	gnome_color_picker_set_i16 (GNOME_COLOR_PICKER (picker_offline),
	           temp_color_offline.red,
	           temp_color_offline.green,
	           temp_color_offline.blue,
	           0);

	gtk_widget_show (picker_offline);
	gtk_container_add (GTK_CONTAINER (alignment8), picker_offline);
	gnome_color_picker_set_title (GNOME_COLOR_PICKER (picker_offline), _("GnomeICU: Offline Color"));

	theme_frame = gtk_frame_new (_("Icon Theme"));
	gtk_box_pack_start (GTK_BOX (interface_vbox), theme_frame, TRUE, TRUE, 0);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (theme_frame), vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (GTK_WIDGET (scrolled_window));
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);

	theme_clist = gtk_clist_new (1);
	gtk_container_add (GTK_CONTAINER (scrolled_window), theme_clist);

	label = gtk_label_new ("");
	gtk_label_set_line_wrap (GTK_LABEL (label), TRUE);
	gtk_object_set_data (GTK_OBJECT (theme_clist), "label", label);
	gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, TRUE, 0);

	themes_fill_clist (theme_clist);

	theme_button = gtk_button_new_with_label (_("Download Themes"));

	gtk_box_pack_start (GTK_BOX (vbox), theme_button, FALSE, FALSE, 0);

	gtk_signal_connect (GTK_OBJECT (theme_button), "clicked",
	                    GTK_SIGNAL_FUNC (url_show_themes), NULL);

	gtk_signal_connect (GTK_OBJECT (theme_clist), "select-row",
	                    GTK_SIGNAL_FUNC (theme_clist_select_row),
	                    NULL);

	gtk_widget_show_all (vbox);

#ifdef BUILD_APPLET
	frame6 = gtk_frame_new (_("Applet"));
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (interface_vbox), frame6, FALSE, TRUE, 0);

	vbox10 = gtk_vbox_new (FALSE, 0);
	
	gtk_widget_show (vbox10);
	gtk_container_add (GTK_CONTAINER (frame6), vbox10);
	gtk_container_set_border_width (GTK_CONTAINER (vbox10), 6);

	showappletborder_button = gtk_check_button_new_with_label (_("Show Border Around Applet"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (showappletborder_button), temp_toggles->show_applet_border);
	gtk_widget_show (showappletborder_button);
	gtk_box_pack_start (GTK_BOX (vbox10), showappletborder_button, FALSE, FALSE, 0);

	tooltip_button = gtk_check_button_new_with_label (_("Hide Tooltips"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (tooltip_button), temp_toggles->hidetooltip);
	gtk_widget_show (tooltip_button);
	gtk_box_pack_start (GTK_BOX (vbox10), tooltip_button, FALSE, FALSE, 0);
#endif

	/* Miscellaneous tab */

	misc_vbox = gtk_vbox_new (FALSE, 8);
	gtk_widget_show (misc_vbox);
	gtk_container_add (GTK_CONTAINER (notebook1), misc_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (misc_vbox), 6);

	label = gtk_label_new ("");
	gtk_label_parse_uline (GTK_LABEL (label),
	                       _("_Miscellaneous"));
	gtk_widget_show (label);
	gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 4), label);

	frame6 = gtk_frame_new (_("Miscellaneous"));
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (misc_vbox), frame6, FALSE, TRUE, 0);

	vbox10 = gtk_vbox_new (FALSE, 0);
	
	gtk_widget_show (vbox10);
	gtk_container_add (GTK_CONTAINER (frame6), vbox10);
	gtk_container_set_border_width (GTK_CONTAINER (vbox10), 6);

	showmain_button = gtk_check_button_new_with_label (_("Show Main Window on Startup"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (showmain_button), temp_toggles->show_window);
	gtk_widget_show (showmain_button);
	gtk_box_pack_start (GTK_BOX (vbox10), showmain_button, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (FALSE, 4);
	gtk_widget_show (hbox2);
	gtk_box_pack_start (GTK_BOX (vbox10), hbox2, FALSE, FALSE, 0);

	autohide_button = gtk_check_button_new_with_label (_("Automatically hide main window after "));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (autohide_button), temp_toggles->autohide);
	gtk_widget_show (autohide_button);
	gtk_box_pack_start (GTK_BOX (hbox2), autohide_button, FALSE, FALSE, 0);

	spin_button_adj = gtk_adjustment_new (temp_autohide_time, 0, 3600, 1, 10, 10);
	spin_button = gtk_spin_button_new (GTK_ADJUSTMENT (spin_button_adj), 1, 0);
	gtk_widget_set_sensitive (spin_button, GTK_TOGGLE_BUTTON (autohide_button)->active);
	gtk_widget_show (spin_button);
	gtk_box_pack_start (GTK_BOX (hbox2), spin_button, FALSE, TRUE, 0);
	gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (spin_button), GTK_UPDATE_IF_VALID);

	label = gtk_label_new (_("secs"));
	gtk_widget_show (label);
	gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

	popup_button = gtk_check_button_new_with_label (_("Automatically Popup Message Windows"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (popup_button), temp_toggles->auto_popup);
	gtk_widget_show (popup_button);
	gtk_box_pack_start (GTK_BOX (vbox10), popup_button, FALSE, FALSE, 0);

	fullreply_button = gtk_check_button_new_with_label (_("Automatically Show Entire Reply Dialog"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (fullreply_button), temp_toggles->full_reply);
	gtk_widget_show (fullreply_button);
	gtk_box_pack_start (GTK_BOX (vbox10), fullreply_button, FALSE, FALSE, 0);

	statusnotify_button = gtk_check_button_new_with_label (_("Online Notify Includes Returning from Away and N/A"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (statusnotify_button), temp_toggles->status_notify);
	gtk_widget_show (statusnotify_button);
	gtk_box_pack_start (GTK_BOX (vbox10), statusnotify_button, FALSE, FALSE, 0);

	toggle = gtk_check_button_new_with_label (_("Sort the online contact list"));
	gtk_widget_show (toggle);
	gtk_box_pack_start (GTK_BOX (vbox10), toggle, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), temp_toggles->sort_contacts);

	webpresence_button = gtk_check_button_new_with_label (_("Allow others to see me on websites"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (webpresence_button), temp_toggles->webpresence);
	gtk_widget_show (webpresence_button);
	gtk_box_pack_start (GTK_BOX (vbox10), webpresence_button, FALSE, FALSE, 0);

	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->sort_contacts);

	toggle = gtk_check_button_new_with_label (_("Check spelling in messages"));
	gtk_widget_show (toggle);
	gtk_box_pack_start (GTK_BOX (vbox10), toggle, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), temp_toggles->check_spell);

	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->check_spell);

	toggle = gtk_check_button_new_with_label (_("Message windows start in chat mode"));
	gtk_widget_show (toggle);
	gtk_box_pack_start (GTK_BOX (vbox10), toggle, FALSE, FALSE, 0);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (toggle), temp_toggles->default_to_chat);

	gtk_signal_connect (GTK_OBJECT (toggle), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->default_to_chat);

	/* File transfer stuff */
	frame6 = gtk_frame_new (_("File Transfer"));
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (misc_vbox), frame6, FALSE, TRUE, 0);

	vbox5 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox5);
	gtk_container_add (GTK_CONTAINER (frame6), vbox5);
	gtk_container_set_border_width (GTK_CONTAINER (vbox5), 6);

	autoaccept_enable = gtk_check_button_new_with_label (_("Automatically accept file transfers"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (autoaccept_enable ), temp_toggles->auto_accept_xfers);
	gtk_widget_show (autoaccept_enable);
	gtk_box_pack_start (GTK_BOX (vbox5), autoaccept_enable, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox2);
	gtk_container_add (GTK_CONTAINER (vbox5), hbox2);
	
	autoaccept_label = gtk_label_new (_("Save files to: "));
	gtk_widget_set_sensitive (autoaccept_label, temp_toggles->auto_accept_xfers);
	gtk_widget_show (autoaccept_label);
	gtk_box_pack_start (GTK_BOX (hbox2), autoaccept_label, FALSE, FALSE, 0);

	autoaccept_browse = gtk_button_new_with_label (_("Browse..."));
	gtk_widget_set_sensitive (autoaccept_browse, temp_toggles->auto_accept_xfers);
	gtk_widget_show (autoaccept_browse);
	gtk_box_pack_end (GTK_BOX (hbox2), autoaccept_browse, FALSE, FALSE, 1);

	autoaccept_path = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (autoaccept_path), toggles->auto_accept_path);
	gtk_widget_set_sensitive (autoaccept_path, temp_toggles->auto_accept_xfers);
	gtk_widget_show (autoaccept_path);
	gtk_box_pack_end (GTK_BOX (hbox2), autoaccept_path, TRUE, TRUE, 0);

	gtk_signal_connect (GTK_OBJECT (autoaccept_path), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed), NULL);

	gtk_signal_connect (GTK_OBJECT (autoaccept_browse), "clicked",
	                    GTK_SIGNAL_FUNC (autoaccept_dirbrowse), NULL);

	gtk_signal_connect (GTK_OBJECT (autoaccept_enable), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_autoaccept),
	                    &temp_toggles->auto_accept_xfers);

	debug_frame = gtk_frame_new (_("Debug"));
	gtk_widget_show (debug_frame);
	gtk_box_pack_start (GTK_BOX (misc_vbox), debug_frame, FALSE, TRUE, 0);

	debug_vbox = gtk_vbox_new (TRUE, 0);
	gtk_container_add (GTK_CONTAINER (debug_frame), debug_vbox);
	gtk_container_set_border_width (GTK_CONTAINER (debug_vbox), 6);
	gtk_widget_show (debug_vbox);

	dumptcp_button = gtk_check_button_new_with_label (_("Dump Client-Client Packets"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (dumptcp_button), temp_toggles->packet_tcp);
	gtk_widget_show (dumptcp_button);
	gtk_container_add (GTK_CONTAINER (debug_vbox), dumptcp_button);

        dumpudp_button = gtk_check_button_new_with_label (_("Dump Client-Server Packets"));
        gtk_toggle_button_set_state( GTK_TOGGLE_BUTTON( dumpudp_button ), temp_toggles->packet_udp);
        gtk_widget_show (dumpudp_button);
        gtk_container_add(GTK_CONTAINER(debug_vbox), dumpudp_button);

	gtk_signal_connect (GTK_OBJECT (GnomeICU_Options), "apply",
	                    GTK_SIGNAL_FUNC (apply_changes),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (GnomeICU_Options), "close",
	                    GTK_SIGNAL_FUNC (options_delete),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_online), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_online),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_away), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_away),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_ffc), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_ffc),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_na), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_na),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_occ), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_occ),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_dnd), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_dnd),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_inv), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_inv),
	                    NULL);
	gtk_signal_connect (GTK_OBJECT (picker_offline), "color_set",
	                    GTK_SIGNAL_FUNC (color_set_offline),
	                    NULL);
#ifdef HAVE_ESD
	gtk_signal_connect (GTK_OBJECT (sound_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->sound);
#endif
	gtk_signal_connect (GTK_OBJECT (beep_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->beep);
	gtk_signal_connect (GTK_OBJECT (showmain_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->show_window);
#ifdef BUILD_APPLET
	gtk_signal_connect (GTK_OBJECT (showappletborder_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->show_applet_border);
	gtk_signal_connect (GTK_OBJECT (tooltip_button), "toggled",
			    GTK_SIGNAL_FUNC (toggle_switch),
			    &temp_toggles->hidetooltip);
#endif
	gtk_signal_connect (GTK_OBJECT (statusnotify_button), "toggled",
			    GTK_SIGNAL_FUNC (toggle_switch),
			    &temp_toggles->status_notify);
	gtk_signal_connect (GTK_OBJECT (russian_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->russian);
	gtk_signal_connect (GTK_OBJECT (latin2_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
						&temp_toggles->latin2);
#ifdef HAVE_ICONV
	gtk_signal_connect (GTK_OBJECT (kanji_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->kanji);
#endif
	gtk_signal_connect (GTK_OBJECT (fullreply_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->full_reply);
	gtk_signal_connect (GTK_OBJECT (popup_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->auto_popup);
	gtk_signal_connect (GTK_OBJECT (dumptcp_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->packet_tcp);
        gtk_signal_connect (GTK_OBJECT (dumpudp_button), "toggled",
                            GTK_SIGNAL_FUNC (toggle_switch),
                            &temp_toggles->packet_udp);
	gtk_signal_connect (GTK_OBJECT (dumpnew_button), "toggled",
	                GTK_SIGNAL_FUNC (toggle_switch),
	                &temp_toggles->no_new_users);
	gtk_signal_connect (GTK_OBJECT (webpresence_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->webpresence);
	gtk_signal_connect (GTK_OBJECT (autohide_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
	                    &temp_toggles->autohide);
	gtk_signal_connect (GTK_OBJECT (autohide_button), "toggled",
	                    GTK_SIGNAL_FUNC (set_sensitive),
	                    spin_button);
	gtk_signal_connect (GTK_OBJECT (spin_button_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button_changed_cb),
	                    spin_button);
	gtk_signal_connect (GTK_OBJECT (spinbutton4_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button4_changed_cb),
	                    spinbutton4);
	gtk_signal_connect (GTK_OBJECT (spinbutton5_adj), "value_changed",
	                    GTK_SIGNAL_FUNC (spin_button5_changed_cb),
	                    spinbutton5);
	gtk_signal_connect (GTK_OBJECT (connect_startup_button), "toggled",
								GTK_SIGNAL_FUNC (toggle_switch),
								&temp_toggles->connect_startup);
	gtk_signal_connect (GTK_OBJECT (auto_recon_forced_button), "toggled",
	                    GTK_SIGNAL_FUNC (toggle_switch),
		            &temp_toggles->auto_recon_forced);
	gtk_widget_show_all (GnomeICU_Options);

	return;
}

/*** Local functions ***/
void apply_changes (GnomePropertyBox *box, gint page)
{
	if (page != -1)
		return;

	save_changes (NULL, NULL);
	activate_changes (NULL, NULL);
}

gint options_delete (GnomeDialog *widget, gpointer data)
{
	Options_Open = FALSE;
	return FALSE;
}

void color_set_online (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_online.red = pr;
	temp_color_online.green = pg;
	temp_color_online.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_offline (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_offline.red = pr;
	temp_color_offline.green = pg;
	temp_color_offline.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_away (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_away.red = pr;
	temp_color_away.green = pg;
	temp_color_away.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_na (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_na.red = pr;
	temp_color_na.green = pg;
	temp_color_na.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_ffc (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_ffc.red = pr;
	temp_color_ffc.green = pg;
	temp_color_ffc.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_occ (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_occ.red = pr;
	temp_color_occ.green = pg;
	temp_color_occ.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_dnd (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_dnd.red = pr;
	temp_color_dnd.green = pg;
	temp_color_dnd.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void color_set_inv (GnomeColorPicker *cp, guint pr, guint pg, guint pb)
{
	temp_color_inv.red = pr;
	temp_color_inv.green = pg;
	temp_color_inv.blue = pb;
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void toggle_switch (GtkWidget *widget, gboolean *toggle_me)
{
	*toggle_me = !*toggle_me;

	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void toggle_autoaccept (GtkWidget *widget, gboolean *toggle_me)
{
#ifdef TRACE_FUNCTION
	g_print ("toggle_switch\n");
#endif

	*toggle_me = !*toggle_me;

	gtk_widget_set_sensitive (autoaccept_label, *toggle_me);
	gtk_widget_set_sensitive (autoaccept_path, *toggle_me);
	gtk_widget_set_sensitive (autoaccept_browse, *toggle_me);

	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void save_changes (GtkWidget *widget, gpointer data)
{
#ifdef TRACE_FUNCTION
	g_print ("save_changes\n");
#endif

	/* these will be written to file when the user exits gnomeicu
	 * since the rcfile is rewritten every time. Don't ask me why... */

	g_free (server);
	server = g_strdup (gtk_entry_get_text (GTK_ENTRY (icqserver)));
	remote_port = atoi (gtk_entry_get_text (GTK_ENTRY (portnumber)));

	g_free (temp_toggles->auto_accept_path);
	temp_toggles->auto_accept_path = g_strdup (gtk_entry_get_text (GTK_ENTRY (autoaccept_path)));

	our_info->uin = atoi (gtk_entry_get_text (GTK_ENTRY (uin)));

	g_free (our_info->nick);
	our_info->nick = g_strdup (gtk_entry_get_text (GTK_ENTRY (nick)));

	g_free (passwd);
	passwd = g_strdup (gtk_entry_get_text (GTK_ENTRY (pass)));

	/* external programs */
	g_free (programs->receive_message);
	programs->receive_message = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_receive_message)));
	g_free (programs->chat_request);
	programs->chat_request = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_chat_request)));
	g_free (programs->receive_url);
	programs->receive_url = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_receive_url)));
	g_free (programs->file_request);
	programs->file_request = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_file_request)));
	g_free (programs->user_online);
	programs->user_online = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_user_online)));
	g_free (programs->user_offline);
	programs->user_offline = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_user_offline)));
	g_free (programs->auth);
	programs->auth = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_auth)));
	g_free (programs->auth_request);
	programs->auth_request = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_auth_request)));
	g_free (programs->list_add);
	programs->list_add = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_list_add)));
	g_free (programs->contact_list);
	programs->contact_list = g_strdup (gtk_entry_get_text (GTK_ENTRY (ext_prog_contact_list)));

	autohide_time = temp_autohide_time;
	min_tcp_port = temp_min_tcp_port;
	max_tcp_port = temp_max_tcp_port;

	if (toggles->webpresence != temp_toggles->webpresence)
	{
		v7_setstatus (Current_Status);
	}

	auto_away_message = g_strdup (gtk_entry_get_text (GTK_ENTRY (autoaway_entry)));
	auto_na_message = g_strdup (gtk_entry_get_text (GTK_ENTRY (autona_entry)));


	memcpy (toggles, temp_toggles, sizeof (_toggles));

	memcpy (&color_online, &temp_color_online, sizeof (GdkColor));
	memcpy (&color_offline, &temp_color_offline, sizeof (GdkColor));
	memcpy (&color_away, &temp_color_away, sizeof (GdkColor));
	memcpy (&color_na, &temp_color_na, sizeof (GdkColor));
	memcpy (&color_ffc, &temp_color_ffc, sizeof (GdkColor));
	memcpy (&color_occ, &temp_color_occ, sizeof (GdkColor));
	memcpy (&color_dnd, &temp_color_dnd, sizeof (GdkColor));
	memcpy (&color_inv, &temp_color_inv, sizeof (GdkColor));

	/* This should apply the away messages and save them */
	apply_away_msgs_change (temp_away_msgs, AWAY_MSGS_NUM);
	/* End of apply away messages stuff */

	Build_Main_Window ();
	save_preferences ();
}

void activate_changes (GtkWidget *widget, gpointer data)
{
#ifdef TRACE_FUNCTION
	g_print ("activate_changes\n");
#endif
	/* if the timeout is running, stop it */
	if (autohide_timeout_tag) {
		gtk_timeout_remove (autohide_timeout_tag);
		autohide_timeout_tag = 0;
	}

	if (autohide_cbs_are_connected) {
		gtk_signal_disconnect_by_func (GTK_OBJECT (app),
					       GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL);
		gtk_signal_disconnect_by_func (GTK_OBJECT (app),
					       GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL);
		autohide_cbs_are_connected = FALSE;
	}

	if (toggles->autohide) {
		gtk_signal_connect (GTK_OBJECT (app), "focus_in_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL);
		gtk_signal_connect (GTK_OBJECT (app), "focus_out_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL);
		gtk_signal_connect (GTK_OBJECT (app), "expose_event",
				    GTK_SIGNAL_FUNC (start_autohide_timeout_cb), NULL);
		gtk_signal_connect (GTK_OBJECT (app), "delete_event",
				    GTK_SIGNAL_FUNC (stop_autohide_timeout_cb), NULL);
		autohide_cbs_are_connected = TRUE;
	}
	gtk_clist_set_auto_sort (GTK_CLIST (MainData->lb_userwin_online), toggles->sort_contacts);

	if (autoaway_timeout_tag)
	    gtk_timeout_remove (autoaway_timeout_tag);

	if (toggles->use_autoaway)
	 {
		 gtk_timeout_add (1000, (GtkFunction)auto_away, NULL);
	 }

	if (!toggles->check_spell)
	    if (gtkspell_running)
	        gtkspell_stop ();

	icons_init ();
	Show_Quick_Status_lower (UPDATE_ONLINE | UPDATE_OFFLINE |
	                         UPDATE_NOTLIST, NULL);
	ready_set ();
	create_animator ();
	Shortcut_Update_All ();
}

void set_sensitive (GtkWidget *master, GtkWidget *slave)
{
	gtk_widget_set_sensitive (slave, GTK_TOGGLE_BUTTON (master)->active);
}

void spin_button_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print ("spin_button_changed_cb\n");
#endif

	temp_autohide_time = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void spin_button4_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print ("spin_button_changed_cb\n");
#endif
	temp_min_tcp_port = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void spin_button5_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print ("spin_button_changed_cb\n");
#endif
	temp_max_tcp_port = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void spin_button6_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print ("spin_button_changed_cb\n");
#endif
	temp_toggles->auto_away = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void spin_button7_changed_cb (GtkWidget *widget, GtkSpinButton *spinbutton)
{
#ifdef TRACE_FUNCTION
	g_print ("spin_button_changed_cb\n");
#endif
	temp_toggles->auto_na = gtk_spin_button_get_value_as_int (spinbutton);
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}

void entry_changed (GtkWidget *widget, gpointer data)
{
	gnome_property_box_changed (GNOME_PROPERTY_BOX (GnomeICU_Options));
}


gint Build_Main_Window (void)
{
	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print ("Build_Main_Window\n");
#endif

	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_online);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_offline);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_away);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_na);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_ffc);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_occ);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_dnd);
	gdk_color_alloc (gtk_widget_get_colormap (MainData->lb_userwin), &color_inv);

	gtk_clist_freeze (GTK_CLIST (MainData->lb_userwin));

	contact = Contacts;

	while (contact != NULL)
	{
		switch (kontakt->status & 0xffff)
		{
		case STATUS_ONLINE:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
			                          kontakt->lb_index, &color_online);
			break;
		case STATUS_FREE_CHAT:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
			                          kontakt->lb_index, &color_ffc);
			break;
		case STATUS_AWAY:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
			                          kontakt->lb_index, &color_away);
			break;
		case STATUS_NA:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
						                 kontakt->lb_index, &color_na);
			break;
		case STATUS_OCCUPIED:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
						                 kontakt->lb_index, &color_occ);
			break;
		case STATUS_DND:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
						                 kontakt->lb_index, &color_dnd);
			break;
		case STATUS_INVISIBLE:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_online),
						                 kontakt->lb_index, &color_inv);
			break;
		default:
			gtk_clist_set_foreground (GTK_CLIST (MainData->lb_userwin_offline),
						                 kontakt->lb_index, &color_offline);
		}
		contact = contact->next;
	}

	gtk_clist_thaw (GTK_CLIST (MainData->lb_userwin));

	return FALSE;
}

/* Part of awaymsglist.c
   David A. Hepkin
   do_away_msgs ():
   Description: Creates a text entry box for the away message
   associated with num.
*/
void do_away_msgs (GtkWidget* main_window, GtkWidget*
		  away_frame, GtkWidget *away_msg_table, const int
		  num)
{
	const gulong buf_len = 20;  /* Buffer length */
	GtkWidget* away_label;      /* Numbers the Away messages */
	GtkWidget* away_msg;        /* Text field for the away msg */
	gchar label[buf_len];

	g_snprintf (label, buf_len, _("Away Message %d"), num+1);
	away_label = gtk_label_new (label);

	gtk_widget_show (away_label);
	gtk_table_attach_defaults (GTK_TABLE (away_msg_table),
	                           away_label, 0, 1, num, num+1);

	away_msg = gtk_entry_new ();

	if (get_away_msg_from_list (num) != NULL)
		gtk_entry_set_text (GTK_ENTRY (away_msg),
		                    get_away_msg_from_list (num));

	gtk_widget_show (away_msg);
	gtk_table_attach_defaults (GTK_TABLE (away_msg_table), away_msg, 1,
	                           2, num, num+1);
	gtk_signal_connect (GTK_OBJECT (away_msg), "changed",
	                    GTK_SIGNAL_FUNC (get_away_msg),
	                    GINT_TO_POINTER (num));
	gtk_signal_connect (GTK_OBJECT (away_msg), "changed",
	                    GTK_SIGNAL_FUNC (entry_changed),
			    NULL);
}

/* Part of awaymsglist.c
   David A. Hepkin
   get_away_msg ():
   Description: Gets a changed/new away message from the associated
   text entry.  Saves the away message in the temp_away_msgs temporary
   list, so the changes can be "applied" later.
*/
void get_away_msg (GtkWidget *away_msg, gpointer data)
{
	gint index = GPOINTER_TO_INT (data);
	if (index >= AWAY_MSGS_NUM || index < 0)
		return;
	g_free (temp_away_msgs[index]);
	temp_away_msgs[index] = g_strdup (gtk_entry_get_text (GTK_ENTRY (away_msg)));
}

void url_show_themes (GtkWidget *widget, gpointer data)
{
	gnome_url_show ("http://gnomeicu.sourceforge.net/themes.php");
}


void autoaccept_dirbrowse (GtkWidget *widget, gpointer data)
{
	GtkWidget *dirsel;
	dirsel = create_dir_browser (_("Select Auto-Accept Directory"),
	                             autoaccept_setpath, NULL);
	gtk_widget_show (dirsel);
}

void autoaccept_setpath (gchar *path, gpointer data)
{
	gtk_entry_set_text (GTK_ENTRY (autoaccept_path), g_strdup (path));
}
