/****************************
  Sending stuff for ICQ v6-7 protocol (Oscar)
  Olivier Crete (c) 2001
  GnomeICU
*****************************/

#include "common.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "history.h"
#include "kanji_conv.h"
#include "rus_conv.h"
#include "sendcontact.h"
#include "util.h"
#include "v7recv.h"
#include "v7send.h"
#include "v7snac13.h"

void v7_sendmsg4(UIN_T uin, gchar *msgcontent, int contentlen);
DWORD v7_send_15_02_D007( WORD subtype, gchar *buffer, int buffer_len);
void v7_send_simple_msg2(UIN_T uin, gchar *msg, BYTE type, gboolean autoreq);

gchar zerobuf[20] = "\0\0\0\0\0\0\0\0\0\0" "\0\0\0\0\0\0\0\0\0\0";


void v7_sendmsg(UIN_T uin, gchar *text) 
{

  TLVstack *mainpak, *message;
  gchar *tempstr, *convtext;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendmsg\n" );
#endif

  history_add_outgoing( uin, text );
  
  mainpak = new_tlvstack( zerobuf,8); /* msgid */
  add_nontlv_w_be(mainpak, 1);        /* msg-format  1==simple*/

  tempstr = g_strdup_printf(" %d", uin);      /* uin */;
  tempstr[0] = strlen(tempstr) - 1;
  add_nontlv(mainpak, tempstr, tempstr[0]+1);
  g_free(tempstr);

  message = new_tlvstack( "\x05\x01\x00\x01\x01\x01\x01",7); /* fill ? */

  convtext = add_cr(text);
  rus_conv(RUS_KOI_WIN, convtext);
  kanji_conv_auto_s(&convtext, KANJI_SJIS);

  add_nontlv_w_be(message, strlen(convtext)+4);           /* msg length +4*/
  add_nontlv(message, zerobuf, 4);                        /* fill ? */
  add_nontlv(message, convtext, strlen(convtext));        /* message */
  g_free(convtext);

  add_tlv(mainpak, 2, message->beg, message->len);
  free_tlvstack(message);
  
  add_tlv(mainpak, 6, NULL, 0);
  
  snac_send(mainconnection, mainpak->beg, mainpak->len, FAMILY_04_MESSAGING,
            F04_CLIENT_SEND_MESSAGE, NULL, ANY_ID);

  free_tlvstack(mainpak);
}

/* DEPRECATED by the new Snac13 server side contacts list */
void v7_sendcontactlist()
{

  TLVstack *contactlist;
  GSList *contact;
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendcontactlist\n" );
#endif
  
  
  contactlist = new_tlvstack(NULL,0);
  contact = Contacts;

  while( contact != NULL ) {
    if( kontakt->uin > 0 ) {
      strtmp = g_strdup_printf(" %d", kontakt->uin);
      strtmp[0] = strlen(strtmp) -1 ;
      add_nontlv(contactlist, strtmp, strtmp[0]+1);
      g_free(strtmp);
    }
    contact = contact->next;
  }
  
  snac_send(mainconnection, contactlist->beg, contactlist->len,
            FAMILY_03_CONTACTLIST, F03_CLIENT_ADD_TO_CL, NULL, ANY_ID);
  
  free_tlvstack(contactlist);
}

/* need to clean up all reference to this function because
 * v7_try_add_uin() in v7snac13.c is preferred
 */
void v7_addcontact(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendaddcontact\n" );
#endif
  
  
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_03_CONTACTLIST, F03_CLIENT_ADD_TO_CL, NULL, ANY_ID);
  
  g_free(strtmp);
  v7_request_info (uin);
}

/* same as v7_addcontact() */
void v7_remcontact(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendremcontact\n" );
#endif
  
  
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_03_CONTACTLIST, F03_CLIENT_REMOVE_FROM_CL, NULL, ANY_ID);
  
  g_free(strtmp);

}


void v7_sendvisiblelist()
{

  TLVstack *contactlist;
  GSList *contact;
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendvisiblelist\n" );
#endif
  
  
  contactlist = new_tlvstack(NULL,0);
  contact = Contacts;

  while( contact != NULL ) {
    if( kontakt->uin > 0  && kontakt->vis_list) {
      strtmp = g_strdup_printf(" %d", kontakt->uin);
      strtmp[0] = strlen(strtmp) -1 ;
      add_nontlv(contactlist, strtmp, strtmp[0]+1);
      g_free(strtmp);
    }
    contact = contact->next;
  }
  
  snac_send(mainconnection, contactlist->beg, contactlist->len,
            FAMILY_09_LISTS ,F09_CLIENT_ADD_VISIBLE_LIST , NULL, ANY_ID);
  
  free_tlvstack(contactlist);
}

void v7_addvisible(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendaddvisible\n" );
#endif

  if (Current_Status != STATUS_INVISIBLE)
    return;
   
  
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_09_LISTS, F09_CLIENT_ADD_VISIBLE_LIST, NULL, ANY_ID);
  
  g_free(strtmp);

}

void v7_remvisible(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendremvisible\n" );
#endif
  
  if (Current_Status != STATUS_INVISIBLE)
    return;
  
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_09_LISTS, F09_CLIENT_REM_VISIBLE_LIST, NULL, ANY_ID);
  
  g_free(strtmp);

}

void v7_sendinvisiblelist()
{

  TLVstack *contactlist;
  GSList *contact;
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendinvisiblelist\n" );
#endif
  
  
  contactlist = new_tlvstack(NULL,0);
  contact = Contacts;

  while( contact != NULL ) {
    if( kontakt->uin > 0  && kontakt->invis_list) {
      strtmp = g_strdup_printf(" %d", kontakt->uin);
      strtmp[0] = strlen(strtmp) -1 ;
      add_nontlv(contactlist, strtmp, strtmp[0]+1);
      g_free(strtmp);
    }
    contact = contact->next;
  }
  
  snac_send(mainconnection, contactlist->beg, contactlist->len,
            FAMILY_09_LISTS ,F09_CLIENT_ADD_INVISIBLE_LIST , NULL, ANY_ID);
  
  free_tlvstack(contactlist);
}

void v7_addinvisible(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendaddinvisible\n" );
#endif
  
  if (Current_Status == STATUS_INVISIBLE)
    return;
  
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_09_LISTS, F09_CLIENT_ADD_INVISIBLE_LIST, NULL, ANY_ID);
  
  g_free(strtmp);

}

void v7_reminvisible(UIN_T uin) 
{
  gchar *strtmp;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_reminvisible\n" );
#endif
  
  if (Current_Status == STATUS_INVISIBLE)
    return;
   
  strtmp = g_strdup_printf(" %d", uin);
  strtmp[0] = strlen(strtmp) -1 ;
  snac_send(mainconnection, strtmp, strtmp[0]+1,
            FAMILY_09_LISTS, F09_CLIENT_REM_INVISIBLE_LIST, NULL, ANY_ID);
  
  g_free(strtmp);

}

void v7_setstatus(DWORD newstatus)
{
#ifdef TRACE_FUNCTION
  g_print( "v7_setstatus\n" );
#endif

  if (newstatus == Current_Status)
    return;

  /* Send visible/invisible list.. icq2001b style */
  if (newstatus == STATUS_INVISIBLE) {
    v7_send_status_server (FALSE); /* invisible */
    /* v7_sendvisiblelist(); */ /* not need with 2001b */
  } else {
    v7_send_status_server (TRUE); /* visible */
    /* v7_sendinvisiblelist(); */
  }

  Current_Status = newstatus;

  v7_setstatus2(newstatus);
}

void v7_setstatus2(DWORD newstatus)
{
  TLVstack *tlvs;
  gchar directconnectioninfo[37];

  newstatus |= (toggles->webpresence * 0x10000)  | 0x20000;
  /* 0x0008 == BIRTHDAY flag */

  tlvs = new_tlvstack(NULL,0);
  
  add_tlv_dw_be(tlvs, 6, newstatus);

  bzero(directconnectioninfo, 37);
  /*
    Direct connection aint working anyways... so we disable it by setting the
    IP to zero
    
  DW_2_IP(directconnectioninfo, our_ip);
  DW_2_CharsBE(directconnectioninfo+4, our_port);
  */

  directconnectioninfo[8] = 4;
  directconnectioninfo[10] = 8; /* protocol version 8 == 2001b */
  DW_2_CharsBE(directconnectioninfo+15, 0x50);
  DW_2_CharsBE(directconnectioninfo+19, 3);
  

  add_tlv(tlvs, 0x0C, directconnectioninfo, 37);
  
  snac_send(mainconnection, tlvs->beg, tlvs->len, FAMILY_01_GENERIC, 
            F01_CLIENT_STATUS_CODE, NULL, ANY_ID);
  
  free_tlvstack(tlvs);

  ready_set();
}

void v7_quit()
{

#ifdef TRACE_FUNCTION
  g_print( "v7_quit\n" );
#endif 

  if (mainconnection) {

    if (mainconnection->in_watch)
      if (!g_source_remove(mainconnection->in_watch)) {
        gnome_error_dialog("Cannot remove main input watcher!");
        return;
      }
    
    if (mainconnection->err_watch)
      if (!g_source_remove(mainconnection->err_watch)) {
        gnome_error_dialog("Cannot remove main error watcher");
        return;
      }

    if (mainconnection->gsocket)
      gnet_tcp_socket_delete(mainconnection->gsocket);
    
    g_free(mainconnection);
    
    mainconnection = NULL;
  }
  
  while (otherconnections) {
    
    if (((V7Connection*)otherconnections->data)->in_watch)
      if (!g_source_remove(((V7Connection*)otherconnections->data)->in_watch)){
        gnome_error_dialog("Cannot remove other input watcher!");
        return;
      }
    if (((V7Connection*)otherconnections->data)->err_watch)
     if (!g_source_remove(((V7Connection*)otherconnections->data)->err_watch)){
        gnome_error_dialog("Cannot remove other error watcher!");
        return;
     }
    if (((V7Connection*)otherconnections->data)->gsocket)
      gnet_tcp_socket_delete(((V7Connection*)otherconnections->data)->gsocket);
    
    g_free(otherconnections->data);
    otherconnections = g_slist_remove(otherconnections, otherconnections->data);
    
  }
  animate_off();

}

void v7_sendurl(UIN_T uin, gchar *url, gchar *desc)
{
  gchar *buffer;
  int bufferlen;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendurl\n" );
#endif 

  rus_conv(RUS_KOI_WIN,url);
  rus_conv(RUS_KOI_WIN,desc);

  buffer = g_malloc0(strlen(url)+ strlen(desc) + 10);

  DW_2_Chars(buffer, our_info->uin);

  buffer[4] = 4;  /* type 4 = url */

  Word_2_Chars(buffer+6, strlen(url)+strlen(desc)+2);

  g_memmove(buffer+8, desc, strlen(desc));
  bufferlen = 8 + strlen(desc);

  buffer[bufferlen] = 0xFE;
  bufferlen++;

  g_memmove(buffer+bufferlen, url, strlen(url));
  bufferlen += strlen(url) + 1;

  v7_sendmsg4(uin, buffer, bufferlen);
  
  g_free(buffer);
}

void v7_grant_auth(UIN_T uin)
{

#ifdef TRACE_FUNCTION
  g_print( "v7_grant_auth\n" );
#endif 

  /* type 8 = grant auth */

  v7_send_simple_msg2(uin, zerobuf, 8, FALSE);
}

void v7_deny_auth(UIN_T uin, gchar *reason)
{

  gchar *buffer;

#ifdef TRACE_FUNCTION
  g_print( "v7_deny_auth\n" );
#endif 

  rus_conv(RUS_KOI_WIN,reason);
  buffer = g_malloc0(strlen(reason) + 9);
  DW_2_Chars(buffer, our_info->uin);

  buffer[4] = 7;  /* type 7 = deny auth */

  Word_2_Chars(buffer+6, strlen(reason));

  g_memmove(buffer+8, reason, strlen(reason));

  v7_sendmsg4(uin, buffer, strlen(reason) + 9);

  g_free(buffer);
}

void v7_request_away_msg(UIN_T uin, WORD contactstatus)
{


#ifdef TRACE_FUNCTION
  g_print( "v7_request_away_msg\n" );
#endif 

  switch (contactstatus) { /* find which type of message to request */
  case STATUS_AWAY: 
    v7_send_simple_msg2(uin, "\0", 0xE8, TRUE);
    break;
  case STATUS_OCCUPIED:
    v7_send_simple_msg2(uin, "\0", 0xE9, TRUE);
    break;
  case STATUS_NA:
    v7_send_simple_msg2(uin, "\0", 0xEA, TRUE);
    break;
  case STATUS_DND:
    v7_send_simple_msg2(uin, "\0", 0xEB, TRUE);
    break;
  case STATUS_FREE_CHAT:
    v7_send_simple_msg2(uin, "\0", 0xEC, TRUE);
    break;
  default:
    return;
  }
}


void v7_sendmsg4(UIN_T uin, gchar *msgcontent, int contentlen)
{
  gchar *uinstr, *buffer;
  TLVstack *tlvs;
  int bufferlen;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_sendmsg4\n" );
#endif 

 uinstr = g_strdup_printf("%d",uin);

  bufferlen =  11+strlen(uinstr);
  buffer = g_malloc0(bufferlen);

  Word_2_CharsBE(buffer+8, 4); /* msg-format=4 special messages */

  buffer[10] = strlen(uinstr);
  g_memmove(buffer+11, uinstr, buffer[10]);
  
  g_free(uinstr);
    
  tlvs = new_tlvstack(buffer, bufferlen);

  g_free(buffer);

  add_tlv(tlvs, 5, msgcontent, contentlen);
  
  snac_send(mainconnection, tlvs->beg, tlvs->len ,FAMILY_04_MESSAGING,
            F04_CLIENT_SEND_MESSAGE, NULL, ANY_ID);
  
  free_tlvstack(tlvs);
  
}


void v7_send_simple_msg2(UIN_T uin, gchar *msg, BYTE type, gboolean autoreq)
{
  gchar *uinstr, *buffer;
  /* We have three levels of TLVS one within the other, its not nice at all,
     it should be done in a cleaner way some day... */
  TLVstack *outertlvs, *middletlvs, *innertlvs;
  int bufferlen;
  static guint16 downcounter = 0xFFFF;
  
#ifdef TRACE_FUNCTION
  g_print( "v7_send_simple_msg2\n" );
#endif 
 
  middletlvs = new_tlvstack("\0\0" "\041\032\031\042" "\063\035\063\024"
                           "\x09\x46\x13\x49\x4C\x7F\x11\xD1"
                           "\x82\x22\x44\x45\x53\x54\x00\x00", 16+8+2);

  
  add_tlv(middletlvs, 0x0A, "\x00\x01", 2);
  add_tlv(middletlvs, 0x0F, NULL, 0);
  
  innertlvs = new_tlvstack("\x1B\0", 2);
  
  add_nontlv(innertlvs, "\x08", 1); /* protocol version 8 */
  add_nontlv(innertlvs, zerobuf, 19);
  add_nontlv_w_le(innertlvs, 0x03);
  add_nontlv(innertlvs, zerobuf, 3);
  add_nontlv_w_le(innertlvs, --downcounter);
  add_nontlv_w_be(innertlvs, 0x0E00);
  add_nontlv_w_le(innertlvs, downcounter);
  add_nontlv(innertlvs, zerobuf, 12);
  add_nontlv(innertlvs, &type, 1);
  add_nontlv(innertlvs, autoreq ? "\x03": zerobuf, 1);
  /* first word of status code */
  add_nontlv_w_le(innertlvs, toggles->webpresence ? 0x10000 : 0);
  add_nontlv_w_le(innertlvs, 1);
  add_nontlv_w_le(innertlvs, strlen(msg)+1);
  add_nontlv(innertlvs, msg, strlen(msg)+1);

  add_tlv(middletlvs, 0x2711, innertlvs->beg, innertlvs->len);
  
  free_tlvstack(innertlvs);
  
  uinstr = g_strdup_printf("%d",uin);

  bufferlen =  11+strlen(uinstr);
  buffer = g_malloc0(bufferlen);


  g_memmove(buffer, middletlvs->beg+2, 8);  /* copy msgid */
  Word_2_CharsBE(buffer+8, 2); /* msg-format=2 advanced messages */

  buffer[10] = strlen(uinstr);  /* LNTS */
  g_memmove(buffer+11, uinstr, buffer[10]);
  
  g_free(uinstr);
    
  outertlvs = new_tlvstack(buffer, bufferlen);

  g_free(buffer);

  add_tlv(outertlvs, 5, middletlvs->beg, middletlvs->len);

  free_tlvstack(middletlvs);
  
  add_tlv(outertlvs, 3, NULL, 0); /* ACK request */
  
  snac_send(mainconnection, outertlvs->beg, outertlvs->len ,FAMILY_04_MESSAGING,
            F04_CLIENT_SEND_MESSAGE, NULL, ANY_ID);
  
  free_tlvstack(outertlvs);
  
}
/* returns a reqid from inside the 15/2 packets */

DWORD v7_findbyuin(UIN_T uin)
{
 
  BYTE buffer[8] = "\x36\x01\x04\0";
  
#ifdef TRACE_FUNCTION
  g_print( "v7_findbyuin\n" );
#endif 
  
  DW_2_Chars(buffer+4, uin);
  
  return v7_send_15_02_D007( 0x6905, buffer, 8);
}

/* returns a reqid from inside the 15/2 packets */

DWORD v7_findbyname(gchar *nick, gchar *firstname, gchar *lastname)
{
  DWORD reqid;
  TLVstack *tlvs;

#ifdef TRACE_FUNCTION
  g_print( "v7_findbyname\n" );
#endif 

  rus_conv(RUS_KOI_WIN,nick);
  rus_conv(RUS_KOI_WIN,firstname);
  rus_conv(RUS_KOI_WIN,lastname);

  tlvs = new_tlvstack(NULL, 0);

  if (strlen(firstname)) {
    add_nontlv_w_be(tlvs, 0x4001);
    add_nontlv_w_le(tlvs, strlen(firstname)+3);
    add_nontlv_w_le(tlvs, strlen(firstname)+1);
    add_nontlv(tlvs, firstname, strlen(firstname)+1);
  }
  
  if (strlen(lastname)) {
    add_nontlv_w_be(tlvs, 0x4A01);
    add_nontlv_w_le(tlvs, strlen(lastname)+3);
    add_nontlv_w_le(tlvs, strlen(lastname)+1);
    add_nontlv(tlvs, lastname, strlen(lastname)+1);
  }

  if (strlen(nick)) {
    add_nontlv_w_be(tlvs, 0x5401);
    add_nontlv_w_le(tlvs, strlen(nick)+3);
    add_nontlv_w_le(tlvs, strlen(nick)+1);
    add_nontlv(tlvs, nick, strlen(nick)+1);
  }
    
  reqid = v7_send_15_02_D007( 0x5F05, tlvs->beg, tlvs->len);
  
  free_tlvstack(tlvs);
  return reqid;
}

/* returns reqid from inside the 15/2 packets */

DWORD v7_findbyemail(gchar *email)
{
  DWORD reqid;
  gchar *buffer;

#ifdef TRACE_FUNCTION
  g_print( "v7_findbyemail\n" );
#endif

  rus_conv(RUS_KOI_WIN,email);

  buffer = g_strdup_printf("\x5E\x01    %s", email);
  Word_2_Chars(buffer+2, strlen(email)+3);
  Word_2_Chars(buffer+4, strlen(email)+1);
    
  reqid = v7_send_15_02_D007( 0x7303, buffer, 2+strlen(email)+1); 
  
  g_free(buffer);

  return reqid;
}

/* returns reqid from inside the 15/2 packets */

DWORD v7_send_15_02_D007(WORD subtype, gchar *buffer, int buffer_len)
{

  DWORD reqid;
  TLVstack *outer_tlvs, *inner_tlvs;

#ifdef TRACE_FUNCTION
  g_print( "v7_send_15_02_D007\n" );
#endif 
  if (!mainconnection)
    return 0;

  
  inner_tlvs = new_tlvstack("  ", 2);

  add_nontlv_dw_le(inner_tlvs, our_info->uin);
  add_nontlv_w_be(inner_tlvs, 0xD007);
  add_nontlv_w_le(inner_tlvs, 0);
  add_nontlv_w_be(inner_tlvs, subtype);
  add_nontlv(inner_tlvs, buffer, buffer_len);

  Word_2_Chars(inner_tlvs->beg, inner_tlvs->len-2);

  outer_tlvs = new_tlvstack(NULL, 0);
  add_tlv(outer_tlvs, 1, inner_tlvs->beg, inner_tlvs->len);

  free_tlvstack(inner_tlvs);
  
  reqid = snac_send(mainconnection, outer_tlvs->beg, outer_tlvs->len,
            FAMILY_15_SAVED_DATA, F15_CLIENT_REQ_SAVE_DATA ,NULL, ANY_ID);
  
  free_tlvstack(outer_tlvs);

  return reqid;

}

DWORD v7_sendxml (gchar *xmlstring)
{

  DWORD reqid;
  gchar *buffer;

#ifdef TRACE_FUNCTION
  g_print( "v7_sendxml\n" );
#endif 

  buffer = g_strdup_printf("  %s", xmlstring);

  Word_2_Chars(buffer, strlen(xmlstring)+1);

  reqid = v7_send_15_02_D007( 0x9808, buffer, strlen(xmlstring)+3); 
  
  g_free(buffer);

  return reqid;
  
}

DWORD v7_request_info (UIN_T uin)
{

  Request *inforeq;
  BYTE buffer[4];
  
#ifdef TRACE_FUNCTION
  g_print( "v7_request_info\n" );
#endif 
  
  DW_2_Chars(buffer, uin);
  
  inforeq = g_malloc0(sizeof(Request));
  
  requests = g_slist_append(requests ,inforeq);
  
  inforeq->type = FULL_INFO;
  inforeq->uin = uin;

  inforeq->reqid = v7_send_15_02_D007( 0xB204, buffer, 4);
  

  return inforeq->reqid;

}

DWORD v7_request_my_info()
{

  Request *inforeq;
  BYTE buffer[4];
  
#ifdef TRACE_FUNCTION
  g_print( "v7_request_my_info\n" );
#endif 
  
  DW_2_Chars(buffer, our_info->uin);
  
  inforeq = g_malloc0(sizeof(Request));
  
  requests = g_slist_append(requests ,inforeq);
  
  inforeq->type = MY_INFO;
  inforeq->uin = our_info->uin;

  inforeq->reqid = v7_send_15_02_D007( 0xD004, buffer, 4);

  return inforeq->reqid;

}

void v7_modify_about (gchar *about)
{
  gchar *buffer;

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_about\n" );
#endif

  rus_conv(RUS_KOI_WIN,about);

  buffer = g_strdup_printf("  %s", about);
  
  Word_2_Chars(buffer, strlen(about)+1);

  v7_send_15_02_D007( 0x0604, buffer, strlen(about)+3);

  g_free(buffer);
}

void v7_modify_work_info (gchar *city, gchar *state, gchar *street,
                           gchar *zip, gchar *company_name, gchar *department, 
                           gchar *position, gchar *webpage, WORD country)
{

  TLVstack *infotlvs;

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_work_info\n" );
#endif 

  infotlvs = new_tlvstack(NULL, 0);

  rus_conv(RUS_KOI_WIN,city);
  rus_conv(RUS_KOI_WIN,state);
  rus_conv(RUS_KOI_WIN,street);
  rus_conv(RUS_KOI_WIN,zip);
  rus_conv(RUS_KOI_WIN,company_name);
  rus_conv(RUS_KOI_WIN,department);
  rus_conv(RUS_KOI_WIN,position);
  rus_conv(RUS_KOI_WIN,webpage);

  add_nontlv_lnts(infotlvs, city);
  add_nontlv_lnts(infotlvs, state);
  add_nontlv_dw_le(infotlvs, 0);
  add_nontlv_lnts(infotlvs, street);
  add_nontlv_lnts(infotlvs, zip);
  add_nontlv_w_le(infotlvs, country);
  add_nontlv_lnts(infotlvs, company_name);
  add_nontlv_lnts(infotlvs, department);
  add_nontlv_lnts(infotlvs, position);
  add_nontlv_w_le(infotlvs, 0);
  add_nontlv_lnts(infotlvs, webpage);

  v7_send_15_02_D007( 0xF303, infotlvs->beg, infotlvs->len);

  free_tlvstack(infotlvs);
}

void v7_modify_main_home_info (gchar *nick, gchar *first, gchar *last,
                                gchar *email, gchar *city, gchar *state, 
                                gchar *phone, gchar *fax, gchar *street, 
                                gchar *cellular, gchar *zip, WORD country,
                                BYTE timezone, BYTE publish_email)
{

  TLVstack *infotlvs;

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_main_home_info\n" );
#endif 

  infotlvs = new_tlvstack(NULL, 0);

  rus_conv(RUS_KOI_WIN,nick);
  rus_conv(RUS_KOI_WIN,first);
  rus_conv(RUS_KOI_WIN,last);
  rus_conv(RUS_KOI_WIN,email);
  rus_conv(RUS_KOI_WIN,city);
  rus_conv(RUS_KOI_WIN,state);
  rus_conv(RUS_KOI_WIN,phone);
  rus_conv(RUS_KOI_WIN,fax);
  rus_conv(RUS_KOI_WIN,street);
  rus_conv(RUS_KOI_WIN,cellular);
  rus_conv(RUS_KOI_WIN,zip);

  add_nontlv_lnts(infotlvs, nick);
  add_nontlv_lnts(infotlvs, first);
  add_nontlv_lnts(infotlvs, last);
  add_nontlv_lnts(infotlvs, email);
  add_nontlv_lnts(infotlvs, city);
  add_nontlv_lnts(infotlvs, state);
  add_nontlv_lnts(infotlvs, phone);
  add_nontlv_lnts(infotlvs, fax);
  add_nontlv_lnts(infotlvs, street);
  add_nontlv_lnts(infotlvs, cellular);
  add_nontlv_lnts(infotlvs, zip);
  add_nontlv_w_le(infotlvs, country);
  add_nontlv(infotlvs, &timezone, 1);
  add_nontlv(infotlvs, &publish_email, 1);

  v7_send_15_02_D007( 0xEA03, infotlvs->beg, infotlvs->len);

  free_tlvstack(infotlvs);
}

void v7_modify_more_info(BYTE age, BYTE sex, gchar *homepage, WORD birthyear,
                          BYTE birthmonth, BYTE birthday, BYTE language1,
                          BYTE language2, BYTE language3)
{

  TLVstack *infotlvs;

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_more_info\n" );
#endif 

  rus_conv(RUS_KOI_WIN,homepage);

  infotlvs = new_tlvstack(NULL, 0);
  if (age > 13)
    add_nontlv(infotlvs, &age, 1);
  else
    add_nontlv(infotlvs, "\x0E", 1);
  add_nontlv_w_be(infotlvs, sex);
  add_nontlv_lnts(infotlvs, homepage);
  add_nontlv_w_le(infotlvs, birthyear);
  add_nontlv(infotlvs, &birthmonth, 1);
  add_nontlv(infotlvs, &birthday, 1);
  add_nontlv(infotlvs, &language1, 1);
  add_nontlv(infotlvs, &language2, 1);
  add_nontlv(infotlvs, &language3, 1);

  v7_send_15_02_D007( 0xFD03, infotlvs->beg, infotlvs->len);

  free_tlvstack(infotlvs);
}

void v7_modify_permissions(BYTE auth, BYTE webaware)
{

  BYTE buffer[4];

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_permissions\n" );
#endif 

  buffer[0] = auth ? 0 : 1;
  buffer[1] = webaware ? 1 : 0;
  buffer[2] = 1;
  buffer[3] = 0;

  v7_send_15_02_D007( 0x2404, buffer, 4);


}

void v7_modify_emails_info (GList *emails)
{

  TLVstack *infotlvs;
  GList *email;

#ifdef TRACE_FUNCTION
  g_print( "v7_modify_emails_info\n" );
#endif 

  infotlvs = new_tlvstack("\0", 1);

  for (email = emails; email != NULL; email = email->next) {
    add_nontlv(infotlvs, email->data, 1);
    add_nontlv_lnts(infotlvs, email->data+1);
    infotlvs->beg[0]++;
  }                
  
  v7_send_15_02_D007( 0x0B04, infotlvs->beg, infotlvs->len);
  
  free_tlvstack(infotlvs);
}

void v7_sendcontacts(UIN_T uin, GList *contacts)
{

  GList *contact;
  TLVstack *msgtlvs;
  gchar *count;

#ifdef TRACE_FUNCTION
  g_print( "v7_sendcontacts\n" );
#endif 

  msgtlvs = new_tlvstack(zerobuf, 8);

  DW_2_Chars(msgtlvs->beg, our_info->uin);

  msgtlvs->beg[4] = 0x13;  /* type 0x13 = send contacts  */

  count = g_strdup_printf("%d", g_list_length(contacts));
  add_nontlv(msgtlvs, count, strlen(count));
  g_free(count);
  
  for (contact = contacts; contact != NULL; contact = contact->next) {
    add_nontlv(msgtlvs, "\xFE", 1);
    add_nontlv(msgtlvs, ((ContactPair *)contact->data)->textuin,
               strlen(((ContactPair *)contact->data)->textuin));
    add_nontlv(msgtlvs, "\xFE", 1);
    add_nontlv(msgtlvs, ((ContactPair *)contact->data)->nick,
               strlen(((ContactPair *)contact->data)->nick));
  }

  add_nontlv(msgtlvs, zerobuf, 1);


  Word_2_Chars(msgtlvs->beg+6, msgtlvs->len - 8);

  v7_sendmsg4(uin, msgtlvs->beg, msgtlvs->len);
  
  free_tlvstack(msgtlvs);
}

void v7_iam_icq (V7Connection *conn)
{
  BYTE i_am_icq_array[40] = "\x00\x01\x00\x03\x00\x13\x00\x02"
                            "\x00\x02\x00\x01\x00\x03\x00\x01"
                            "\x00\x15\x00\x01\x00\x04\x00\x01"
                            "\x00\x06\x00\x01\x00\x09\x00\x01"
                            "\x00\x0A\x00\x01\x00\x0B\x00\x01";

  snac_send(conn, i_am_icq_array, 40, FAMILY_01_GENERIC, F01_CLIENT_I_AM_ICQ,
            NULL, ANY_ID);
}

void v7_request_rate (V7Connection *conn)
{
  snac_send(conn, NULL, 0, FAMILY_01_GENERIC, F01_CLIENT_REQ_RATE,
            NULL, ANY_ID);
}

void v7_make_requests(V7Connection *conn)
{
#ifdef TRACE_FUNCTION
  g_print( "v7_make_requests\n" );
#endif

  snac_send(conn, NULL, 0, FAMILY_01_GENERIC,  F01_CLIENT_REQ_PERSONAL_INFO,
            NULL, ANY_ID);

  v7_request_contacts_list ();

  snac_send(conn, NULL, 0, FAMILY_02_LOCATION, F02_CLIENT_REQ_RIGHTS_LOCATION,
            NULL, ANY_ID);
  snac_send(conn, NULL, 0, FAMILY_03_CONTACTLIST, F03_CLIENT_REQ_CL_INFO,
            NULL, ANY_ID);
  snac_send(conn, NULL, 0, FAMILY_04_MESSAGING, F04_CLIENT_REQ_RIGHTS_MSG,
            NULL, ANY_ID);
  snac_send(conn, NULL, 0, FAMILY_09_LISTS, F09_CLIENT_REQ_LISTS_RIGHTS,
	    NULL, ANY_ID);
}


void v7_set_user_info (V7Connection *conn)
{
  TLVstack *tlv;
  BYTE caps[64] =
    "\x09\x46\x13\x49" "\x4C\x7F\x11\xD1" "\x82\x22\x44\x45" "\x53\x54\x00\x00"
    "\x97\xB1\x27\x51" "\x24\x3C\x43\x34" "\xAD\x22\xD6\xAB" "\xF7\x3F\x14\x92"
    "\x2E\x7A\x64\x75" "\xFA\xDF\x4D\xC8" "\x88\x6F\xEA\x35" "\x95\xFD\xB6\xDF"
    "\x09\x46\x13\x44" "\x4C\x7F\x11\xD1" "\x82\x22\x44\x45" "\x53\x54\x00\x00";

  tlv = new_tlvstack(NULL,0);
  /* Only send the 2 first caps (32 bytes), because we dont support
     RTF messages yet, that blocks windows users from getting our away
     messages though */
  add_tlv(tlv, 5, caps, 64);
  snac_send(conn, tlv->beg, tlv->len, FAMILY_02_LOCATION,
            F02_CLIENT_SET_CAPS, NULL, ANY_ID);
  free_tlvstack(tlv);
}

void v7_add_icbm (V7Connection *conn)
{
  BYTE msg_param[16] ="\x00\x00\x00\x00\x00\x03\x1F\x40\x03\xE7\x03\xE7\x00\x00\x00\x00";

  snac_send(conn, msg_param, 16, FAMILY_04_MESSAGING, F04_CLIENT_ADD_MSG_PARM,
	    NULL, ANY_ID);
}

void v7_client_ready (V7Connection *conn)
{
  /*  BYTE ready_data2000[64] = \
    "\x00\x01\x00\x03\x01\x10\x02\x8A"
    "\x00\x02\x00\x01\x01\x01\x02\x8A"
    "\x00\x03\x00\x01\x01\x10\x02\x8A"
    "\x00\x15\x00\x01\x01\x10\x02\x8A"
    "\x00\x04\x00\x01\x01\x10\x02\x8A"
    "\x00\x06\x00\x01\x01\x10\x02\x8A"
    "\x00\x09\x00\x01\x01\x10\x02\x8A"
    "\x00\x0A\x00\x01\x01\x10\x02\x8A";*/

  gchar ready_data2001[80] = \
    "\x00\x01\x00\x03\x01\x10\x04\x7B"
    "\x00\x13\x00\x02\x01\x10\x04\x7B"
    "\x00\x02\x00\x01\x01\x01\x04\x7B"
    "\x00\x03\x00\x01\x01\x10\x04\x7B"
    "\x00\x15\x00\x01\x01\x10\x04\x7B"
    "\x00\x04\x00\x01\x01\x10\x04\x7B"
    "\x00\x06\x00\x01\x01\x10\x04\x7B"
    "\x00\x09\x00\x01\x01\x10\x04\x7B"
    "\x00\x0A\x00\x01\x01\x10\x04\x7B"
    "\x00\x0B\x00\x01\x01\x10\x04\x7B";

  snac_send(conn, ready_data2001, 80, FAMILY_01_GENERIC, F01_CLIENT_READY, NULL,
	    ANY_ID);

  conn->status = READY;
  enable_online_events = TRUE;
  animate_off();

  ready_set();

  init();

  v7_reqofflinemsg();
}

void v7_send_often(DWORD reqid)
{
  TLVstack *tlvs;
  gchar buffer[10];

#ifdef TRACE_FUNCTION
  g_print( "v7_send_often\n" );
#endif
  
  Word_2_Chars(buffer, 8);
  DW_2_Chars(buffer+2, our_info->uin);
  Word_2_CharsBE(buffer+6, 0x3E00);
  Word_2_CharsBE(buffer+8, reqid);

  tlvs = new_tlvstack(NULL,0);

  add_tlv(tlvs, 1, buffer, 10);
  
  snac_send(mainconnection, tlvs->beg, tlvs->len, FAMILY_15_SAVED_DATA,
            F15_CLIENT_REQ_SAVE_DATA, NULL, ANY_ID);
  free_tlvstack(tlvs);

}

void v7_reqofflinemsg()
{

  TLVstack *tlvs;
  gchar buffer[10];

#ifdef TRACE_FUNCTION
  g_print( "v7_reqofflinemsg\n" );
#endif
  
  Word_2_Chars(buffer, 8);
  DW_2_Chars(buffer+2, our_info->uin);
  Word_2_CharsBE(buffer+6, 0x3C00);

  tlvs = new_tlvstack(NULL,0);

  add_tlv(tlvs, 1, buffer, 10);
  
  snac_send(mainconnection, tlvs->beg, tlvs->len, FAMILY_15_SAVED_DATA,
            F15_CLIENT_REQ_SAVE_DATA, NULL, ANY_ID);
  free_tlvstack(tlvs);

}
