/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _GNCRPC_H_RPCGEN
#define _GNCRPC_H_RPCGEN

#include <rpc/rpc.h>

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef char gncGUID[16];

struct gnc_guidlist {
	gncGUID *guid;
	struct gnc_guidlist *next;
};
typedef struct gnc_guidlist gnc_guidlist;

struct gnc_vers_list {
	gncGUID *guid;
	int vers;
	struct gnc_vers_list *next;
};
typedef struct gnc_vers_list gnc_vers_list;

struct gncTimespec {
	int64_t tv_sec;
	int tv_nsec;
};
typedef struct gncTimespec gncTimespec;
#include "kvp_frame.h"

struct gncNumeric {
	int64_t num;
	int64_t denom;
};
typedef struct gncNumeric gncNumeric;

struct gnc_kvp_valuelist {
	struct gnc_kvp_value *val;
	struct gnc_kvp_valuelist *next;
};
typedef struct gnc_kvp_valuelist gnc_kvp_valuelist;

struct gnc_kvp_value {
	enum_t type;
	union {
		int64_t int64;
		double dbl;
		gncNumeric numeric;
		char *str;
		gncGUID guid;
		struct {
			u_int binary_len;
			char *binary_val;
		} binary;
		gnc_kvp_valuelist *glist;
		struct gnc_kvp_frame *frame;
	} gnc_kvp_value_u;
};
typedef struct gnc_kvp_value gnc_kvp_value;

struct gnc_kvp {
	char *key;
	gnc_kvp_value *value;
};
typedef struct gnc_kvp gnc_kvp;

struct gnc_kvp_frame {
	gnc_kvp *data;
	struct gnc_kvp_frame *next;
};
typedef struct gnc_kvp_frame gnc_kvp_frame;

struct gncCommodity {
	char *fullname;
	char *namespace;
	char *mnemonic;
	char *printname;
	char *exchange_code;
	int fraction;
};
typedef struct gncCommodity gncCommodity;

struct gnc_commoditylist {
	gncCommodity *commodity;
	struct gnc_commoditylist *next;
};
typedef struct gnc_commoditylist gnc_commoditylist;

struct gncCommodityPtr {
	char *namespace;
	char *mnemonic;
};
typedef struct gncCommodityPtr gncCommodityPtr;
#include "Account.h"

struct gncAccount {
	gncGUID guid;
	char *name;
	char *code;
	char *desc;
	gnc_kvp_frame *kvp_data;
	enum_t type;
	gncCommodityPtr currency;
	gncCommodityPtr security;
	gncGUID *parent;
	int vers;
	gncNumeric balance;
	gncNumeric cleared_balance;
	gncNumeric reconciled_balance;
	gncNumeric share_balance;
	gncNumeric share_cleared_balance;
	gncNumeric share_reconciled_balance;
	bool_t core_dirty;
	bool_t do_free;
};
typedef struct gncAccount gncAccount;

struct gnc_acctlist {
	gncAccount *acct;
	struct gnc_acctlist *next;
};
typedef struct gnc_acctlist gnc_acctlist;
#include "Query.h"

struct gncDatePredicateData {
	enum_t term_type;
	int sense;
	int usestart;
	gncTimespec start;
	int useend;
	gncTimespec end;
};
typedef struct gncDatePredicateData gncDatePredicateData;

struct gncAmountPredicateData {
	enum_t term_type;
	int sense;
	enum_t how;
	enum_t amt_sgn;
	double amount;
};
typedef struct gncAmountPredicateData gncAmountPredicateData;

struct gncAccountPredicateData {
	enum_t term_type;
	int sense;
	enum_t how;
	gnc_guidlist *acct_guids;
};
typedef struct gncAccountPredicateData gncAccountPredicateData;

struct gncStringPredicateData {
	enum_t term_type;
	int sense;
	int case_sens;
	int use_regexp;
	char *matchstring;
};
typedef struct gncStringPredicateData gncStringPredicateData;

struct gncClearedPredicateData {
	enum_t term_type;
	int sense;
	enum_t how;
};
typedef struct gncClearedPredicateData gncClearedPredicateData;

struct gncBalancePredicateData {
	enum_t term_type;
	int sense;
	enum_t how;
};
typedef struct gncBalancePredicateData gncBalancePredicateData;

struct gncMiscPredicateData {
	enum_t term_type;
	int sense;
	int how;
	int data;
};
typedef struct gncMiscPredicateData gncMiscPredicateData;

struct gncPredicateData {
	enum_t type;
	union {
		gncDatePredicateData date;
		gncAmountPredicateData amount;
		gncAccountPredicateData acct;
		gncStringPredicateData str;
		gncClearedPredicateData cleared;
		gncBalancePredicateData balance;
		gncMiscPredicateData misc;
	} gncPredicateData_u;
};
typedef struct gncPredicateData gncPredicateData;

struct gncQueryTerm {
	gncPredicateData data;
	int *p;
};
typedef struct gncQueryTerm gncQueryTerm;

struct gncQTList {
	gncQueryTerm *qt;
	struct gncQTList *next;
};
typedef struct gncQTList gncQTList;

struct gncQTOrlist {
	gncQTList *andlist;
	struct gncQTOrlist *next;
};
typedef struct gncQTOrlist gncQTOrlist;

struct gncQuery {
	gncQTOrlist *terms;
	enum_t primary_sort;
	enum_t secondary_sort;
	enum_t tertiary_sort;
	bool_t primary_increasing;
	bool_t secondary_increasing;
	bool_t tertiary_increasing;
	int max_splits;
	int changed;
	enum_t last_run_type;
	int *acct_group;
	int *split_list;
	int *xtn_list;
};
typedef struct gncQuery gncQuery;

struct gncSplit {
	gncGUID guid;
	gncGUID acct_guid;
	gncGUID txn_guid;
	char *memo;
	char *action;
	gnc_kvp_frame *kvp_data;
	char reconciled;
	gncTimespec date_reconciled;
	gncNumeric value;
	gncNumeric damount;
};
typedef struct gncSplit gncSplit;

struct gnc_splitlist {
	gncSplit *split;
	struct gnc_splitlist *next;
};
typedef struct gnc_splitlist gnc_splitlist;

struct gncTransaction {
	gncGUID guid;
	gncTimespec date_entered;
	gncTimespec date_posted;
	char *num;
	char *desc;
	gnc_kvp_frame *kvp_data;
	gncCommodityPtr common_currency;
	int vers;
	gnc_splitlist *splits;
	bool_t do_free;
};
typedef struct gncTransaction gncTransaction;

struct gnc_txnlist {
	gncTransaction *txn;
	struct gnc_txnlist *next;
};
typedef struct gnc_txnlist gnc_txnlist;

typedef char gncrpc_ptr[8];

struct gncrpc_book_begin_args {
	gncrpc_ptr book;
	gncrpc_ptr backend;
	char *book_id;
	bool_t ignore_lock;
	bool_t create;
};
typedef struct gncrpc_book_begin_args gncrpc_book_begin_args;

struct gncrpc_book_load_ret {
	int error;
	gnc_commoditylist *commodities;
	gnc_acctlist *acctlist;
};
typedef struct gncrpc_book_load_ret gncrpc_book_load_ret;

struct gncrpc_backend_guid {
	gncrpc_ptr backend;
	gncGUID guid;
};
typedef struct gncrpc_backend_guid gncrpc_backend_guid;

struct gncrpc_backend_txn {
	gncrpc_ptr backend;
	gncTransaction txn;
};
typedef struct gncrpc_backend_txn gncrpc_backend_txn;

struct gncrpc_commit_acct_args {
	gncrpc_ptr backend;
	gncAccount acct;
#ifdef GNCACCT_COMMODITY
	gncCommodity *commodity;
#else
	gncCommodity *currency;
	gncCommodity *security;
#endif
};
typedef struct gncrpc_commit_acct_args gncrpc_commit_acct_args;

struct gncrpc_commit_txn_args {
	gncrpc_ptr backend;
	gncTransaction new;
};
typedef struct gncrpc_commit_txn_args gncrpc_commit_txn_args;

struct gncrpc_sync1_args {
	gncrpc_ptr backend;
	gnc_commoditylist *commodities;
	gnc_vers_list *acctlist;
	gnc_vers_list *txnlist;
};
typedef struct gncrpc_sync1_args gncrpc_sync1_args;

struct gncrpc_sync1_ret {
	int error;
	gnc_vers_list *send_acctlist;
	gnc_vers_list *send_txnlist;
	gnc_acctlist *acctlist;
	gnc_txnlist *txnlist;
	gnc_commoditylist *commodities;
};
typedef struct gncrpc_sync1_ret gncrpc_sync1_ret;

struct gncrpc_sync2_args {
	gncrpc_ptr backend;
	gnc_acctlist *acctlist;
	gnc_txnlist *txnlist;
};
typedef struct gncrpc_sync2_args gncrpc_sync2_args;

struct gncrpc_query_args {
	gncrpc_ptr backend;
	gncGUID *group_parent_guid;
	gncQuery *query;
};
typedef struct gncrpc_query_args gncrpc_query_args;

struct gncrpc_query_ret {
	int error;
	gnc_vers_list *txnlist;
};
typedef struct gncrpc_query_ret gncrpc_query_ret;

struct gncrpc_get_txns_args {
	gncrpc_ptr backend;
	gnc_vers_list *guids;
};
typedef struct gncrpc_get_txns_args gncrpc_get_txns_args;

struct gncrpc_get_txns_ret {
	int error;
	gnc_txnlist *txnlist;
};
typedef struct gncrpc_get_txns_ret gncrpc_get_txns_ret;

#define GNCRPC_PROG 729284
#define GNCRPC_VERS 1

#if defined(__STDC__) || defined(__cplusplus)
#define gncrpc_version 0
extern  enum clnt_stat gncrpc_version_1(void *, int *, CLIENT *);
extern  bool_t gncrpc_version_1_svc(void *, int *, struct svc_req *);
#define gncrpc_book_begin 1
extern  enum clnt_stat gncrpc_book_begin_1(gncrpc_book_begin_args *, int *, CLIENT *);
extern  bool_t gncrpc_book_begin_1_svc(gncrpc_book_begin_args *, int *, struct svc_req *);
#define gncrpc_book_load 2
extern  enum clnt_stat gncrpc_book_load_1(char *, gncrpc_book_load_ret *, CLIENT *);
extern  bool_t gncrpc_book_load_1_svc(char *, gncrpc_book_load_ret *, struct svc_req *);
#define gncrpc_book_end 3
extern  enum clnt_stat gncrpc_book_end_1(char *, int *, CLIENT *);
extern  bool_t gncrpc_book_end_1_svc(char *, int *, struct svc_req *);
#define gncrpc_account_begin_edit 4
extern  enum clnt_stat gncrpc_account_begin_edit_1(gncrpc_backend_guid *, int *, CLIENT *);
extern  bool_t gncrpc_account_begin_edit_1_svc(gncrpc_backend_guid *, int *, struct svc_req *);
#define gncrpc_account_commit_edit 5
extern  enum clnt_stat gncrpc_account_commit_edit_1(gncrpc_commit_acct_args *, int *, CLIENT *);
extern  bool_t gncrpc_account_commit_edit_1_svc(gncrpc_commit_acct_args *, int *, struct svc_req *);
#define gncrpc_account_rollback_edit 6
extern  enum clnt_stat gncrpc_account_rollback_edit_1(gncrpc_backend_guid *, int *, CLIENT *);
extern  bool_t gncrpc_account_rollback_edit_1_svc(gncrpc_backend_guid *, int *, struct svc_req *);
#define gncrpc_txn_begin_edit 7
extern  enum clnt_stat gncrpc_txn_begin_edit_1(gncrpc_backend_guid *, int *, CLIENT *);
extern  bool_t gncrpc_txn_begin_edit_1_svc(gncrpc_backend_guid *, int *, struct svc_req *);
#define gncrpc_txn_commit_edit 8
extern  enum clnt_stat gncrpc_txn_commit_edit_1(gncrpc_commit_txn_args *, int *, CLIENT *);
extern  bool_t gncrpc_txn_commit_edit_1_svc(gncrpc_commit_txn_args *, int *, struct svc_req *);
#define gncrpc_txn_rollback_edit 9
extern  enum clnt_stat gncrpc_txn_rollback_edit_1(gncrpc_backend_guid *, int *, CLIENT *);
extern  bool_t gncrpc_txn_rollback_edit_1_svc(gncrpc_backend_guid *, int *, struct svc_req *);
#define gncrpc_run_query 10
extern  enum clnt_stat gncrpc_run_query_1(gncrpc_query_args *, gncrpc_query_ret *, CLIENT *);
extern  bool_t gncrpc_run_query_1_svc(gncrpc_query_args *, gncrpc_query_ret *, struct svc_req *);
#define gncrpc_sync1 11
extern  enum clnt_stat gncrpc_sync1_1(gncrpc_sync1_args *, gncrpc_sync1_ret *, CLIENT *);
extern  bool_t gncrpc_sync1_1_svc(gncrpc_sync1_args *, gncrpc_sync1_ret *, struct svc_req *);
#define gncrpc_sync2 12
extern  enum clnt_stat gncrpc_sync2_1(gncrpc_sync2_args *, int *, CLIENT *);
extern  bool_t gncrpc_sync2_1_svc(gncrpc_sync2_args *, int *, struct svc_req *);
#define gncrpc_get_txns 13
extern  enum clnt_stat gncrpc_get_txns_1(gncrpc_get_txns_args *, gncrpc_get_txns_ret *, CLIENT *);
extern  bool_t gncrpc_get_txns_1_svc(gncrpc_get_txns_args *, gncrpc_get_txns_ret *, struct svc_req *);
extern int gncrpc_prog_1_freeresult (SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
#define gncrpc_version 0
extern  enum clnt_stat gncrpc_version_1();
extern  bool_t gncrpc_version_1_svc();
#define gncrpc_book_begin 1
extern  enum clnt_stat gncrpc_book_begin_1();
extern  bool_t gncrpc_book_begin_1_svc();
#define gncrpc_book_load 2
extern  enum clnt_stat gncrpc_book_load_1();
extern  bool_t gncrpc_book_load_1_svc();
#define gncrpc_book_end 3
extern  enum clnt_stat gncrpc_book_end_1();
extern  bool_t gncrpc_book_end_1_svc();
#define gncrpc_account_begin_edit 4
extern  enum clnt_stat gncrpc_account_begin_edit_1();
extern  bool_t gncrpc_account_begin_edit_1_svc();
#define gncrpc_account_commit_edit 5
extern  enum clnt_stat gncrpc_account_commit_edit_1();
extern  bool_t gncrpc_account_commit_edit_1_svc();
#define gncrpc_account_rollback_edit 6
extern  enum clnt_stat gncrpc_account_rollback_edit_1();
extern  bool_t gncrpc_account_rollback_edit_1_svc();
#define gncrpc_txn_begin_edit 7
extern  enum clnt_stat gncrpc_txn_begin_edit_1();
extern  bool_t gncrpc_txn_begin_edit_1_svc();
#define gncrpc_txn_commit_edit 8
extern  enum clnt_stat gncrpc_txn_commit_edit_1();
extern  bool_t gncrpc_txn_commit_edit_1_svc();
#define gncrpc_txn_rollback_edit 9
extern  enum clnt_stat gncrpc_txn_rollback_edit_1();
extern  bool_t gncrpc_txn_rollback_edit_1_svc();
#define gncrpc_run_query 10
extern  enum clnt_stat gncrpc_run_query_1();
extern  bool_t gncrpc_run_query_1_svc();
#define gncrpc_sync1 11
extern  enum clnt_stat gncrpc_sync1_1();
extern  bool_t gncrpc_sync1_1_svc();
#define gncrpc_sync2 12
extern  enum clnt_stat gncrpc_sync2_1();
extern  bool_t gncrpc_sync2_1_svc();
#define gncrpc_get_txns 13
extern  enum clnt_stat gncrpc_get_txns_1();
extern  bool_t gncrpc_get_txns_1_svc();
extern int gncrpc_prog_1_freeresult ();
#endif /* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_gncGUID (XDR *, gncGUID);
extern  bool_t xdr_gnc_guidlist (XDR *, gnc_guidlist*);
extern  bool_t xdr_gnc_vers_list (XDR *, gnc_vers_list*);
extern  bool_t xdr_gncTimespec (XDR *, gncTimespec*);
extern  bool_t xdr_gncNumeric (XDR *, gncNumeric*);
extern  bool_t xdr_gnc_kvp_valuelist (XDR *, gnc_kvp_valuelist*);
extern  bool_t xdr_gnc_kvp_value (XDR *, gnc_kvp_value*);
extern  bool_t xdr_gnc_kvp (XDR *, gnc_kvp*);
extern  bool_t xdr_gnc_kvp_frame (XDR *, gnc_kvp_frame*);
extern  bool_t xdr_gncCommodity (XDR *, gncCommodity*);
extern  bool_t xdr_gnc_commoditylist (XDR *, gnc_commoditylist*);
extern  bool_t xdr_gncCommodityPtr (XDR *, gncCommodityPtr*);
extern  bool_t xdr_gncAccount (XDR *, gncAccount*);
extern  bool_t xdr_gnc_acctlist (XDR *, gnc_acctlist*);
extern  bool_t xdr_gncDatePredicateData (XDR *, gncDatePredicateData*);
extern  bool_t xdr_gncAmountPredicateData (XDR *, gncAmountPredicateData*);
extern  bool_t xdr_gncAccountPredicateData (XDR *, gncAccountPredicateData*);
extern  bool_t xdr_gncStringPredicateData (XDR *, gncStringPredicateData*);
extern  bool_t xdr_gncClearedPredicateData (XDR *, gncClearedPredicateData*);
extern  bool_t xdr_gncBalancePredicateData (XDR *, gncBalancePredicateData*);
extern  bool_t xdr_gncMiscPredicateData (XDR *, gncMiscPredicateData*);
extern  bool_t xdr_gncPredicateData (XDR *, gncPredicateData*);
extern  bool_t xdr_gncQueryTerm (XDR *, gncQueryTerm*);
extern  bool_t xdr_gncQTList (XDR *, gncQTList*);
extern  bool_t xdr_gncQTOrlist (XDR *, gncQTOrlist*);
extern  bool_t xdr_gncQuery (XDR *, gncQuery*);
extern  bool_t xdr_gncSplit (XDR *, gncSplit*);
extern  bool_t xdr_gnc_splitlist (XDR *, gnc_splitlist*);
extern  bool_t xdr_gncTransaction (XDR *, gncTransaction*);
extern  bool_t xdr_gnc_txnlist (XDR *, gnc_txnlist*);
extern  bool_t xdr_gncrpc_ptr (XDR *, gncrpc_ptr);
extern  bool_t xdr_gncrpc_book_begin_args (XDR *, gncrpc_book_begin_args*);
extern  bool_t xdr_gncrpc_book_load_ret (XDR *, gncrpc_book_load_ret*);
extern  bool_t xdr_gncrpc_backend_guid (XDR *, gncrpc_backend_guid*);
extern  bool_t xdr_gncrpc_backend_txn (XDR *, gncrpc_backend_txn*);
extern  bool_t xdr_gncrpc_commit_acct_args (XDR *, gncrpc_commit_acct_args*);
extern  bool_t xdr_gncrpc_commit_txn_args (XDR *, gncrpc_commit_txn_args*);
extern  bool_t xdr_gncrpc_sync1_args (XDR *, gncrpc_sync1_args*);
extern  bool_t xdr_gncrpc_sync1_ret (XDR *, gncrpc_sync1_ret*);
extern  bool_t xdr_gncrpc_sync2_args (XDR *, gncrpc_sync2_args*);
extern  bool_t xdr_gncrpc_query_args (XDR *, gncrpc_query_args*);
extern  bool_t xdr_gncrpc_query_ret (XDR *, gncrpc_query_ret*);
extern  bool_t xdr_gncrpc_get_txns_args (XDR *, gncrpc_get_txns_args*);
extern  bool_t xdr_gncrpc_get_txns_ret (XDR *, gncrpc_get_txns_ret*);

#else /* K&R C */
extern bool_t xdr_gncGUID ();
extern bool_t xdr_gnc_guidlist ();
extern bool_t xdr_gnc_vers_list ();
extern bool_t xdr_gncTimespec ();
extern bool_t xdr_gncNumeric ();
extern bool_t xdr_gnc_kvp_valuelist ();
extern bool_t xdr_gnc_kvp_value ();
extern bool_t xdr_gnc_kvp ();
extern bool_t xdr_gnc_kvp_frame ();
extern bool_t xdr_gncCommodity ();
extern bool_t xdr_gnc_commoditylist ();
extern bool_t xdr_gncCommodityPtr ();
extern bool_t xdr_gncAccount ();
extern bool_t xdr_gnc_acctlist ();
extern bool_t xdr_gncDatePredicateData ();
extern bool_t xdr_gncAmountPredicateData ();
extern bool_t xdr_gncAccountPredicateData ();
extern bool_t xdr_gncStringPredicateData ();
extern bool_t xdr_gncClearedPredicateData ();
extern bool_t xdr_gncBalancePredicateData ();
extern bool_t xdr_gncMiscPredicateData ();
extern bool_t xdr_gncPredicateData ();
extern bool_t xdr_gncQueryTerm ();
extern bool_t xdr_gncQTList ();
extern bool_t xdr_gncQTOrlist ();
extern bool_t xdr_gncQuery ();
extern bool_t xdr_gncSplit ();
extern bool_t xdr_gnc_splitlist ();
extern bool_t xdr_gncTransaction ();
extern bool_t xdr_gnc_txnlist ();
extern bool_t xdr_gncrpc_ptr ();
extern bool_t xdr_gncrpc_book_begin_args ();
extern bool_t xdr_gncrpc_book_load_ret ();
extern bool_t xdr_gncrpc_backend_guid ();
extern bool_t xdr_gncrpc_backend_txn ();
extern bool_t xdr_gncrpc_commit_acct_args ();
extern bool_t xdr_gncrpc_commit_txn_args ();
extern bool_t xdr_gncrpc_sync1_args ();
extern bool_t xdr_gncrpc_sync1_ret ();
extern bool_t xdr_gncrpc_sync2_args ();
extern bool_t xdr_gncrpc_query_args ();
extern bool_t xdr_gncrpc_query_ret ();
extern bool_t xdr_gncrpc_get_txns_args ();
extern bool_t xdr_gncrpc_get_txns_ret ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_GNCRPC_H_RPCGEN */
