dnl Copyright (C) 1988 Eleftherios Gkioulekas <lf@amath.washington.edu>
dnl Copyright (C) 2009 Free Software Foundation, Inc.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 3 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 51 Franklin Street, Boston, MA 02110-1301, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

# --------------------------------------------------------------------------
# Check whether the C++ compiler accepts a certain flag
# If it does it adds the flag to lf_CXXFLAGS
# If it does not then it returns an error to lf_ok
# Usage:
#   LF_CHECK_CXX_FLAG(-flag1 -flag2 -flag3 ...)
# -------------------------------------------------------------------------

AC_DEFUN([LF_CHECK_CXX_FLAG],[
  echo "#include <stdio.h>
int main(int argc, char **argv){return 0;}" > conftest.cc
  for i in $1
  do
    AC_MSG_CHECKING([whether $CXX accepts $i])
    if test -z "`${CXX} $i -c conftest.cc 2>&1`"
    then
      lf_CXXFLAGS="${lf_CXXFLAGS} $i"
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi
  done
  rm -f conftest.cc conftest.o
  AC_SUBST(lf_CXXFLAGS)
])

# --------------------------------------------------------------------------
# Check whether the C compiler accepts a certain flag
# If it does it adds the flag to lf_CFLAGS
# If it does not then it returns an error to lf_ok
# Usage:
#  LF_CHECK_CC_FLAG(-flag1 -flag2 -flag3 ...)
# -------------------------------------------------------------------------

AC_DEFUN([LF_CHECK_CC_FLAG],[
  echo "#include <stdio.h>
int main(int argc, char **argv){return 0;}" > conftest.c
  for i in $1
  do
    AC_MSG_CHECKING([whether $CC accepts $i])
    if test -z "`${CC} $i -c conftest.c 2>&1`"
    then
      lf_CFLAGS="${lf_CFLAGS} $i"
      AC_MSG_RESULT(yes)
    else
      AC_MSG_RESULT(no)
    fi
  done
  rm -f conftest.c conftest.o
  AC_SUBST(lf_CFLAGS)
])

# --------------------------------------------------------------------------
# Check whether the Fortran compiler accepts a certain flag
# If it does it adds the flag to lf_FFLAGS
# If it does not then it returns an error to lf_ok
# Usage:
#  LF_CHECK_F77_FLAG(-flag1 -flag2 -flag3 ...)
# -------------------------------------------------------------------------

AC_DEFUN([LF_CHECK_F77_FLAG],[
  cat << EOF > conftest.f
c....:++++++++++++++++++++++++
      PROGRAM MAIN
      PRINT*,'Hello World!'
      END
EOF
  for i in $1
  do
    AC_MSG_CHECKING([whether $F77 accepts $i])
    if test -z "`${F77} $i -c conftest.f 2>&1`"
    then
      lf_FFLAGS="${lf_FFLAGS} $i"
      AC_MSG_RESULT(yes)  
    else
      AC_MSG_RESULT(no)
    fi
  done
  rm -f conftest.f conftest.o
  AC_SUBST(lf_FFLAGS)
])

# ----------------------------------------------------------------------
# Enable compiler warnings. 
# Call this command AFTER you have configured ALL your compilers. 
# ----------------------------------------------------------------------

AC_DEFUN([LF_SET_WARNINGS],[
  dnl Warnings for the two main compilers
  dnl add -Wextra when you're got time to fix a bunch of them ;-)
  cc_warning_flags="-Wall -Werror-implicit-function-declaration -Wno-uninitialized"
  cxx_warning_flags="-Wall -Woverloaded-virtual -Wno-uninitialized"
  if test -n "${CC}"
  then
    LF_CHECK_CC_FLAG($cc_warning_flags)
  fi
  if test -n "${CXX}" 
  then
    LF_CHECK_CXX_FLAG($cxx_warning_flags)
  fi
])
