// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/datastore/v1/datastore.proto
// DO NOT EDIT!

/*
Package google_datastore_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/datastore/v1/datastore.proto
	google.golang.org/genproto/googleapis/datastore/v1/entity.proto
	google.golang.org/genproto/googleapis/datastore/v1/query.proto

It has these top-level messages:
	LookupRequest
	LookupResponse
	RunQueryRequest
	RunQueryResponse
	BeginTransactionRequest
	BeginTransactionResponse
	RollbackRequest
	RollbackResponse
	CommitRequest
	CommitResponse
	AllocateIdsRequest
	AllocateIdsResponse
	Mutation
	MutationResult
	ReadOptions
	PartitionId
	Key
	ArrayValue
	Value
	Entity
	EntityResult
	Query
	KindExpression
	PropertyReference
	Projection
	PropertyOrder
	Filter
	CompositeFilter
	PropertyFilter
	GqlQuery
	GqlQueryParameter
	QueryResultBatch
*/
package google_datastore_v1 // import "google.golang.org/genproto/googleapis/datastore/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The modes available for commits.
type CommitRequest_Mode int32

const (
	// Unspecified. This value must not be used.
	CommitRequest_MODE_UNSPECIFIED CommitRequest_Mode = 0
	// Transactional: The mutations are either all applied, or none are applied.
	// Learn about transactions [here](https://cloud.google.com/datastore/docs/concepts/transactions).
	CommitRequest_TRANSACTIONAL CommitRequest_Mode = 1
	// Non-transactional: The mutations may not apply as all or none.
	CommitRequest_NON_TRANSACTIONAL CommitRequest_Mode = 2
)

var CommitRequest_Mode_name = map[int32]string{
	0: "MODE_UNSPECIFIED",
	1: "TRANSACTIONAL",
	2: "NON_TRANSACTIONAL",
}
var CommitRequest_Mode_value = map[string]int32{
	"MODE_UNSPECIFIED":  0,
	"TRANSACTIONAL":     1,
	"NON_TRANSACTIONAL": 2,
}

func (x CommitRequest_Mode) String() string {
	return proto.EnumName(CommitRequest_Mode_name, int32(x))
}
func (CommitRequest_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8, 0} }

// The possible values for read consistencies.
type ReadOptions_ReadConsistency int32

const (
	// Unspecified. This value must not be used.
	ReadOptions_READ_CONSISTENCY_UNSPECIFIED ReadOptions_ReadConsistency = 0
	// Strong consistency.
	ReadOptions_STRONG ReadOptions_ReadConsistency = 1
	// Eventual consistency.
	ReadOptions_EVENTUAL ReadOptions_ReadConsistency = 2
)

var ReadOptions_ReadConsistency_name = map[int32]string{
	0: "READ_CONSISTENCY_UNSPECIFIED",
	1: "STRONG",
	2: "EVENTUAL",
}
var ReadOptions_ReadConsistency_value = map[string]int32{
	"READ_CONSISTENCY_UNSPECIFIED": 0,
	"STRONG":                       1,
	"EVENTUAL":                     2,
}

func (x ReadOptions_ReadConsistency) String() string {
	return proto.EnumName(ReadOptions_ReadConsistency_name, int32(x))
}
func (ReadOptions_ReadConsistency) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{14, 0}
}

// The request for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The options for this lookup request.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions" json:"read_options,omitempty"`
	// Keys of entities to look up.
	Keys []*Key `protobuf:"bytes,3,rep,name=keys" json:"keys,omitempty"`
}

func (m *LookupRequest) Reset()                    { *m = LookupRequest{} }
func (m *LookupRequest) String() string            { return proto.CompactTextString(m) }
func (*LookupRequest) ProtoMessage()               {}
func (*LookupRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *LookupRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *LookupRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
type LookupResponse struct {
	// Entities found as `ResultType.FULL` entities. The order of results in this
	// field is undefined and has no relation to the order of the keys in the
	// input.
	Found []*EntityResult `protobuf:"bytes,1,rep,name=found" json:"found,omitempty"`
	// Entities not found as `ResultType.KEY_ONLY` entities. The order of results
	// in this field is undefined and has no relation to the order of the keys
	// in the input.
	Missing []*EntityResult `protobuf:"bytes,2,rep,name=missing" json:"missing,omitempty"`
	// A list of keys that were not looked up due to resource constraints. The
	// order of results in this field is undefined and has no relation to the
	// order of the keys in the input.
	Deferred []*Key `protobuf:"bytes,3,rep,name=deferred" json:"deferred,omitempty"`
}

func (m *LookupResponse) Reset()                    { *m = LookupResponse{} }
func (m *LookupResponse) String() string            { return proto.CompactTextString(m) }
func (*LookupResponse) ProtoMessage()               {}
func (*LookupResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *LookupResponse) GetFound() []*EntityResult {
	if m != nil {
		return m.Found
	}
	return nil
}

func (m *LookupResponse) GetMissing() []*EntityResult {
	if m != nil {
		return m.Missing
	}
	return nil
}

func (m *LookupResponse) GetDeferred() []*Key {
	if m != nil {
		return m.Deferred
	}
	return nil
}

// The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// Entities are partitioned into subsets, identified by a partition ID.
	// Queries are scoped to a single partition.
	// This partition ID is normalized with the standard default context
	// partition ID.
	PartitionId *PartitionId `protobuf:"bytes,2,opt,name=partition_id,json=partitionId" json:"partition_id,omitempty"`
	// The options for this query.
	ReadOptions *ReadOptions `protobuf:"bytes,1,opt,name=read_options,json=readOptions" json:"read_options,omitempty"`
	// The type of query.
	//
	// Types that are valid to be assigned to QueryType:
	//	*RunQueryRequest_Query
	//	*RunQueryRequest_GqlQuery
	QueryType isRunQueryRequest_QueryType `protobuf_oneof:"query_type"`
}

func (m *RunQueryRequest) Reset()                    { *m = RunQueryRequest{} }
func (m *RunQueryRequest) String() string            { return proto.CompactTextString(m) }
func (*RunQueryRequest) ProtoMessage()               {}
func (*RunQueryRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isRunQueryRequest_QueryType interface {
	isRunQueryRequest_QueryType()
}

type RunQueryRequest_Query struct {
	Query *Query `protobuf:"bytes,3,opt,name=query,oneof"`
}
type RunQueryRequest_GqlQuery struct {
	GqlQuery *GqlQuery `protobuf:"bytes,7,opt,name=gql_query,json=gqlQuery,oneof"`
}

func (*RunQueryRequest_Query) isRunQueryRequest_QueryType()    {}
func (*RunQueryRequest_GqlQuery) isRunQueryRequest_QueryType() {}

func (m *RunQueryRequest) GetQueryType() isRunQueryRequest_QueryType {
	if m != nil {
		return m.QueryType
	}
	return nil
}

func (m *RunQueryRequest) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *RunQueryRequest) GetReadOptions() *ReadOptions {
	if m != nil {
		return m.ReadOptions
	}
	return nil
}

func (m *RunQueryRequest) GetQuery() *Query {
	if x, ok := m.GetQueryType().(*RunQueryRequest_Query); ok {
		return x.Query
	}
	return nil
}

func (m *RunQueryRequest) GetGqlQuery() *GqlQuery {
	if x, ok := m.GetQueryType().(*RunQueryRequest_GqlQuery); ok {
		return x.GqlQuery
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RunQueryRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RunQueryRequest_OneofMarshaler, _RunQueryRequest_OneofUnmarshaler, _RunQueryRequest_OneofSizer, []interface{}{
		(*RunQueryRequest_Query)(nil),
		(*RunQueryRequest_GqlQuery)(nil),
	}
}

func _RunQueryRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Query); err != nil {
			return err
		}
	case *RunQueryRequest_GqlQuery:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GqlQuery); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RunQueryRequest.QueryType has unexpected type %T", x)
	}
	return nil
}

func _RunQueryRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RunQueryRequest)
	switch tag {
	case 3: // query_type.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Query)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_Query{msg}
		return true, err
	case 7: // query_type.gql_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GqlQuery)
		err := b.DecodeMessage(msg)
		m.QueryType = &RunQueryRequest_GqlQuery{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RunQueryRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RunQueryRequest)
	// query_type
	switch x := m.QueryType.(type) {
	case *RunQueryRequest_Query:
		s := proto.Size(x.Query)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RunQueryRequest_GqlQuery:
		s := proto.Size(x.GqlQuery)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
type RunQueryResponse struct {
	// A batch of query results (always present).
	Batch *QueryResultBatch `protobuf:"bytes,1,opt,name=batch" json:"batch,omitempty"`
	// The parsed form of the `GqlQuery` from the request, if it was set.
	Query *Query `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
}

func (m *RunQueryResponse) Reset()                    { *m = RunQueryResponse{} }
func (m *RunQueryResponse) String() string            { return proto.CompactTextString(m) }
func (*RunQueryResponse) ProtoMessage()               {}
func (*RunQueryResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *RunQueryResponse) GetBatch() *QueryResultBatch {
	if m != nil {
		return m.Batch
	}
	return nil
}

func (m *RunQueryResponse) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

// The request for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// The response for [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
type BeginTransactionResponse struct {
	// The transaction identifier (always present).
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *BeginTransactionResponse) Reset()                    { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()               {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// The request for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
type RollbackRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The transaction identifier, returned by a call to
	// [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (m *RollbackRequest) Reset()                    { *m = RollbackRequest{} }
func (m *RollbackRequest) String() string            { return proto.CompactTextString(m) }
func (*RollbackRequest) ProtoMessage()               {}
func (*RollbackRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// The response for [Datastore.Rollback][google.datastore.v1.Datastore.Rollback].
// (an empty message).
type RollbackResponse struct {
}

func (m *RollbackResponse) Reset()                    { *m = RollbackResponse{} }
func (m *RollbackResponse) String() string            { return proto.CompactTextString(m) }
func (*RollbackResponse) ProtoMessage()               {}
func (*RollbackResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The type of commit to perform. Defaults to `TRANSACTIONAL`.
	Mode CommitRequest_Mode `protobuf:"varint,5,opt,name=mode,enum=google.datastore.v1.CommitRequest_Mode" json:"mode,omitempty"`
	// Must be set when mode is `TRANSACTIONAL`.
	//
	// Types that are valid to be assigned to TransactionSelector:
	//	*CommitRequest_Transaction
	TransactionSelector isCommitRequest_TransactionSelector `protobuf_oneof:"transaction_selector"`
	// The mutations to perform.
	//
	// When mode is `TRANSACTIONAL`, mutations affecting a single entity are
	// applied in order. The following sequences of mutations affecting a single
	// entity are not permitted in a single `Commit` request:
	//
	// - `insert` followed by `insert`
	// - `update` followed by `insert`
	// - `upsert` followed by `insert`
	// - `delete` followed by `update`
	//
	// When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
	// entity.
	Mutations []*Mutation `protobuf:"bytes,6,rep,name=mutations" json:"mutations,omitempty"`
}

func (m *CommitRequest) Reset()                    { *m = CommitRequest{} }
func (m *CommitRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitRequest) ProtoMessage()               {}
func (*CommitRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isCommitRequest_TransactionSelector interface {
	isCommitRequest_TransactionSelector()
}

type CommitRequest_Transaction struct {
	Transaction []byte `protobuf:"bytes,1,opt,name=transaction,proto3,oneof"`
}

func (*CommitRequest_Transaction) isCommitRequest_TransactionSelector() {}

func (m *CommitRequest) GetTransactionSelector() isCommitRequest_TransactionSelector {
	if m != nil {
		return m.TransactionSelector
	}
	return nil
}

func (m *CommitRequest) GetTransaction() []byte {
	if x, ok := m.GetTransactionSelector().(*CommitRequest_Transaction); ok {
		return x.Transaction
	}
	return nil
}

func (m *CommitRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommitRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommitRequest_OneofMarshaler, _CommitRequest_OneofUnmarshaler, _CommitRequest_OneofSizer, []interface{}{
		(*CommitRequest_Transaction)(nil),
	}
}

func _CommitRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("CommitRequest.TransactionSelector has unexpected type %T", x)
	}
	return nil
}

func _CommitRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommitRequest)
	switch tag {
	case 1: // transaction_selector.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.TransactionSelector = &CommitRequest_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _CommitRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommitRequest)
	// transaction_selector
	switch x := m.TransactionSelector.(type) {
	case *CommitRequest_Transaction:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
type CommitResponse struct {
	// The result of performing the mutations.
	// The i-th mutation result corresponds to the i-th mutation in the request.
	MutationResults []*MutationResult `protobuf:"bytes,3,rep,name=mutation_results,json=mutationResults" json:"mutation_results,omitempty"`
	// The number of index entries updated during the commit, or zero if none were
	// updated.
	IndexUpdates int32 `protobuf:"varint,4,opt,name=index_updates,json=indexUpdates" json:"index_updates,omitempty"`
}

func (m *CommitResponse) Reset()                    { *m = CommitResponse{} }
func (m *CommitResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitResponse) ProtoMessage()               {}
func (*CommitResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *CommitResponse) GetMutationResults() []*MutationResult {
	if m != nil {
		return m.MutationResults
	}
	return nil
}

// The request for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsRequest struct {
	// The ID of the project against which to make the request.
	ProjectId string `protobuf:"bytes,8,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// A list of keys with incomplete key paths for which to allocate IDs.
	// No key may be reserved/read-only.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *AllocateIdsRequest) Reset()                    { *m = AllocateIdsRequest{} }
func (m *AllocateIdsRequest) String() string            { return proto.CompactTextString(m) }
func (*AllocateIdsRequest) ProtoMessage()               {}
func (*AllocateIdsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *AllocateIdsRequest) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// The response for [Datastore.AllocateIds][google.datastore.v1.Datastore.AllocateIds].
type AllocateIdsResponse struct {
	// The keys specified in the request (in the same order), each with
	// its key path completed with a newly allocated ID.
	Keys []*Key `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *AllocateIdsResponse) Reset()                    { *m = AllocateIdsResponse{} }
func (m *AllocateIdsResponse) String() string            { return proto.CompactTextString(m) }
func (*AllocateIdsResponse) ProtoMessage()               {}
func (*AllocateIdsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *AllocateIdsResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

// A mutation to apply to an entity.
type Mutation struct {
	// The mutation operation.
	//
	// For `insert`, `update`, and `upsert`:
	// - The entity's key must not be reserved/read-only.
	// - No property in the entity may have a reserved name,
	//   not even a property in an entity in a value.
	// - No value in the entity may have meaning 18,
	//   not even a value in an entity in another value.
	//
	// Types that are valid to be assigned to Operation:
	//	*Mutation_Insert
	//	*Mutation_Update
	//	*Mutation_Upsert
	//	*Mutation_Delete
	Operation isMutation_Operation `protobuf_oneof:"operation"`
	// When set, the server will detect whether or not this mutation conflicts
	// with the current version of the entity on the server. Conflicting mutations
	// are not applied, and are marked as such in MutationResult.
	//
	// Types that are valid to be assigned to ConflictDetectionStrategy:
	//	*Mutation_BaseVersion
	ConflictDetectionStrategy isMutation_ConflictDetectionStrategy `protobuf_oneof:"conflict_detection_strategy"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

type isMutation_Operation interface {
	isMutation_Operation()
}
type isMutation_ConflictDetectionStrategy interface {
	isMutation_ConflictDetectionStrategy()
}

type Mutation_Insert struct {
	Insert *Entity `protobuf:"bytes,4,opt,name=insert,oneof"`
}
type Mutation_Update struct {
	Update *Entity `protobuf:"bytes,5,opt,name=update,oneof"`
}
type Mutation_Upsert struct {
	Upsert *Entity `protobuf:"bytes,6,opt,name=upsert,oneof"`
}
type Mutation_Delete struct {
	Delete *Key `protobuf:"bytes,7,opt,name=delete,oneof"`
}
type Mutation_BaseVersion struct {
	BaseVersion int64 `protobuf:"varint,8,opt,name=base_version,json=baseVersion,oneof"`
}

func (*Mutation_Insert) isMutation_Operation()                      {}
func (*Mutation_Update) isMutation_Operation()                      {}
func (*Mutation_Upsert) isMutation_Operation()                      {}
func (*Mutation_Delete) isMutation_Operation()                      {}
func (*Mutation_BaseVersion) isMutation_ConflictDetectionStrategy() {}

func (m *Mutation) GetOperation() isMutation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}
func (m *Mutation) GetConflictDetectionStrategy() isMutation_ConflictDetectionStrategy {
	if m != nil {
		return m.ConflictDetectionStrategy
	}
	return nil
}

func (m *Mutation) GetInsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Insert); ok {
		return x.Insert
	}
	return nil
}

func (m *Mutation) GetUpdate() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *Mutation) GetUpsert() *Entity {
	if x, ok := m.GetOperation().(*Mutation_Upsert); ok {
		return x.Upsert
	}
	return nil
}

func (m *Mutation) GetDelete() *Key {
	if x, ok := m.GetOperation().(*Mutation_Delete); ok {
		return x.Delete
	}
	return nil
}

func (m *Mutation) GetBaseVersion() int64 {
	if x, ok := m.GetConflictDetectionStrategy().(*Mutation_BaseVersion); ok {
		return x.BaseVersion
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_Insert)(nil),
		(*Mutation_Update)(nil),
		(*Mutation_Upsert)(nil),
		(*Mutation_Delete)(nil),
		(*Mutation_BaseVersion)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Insert); err != nil {
			return err
		}
	case *Mutation_Update:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *Mutation_Upsert:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Upsert); err != nil {
			return err
		}
	case *Mutation_Delete:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delete); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Operation has unexpected type %T", x)
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		return fmt.Errorf("Mutation.ConflictDetectionStrategy has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 4: // operation.insert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Insert{msg}
		return true, err
	case 5: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Update{msg}
		return true, err
	case 6: // operation.upsert
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Entity)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Upsert{msg}
		return true, err
	case 7: // operation.delete
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Key)
		err := b.DecodeMessage(msg)
		m.Operation = &Mutation_Delete{msg}
		return true, err
	case 8: // conflict_detection_strategy.base_version
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConflictDetectionStrategy = &Mutation_BaseVersion{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// operation
	switch x := m.Operation.(type) {
	case *Mutation_Insert:
		s := proto.Size(x.Insert)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Update:
		s := proto.Size(x.Update)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Upsert:
		s := proto.Size(x.Upsert)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_Delete:
		s := proto.Size(x.Delete)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// conflict_detection_strategy
	switch x := m.ConflictDetectionStrategy.(type) {
	case *Mutation_BaseVersion:
		n += proto.SizeVarint(8<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.BaseVersion))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The result of applying a mutation.
type MutationResult struct {
	// The automatically allocated key.
	// Set only when the mutation allocated a key.
	Key *Key `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
	// The version of the entity on the server after processing the mutation. If
	// the mutation doesn't change anything on the server, then the version will
	// be the version of the current entity or, if no entity is present, a version
	// that is strictly greater than the version of any previous entity and less
	// than the version of any possible future entity.
	Version int64 `protobuf:"varint,4,opt,name=version" json:"version,omitempty"`
	// Whether a conflict was detected for this mutation. Always false when a
	// conflict detection strategy field is not set in the mutation.
	ConflictDetected bool `protobuf:"varint,5,opt,name=conflict_detected,json=conflictDetected" json:"conflict_detected,omitempty"`
}

func (m *MutationResult) Reset()                    { *m = MutationResult{} }
func (m *MutationResult) String() string            { return proto.CompactTextString(m) }
func (*MutationResult) ProtoMessage()               {}
func (*MutationResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *MutationResult) GetKey() *Key {
	if m != nil {
		return m.Key
	}
	return nil
}

// The options shared by read requests.
type ReadOptions struct {
	// If not specified, lookups and ancestor queries default to
	// `read_consistency`=`STRONG`, global queries default to
	// `read_consistency`=`EVENTUAL`.
	//
	// Types that are valid to be assigned to ConsistencyType:
	//	*ReadOptions_ReadConsistency_
	//	*ReadOptions_Transaction
	ConsistencyType isReadOptions_ConsistencyType `protobuf_oneof:"consistency_type"`
}

func (m *ReadOptions) Reset()                    { *m = ReadOptions{} }
func (m *ReadOptions) String() string            { return proto.CompactTextString(m) }
func (*ReadOptions) ProtoMessage()               {}
func (*ReadOptions) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

type isReadOptions_ConsistencyType interface {
	isReadOptions_ConsistencyType()
}

type ReadOptions_ReadConsistency_ struct {
	ReadConsistency ReadOptions_ReadConsistency `protobuf:"varint,1,opt,name=read_consistency,json=readConsistency,enum=google.datastore.v1.ReadOptions_ReadConsistency,oneof"`
}
type ReadOptions_Transaction struct {
	Transaction []byte `protobuf:"bytes,2,opt,name=transaction,proto3,oneof"`
}

func (*ReadOptions_ReadConsistency_) isReadOptions_ConsistencyType() {}
func (*ReadOptions_Transaction) isReadOptions_ConsistencyType()      {}

func (m *ReadOptions) GetConsistencyType() isReadOptions_ConsistencyType {
	if m != nil {
		return m.ConsistencyType
	}
	return nil
}

func (m *ReadOptions) GetReadConsistency() ReadOptions_ReadConsistency {
	if x, ok := m.GetConsistencyType().(*ReadOptions_ReadConsistency_); ok {
		return x.ReadConsistency
	}
	return ReadOptions_READ_CONSISTENCY_UNSPECIFIED
}

func (m *ReadOptions) GetTransaction() []byte {
	if x, ok := m.GetConsistencyType().(*ReadOptions_Transaction); ok {
		return x.Transaction
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadOptions) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadOptions_OneofMarshaler, _ReadOptions_OneofUnmarshaler, _ReadOptions_OneofSizer, []interface{}{
		(*ReadOptions_ReadConsistency_)(nil),
		(*ReadOptions_Transaction)(nil),
	}
}

func _ReadOptions_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Transaction)
	case nil:
	default:
		return fmt.Errorf("ReadOptions.ConsistencyType has unexpected type %T", x)
	}
	return nil
}

func _ReadOptions_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadOptions)
	switch tag {
	case 1: // consistency_type.read_consistency
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConsistencyType = &ReadOptions_ReadConsistency_{ReadOptions_ReadConsistency(x)}
		return true, err
	case 2: // consistency_type.transaction
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConsistencyType = &ReadOptions_Transaction{x}
		return true, err
	default:
		return false, nil
	}
}

func _ReadOptions_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadOptions)
	// consistency_type
	switch x := m.ConsistencyType.(type) {
	case *ReadOptions_ReadConsistency_:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.ReadConsistency))
	case *ReadOptions_Transaction:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Transaction)))
		n += len(x.Transaction)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*LookupRequest)(nil), "google.datastore.v1.LookupRequest")
	proto.RegisterType((*LookupResponse)(nil), "google.datastore.v1.LookupResponse")
	proto.RegisterType((*RunQueryRequest)(nil), "google.datastore.v1.RunQueryRequest")
	proto.RegisterType((*RunQueryResponse)(nil), "google.datastore.v1.RunQueryResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "google.datastore.v1.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "google.datastore.v1.BeginTransactionResponse")
	proto.RegisterType((*RollbackRequest)(nil), "google.datastore.v1.RollbackRequest")
	proto.RegisterType((*RollbackResponse)(nil), "google.datastore.v1.RollbackResponse")
	proto.RegisterType((*CommitRequest)(nil), "google.datastore.v1.CommitRequest")
	proto.RegisterType((*CommitResponse)(nil), "google.datastore.v1.CommitResponse")
	proto.RegisterType((*AllocateIdsRequest)(nil), "google.datastore.v1.AllocateIdsRequest")
	proto.RegisterType((*AllocateIdsResponse)(nil), "google.datastore.v1.AllocateIdsResponse")
	proto.RegisterType((*Mutation)(nil), "google.datastore.v1.Mutation")
	proto.RegisterType((*MutationResult)(nil), "google.datastore.v1.MutationResult")
	proto.RegisterType((*ReadOptions)(nil), "google.datastore.v1.ReadOptions")
	proto.RegisterEnum("google.datastore.v1.CommitRequest_Mode", CommitRequest_Mode_name, CommitRequest_Mode_value)
	proto.RegisterEnum("google.datastore.v1.ReadOptions_ReadConsistency", ReadOptions_ReadConsistency_name, ReadOptions_ReadConsistency_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Datastore service

type DatastoreClient interface {
	// Looks up entities by key.
	Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error)
}

type datastoreClient struct {
	cc *grpc.ClientConn
}

func NewDatastoreClient(cc *grpc.ClientConn) DatastoreClient {
	return &datastoreClient{cc}
}

func (c *datastoreClient) Lookup(ctx context.Context, in *LookupRequest, opts ...grpc.CallOption) (*LookupResponse, error) {
	out := new(LookupResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Lookup", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) RunQuery(ctx context.Context, in *RunQueryRequest, opts ...grpc.CallOption) (*RunQueryResponse, error) {
	out := new(RunQueryResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/RunQuery", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) BeginTransaction(ctx context.Context, in *BeginTransactionRequest, opts ...grpc.CallOption) (*BeginTransactionResponse, error) {
	out := new(BeginTransactionResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/BeginTransaction", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Commit(ctx context.Context, in *CommitRequest, opts ...grpc.CallOption) (*CommitResponse, error) {
	out := new(CommitResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Commit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) Rollback(ctx context.Context, in *RollbackRequest, opts ...grpc.CallOption) (*RollbackResponse, error) {
	out := new(RollbackResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/Rollback", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreClient) AllocateIds(ctx context.Context, in *AllocateIdsRequest, opts ...grpc.CallOption) (*AllocateIdsResponse, error) {
	out := new(AllocateIdsResponse)
	err := grpc.Invoke(ctx, "/google.datastore.v1.Datastore/AllocateIds", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Datastore service

type DatastoreServer interface {
	// Looks up entities by key.
	Lookup(context.Context, *LookupRequest) (*LookupResponse, error)
	// Queries for entities.
	RunQuery(context.Context, *RunQueryRequest) (*RunQueryResponse, error)
	// Begins a new transaction.
	BeginTransaction(context.Context, *BeginTransactionRequest) (*BeginTransactionResponse, error)
	// Commits a transaction, optionally creating, deleting or modifying some
	// entities.
	Commit(context.Context, *CommitRequest) (*CommitResponse, error)
	// Rolls back a transaction.
	Rollback(context.Context, *RollbackRequest) (*RollbackResponse, error)
	// Allocates IDs for the given keys, which is useful for referencing an entity
	// before it is inserted.
	AllocateIds(context.Context, *AllocateIdsRequest) (*AllocateIdsResponse, error)
}

func RegisterDatastoreServer(s *grpc.Server, srv DatastoreServer) {
	s.RegisterService(&_Datastore_serviceDesc, srv)
}

func _Datastore_Lookup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Lookup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Lookup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Lookup(ctx, req.(*LookupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_RunQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).RunQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/RunQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).RunQuery(ctx, req.(*RunQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_BeginTransaction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BeginTransactionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).BeginTransaction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/BeginTransaction",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).BeginTransaction(ctx, req.(*BeginTransactionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Commit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Commit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Commit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Commit(ctx, req.(*CommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_Rollback_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RollbackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).Rollback(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/Rollback",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).Rollback(ctx, req.(*RollbackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Datastore_AllocateIds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AllocateIdsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreServer).AllocateIds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.v1.Datastore/AllocateIds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreServer).AllocateIds(ctx, req.(*AllocateIdsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Datastore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.v1.Datastore",
	HandlerType: (*DatastoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Lookup",
			Handler:    _Datastore_Lookup_Handler,
		},
		{
			MethodName: "RunQuery",
			Handler:    _Datastore_RunQuery_Handler,
		},
		{
			MethodName: "BeginTransaction",
			Handler:    _Datastore_BeginTransaction_Handler,
		},
		{
			MethodName: "Commit",
			Handler:    _Datastore_Commit_Handler,
		},
		{
			MethodName: "Rollback",
			Handler:    _Datastore_Rollback_Handler,
		},
		{
			MethodName: "AllocateIds",
			Handler:    _Datastore_AllocateIds_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/datastore/v1/datastore.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/datastore/v1/datastore.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1191 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x57, 0x51, 0x6f, 0xdb, 0x54,
	0x14, 0xae, 0x93, 0x36, 0x4b, 0x4e, 0xd2, 0x34, 0xbb, 0x1b, 0xcc, 0xca, 0x98, 0x14, 0x5c, 0xaa,
	0x45, 0xdd, 0x96, 0x6c, 0x81, 0x09, 0xd4, 0x4e, 0xa0, 0x26, 0xcd, 0xd6, 0x88, 0x35, 0x29, 0xb7,
	0xe9, 0x24, 0x1e, 0x90, 0xe5, 0xda, 0xb7, 0xc6, 0xd4, 0xf1, 0x75, 0xed, 0x9b, 0x8a, 0x08, 0x31,
	0x09, 0x10, 0xfc, 0x00, 0xf8, 0x05, 0xbc, 0xf0, 0xc4, 0x23, 0x4f, 0x88, 0x7f, 0xc1, 0x23, 0xaf,
	0xfc, 0x03, 0xfe, 0x00, 0xf2, 0xf5, 0x75, 0x53, 0x67, 0x4e, 0x63, 0x26, 0xde, 0x72, 0x4f, 0xbe,
	0xef, 0xdc, 0xef, 0x9c, 0x73, 0xef, 0x39, 0xd7, 0xd0, 0x36, 0x29, 0x35, 0x6d, 0xd2, 0x30, 0xa9,
	0xad, 0x39, 0x66, 0x83, 0x7a, 0x66, 0xd3, 0x24, 0x8e, 0xeb, 0x51, 0x46, 0x9b, 0xe1, 0x5f, 0x9a,
	0x6b, 0xf9, 0x4d, 0x43, 0x63, 0x9a, 0xcf, 0xa8, 0x47, 0x9a, 0xe7, 0x8f, 0xa6, 0x8b, 0x06, 0xc7,
	0xa1, 0x1b, 0xc2, 0xc7, 0xd4, 0x7e, 0xfe, 0xa8, 0xda, 0x4b, 0xe7, 0x58, 0x73, 0xad, 0xa6, 0x4f,
	0xbc, 0x73, 0x4b, 0x27, 0x3a, 0x75, 0x4e, 0x2c, 0xb3, 0xa9, 0x39, 0x0e, 0x65, 0x1a, 0xb3, 0xa8,
	0xe3, 0x87, 0xfe, 0xab, 0x1f, 0xbd, 0x86, 0x46, 0xe2, 0x30, 0x8b, 0x4d, 0x84, 0x83, 0x0f, 0x5f,
	0xc3, 0xc1, 0xd9, 0x98, 0x78, 0x82, 0xaf, 0xfc, 0x2c, 0xc1, 0xea, 0x73, 0x4a, 0x4f, 0xc7, 0x2e,
	0x26, 0x67, 0x63, 0xe2, 0x33, 0x74, 0x07, 0xc0, 0xf5, 0xe8, 0x17, 0x44, 0x67, 0xaa, 0x65, 0xc8,
	0xf9, 0x9a, 0x54, 0x2f, 0xe0, 0x82, 0xb0, 0xf4, 0x0c, 0xd4, 0x81, 0x92, 0x47, 0x34, 0x43, 0xa5,
	0x2e, 0x8f, 0x43, 0x96, 0x6a, 0x52, 0xbd, 0xd8, 0xaa, 0x35, 0x12, 0x12, 0xd5, 0xc0, 0x44, 0x33,
	0x06, 0x21, 0x0e, 0x17, 0xbd, 0xe9, 0x02, 0xdd, 0x87, 0xe5, 0x53, 0x32, 0xf1, 0xe5, 0x6c, 0x2d,
	0x5b, 0x2f, 0xb6, 0xe4, 0x44, 0xf2, 0xc7, 0x64, 0x82, 0x39, 0x4a, 0xf9, 0x43, 0x82, 0x72, 0xa4,
	0xd1, 0x77, 0xa9, 0xe3, 0x13, 0xf4, 0x3e, 0xac, 0x9c, 0xd0, 0xb1, 0x63, 0xc8, 0x12, 0xf7, 0xf0,
	0x76, 0xa2, 0x87, 0x2e, 0x4f, 0x14, 0x26, 0xfe, 0xd8, 0x66, 0x38, 0xc4, 0xa3, 0x6d, 0xb8, 0x36,
	0xb2, 0x7c, 0xdf, 0x72, 0x4c, 0x39, 0x93, 0x96, 0x1a, 0x31, 0xd0, 0x7b, 0x90, 0x37, 0xc8, 0x09,
	0xf1, 0x3c, 0x62, 0x2c, 0x94, 0x7e, 0x81, 0x54, 0x7e, 0xcf, 0xc0, 0x1a, 0x1e, 0x3b, 0x9f, 0x04,
	0x59, 0x4f, 0x9f, 0x64, 0x57, 0xf3, 0x98, 0x15, 0x64, 0x2b, 0x00, 0x64, 0xae, 0x48, 0xf2, 0x41,
	0x04, 0xec, 0x19, 0xb8, 0xe8, 0x4e, 0x17, 0xff, 0x4f, 0xa5, 0x5a, 0xb0, 0xc2, 0x8f, 0x8b, 0x9c,
	0xe5, 0xec, 0x6a, 0x22, 0x9b, 0x87, 0xb6, 0xb7, 0x84, 0x43, 0x28, 0x7a, 0x02, 0x05, 0xf3, 0xcc,
	0x56, 0x43, 0xde, 0x35, 0xce, 0xbb, 0x93, 0xc8, 0x7b, 0x76, 0x66, 0x47, 0xd4, 0xbc, 0x29, 0x7e,
	0xb7, 0x4b, 0x00, 0x9c, 0xa9, 0xb2, 0x89, 0x4b, 0x94, 0x6f, 0x24, 0xa8, 0x4c, 0x93, 0x27, 0xaa,
	0xbf, 0x0d, 0x2b, 0xc7, 0x1a, 0xd3, 0x3f, 0x17, 0x21, 0x6d, 0xcc, 0x17, 0x15, 0x56, 0xb0, 0x1d,
	0x80, 0x71, 0xc8, 0x41, 0x0f, 0xa3, 0x88, 0x32, 0x8b, 0x22, 0x12, 0xf1, 0x28, 0x1f, 0xc0, 0xad,
	0x36, 0x31, 0x2d, 0x67, 0xe8, 0x69, 0x8e, 0xaf, 0xe9, 0x41, 0x62, 0xd2, 0xd5, 0x51, 0x79, 0x02,
	0xf2, 0xab, 0x4c, 0x11, 0x44, 0x0d, 0x8a, 0x6c, 0x6a, 0xe6, 0xa1, 0x94, 0xf0, 0x65, 0x93, 0x82,
	0x61, 0x0d, 0x53, 0xdb, 0x3e, 0xd6, 0xf4, 0xd3, 0x94, 0xe7, 0x66, 0xb1, 0x4f, 0x04, 0x95, 0xa9,
	0xcf, 0x50, 0x89, 0xf2, 0x6b, 0x06, 0x56, 0x3b, 0x74, 0x34, 0xb2, 0x58, 0xca, 0x6d, 0xb6, 0x61,
	0x79, 0x44, 0x0d, 0x22, 0xaf, 0xd4, 0xa4, 0x7a, 0xb9, 0x75, 0x37, 0x31, 0x83, 0x31, 0x87, 0x8d,
	0x7d, 0x6a, 0x10, 0xcc, 0x49, 0x48, 0x49, 0xd0, 0xb8, 0xb7, 0x14, 0x53, 0x89, 0xb6, 0xa1, 0x30,
	0x1a, 0x8b, 0x4e, 0x29, 0xe7, 0xf8, 0x4d, 0x4b, 0x3e, 0x41, 0xfb, 0x02, 0x85, 0xa7, 0x78, 0xe5,
	0x29, 0x2c, 0x07, 0xdb, 0xa1, 0x9b, 0x50, 0xd9, 0x1f, 0xec, 0x76, 0xd5, 0xa3, 0xfe, 0xe1, 0x41,
	0xb7, 0xd3, 0x7b, 0xda, 0xeb, 0xee, 0x56, 0x96, 0xd0, 0x75, 0x58, 0x1d, 0xe2, 0x9d, 0xfe, 0xe1,
	0x4e, 0x67, 0xd8, 0x1b, 0xf4, 0x77, 0x9e, 0x57, 0x24, 0xf4, 0x06, 0x5c, 0xef, 0x0f, 0xfa, 0x6a,
	0xdc, 0x9c, 0x69, 0xbf, 0x09, 0x37, 0x2f, 0x69, 0x52, 0x7d, 0x62, 0x13, 0x9d, 0x51, 0x4f, 0xf9,
	0x5e, 0x82, 0x72, 0x14, 0x9d, 0xa8, 0x65, 0x1f, 0x2a, 0xd1, 0xfe, 0xaa, 0xc7, 0x8f, 0x5c, 0xd4,
	0xdb, 0xd6, 0xaf, 0x96, 0x1d, 0x36, 0x98, 0xb5, 0x51, 0x6c, 0xed, 0xa3, 0x75, 0x58, 0xb5, 0x1c,
	0x83, 0x7c, 0xa9, 0x8e, 0x5d, 0x43, 0x63, 0xc4, 0x97, 0x97, 0x6b, 0x52, 0x7d, 0x05, 0x97, 0xb8,
	0xf1, 0x28, 0xb4, 0x29, 0x1a, 0xa0, 0x1d, 0xdb, 0xa6, 0xba, 0xc6, 0x48, 0xcf, 0xf0, 0x53, 0x96,
	0x2e, 0xea, 0xbc, 0x52, 0xaa, 0xce, 0xdb, 0x81, 0x1b, 0xb1, 0x2d, 0x44, 0xb8, 0xff, 0xcd, 0xc9,
	0x6f, 0x19, 0xc8, 0x47, 0x01, 0xa3, 0xc7, 0x90, 0xb3, 0x1c, 0x9f, 0x78, 0x8c, 0x87, 0x54, 0x6c,
	0xdd, 0xbe, 0xa2, 0xfd, 0xee, 0x2d, 0x61, 0x01, 0x0e, 0x68, 0x61, 0x2a, 0xf8, 0x99, 0x5b, 0x4c,
	0x0b, 0xc1, 0x21, 0x8d, 0xef, 0x96, 0x4b, 0x49, 0xe3, 0xbb, 0xb5, 0x20, 0x67, 0x10, 0x9b, 0x30,
	0x22, 0xba, 0xd7, 0xdc, 0x08, 0x03, 0x4e, 0x88, 0x44, 0xeb, 0x50, 0x3a, 0xd6, 0x7c, 0xa2, 0x9e,
	0x13, 0xcf, 0x0f, 0xce, 0x75, 0x90, 0xf9, 0xec, 0x9e, 0x84, 0x8b, 0x81, 0xf5, 0x45, 0x68, 0x6c,
	0x17, 0xa1, 0x40, 0x5d, 0xe2, 0xf1, 0x54, 0xb4, 0xef, 0xc0, 0xed, 0xe0, 0x5d, 0x60, 0x5b, 0x3a,
	0x53, 0x0d, 0xc2, 0x88, 0x38, 0x66, 0xcc, 0xd3, 0x18, 0x31, 0x27, 0xca, 0x77, 0x12, 0x94, 0xe3,
	0xe7, 0x04, 0x6d, 0x42, 0xf6, 0x94, 0x44, 0xad, 0x78, 0x7e, 0xda, 0x03, 0x10, 0x92, 0xe1, 0x5a,
	0x24, 0x25, 0xc8, 0x74, 0x16, 0x47, 0x4b, 0x74, 0x0f, 0xae, 0xcf, 0xec, 0x4b, 0x0c, 0x9e, 0xd6,
	0x3c, 0xae, 0x44, 0x7f, 0xec, 0x0a, 0xbb, 0xf2, 0x8f, 0x04, 0xc5, 0x4b, 0xc3, 0x01, 0x7d, 0x06,
	0x15, 0x3e, 0x54, 0x74, 0xea, 0xf8, 0x96, 0xcf, 0x88, 0xa3, 0x4f, 0xf8, 0x15, 0x2e, 0xb7, 0x1e,
	0x2e, 0x1a, 0x2c, 0xfc, 0x77, 0x67, 0xca, 0xdb, 0x5b, 0xc2, 0x6b, 0x5e, 0xdc, 0x34, 0xdb, 0x1c,
	0x32, 0x09, 0xcd, 0x41, 0xd9, 0x87, 0xb5, 0x19, 0x4f, 0xa8, 0x06, 0x6f, 0xe1, 0xee, 0xce, 0xae,
	0xda, 0x19, 0xf4, 0x0f, 0x7b, 0x87, 0xc3, 0x6e, 0xbf, 0xf3, 0xe9, 0xcc, 0xb5, 0x07, 0xc8, 0x1d,
	0x0e, 0xf1, 0xa0, 0xff, 0xac, 0x22, 0xa1, 0x12, 0xe4, 0xbb, 0x2f, 0xba, 0xfd, 0xe1, 0x11, 0xbf,
	0xe6, 0x08, 0x2a, 0x97, 0x82, 0xe1, 0x53, 0xa7, 0xf5, 0x57, 0x0e, 0x0a, 0xbb, 0x51, 0x18, 0xe8,
	0x25, 0xe4, 0xc2, 0xe7, 0x07, 0x52, 0x12, 0x63, 0x8c, 0xbd, 0x9f, 0xaa, 0xeb, 0x57, 0x62, 0x44,
	0xcb, 0xbd, 0xf7, 0xed, 0x9f, 0x7f, 0xff, 0x94, 0xd9, 0x50, 0x6a, 0xc1, 0x7b, 0x4c, 0xdc, 0x4e,
	0xbf, 0xf9, 0xd5, 0xf4, 0xe6, 0x7e, 0xbd, 0x65, 0x73, 0xc6, 0x96, 0xb4, 0x89, 0x7e, 0x90, 0x20,
	0x1f, 0xcd, 0x40, 0xf4, 0x4e, 0x72, 0x9a, 0xe3, 0xef, 0x8b, 0xea, 0xc6, 0x02, 0x94, 0x90, 0xf1,
	0x80, 0xcb, 0xb8, 0xab, 0x28, 0xf3, 0x65, 0x78, 0x82, 0x13, 0x08, 0xf9, 0x45, 0x82, 0xca, 0xec,
	0x3c, 0x43, 0xf7, 0x13, 0xb7, 0x9a, 0x33, 0x30, 0xab, 0x0f, 0x52, 0xa2, 0x85, 0xc0, 0xc7, 0x5c,
	0x60, 0x53, 0xd9, 0x9c, 0x2f, 0xf0, 0x78, 0x86, 0x1b, 0x08, 0x7d, 0x09, 0xb9, 0xb0, 0x43, 0xcf,
	0xa9, 0x58, 0x6c, 0x38, 0xcd, 0xa9, 0x58, 0xbc, 0xc5, 0xa7, 0xa9, 0x98, 0xce, 0x19, 0x17, 0x15,
	0x13, 0x63, 0x76, 0x5e, 0xc5, 0xe2, 0x93, 0x7d, 0x5e, 0xc5, 0x66, 0x67, 0x75, 0x9a, 0x8a, 0x09,
	0x4e, 0x20, 0xe4, 0x47, 0x09, 0x8a, 0x97, 0x3a, 0x38, 0x4a, 0x9e, 0xd5, 0xaf, 0x8e, 0x91, 0x6a,
	0x7d, 0x31, 0x50, 0x28, 0x7a, 0xc8, 0x15, 0x6d, 0x2a, 0x1b, 0xf3, 0x15, 0x69, 0x53, 0xda, 0x96,
	0xb4, 0xd9, 0xbe, 0x07, 0xb7, 0x74, 0x3a, 0x4a, 0xda, 0xa0, 0x5d, 0xbe, 0xb8, 0x75, 0x07, 0xc1,
	0xe7, 0xc9, 0x81, 0x74, 0x9c, 0xe3, 0xdf, 0x29, 0xef, 0xfe, 0x1b, 0x00, 0x00, 0xff, 0xff, 0xb9,
	0x33, 0xe7, 0xde, 0xce, 0x0d, 0x00, 0x00,
}
