// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/iam/v1/iam_policy.proto
// DO NOT EDIT!

/*
Package google_iam_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/iam/v1/iam_policy.proto
	google.golang.org/genproto/googleapis/iam/v1/policy.proto

It has these top-level messages:
	SetIamPolicyRequest
	GetIamPolicyRequest
	TestIamPermissionsRequest
	TestIamPermissionsResponse
	Policy
	Binding
*/
package google_iam_v1 // import "google.golang.org/genproto/googleapis/iam/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// REQUIRED: The resource for which the policy is being specified.
	// `resource` is usually specified as a path. For example, a Project
	// resource is specified as `projects/{project}`.
	Resource string `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	// REQUIRED: The complete policy to be applied to the `resource`. The size of
	// the policy is limited to a few 10s of KB. An empty policy is a
	// valid policy but certain Cloud Platform services (such as Projects)
	// might reject them.
	Policy *Policy `protobuf:"bytes,2,opt,name=policy" json:"policy,omitempty"`
}

func (m *SetIamPolicyRequest) Reset()                    { *m = SetIamPolicyRequest{} }
func (m *SetIamPolicyRequest) String() string            { return proto.CompactTextString(m) }
func (*SetIamPolicyRequest) ProtoMessage()               {}
func (*SetIamPolicyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *SetIamPolicyRequest) GetPolicy() *Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

// Request message for `GetIamPolicy` method.
type GetIamPolicyRequest struct {
	// REQUIRED: The resource for which the policy is being requested.
	// `resource` is usually specified as a path. For example, a Project
	// resource is specified as `projects/{project}`.
	Resource string `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
}

func (m *GetIamPolicyRequest) Reset()                    { *m = GetIamPolicyRequest{} }
func (m *GetIamPolicyRequest) String() string            { return proto.CompactTextString(m) }
func (*GetIamPolicyRequest) ProtoMessage()               {}
func (*GetIamPolicyRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// REQUIRED: The resource for which the policy detail is being requested.
	// `resource` is usually specified as a path. For example, a Project
	// resource is specified as `projects/{project}`.
	Resource string `protobuf:"bytes,1,opt,name=resource" json:"resource,omitempty"`
	// The set of permissions to check for the `resource`. Permissions with
	// wildcards (such as '*' or 'storage.*') are not allowed. For more
	// information see
	// [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `protobuf:"bytes,2,rep,name=permissions" json:"permissions,omitempty"`
}

func (m *TestIamPermissionsRequest) Reset()                    { *m = TestIamPermissionsRequest{} }
func (m *TestIamPermissionsRequest) String() string            { return proto.CompactTextString(m) }
func (*TestIamPermissionsRequest) ProtoMessage()               {}
func (*TestIamPermissionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Response message for `TestIamPermissions` method.
type TestIamPermissionsResponse struct {
	// A subset of `TestPermissionsRequest.permissions` that the caller is
	// allowed.
	Permissions []string `protobuf:"bytes,1,rep,name=permissions" json:"permissions,omitempty"`
}

func (m *TestIamPermissionsResponse) Reset()                    { *m = TestIamPermissionsResponse{} }
func (m *TestIamPermissionsResponse) String() string            { return proto.CompactTextString(m) }
func (*TestIamPermissionsResponse) ProtoMessage()               {}
func (*TestIamPermissionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func init() {
	proto.RegisterType((*SetIamPolicyRequest)(nil), "google.iam.v1.SetIamPolicyRequest")
	proto.RegisterType((*GetIamPolicyRequest)(nil), "google.iam.v1.GetIamPolicyRequest")
	proto.RegisterType((*TestIamPermissionsRequest)(nil), "google.iam.v1.TestIamPermissionsRequest")
	proto.RegisterType((*TestIamPermissionsResponse)(nil), "google.iam.v1.TestIamPermissionsResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for IAMPolicy service

type IAMPolicyClient interface {
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*TestIamPermissionsResponse, error)
}

type iAMPolicyClient struct {
	cc *grpc.ClientConn
}

func NewIAMPolicyClient(cc *grpc.ClientConn) IAMPolicyClient {
	return &iAMPolicyClient{cc}
}

func (c *iAMPolicyClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := grpc.Invoke(ctx, "/google.iam.v1.IAMPolicy/SetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMPolicyClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := grpc.Invoke(ctx, "/google.iam.v1.IAMPolicy/GetIamPolicy", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMPolicyClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsRequest, opts ...grpc.CallOption) (*TestIamPermissionsResponse, error) {
	out := new(TestIamPermissionsResponse)
	err := grpc.Invoke(ctx, "/google.iam.v1.IAMPolicy/TestIamPermissions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for IAMPolicy service

type IAMPolicyServer interface {
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyRequest) (*Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *GetIamPolicyRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsRequest) (*TestIamPermissionsResponse, error)
}

func RegisterIAMPolicyServer(s *grpc.Server, srv IAMPolicyServer) {
	s.RegisterService(&_IAMPolicy_serviceDesc, srv)
}

func _IAMPolicy_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMPolicyServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1.IAMPolicy/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMPolicyServer).SetIamPolicy(ctx, req.(*SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMPolicy_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMPolicyServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1.IAMPolicy/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMPolicyServer).GetIamPolicy(ctx, req.(*GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMPolicy_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMPolicyServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v1.IAMPolicy/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMPolicyServer).TestIamPermissions(ctx, req.(*TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAMPolicy_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v1.IAMPolicy",
	HandlerType: (*IAMPolicyServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetIamPolicy",
			Handler:    _IAMPolicy_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _IAMPolicy_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _IAMPolicy_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/iam/v1/iam_policy.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/iam/v1/iam_policy.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 375 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x52, 0xcf, 0x4a, 0xc3, 0x30,
	0x18, 0x27, 0x1b, 0x0c, 0x97, 0xa9, 0x60, 0x86, 0x30, 0x7b, 0x90, 0x12, 0x3d, 0x74, 0x05, 0x1b,
	0x36, 0x4f, 0x0e, 0x26, 0xb8, 0xcb, 0xd8, 0x41, 0x18, 0xd3, 0x8b, 0x27, 0x8d, 0x25, 0x86, 0xc0,
	0x9a, 0xd4, 0x26, 0x1b, 0x88, 0x78, 0xf1, 0x15, 0xf4, 0xe4, 0x6b, 0xf9, 0x0a, 0x3e, 0x84, 0x47,
	0x69, 0x3b, 0x67, 0xb7, 0x4e, 0xe9, 0xc0, 0x53, 0x69, 0xf2, 0xfd, 0xfe, 0x7e, 0x81, 0x5d, 0xae,
	0x14, 0x1f, 0x33, 0x8f, 0xab, 0x31, 0x95, 0xdc, 0x53, 0x11, 0x27, 0x9c, 0xc9, 0x30, 0x52, 0x46,
	0x91, 0xf4, 0x8a, 0x86, 0x42, 0x13, 0x41, 0x03, 0x32, 0x6d, 0xc5, 0x9f, 0xeb, 0x50, 0x8d, 0x85,
	0xff, 0xe0, 0x25, 0x23, 0x68, 0x6b, 0x06, 0x17, 0x34, 0xf0, 0xa6, 0x2d, 0x6b, 0x50, 0x8c, 0x8d,
	0x86, 0x82, 0x68, 0x16, 0x4d, 0x85, 0xcf, 0x7c, 0x25, 0xef, 0x04, 0x27, 0x54, 0x4a, 0x65, 0xa8,
	0x11, 0x4a, 0xea, 0x94, 0xd9, 0x3a, 0x59, 0xcb, 0x58, 0xd6, 0x14, 0xbe, 0x81, 0xf5, 0x0b, 0x66,
	0x06, 0x34, 0x18, 0x26, 0xa7, 0x23, 0x76, 0x3f, 0x61, 0xda, 0x20, 0x0b, 0x6e, 0x44, 0x4c, 0xab,
	0x49, 0xe4, 0xb3, 0x06, 0xb0, 0x81, 0x53, 0x1d, 0xcd, 0xff, 0xd1, 0x11, 0xac, 0xa4, 0x14, 0x8d,
	0x92, 0x0d, 0x9c, 0x5a, 0x7b, 0xd7, 0x5b, 0x08, 0xe6, 0xcd, 0x98, 0x66, 0x43, 0xb8, 0x05, 0xeb,
	0xfd, 0xf5, 0x14, 0xf0, 0x15, 0xdc, 0xbb, 0x64, 0x3a, 0xc1, 0xb0, 0x28, 0x10, 0x5a, 0xc7, 0x59,
	0x8b, 0x58, 0xb3, 0x61, 0x2d, 0xfc, 0x41, 0x34, 0x4a, 0x76, 0xd9, 0xa9, 0x8e, 0xb2, 0x47, 0xf8,
	0x14, 0x5a, 0xab, 0xa8, 0x75, 0xa8, 0xa4, 0xce, 0xe1, 0x41, 0x0e, 0xdf, 0x7e, 0x2d, 0xc3, 0xea,
	0xe0, 0xec, 0x3c, 0xcd, 0x82, 0x0c, 0xdc, 0xcc, 0xb6, 0x87, 0xf0, 0x52, 0x15, 0x2b, 0xaa, 0xb5,
	0x56, 0xd7, 0x85, 0x9b, 0xcf, 0xef, 0x1f, 0x2f, 0xa5, 0x03, 0xbc, 0x1f, 0xaf, 0xe8, 0xf1, 0x3b,
	0x51, 0xd7, 0x75, 0x9f, 0x3a, 0x3a, 0xc3, 0xd2, 0x01, 0x6e, 0xac, 0xda, 0xff, 0x4b, 0xb5, 0xff,
	0x2f, 0xaa, 0x7c, 0x49, 0xf5, 0x0d, 0x40, 0x94, 0xaf, 0x0e, 0x39, 0x4b, 0xc4, 0xbf, 0x2e, 0xce,
	0x6a, 0x16, 0x98, 0x4c, 0xf7, 0x80, 0x49, 0x62, 0xab, 0x89, 0x0f, 0xf3, 0xb6, 0x4c, 0x0e, 0xd5,
	0x01, 0x6e, 0xcf, 0x81, 0x3b, 0xbe, 0x0a, 0x16, 0x05, 0x7a, 0xdb, 0x73, 0xff, 0xc3, 0xf8, 0xad,
	0x0f, 0xc1, 0x27, 0x00, 0xb7, 0x95, 0xe4, 0xdd, 0x1f, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x17,
	0xc5, 0x32, 0xda, 0xcd, 0x03, 0x00, 0x00,
}
