/*
 * Copyright (C) 2007, 2008  Miriam Ruiz <little_miry@yahoo.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "filter.h"
#include "taghandler.h"

#ifdef UNIT_TEST
#include "CuTest.h"
#endif

#include <string>

#define FACET_VIOLENCE "rating:violence"
#define FACET_SEX "rating:sex"
#define FACET_LANGUAGE "rating:language"
#define FACET_DISCRIMINATION "rating:discrimination"

#define GREEN_MINIMUM 2

PackageFilter::PackageFilter()
{
	list = NULL;
	ResultList *element = NULL;

	// BLACK

	element = new ResultList("black 1", PackageFilter::Black);
	tagdata.SetTag(element, "rating:sex::violence");
	AddLast(element);

	// RED

	element = new ResultList("red 1", PackageFilter::Red);
	tagdata.SetTag(element, "rating:violence::non-realistic:optional");
	AddLast(element);

	element = new ResultList("red 2", PackageFilter::Red);
	tagdata.SetTag(element, "rating:violence::non-realistic");
	AddLast(element);

	element = new ResultList("red 3", PackageFilter::Red);
	tagdata.SetTag(element, "rating:violence::realistic:optional");
	AddLast(element);

	element = new ResultList("red 4", PackageFilter::Red);
	tagdata.SetTag(element, "rating:violence::realistic");
	AddLast(element);

	element = new ResultList("red 5", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::non-realistic");
	AddLast(element);

	element = new ResultList("red 6", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::realistic:optional");
	AddLast(element);

	element = new ResultList("red 7", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::realistic");
	AddLast(element);

	element = new ResultList("red 8", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::hard:optional");
	AddLast(element);

	element = new ResultList("red 9", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::hard");
	AddLast(element);

	element = new ResultList("red A", PackageFilter::Red);
	tagdata.SetTag(element, "rating:sex::violence:optional");
	AddLast(element);

	element = new ResultList("red B", PackageFilter::Red);
	tagdata.SetTag(element, "rating:theme::cruelty");
	AddLast(element);

	// YELLOW

	element = new ResultList("yellow 1", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:violence::minor");
	AddLast(element);

	element = new ResultList("yellow 2", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:violence::brief");
	AddLast(element);

	element = new ResultList("yellow 3", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:sex::nudity");
	AddLast(element);

	element = new ResultList("yellow 4", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:sex::non-realistic:optional");
	AddLast(element);

	element = new ResultList("yellow 5", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:theme::death");
	AddLast(element);

	element = new ResultList("yellow 6", PackageFilter::Yellow);
	tagdata.SetTag(element, "rating:theme::horror");
	AddLast(element);

	// GREEN

	element = new ResultList("green 1", PackageFilter::Green);
	tagdata.SetTag(element,  "rating:violence::none");
	tagdata.SetTag(element,  "rating:sex::none");
	tagdata.SetTag(element,  "rating:language::benign");
	tagdata.SetTag(element,  "rating:discrimination::none");
	AddLast(element);

	element = new ResultList("green 2", PackageFilter::Green);
	tagdata.SetTag(element,  "rating:violence::minor:optional");
	tagdata.SetTag(element,  "rating:sex::none");
	tagdata.SetTag(element,  "rating:language::benign");
	tagdata.SetTag(element,  "rating:discrimination::none");
	AddLast(element);

	element = new ResultList("green 3", PackageFilter::Green);
	tagdata.SetTag(element,  "rating:violence::none");
	tagdata.SetTag(element,  "rating:sex::nudity:optional");
	tagdata.SetTag(element,  "rating:language::benign");
	tagdata.SetTag(element,  "rating:discrimination::none");
	AddLast(element);

	element = new ResultList("green 4", PackageFilter::Green);
	tagdata.SetTag(element,  "rating:violence::minor:optional");
	tagdata.SetTag(element,  "rating:sex::nudity:optional");
	tagdata.SetTag(element,  "rating:language::benign");
	tagdata.SetTag(element,  "rating:discrimination::none");
	AddLast(element);
}

PackageFilter::~PackageFilter()
{
	DeleteList();
}

/* Find out the color of a single tag */
int PackageFilter::TagValue(const Tag &tag)
{
	// The order is important
	PackageFilter::ResultList *item = list;
	while (item != NULL) {
		if (tagdata.CheckTag(item, tag))
			return item->type;
		item = item->next;
	}

	return PackageFilter::Unknown;
}

/* Find out the color of a set of tags */
int PackageFilter::TagsValue(const TagSet &tags)
{
	FilterTagHandler::Result t;
//	unsigned int i = 0;

//	tagdata.PrintAll(std::cerr);

	for (TagSet::const_iterator i = tags.begin(); i != tags.end(); ++i) {
		//std::string facet_name = i->facet().name();
		//std::string tag_name = i->name();
//		std::cerr << "Add Tag: " << name << std::endl;
		tagdata.SetTagIfExists(&t, *i);
	}

	// The order is important
	PackageFilter::ResultList *item = list;
	while (item != NULL) {
//		std::cerr << "Compare: ";
//		t.Print(std::cerr);
//		std::cerr << "With table value " << i++ << ": ";
//		item->Print(std::cerr);
//		std::cerr << std::endl;
		if (t.CompareAll(*item))
			return item->type;
		item = item->next;
	}

	return PackageFilter::Unknown;
}

PackageFilter pkgfilter;

#ifdef UNIT_TEST
TEST_FUNCTION TestCuPackageFilter(CuTest* tc)
{
}
#endif
