# gozerbot/datadir.py
# -*- coding: utf-8 -*-
#

""" 
    :mod: `gozerbot.datadir` -- the datadir of the bot

    .. data::
        datadir .. points to the datadir of the bot

"""

__copyright__ = 'this file is in the public domain'

# IMPORT SECTION

# basic imports
import re, os

# END IMPORT

def makedirs(ddir=None):

    """
        make subdirs in datadir. users, db, fleet, pgp, plugs and old.

        .. literalinclude:: ../../gozerbot/datadir.py
            :pyobject: makedirs

    """

    ddir = ddir or datadir
    curdir = os.getcwd()

    if not os.path.isdir(ddir):
        os.mkdir(ddir)
    if not os.path.isdir(ddir + '/users/'):
        os.mkdir(ddir + '/users/')
    if not os.path.isdir(ddir + '/db/'):
        os.mkdir(ddir + '/db/')
    if not os.path.isdir(ddir + '/fleet/'):
        os.mkdir(ddir + '/fleet/')
    if not os.path.isdir(ddir + '/pgp/'):
        os.mkdir(ddir + '/pgp/')
    if not os.path.isdir(ddir + '/plugs/'):
        os.mkdir(ddir + '/plugs/')
    if not os.path.isdir(ddir + '/old/'):
        os.mkdir(ddir + '/old/')

# INIT SECTION

# the datadir
datadir = 'gozerdata'

# END INIT
