#/bin/sh
#
#  Copyright  2007  Neil Williams  <linux@codehelp.co.uk>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

# Use this script to regenerate translate.h when necessary.
# The script is not used in the build because it complicates
# make distcheck and the strings do not change often.
# translate.h is only used by gettext - do NOT include it
# in any source file. For this reason, it is safe to use
# gcc here, even if the package is being cross-compiled.

cd src
if [ -f translate.h ]; then
	rm translate.h
fi
# see the doxygen docs for more information.
gcc -I.. -I/usr/include/glib-2.0 -I/usr/lib/glib-2.0/include -I/usr/include/qof/ -E translate.c 1> translate.h 2>/dev/null

# gcc -E returns non-zero so wrap it.
exit 0

