/*
  Gnome-o-Phone - A program for internet telephony
  Copyright (C) 1999  Roland Dreier
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  $Id: listen.c 1.11 Sat, 04 Dec 1999 15:20:37 -0600 dreier $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "listen.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <glib.h>

#if defined (HAVE_GSM_H)
#include <gsm.h>
#elif defined (HAVE_GSM_GSM_H)
#include <gsm/gsm.h>
#else
#error "GSM header file not found."
#endif

#include "thread-queue.h"
#include "connection.h"
#include "request.h"
#include "thread.h"
#include "sound.h"

#include "gphone.h"
#include "gphone-lib.h"

static Thread_Queue Listen_Queue;
static gsm Listen_Handle;
static Sound_Handle Listen_SH;

void
listen_init(void)
{
  Listen_SH = NULL;

  Listen_Queue = thread_queue_new();

  if ((Listen_Handle = gsm_create()) == 0) {
    gphone_print_exit("*** listen_init : no gsm listen handle.", 2);
  }
}

void
listen_add_request(Request req)
{
  thread_queue_add(Listen_Queue, req);
}

static void
do_switch(void)
{
  g_assert(get_sound_duplex() == HALF_DUPLEX);

  switch(get_status()) {
  case STAT_TALK:
    /* Not implemented yet */
    break;
  case STAT_LISTEN:
    sound_close(Listen_SH);
    Listen_SH = NULL;
    set_status(STAT_TALK);
    break;
  default:
    break;
  }
}

void *
listen_side(void *arg)
{
  while (1) {
    if (!thread_queue_empty(Listen_Queue)) {
      Request req = (Request) thread_queue_head(Listen_Queue);

      switch (req -> type) {
      case REQUEST_QUIT:
        return NULL;
        break;
      case REQUEST_SWITCH:
        do_switch();
        break;
      default:
        g_assert_not_reached();
        break;
      }

      g_free(req -> data);
      thread_queue_remove_free(Listen_Queue);
    }

    if (!connection_listen(.05)) {
      set_spk_level(0);
    }
  }

  return(NULL);
}

void
play_gsm_data(gpointer data, gint datalen)
{
  int i;
  int num_frame, sndbufsize;
  Program_Status status;

  static int buflen = 0;
  static gchar *sndbuf = NULL;

  status = get_status();
  if (status != STAT_LISTEN && status != STAT_TALK_FD) {
    return;
  }

  num_frame = datalen / (sizeof (gsm_frame));

  sndbufsize = num_frame * get_raw_frame_length();

  if (sndbufsize > buflen) {
    sndbuf = g_realloc(sndbuf, sndbufsize);
    buflen = sndbufsize;
  }

  if (Listen_SH == NULL) {
    Listen_SH = sound_open(O_WRONLY);
    if (Listen_SH == NULL) {
      g_warning("*** Sound card refuses to open the speakers\n");
    } else {
      g_log("GPHONE", G_LOG_LEVEL_INFO,
            "Speakers ON");
    }
  }

  for (i = 0; i < num_frame; i++) {
    gsm_decode(Listen_Handle, ((gsm_frame *) data)[i],
               (gsm_signal *) (sndbuf + i * get_raw_frame_length()));
  }

  set_spk_level(find_power_level((void *) sndbuf, sndbufsize));

  write_samples(Listen_SH, (void *) sndbuf, sndbufsize);
}



/*
 * Local variables:
 *  compile-command: "make -k gphone"
 * End:
 */
