#!/usr/bin/perl

#   gpiv_series - Proceeds a **set** of PIV data in an identical way

#   Copyright (C) 2002 Gerber van der Graaf

#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2, or (at your option)
#   any later version.

#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software Foundation,
#   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  


#--------------------------------------------------------------------

$VERSION = q$Id: series.pl,v 1.3 2006/03/04 12:37:08 gerber Exp $;
$HELP = "Script to process a series of numbered files in an identical way";
$USAGE = "gpiv_series [-h|-help][-n|-none][-p|-print][-v|-version] 
[-arg_n] [-db|-dir_basename] [-df|-dir_first N] [-dl|-dir_last N]
[-dx|-dir_prefix] [-fb|-file_basename] [-fext|-file_extension] 
[-ff|-first_file N] [-fl|-file_last N] [-fi|-fincr N] [-fx|-file_prefix] 
\"process\"

keys:
-h:      on-line help
-n:      suppresses real execution
-p:      prints process parameters/variables to stdout
-v:      prints version
-arg_n:  if the process needs the current number in its argument list instead 
         of prepending/appending it to the filebase name, the number will
         be put before (-f) \"filename\" in the \"process\" string.
-dn:     directory name to be processed (default: ./)
-df:     starting at first directory number N  (default: 0)
-dl:     ending at last directory number N (default: 0)
-dx:     prefix numbering to directory base name
-fb:     file base name to be processed
-fext:   add an extension after the file basename + number (without 
         leading \".\")
-ff:     starting at first file number N (default: 0)
-fl:     last file number N (default: 0)
-fi:     increment file number with N (default: 1)
-fx:     prefix numbering to file base name
\"process\": string which contains the name of program to be processed,
             including eventually command line options and arguments. 
             The file to be processed will be appended to the string. 
             If the program needs -f \"filename\", write -f at the end 
             of the string. 
";


#----------------- Command line arguments handling ----------
$opt_h = 0;
$opt_n = 0;
$opt_p = 0;
$opt_v = 0;
$opt_dx = 0;
$opt_fx = 0;
$opt_arg_n = 0;

use Getopt::Long;
#$result = 
GetOptions('h|help', 'n|none', 'p|print', 'v|version',
'arg_n',
'db|dir_basename=s' => \$dir_base_name,
'df|dir_first=i' => \$dir_first_nr,
'dl|dir_last=i' => \$dir_last_nr,
'dx|dir_prefix',
'fb|file_basename=s' => \$file_base_name,
'fext|file_extension=s' => \$file_ext,
'ff|first_file=i' => \$file_first_nr,
'fl|last_file=i' => \$file_last_nr,
'fi|fincr=i' => \$file_incr_nr,
'fx|file_prefix'
);


if ($opt_h) {
  print ("$HELP\n");
  print ("$USAGE\n");
  exit;
}
if ($opt_v) {
  print ("$VERSION\n");
  exit;
}

if ($file_base_name && $opt_p) {
print ("\nfile_base_name=$file_base_name \
file_first_nr=$file_first_nr \
file_last_nr=$file_last_nr\n");
}

#if ($dir_base_name && $opt_p) {
#print ("\ndir_base_name=$dir_base_name \
#dir_first_nr=$dir_first_nr \
#dir_last_nr=$dir_last_nr\n");
#}

$process = shift (@ARGV);
$process_arg_number=0;

while ($#ARGV != -1) {
  $process_arg[$process_arg_number] = shift (@ARGV);
  $process_arg_number++;
}

if ($#ARGV != -1) {
  printf ("\nUsage: $USAGE\n");
  exit;
}

#----------------------------------------------- Initializing variables
#-------------------------- General options
if (!$file_base_name) {$file_base_name = "";}
if (!$file_first_nr) {$file_first_nr = 0; }  # First data set to be scanned
if (!$file_last_nr) {$file_last_nr = 0; }    # Last data set to be scanned
if (!$file_incr_nr) {
    $file_incr_nr = 1;
} else {
    # if ($opt_p || $opt_n) {printf ("file_incr_nr = $file_incr_nr\n");}
}   # Next data set to be scanned

if (!$dir_base_name) {
    $dir_base_name_defined = 0; $dir_base_name = "."; 
} else {
    $dir_base_name_defined = 1;
}

if (!$dir_first_nr) { $dir_first_nr = 0; }     # First directory to be scanned
if (!$dir_last_nr) { $dir_last_nr = 0;  }      # Last directory to be scanned

#use FileBaseExt;
#if (!$dir_base_name) {
#$dir_base_name = $ENV{"PWD"}; 
#printf ("\nenv=%s",$dir_base_name); 
#exit;
#}
#if (!$dir_first_nr) { $dir_first_nr = FileExt($full_filename)
#if (!$dir_last_nr) { $dir_first_nr = FileExt($full_filename)




#===========================================================================
#  Probably, you do not have to edit below here
#===========================================================================

#----------------------------- time stamp for starting process
@args=("date");
if ($opt_p || $opt_n) {printf ("Time stamp of starting processing of series:\n");}
if (!$opt_n) {system (@args) == 0 || die "system @args failed: $?";}


#----------------------------------------- loops for directory and files:
for ($dir_nr = $dir_first_nr; $dir_nr <= $dir_last_nr; $dir_nr++) {

    if ($dir_base_name_defined) {
        if (!$opt_dx) {
	    $target_dir = $dir_base_name.$dir_nr."/";
        } else {
	    $target_dir = $dir_nr.$dir_base_name."/";
	}
    } else { 
        $target_dir = $dir_base_name."/";
    }

#  print ("file_nr = $file_nr\n");
# print ("opt_fx = $opt_fx\n");
    for ($file_nr = $file_first_nr; $file_nr <= $file_last_nr;
         $file_nr = $file_nr + $file_incr_nr) {
# print ("file_nr = %d",$file_nr);

        if ($opt_fx) {
# print ("prefix\n");
            if (!$opt_arg_n) {
	        $file_name=$target_dir.$file_nr.$file_base_name;
	    } else {
	        $file_name=$target_dir.file_base_name;
	    }
        } else {
# print ("append\n");
            if (!$opt_arg_n) {
                $file_name=$target_dir.$file_base_name.$file_nr;
	    } else {
                $file_name=$target_dir.$file_base_name;
	    }
        }

        if ($file_ext) {$file_name=$file_name.".$file_ext"};

        $l_process = $process;
        if ($opt_arg_n) {
       	    if ($l_process =~ s/ -f/ $file_nr -f/) {  # Eventually, substitutes
                                                      # "-f" with: "$file_nr -f"
                                                      # in the local process string
		@args=("$l_process $file_name");
	    } else {
                @args=("$l_process $file_nr $file_name");
	    }
        } else {
            @args=("$l_process $file_name");
	}
        if ($opt_p || $opt_n) {printf ("@args \n");}
        if (!$opt_n) {system (@args) == 0 || die "system @args failed: $?";}
    }
}


#-------------------------------------------------- put time stamp for ending
@args=("date");
if ($opt_p || $opt_n) {printf ("\ntime stamp of ending processing of series: \n");}
if (!$opt_n) {system (@args) == 0 || die "system @args failed: $?";}

if ($opt_p || $opt_n) {print "\n";}

#
# that's all folks
#
