#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>

#define UNKNOWN_TOP 0
#define LINUX_TOP 1
#define REAL_TOP 2

char *linux_top_args[7] =
	{
	NULL, 
	"-i", 
	"-d", 
	"infinity", 
	"-s3600", 
	"-S", 
	NULL 
	};

char *real_top_args[6] =
	{
	NULL, 
	"-b", 
	"-d", 
	"infinity", 
	"10000", 
	NULL 
	};

int PORT = 24374;
void signal_handler(int sig);

int sock=-1, actsock=-1;

void usage(int argc, char **argv)
  {
  fprintf(stderr, "\nusage %s ip [myport]\n\n", argv[0]);
  fprintf(stderr, "'ip' is the IP number of the machine where gps is running\n");
	fprintf(stderr, "'myport' is the port on this machine\n");

  exit(-1);
  }


char *find_top()
	{
  int success = (0==1);
  char *tok;
  char *path;
  char *buffer;
  char *stat_fname;
  int path_len;

  path = getenv("PATH");
  if(path==NULL) 
    { 
    fprintf(stderr, "no PATH variable is set. Can't find 'top'\n"); 
    exit(-1);
    }

  path_len = strlen(path);
  buffer = (char *) malloc( strlen(path) );
  stat_fname = (char *) malloc( strlen(path) +5 );
  strcpy(buffer, path);
  tok=strtok(buffer, ":");
  while(tok)
    {
    int ret;
    struct stat topstat;

    sprintf(stat_fname, "%s/top", tok);

    ret = stat(stat_fname, &topstat);
    if(ret==0)
			{
			free(buffer);
			return stat_fname;
      }
    tok=strtok(NULL, ":");
    }

	free(stat_fname);
	free(buffer);
	return NULL;
  }

int check_top(char *top_fname)
	{
	int inbufsize=128;
	char inbuf[inbufsize];
	int pid;
	int status;
	int p[2];

	pipe(p);

	pid = fork();
	if( pid == 0 )
		{
		char *args[3] = { top_fname, "-v", NULL};
		close(2);
		dup(p[1]);
		close(p[0]);
		close(p[1]);
		close(1);
		close(0);

		execv(top_fname, args);
		exit(0);
		}
	else
		{
		char *x;
		int ret;
		close(p[1]);

		x = inbuf;
		while( (x<(inbuf+inbufsize-2)) && (read(p[0], x, 1)==1) )
			x++;
		*x='\0';

		close(p[0]);
		}
	waitpid(pid, &status, 0);

	if(strcmp(inbuf, "top: Unknown argument `v'\n")==0)
		return LINUX_TOP;
	else if( strncmp(inbuf, "top: version", 12)==0 )
		return REAL_TOP;

	fprintf(stderr, "Couldn't determine version of top at %s\n", top_fname);
	fprintf(stderr, "top -v returned:\n%s", inbuf);
	exit(-1);
	}

int main(int argc, char **argv)
  {
  int fd;
	int version;
	char *mytop;
  int      addrlen;
  struct   sockaddr_in sin;
  struct   sockaddr_in pin;
 
  if(argc<2)
    usage(argc, argv);
	else if (argc==3)
		PORT= atoi(argv[2]);

  /* find top */
	mytop = find_top();
	if(mytop==NULL)
		{
		fprintf(stderr, "couldn't find 'top' in $PATH\n");
		exit(-1);
		}

	/* check for a version number */
	version = check_top(mytop);
	fprintf(stderr, "found version %d\n", version);

  /* attach signals to catch for proper termination */
  signal(SIGKILL, signal_handler);
  signal(SIGSTOP, signal_handler);
  signal(SIGHUP, signal_handler);
  signal(SIGSEGV, signal_handler);
  signal(SIGPIPE, signal_handler);
  signal(SIGQUIT, signal_handler);
  signal(SIGTERM, signal_handler);
  signal(SIGINT, signal_handler);

  sock = socket(AF_INET, SOCK_STREAM, 0);

  memset(&sin, 0, sizeof(sin));
  sin.sin_family = AF_INET;
  sin.sin_addr.s_addr = INADDR_ANY;
  sin.sin_port = htons(PORT);

  if(bind(sock, (struct sockaddr *) &sin, sizeof(sin))==-1)
    {
    fprintf(stderr, "bind failed on port %d\n", PORT);
    exit(-1);
    }

  listen(sock, 5);

  while(1) 
    { 
    int c[4];
    char remote[32];
    addrlen=sizeof(pin); /* <--- you must set this before accept'ing */
    actsock = accept(sock, (struct sockaddr *)  &pin, &addrlen);
    c[3] = ( pin.sin_addr.s_addr >> 24 ) & 0xff;
    c[2] = ( pin.sin_addr.s_addr >> 16 ) & 0xff;
    c[1] = ( pin.sin_addr.s_addr >> 8 )  & 0xff;
    c[0] = ( pin.sin_addr.s_addr ) & 0xff;
    snprintf(remote, 32, "%d.%d.%d.%d", c[0], c[1], c[2], c[3]);

    if( strcmp(remote, argv[1])!=0 )
      {
      fprintf(stderr, "rtop: illegal connect from %s. Only %s may connect...\n", remote, argv[1]);
      }
    else
      {
      int pid, status;

      /* ok. so we want to spawn off top... */
      if( (pid = fork()) ==0 )
        {
				char **args;
       if(version==LINUX_TOP)
          args = linux_top_args;
        else
					args = real_top_args;

				/* and spawn off another child to get rid of the ppid */
				if(fork()>0)
					{
					close(actsock);
        	exit(0);
					}

      	/* change stdout of top to the socket. I just love unix *g*/
      	close(1); /* stdout */
      	dup(actsock);
      	close(2); /* stderr */

      	close(actsock);
				close(0);

				args[0] = mytop;
      	execv( mytop, args);
      	exit(0);
      	}
      waitpid(pid, &status, 0);
      }
		shutdown(actsock, 2);
    close(actsock); actsock=-1;
    sleep(1); 
    }

  /* close up both sockets */
	shutdown(sock, 2);
  close(sock);
        
  /* give client a chance to properly shutdown */
  sleep(1);

  exit(0);
  }

void signal_handler(int sig)
  {
  fprintf(stderr, "rtop: caught signal. terminating...\n");
  fflush(stderr);
  if(actsock!=-1)
		{
		shutdown(actsock, 2);
    close(actsock);
		}
  if(sock!=-1)
		{
		shutdown(sock, 2);
    close(sock);
		}

  sleep(1);
  exit(0);
  }
