/* gpsk31  - PSK31 for Linux with a GTK+ Interface
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 0.1 - March 2000
 *
 */

/*
 * globals.h - Definitions of global Variables
 */

struct qsodata			/* The Data of the current QSO */
{
  gchar call[12];
  gchar name[26];
  gchar qth[26];
  gchar rst_s[9];
  gchar rst_r[9];
  gchar notes[41];
  gchar freq[10];
  gchar date[12];
  gchar time[6];
};
extern struct qsodata qsodata;

struct qso_dialog		/* The Text entry widgets for the call entry dialog */
{
  GtkWidget *call_text;
  GtkWidget *name_text;
  GtkWidget *qth_text;
  GtkWidget *notes_text;
  GtkWidget *rst_s_text;
  GtkWidget *rst_r_text;
  GtkWidget *freq_text;
  GtkWidget *window;
};
extern struct qso_dialog qso_dialog;

struct statusbar		/* The Statusbar Widgets */
{
  GtkWidget *logged;
  GtkWidget *mode;
  GtkWidget *txstate;
  GtkWidget *time;
};
extern struct statusbar statusbar;

struct main_screen
{
  GdkPixmap *phase_scope;	/* For drawing the phase scope */
  GdkPixmap *spectrum;		/* For drawing the spectrum analizer */
  GtkWidget *rxwindow;		/* RX Window */
  GtkWidget *txwindow;
  GtkWidget *window;		/* The Main Widget */
  GtkWidget *phase_drawing;	/* Phase Scope drawing area */
  GtkWidget *spectrum_drawing;	/* Spectrum drawing area */
  GtkWidget *rx_freq;
  GtkWidget *tx_freq;
  GtkWidget *dcd;
  GtkWidget *cwid;
  GtkWidget *afc;
  GtkWidget *net;
  GtkWidget *mode_qpsk;
  GtkWidget *mode_bpsk;
  GtkWidget *mode_autotx;
  GtkWidget *menu;
  GtkWidget *f_button[8];
  GtkAdjustment *dcd_adj;
};
extern struct main_screen main_screen;

struct ini_settings		/* Settings to be written in config file */
{
  char tx_window_color[20];
  char rx_window_color_rx[20];
  char rx_window_color_tx[20];
  char tx_window_font[60];
  char rx_window_font[60];
  char spectrum_color[20];
  char spectrum_tune_line_color[20];
  char phase_scope_dcd_on_color[20];
  char phase_scope_dcd_off_color[20];
  char phase_scope_arc_color[20];
  char name[20];
  char qth[20];
  char call[20];
  int freq;
  int new_rx;
  char cw_string[15];
  int dcd_level;
  int lsb;
  char label [16][20];
  char text[16][1024];
  char ptt_device[20];
  char audio_device[20];
  int spectrum_width;
  int spectrum_speed;
  char log_filename[50];
};
extern struct ini_settings ini_settings;  

