/**
 * @file
 * ɾؿӳǧ.
 * osl/sample/checkstat ȤۤƱɤ
 * PieceCost Ȥʤȡ h_estimator 򿧡٤㤦
 * ޤ dominance ɬȤ
 */
#include "osl/checkmate/dualCheckmateSearcher.h"
#include "osl/checkmate/dualCheckmateSearcher.tcc"
#include "osl/checkmate/checkmateSearcher.tcc"

#include "osl/checkmate/analyzer/checkTableAnalyzer.h"
#include "osl/checkmate/simpleCheckHashTable.h"
#include "osl/checkmate/dominanceTable.h"
#include "osl/checkmate/checkHashRecord.h"
#include "osl/checkmate/checkmateRecorder.h"

#include "osl/checkmate/h_seed/features.h"
#include "osl/checkmate/h_seed/seedMap.h"
#include "osl/checkmate/h_estimator/slowEval.h"

#include "osl/checkmate/libertyEstimator.h"
#include "osl/checkmate/nullEstimator.h"
#include "osl/checkmate/nullCost.h"
#include "osl/record/csaRecord.h"
#include "osl/hashEffectState.h"
#include "osl/perfmon.h"

#include <boost/scoped_ptr.hpp>
#include <string>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <unistd.h>

using namespace osl;
using namespace osl::checkmate;
using namespace osl::checkmate::h_estimator;
using namespace osl::checkmate::h_seed;
using record::csa::ICsaRecordStream;
void usage(const char *prog)
{
  using namespace std;
  cerr << "Usage: " << prog << " [-vpEOt] [-H heuristic-type] "
       << "[-w proof-weightfilename] [-W disproof-weightfilename] "
       << "[-T tree-size-out] [-F FILES] "
       << "[-l nodelimit] [-L loglimit] [-o tree-output-filename] "
       << "[-d logdepth] [-A depth(>0)] [-a depth(>0)] csa-filenames "
       << endl
       << "-v show result\n"
       << "-p show proof tree\n"
       << "-A depth  show all tree (expanding solved branch)\n"
       << "-a depth  show tree\n"
       << "-E show filnames that are solved and found to be 'escape'\n"
       << "-t force turn's player to attack even if he is in check\n"
       << "-O use outline format for dumping tree\n"
       << endl;
  exit(1);
}

bool verbose=false;
unsigned long long totalCycles=0;
size_t limit = 409600; // 3900;
bool showProofTree = false;
int showAllTreeDepth = 0;
int showTreeDepth = 0;
bool showEscapeFilename = false;
bool forceAttack = false;
int numCheckmate=0, numEscape=0, numUnkown=0;
bool useOutlineFormat = false;
size_t logThreshold = 0;
const char *proof_weights_filename = 0;
const char *disproof_weights_filename = 0;

std::ostream *treeOut = 0;
std::ostream *tree_sizeOut = 0;
Features *features=0;

double sum_tree_size = 0;
double sum_nodes = 0;
bool use_piece_cost = true;

void searchFile(const char *filename);

int main(int argc, char **argv)
{
  const char *program_name = argv[0];
  bool error_flag = false;
  extern char *optarg;
  extern int optind;

  const char *FILES = 0;
  treeOut = &std::cout;
  boost::scoped_ptr<std::ofstream> treefs, treesizefs;
  SeedMap seeds;
    
  char c;
  while ((c = getopt(argc, argv, "A:a:d:EF:H:L:l:Oo:ptT:w:W:vh")) != EOF)
  {
    switch(c)
    {
    case 'A':	showAllTreeDepth = atoi(optarg);
      assert(showAllTreeDepth);
      break;
    case 'a':	showTreeDepth = atoi(optarg);
      assert(showTreeDepth);
      break;
    case 'd':	checkmate::CheckmateRecorder::DepthTracer::maxVerboseLogDepth 
							     = atoi(optarg);
      break;
    case 'E':	showEscapeFilename = true;
      break;
    case 'F':	FILES = optarg;
      break;
    case 'H':	features = seeds.find(optarg);
      break;
    case 'L':	logThreshold = atoi(optarg);
      assert(logThreshold);
      break;
    case 'l':	limit = atoi(optarg);
      assert(limit);
      break;
    case 'O':	useOutlineFormat = true;
      break;
    case 'o':	treefs.reset(new std::ofstream(optarg));
      treeOut = &*treefs;
      break;
    case 'p':	showProofTree = true;
      break;
    case 'P':	use_piece_cost = false;
      break;
    case 't':	forceAttack = true;
      break;
    case 'T':	treesizefs.reset(new std::ofstream(optarg));
      tree_sizeOut = &*treesizefs;
      break;
    case 'v':	verbose = true;
      break;
    case 'w':	proof_weights_filename = optarg;
      break;
    case 'W':	disproof_weights_filename = optarg;
      break;
    default:	error_flag = true;
    }
  }
  argc -= optind;
  argv += optind;

  if (error_flag || ((argc < 1) && (! FILES)))
    usage(program_name);

  if (features)
    assert(proof_weights_filename || disproof_weights_filename);

  std::cerr << "limit " << limit << "\n";
  try
  {
    for (int i=0; i<argc; ++i)
    {
      searchFile(argv[i]);
      totalCycles = 0;
    }
    if (FILES)
    {
      std::ifstream is(FILES);
      assert(is);
      std::string filename;
      size_t count=0;
      while (is >> filename)
      {
	if (tree_sizeOut && (++count % 512) == 0)
	{
	  std::cerr << sum_tree_size / sum_nodes << "\n";
	  *tree_sizeOut << std::flush;
	}
	searchFile(filename.c_str());
	totalCycles = 0;
      }
    }
    std::cerr << "check " << numCheckmate << " escape " << numEscape
	      << " unknown " << numUnkown << "\n";
    if (tree_sizeOut)
    {
      std::cerr << "tree ratio " << sum_tree_size << " / " 
		<< sum_nodes << " = " << sum_tree_size / sum_nodes << "\n";
      std::cerr << "tree ratio " << (unsigned long long)sum_tree_size << " / " 
		<< (unsigned long long)sum_nodes 
		<< " = " << sum_tree_size / sum_nodes << "\n";
    }
  }
  catch (std::exception& e)
  {
    std::cerr << e.what() << "\n";
    return 1;
  }
}

void dumpTree(const CheckTableAnalyzer& analyzer,
	      const CheckHashRecord *record)
{
  if (showAllTreeDepth)
  {
    analyzer.showTree(record,*treeOut,showAllTreeDepth,true,false,logThreshold);
  }
  if (showTreeDepth)
  {
    analyzer.showTree(record,*treeOut,showTreeDepth,false,false,logThreshold);
  }
}

template <class Eval, class Cost>
void search(const char *filename);

template <class Eval, class Cost>
void readEvalAndSearch(const char *filename)
{
  if (proof_weights_filename && disproof_weights_filename)
  {
    Eval::init(proof_weights_filename, disproof_weights_filename, 0, 0);
    // ɾؿɤ߹ߤ1ǽʬ
    proof_weights_filename = 0;
    disproof_weights_filename = 0;
  }
  search<Eval, Cost>(filename);
}

void searchFile(const char *filename)
{
  if (verbose)
    std::cerr << "\nsolving " << filename << "\n";
  if (features)
  {
    if (use_piece_cost)
      readEvalAndSearch<SlowEval, PieceCost>(filename);
    else
      readEvalAndSearch<SlowEval, NullCost>(filename);
  }
  else
  {
    // search<PureLibertyEstimator>(filename);
    if (use_piece_cost)
      search<NullEstimator, PieceCost>(filename);
    else
      search<NullEstimator, NullCost>(filename);
  }
}

/**
 * CSA Υե뤫 stream 1()ɤ
 */
void readCsaState(std::istream& is, SimpleState& state)
{
  record::Record rec;
  record::csa::ICsaRecordStream irs(is);
  irs.load(&rec);
  state = rec.getInitialState();
}


template <Player P, class Searcher>
void testWinOrLose(const char *curFilename,
		   Searcher& searcher,
		   const SimpleState& sstate, int limit)
{
  typedef typename Searcher::table_t table_t;
  HashEffectState state((NumEffectState(sstate)));
  const PathEncoding path(state.getTurn());
  const HashKey& key = state.getHash();
  if ((! forceAttack) 
      && state.hasEffectBy(alt(P),state.template getKingPosition<P>()))
  {
    // ꤫鲦꤬äƤ
    clock_start();
    const bool lose = searcher.isLosingStateSlow(limit, state, path);
    totalCycles += clock_stop();
#if 0
    std::cerr << " done\n";
#endif
    if (verbose)
    {
      const table_t& table = searcher.getTable(alt(P));
      const CheckHashRecord *record = table.find(key);
      CheckTableAnalyzer analyzer(table.getTwinTable(), useOutlineFormat);
      dumpTree(analyzer, record);
      if (lose)
      {
	++numCheckmate;
	const size_t tree_size = analyzer.proofTreeSize(record,key,path,false);
	std::cerr << "lose\n";
	std::cerr << "proof tree " << tree_size << "\n";
	if (tree_sizeOut)
	{
	  sum_tree_size += tree_size;
	  sum_nodes += table.size();
	  *tree_sizeOut << tree_size << " " << table.size() << "\n";
	}
	if (showProofTree)
	  analyzer.showProofTree(record,key,path,false,*treeOut);
	return;
      }
      else
      {
	assert(record);
	if (showEscapeFilename)
	  std::cerr << curFilename << "\n";
	if (record->proofDisproof().isCheckmateFail()
	    || record->findLoop(path, table.getTwinTable()))
	{
	  ++numEscape;
	  const size_t tree_size = analyzer.disproofTreeSize(record,key,path,true);
	  std::cerr << "escape\n";
	  std::cerr << "disproof tree " << tree_size << "\n";
	  if (tree_sizeOut)
	  {
	    sum_tree_size += tree_size;
	    sum_nodes += table.size();
	    *tree_sizeOut << tree_size << " " << table.size() << "\n";
	  }

	  if (showProofTree)
	    analyzer.showProofTree(record,key,path,true,*treeOut);
	  return;
	}
	else
	{
	  assert(! record->proofDisproof().isFinal());
	  ++numUnkown;
	  std::cerr << "unknown " << record->proofDisproof() << "\n";
	  return;
	}
      }
    }
  }
  else
  {
    Move checkmateMove;
    clock_start();
    const bool win = searcher.
      template isWinningStateSlow(limit, state, path, checkmateMove);
    totalCycles += clock_stop();
#if 0
    std::cerr << " done\n";
#endif
    if (verbose)
    {
      const table_t& table = searcher.getTable(P);
      const CheckHashRecord *record = table.find(state.getHash());
      CheckTableAnalyzer analyzer(table.getTwinTable(), useOutlineFormat);
      if ((record->proofDisproof() != ProofDisproof::Checkmate())
	  && (record->proofDisproof() != ProofDisproof::NoCheckmate()))
	std::cerr << record->proofDisproof() << "\n";
      // std::cerr << record->bestResultInSolved << "\n";
      dumpTree(analyzer, record);
      if (win)
      {
	++numCheckmate;
	const size_t tree_size = analyzer.proofTreeSize(record,key,path,true);
	std::cerr << "win by " << checkmateMove << "\n";
	std::cerr << "proof tree " << tree_size << "\n";
	if (tree_sizeOut)
	{
	  sum_tree_size += tree_size;
	  sum_nodes += table.size();	  
	  *tree_sizeOut << tree_size << " " << table.size() << "\n";
	}
	if (showProofTree)
	  analyzer.showProofTree(record,key,path,true,*treeOut);
	return;
      }
      else
      {
	assert(record);
	if (record->proofDisproof().isFinal()
	    || record->findLoop(path, table.getTwinTable()))
	{
	  ++numEscape;
	  const size_t tree_size = analyzer.disproofTreeSize(record,key,path,false);
	  std::cerr << "no checkmate\n";
	  std::cerr << "disproof tree " << tree_size << "\n";
	  if (tree_sizeOut)
	  {
	    sum_tree_size += tree_size;
	    sum_nodes += table.size();	    
	    *tree_sizeOut << tree_size << " " << table.size() << "\n";
	  }
	  if (showProofTree)
	    analyzer.showProofTree(record,key,path,false,*treeOut);
	  return;
	}
	else
	{
	  ++numUnkown;
	  std::cerr << "unknown " << record->proofDisproof() << "\n";
	  return;
	}
      }
    }
  }
}

template <class Eval, class Cost>
void search(const char *filename)
{
  std::ifstream is(filename);
  typedef DualCheckmateSearcher<HashEffectState, DominanceTable, 
    Eval, Cost> searcher_t;
  searcher_t searcher(20000000, verbose);

  SimpleState state;
  readCsaState(is, state);

  if (state.getTurn() == BLACK)
    testWinOrLose<BLACK,searcher_t>(filename, searcher, state, limit);
  else
    testWinOrLose<WHITE,searcher_t>(filename, searcher, state, limit);


  clock_message(totalCycles, "total ", 
		searcher.searcher(BLACK).getTotalNodeCount()
		+ searcher.searcher(WHITE).getTotalNodeCount());
  clock_message(totalCycles, "unique", 
		searcher.getTable(BLACK).size()
		+ searcher.getTable(WHITE).size());
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
