#include "moveTree.h"
#include "viewer.h"
#include "osl/eval/pieceEval.h"

#if QT_VERSION >= 0x040000
#include <Q3PopupMenu>
#include <Q3Action>
#include <QContextMenuEvent>
#include <Q3Header>
#else
#include <qpopupmenu.h>
#include <qaction.h>
#define Q3PopupMenu QPopupMenu
#define Q3Action QAction
#define Q3ListViewItemIterator QListViewItemIterator
#include <qheader.h>
#endif

MoveTree::~MoveTree()
{
}

void MoveTree::showContextMenu(Q3PopupMenu *)
{
}

void MoveTree::contextMenuEvent(QContextMenuEvent *event)
{
  Q3PopupMenu contextMenu(this);
  Q3Action *expandBestAction = new Q3Action("Expand Best", 0, &contextMenu);
  connect(expandBestAction, SIGNAL(activated()),
	  this, SLOT(expandBest()));
  expandBestAction->addTo(&contextMenu);
  Q3Action *expandAllAction = new Q3Action("Expand All", 0, &contextMenu);
  connect(expandAllAction, SIGNAL(activated()),
	  this, SLOT(expandAll()));
  expandAllAction->addTo(&contextMenu);
  Q3Action *closeAllAction = new Q3Action("Close All", 0, &contextMenu);
  connect(closeAllAction, SIGNAL(activated()),
	  this, SLOT(closeAll()));
  closeAllAction->addTo(&contextMenu);

  contextMenu.insertSeparator();
  Q3Action *moveGenerateAction = new Q3Action("Show Generated &Moves", 0, this);
  connect(moveGenerateAction, SIGNAL(activated()),
	  this, SIGNAL(moveGenerate()));
  moveGenerateAction->addTo(&contextMenu);

  showContextMenu(&contextMenu);
  if (! selectedItem())
  {
    QPoint pos(event->x(), event->y() - header()->height());
    Q3ListViewItem *item = itemAt(pos);
    if (item)
    {
      setSelected(item, true);
    }
  }
  contextMenu.exec(event->globalPos());
}

void MoveTree::expandAll()
{
  MoveTreeItem *item = (MoveTreeItem *) selectedItem();
  if (!item)
    return;

  for (Q3ListViewItemIterator it(item); it.current(); it++)
  {
    it.current()->setOpen(true);
  }
}

void MoveTree::closeAll()
{
  MoveTreeItem *item = (MoveTreeItem *) selectedItem();
  if (!item)
    return;

  for (Q3ListViewItemIterator it(item); it.current(); it++)
  {
    it.current()->setOpen(false);
  }
}

void MoveTree::expandBest()
{
  expandBestChildren((MoveTreeItem *) selectedItem());
}

void MoveTree::expandBestChildren(MoveTreeItem *item)
{
  if (!item)
    return;

  item->setOpen(true);
  for (MoveTreeItem *child = (MoveTreeItem *)item->firstChild();
       child;
       child = (MoveTreeItem *)child->nextSibling())
  {
    if (child->isBestMove())
    {
      child->setOpen(true);
      expandBestChildren(child);
      break;
    }
  }
}

int MoveTreeItem::compare(Q3ListViewItem *i, int col, bool ascending) const
{
  if (col == 0)
  {
    osl::Move m2 = ((MoveTreeItem *)i)->getMove();
    if ((! move.isNormal()) && (! m2.isNormal()))
      return 0;
    else if (! move.isNormal())
      return -1;
    else if (! m2.isNormal())
      return 1;

    if (move.to().x() < m2.to().x())
      return -1;
    else if (move.to().x() > m2.to().x())
      return 1;
    else
    {
      if (move.to().y() < m2.to().y())
	return -1;
      else if (move.to().y() > m2.to().y())
	return 1;
      else
      {
	int x1 = osl::eval::Ptype_Eval_Table.value(move.ptype()) + osl::eval::Ptype_Eval_Table.value(osl::unpromote(move.ptype()));
	int x2 = osl::eval::Ptype_Eval_Table.value(m2.ptype()) + osl::eval::Ptype_Eval_Table.value(osl::unpromote(m2.ptype()));
	if (x1 < x2)
	  return -1;
	else if (x1 > x2)
	  return 1;
	else return 0;
      }
    }
  }
  else
    return key(col, ascending).compare(i->key(col, ascending));
}
