/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 Peter Stamfest

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_text.c,v 1.16 2006/04/05 00:53:55 herzi Exp $ */

#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>

#include <config.h>

#include "common.h"
#include "util.h"
#include "errorchain.h"
#include "formfill.h"
#include "input.h"
#include "tinput.h"
#include "browse.h"
#include "encode.h"
#include "ldif.h" /* for b64_decode */
#include "syntax.h"
#include "dt_text.h"

#if GTK_MAJOR >= 2
static GByteArray *dt_text_get_data(struct formfill *form, GtkWidget *widget);
static void dt_text_set_data(struct formfill *form, GByteArray *data,
			     GtkWidget *widget);
#endif

static dt_text_handler dt_text_handler_vtab = {
     {
	  "Multi-line Text", 
	  TRUE,
	  TRUE,

	  dt_text_get_widget,
#if GTK_MAJOR >= 2
	  dt_text_get_data,
	  dt_text_set_data,		
#else
	  dt_entry_get_data,		/* reuse method from dt_entry */
	  dt_entry_set_data,		
#endif
	  bervalLDAPMod			/* reuse method from dt_entry */
     },
#if GTK_MAJOR < 2
     decode_utf8, /* encode method */	/* reuse method from dt_entry */
     encode_utf8, /* decode method */	/* reuse method from dt_entry */
#else
     /* gtk2 uses UTF-8 natively! Yipieeh */
     NULL,
     NULL,
#endif
};

display_type_handler *dt_text_get_handler() {
     return (display_type_handler *) &dt_text_handler_vtab;
}

GtkWidget *dt_text_get_widget(int error_context,
			      struct formfill *form, GByteArray *data,
			      GtkSignalFunc *activatefunc,
			      gpointer funcdata) 
{
    GtkWidget *inputbox;

#if GTK_MAJOR >= 2
    GtkWidget *scrolled;

    inputbox = gtk_text_view_new();
    gtk_widget_show(inputbox);

    
    scrolled = gtk_scrolled_window_new(NULL, NULL);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled), 
				   GTK_POLICY_AUTOMATIC,
				   GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrolled),
					GTK_SHADOW_IN);
    gtk_container_add(GTK_CONTAINER(scrolled), inputbox); 
    gtk_widget_show(scrolled);

    dt_text_set_data(form, data, scrolled);

    return scrolled;
#else
    inputbox = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(inputbox), TRUE);
    dt_entry_set_data(form, data, inputbox);

    return inputbox;
#endif
}


#if GTK_MAJOR >= 2

static GByteArray *dt_text_get_data(struct formfill *form, GtkWidget *widget) 
{
     GtkWidget *text = gtk_bin_get_child(GTK_BIN(widget));
     GtkTextBuffer *b = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
     GtkTextIter s, e;
     gchar *c;
     GByteArray *a = NULL;

     gtk_text_buffer_get_start_iter(b, &s);
     gtk_text_buffer_get_end_iter(b, &e);
     c = gtk_text_buffer_get_text(b, &s, &e, TRUE);

     if (!c) return NULL;

     if (strlen(c) != 0) {
	  a = g_byte_array_new();
	  g_byte_array_append(a, (guchar*)c, strlen(c));
     }
     g_free(c);     
     
     return a;
}






static void realize_text(GtkWidget *text, gpointer user_data)
{
     /* go through great lenghts to calculate the line height */
     
     int height;
     PangoContext   *ctx   = gtk_widget_get_pango_context(GTK_WIDGET(text));
     PangoLayout    *lay   = pango_layout_new(ctx);
     PangoRectangle  rect;

     pango_layout_set_single_paragraph_mode(lay, FALSE);
     
     pango_layout_set_text(lay, "X\nX", 3); /* two lines */
     pango_layout_get_pixel_extents(lay, &rect, NULL);
     height = rect.height;

     pango_layout_set_text(lay, "X", 1); /* one line */
     pango_layout_get_pixel_extents(lay, &rect, NULL);

     height -= rect.height;  /* difference is height of one line ... */
     
     g_object_unref(lay);
     
     gtk_widget_set_size_request(GTK_WIDGET(text), 100, 
				 DEFAULT_LINES * height);
}

static void dt_text_set_data(struct formfill *form, GByteArray *data,
			     GtkWidget *widget) 
{
     GtkWidget *text = gtk_bin_get_child(GTK_BIN(widget));
     GtkTextBuffer *b = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));

     if (data) {
	  gtk_text_buffer_set_text(b, (gchar*) data->data, data->len);
	  gtk_signal_connect(GTK_OBJECT(text), "realize", 
			     (GtkSignalFunc) realize_text, NULL);
     }	  
}

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
