#include "config.h"

#include "connection.h"
#include "statement.h"
#include "result-set.h"
#include "database-metadata.h"

#include "gql++/exception.h"

namespace GQL
{

namespace MySQL
{

using namespace std;

MyConnection::MyConnection(const string& host,
                           const string& port,
                           const map<string, string>& info,
                           const string& db,
                           const string& url,
                           MyDriver *driver)
{
  map<string, string>::const_iterator user, password;
  bool ok;
  
  if ((user = info.find("user")) == info.end())
    throw SQLException("The user property is missing. It is manadatory");
  if ((password = info.find("password")) == info.end())
    throw SQLException("The password property is missing. It is manadatory");
  
  auto_commit_ = true;
  driver_ = driver;
  url_ = url;
  database_ = db;
  port_ = port;
  host_ = host;

  conn_ = mysql_init(NULL);
  ok = mysql_real_connect(conn_, host.c_str(),
                          (*user).second.c_str(), (*password).second.c_str(),
                          db.c_str(), atoi(port.c_str()), NULL, 0);

  if (!ok)
    throw SQLException(string("Connection failed: ") + mysql_error(conn_));

  driver_->reference();
  
  metadata_ = 0;
}

MyConnection::~MyConnection()
{
  driver_->unreference();
  
  mysql_close(conn_);
  
  if (metadata_)
    metadata_->unreference();
}

Statement *MyConnection::create_statement()
{
  return manage(new MyStatement(this));
}

PreparedStatement *MyConnection::prepare_statement(const string& url)
{
  return 0;
}

CallableStatement * MyConnection::prepare_call(const string& url)
{
  return 0;
}

void MyConnection::commit()
{
  exec_sql("COMMIT");
  if (auto_commit_ == false)
    exec_sql("BEGIN");
}

void MyConnection::set_auto_commit(bool auto_commit)
{
  if (auto_commit_ == auto_commit)
    return;

  if (auto_commit == false)
  {
    // We leave MySQL always in autocommit mode, and "BEGIN"
    // transactions explicitly
    exec_sql("BEGIN");
  }

  auto_commit_ = auto_commit;
}

void MyConnection::rollback()
{
  exec_sql("ROLLBACK");
  if (auto_commit_ == false)
    exec_sql("BEGIN");
}

string MyConnection::get_catalog() const
{
  string empty;
  
  return empty;
}

string MyConnection::native_sql(const string& sql) const
{
  return sql;
}

DatabaseMetaData *MyConnection::get_meta_data()
{
  if (!metadata_)
  {
    metadata_ = manage(new MyDatabaseMetaData(this));
    metadata_->reference();
  }
  return metadata_;
}

MYSQL_RES *MyConnection::exec_sql(const string& sql)
{
  MYSQL_RES *res;
  
  if (mysql_real_query(conn_, sql.c_str(), sql.length()) != 0 ||
      ((res = mysql_store_result(conn_)) == 0 && 
       mysql_field_count(conn_) != 0))
    throw SQLException(mysql_error(conn_));
  
  return res;
}

}
}
