#include "config.h"

#include <stdlib.h>

#include <iostream>
#include <string>

#include "gql++/driver-manager.h"
#include "gql++/exception.h"
#include "gql++/result-set.h"
#include "gql++/statement.h"
#include "gql++/database-metadata.h"

using namespace GQL;
using namespace std;

static void usage();
static void write_row(const string& name,
                      const string& first_name,
                      const string& birthday,
                      const string& street,
                      const string& zip,
                      const string& country,
                      const string& place,
                      const string& phone);

int main(int argc, char *argv[])
{
  DriverManager man;
  string driver, db, user, passwd;
  string first_name, last_name;
  
  if (argc != 7)
  {
    usage();
    exit(EXIT_FAILURE);
  }

  driver = argv[1];
  db = argv[2];
  user = argv[3];
  passwd = argv[4];
  first_name = strlen(argv[5]) == 0 ? "%" : argv[5];
  last_name = strlen(argv[6]) == 0 ? "%" : argv[6];

  try
  {
    Connection *conn = man.get_connection("gql:" + driver + ":" + db,
                                          user, passwd);
    Statement *stmt = conn->create_statement();
    SQLObject *str_o = conn->create_object();
    ResultSet *persons, *phones, *addresses;
    int j;

    string query;
    string person_id, birthday;
    string phone;
    string addr_id, street, zip, country, place;

    query = "SELECT id, name, first_name, birthday FROM person WHERE "
      "person.name LIKE '" + last_name + "' AND "
      "person.first_name LIKE '" + first_name + "'";
    persons = stmt->execute_query(query);
    
    for (int i = 0; persons->next(); i++)
    {
      persons->get(0, str_o), person_id = str_o->to_string();
      persons->get(1, str_o), last_name = str_o->to_string();
      persons->get(2, str_o), first_name = str_o->to_string();
      persons->get(3, str_o), birthday = str_o->to_string();
      
      phones = stmt->execute_query(
              "SELECT number FROM person, pers_phone, phone WHERE "
              "person.id = " + person_id + " AND "
              "person.id = pers_phone.pers_id AND "
              "pers_phone.phone_id = phone.id");
      for (j = 0; phones->next(); j++)
      {
        phones->get(0, str_o);
        write_row(last_name, first_name, birthday, "", "", "", "",
                  str_o->to_string());
      }
      delete phones;
      
      if (j > 0)
        last_name = first_name = birthday = phone = "";

      addresses = stmt->execute_query(
              "SELECT address.id, street, zip, country, place "
              "FROM pers_addr, address WHERE "
              "pers_addr.pers_id = " + person_id + " AND "
              "pers_addr.addr_id = address.id");
      while (addresses->next())
      {
        addresses->get(0, str_o), addr_id = str_o->to_string();
        addresses->get(1, str_o), street = str_o->to_string();
        addresses->get(2, str_o), zip = str_o->to_string();
        addresses->get(3, str_o), country = str_o->to_string();
        addresses->get(4, str_o), place = str_o->to_string();
        
        phones = stmt->execute_query(
                "SELECT number FROM addr_phone, phone WHERE "
                "addr_phone.addr_id = " + addr_id + " AND "
                "addr_phone.phone_id = phone.id");
        for (int k = 0; phones->next(); k++)
        {
          phones->get(0, str_o), phone = str_o->to_string();
          if (k == 1)
            street = "", zip = "", country = "", place = "";
          write_row(last_name, first_name, birthday, street, zip,
                    country, place, phone);
        }
      }
    }
  }
  catch (SQLException e)
  {
    cout << "SQLException: " << e.what() << endl;
    return(EXIT_FAILURE);
  }
  
  
  man.deregister_driver(driver);
}

static void usage()
{
  cout << "usage: simple <driver> <database> <username> <pwd> <first_name> <last_name>" << endl;
}

static void write_row(const string& name,
                      const string& first_name,
                      const string& birthday,
                      const string& street,
                      const string& zip,
                      const string& country,
                      const string& place,
                      const string& phone)
{
  cout << name << "\t" << first_name << "\t" << birthday << "\t"
       << street << "\t" << zip << "\t" << country << "\t" << place << "\t"
       << phone << endl;
}
