// mandel.c : demo for the Mandelbrot set
// wolf 1/97 - 3/00

#include "window.h"
#undef Complex
#include <Complex.h>

static int itmax = 256, limit = 100;
static char *itmenue = "itmax", *limenue = "limit";

inline int iterate(const Complex& c) {
  int it = 0;
  // Complex z = 0;
  //  do { z = z*z + c; if (++it == itmax) break; } while (norm(z) < limit); return it;
  double cx = real(c), cy = imag(c); 
  double x = cx, y = cy;
  for (; ++it < itmax;) { 
    double x2 = x*x, y2 = y*y; 
    if (x2+y2 > limit) break;
    y = 2*x*y + cy; x = x2-y2 + cx; 
  } 
  return it;
}

main_window *newman(double x1, double y1, double x2, double y2, Bool top=False);

class mandel_win : public coord_window {
  info_window *iw;
public:
  mandel_win(window &parent, int nx, int ny, info_window *iw) :
  coord_window(parent,nx,ny,0,0), iw(iw) {
    selection_mask |= ButtonPressMask | ButtonReleaseMask | PointerMotionMask;
  }
  XPoint p1,p2;
  void BPress_1_CB(XButtonEvent ev) {
    p1.x = ev.x; p1.y = ev.y;
    p2 = p1;
  }
  void BRelease_CB(XButtonEvent ) {   
    if (fabs(p2.x-p1.x) + fabs(p2.y-p1.y) > 20) {
      main_window *mw= newman(x_org(p1.x),x_org(p2.x),y_org(p2.y),y_org(p1.y));
      mw->RealizeChildren();
    }
  }
  void Motion_CB(XMotionEvent ev) { 
    if (ev.state & Button1Mask) { 
      // clear old rect
      XDrawRectangle(display,Win,gc_rubber,p1.x-1, p1.y-1,p2.x - p1.x + 2, p2.y - p1.y + 2);
      p2.x = ev.x; p2.y = ev.y;
      XDrawRectangle(display,Win,gc_rubber,p1.x-1, p1.y-1, p2.x - p1.x + 2, p2.y - p1.y + 2);
    }
    else {     
      double x=x_org(ev.x), y=y_org(ev.y);
      sprintf(iw->info,"z = %8.5f + %8.5fi it=%4d %5d %5d",x,y,iterate(Complex(x,y)),itmax,limit);
      iw->redraw();
    }
  }
  void draw_interior() {
    int nx = width, ny = height;
    for (int y = 0; y < ny; y++) {
      for (int x = 0; x < nx; x++) {
	Complex c(x_org(x),y_org(y));
	int it = iterate(c);
	static int cmax = 0xffff;
	int col = cmax - (it*cmax)/itmax;
	set_color(col);
	DrawPoint(x,y);
      } // to show the progress :
      XCopyArea(display,pix, Win, gc_copy, 0, y, width, 1, 0, y);
      XMapWindow(display, Win); 
    } 
    set_color(black);
  }
  virtual void action(char* menu, char *value) {
    if (menu == itmenue) itmax = atoi(value); else limit = atoi(value);
    redraw();
  } 

};

main_window * newman(double x1, double x2, double y1, double y2, Bool top) {
  int nx = 400, ny = 320; 
  char str[200]; sprintf(str,"x [%g+%g] y [%g+%g]",x1,x2-x1,y1,y2-y1);
  static int xm = 20, ym = 100; // window pos 
  main_window *mw = new main_window(str,nx,ny,1,xm,ym);
  xm += 20; ym += 20;
  info_window *iw = new info_window(*mw,nx,20,0,ny-20);
  mandel_win *cw = new mandel_win(*mw,nx,ny-20,iw);
  cw->define_coord(x1,y1,x2,y2);
  menu_bar *mb = new menu_bar(*mw,nx,20,0,0,70,100,0);
  if (top) new quit_button(*mb);
  char *it_list[] = {"16","32","64","128","256","512","1024","2048","4096",0};
  char *li_list[] = {"10","20","40","80","150","400","1000","2000","4000",0};
  make_radio_menu(*mb,itmenue,it_list,cw);
  make_radio_menu(*mb,limenue,li_list,cw);
  return mw;
}

int main() {
  main_window *mw = newman(-2,0.5,-1,1,True);    
  mw->main_loop();
}










