// -*- c++ -*-
// Generated by assa-genesis
//------------------------------------------------------------------------------
// $Id: MainWindow.cpp,v 1.66 2008/02/04 04:02:21 vlg Exp $
//------------------------------------------------------------------------------
//                            MainWindow.cpp
//------------------------------------------------------------------------------
//  Copyright (c) 2004-2007 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License   
//  as published by the Free Software Foundation; either version  
//  2 of the License, or (at your option) any later version.      
//------------------------------------------------------------------------------
//
// Date   : Wed Dec 31 23:18:34 2003
//
//------------------------------------------------------------------------------

#include <gtkmm/stock.h>
#include <gtkmm/menu.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/filechooserdialog.h>
#include <gdkmm/pixbuf.h>
#include <gdkmm/image.h>
#include <gtkmm/scrolledwindow.h>

#ifdef IS_HILDON
#  include <libosso.h>
#endif

#include "Granule-main.h"
#include "Granule.h"
#include "MainWindow.h"
#include "GrappConf.h"
#include "DeckList.h"
#include "CardBox.h"
#include "PrefWindow.h"
#include "CardBoxPrefsWindow.h"
#include "AboutGRAPP.h"
#include "FileOpenDialog.h"
#include "FileSaveDialog.h"
#include "FolderChooseDialog.h"

// i18n macros - always last
#include "Intern.h"				

//==============================================================================
//                          Static locals
//==============================================================================

const char* MainWindow::states [] = { "Start", "Dirty", "Clean", "Finish" };

static void 
destroy_handler ()
{
	trace_with_mask("[static] destroy_handler",GUITRACE);

	/* From Gtk 1.2 man pages:
	 *  "Makes the innermost invocation of the main loop return when it 
	 *   regains control."
	 */
	DL((GRAPP,"Stop main Gtk+ event loop.\n"));
    Gtk::Main::quit ();
}

//==============================================================================

MainWindow::
MainWindow () :
    m_state (Start),
    m_top_menu_bar (*this, m_deck_manager),
    m_open_item (NULL),
    m_app_title (PACKAGE),
    m_pref_window (NULL),
    m_cb_prefs_window (NULL),
    m_about (NULL)
{
    trace_with_mask("MainWindow::MainWindow",GUITRACE);

    int x = 0;
    int y = 0;

    m_app_title += "-" + string (VERSION);

    /** For OE, put main window in a scrollwindow
     */
#if defined (IS_PDA)
    Gtk::ScrolledWindow* scrollw = Gtk::manage (new Gtk::ScrolledWindow);
    scrollw->set_flags       (Gtk::CAN_FOCUS);
    scrollw->set_shadow_type (Gtk::SHADOW_NONE);
    scrollw->set_policy      (Gtk::POLICY_AUTOMATIC , Gtk::POLICY_AUTOMATIC);
    add (*scrollw);
    scrollw->add (m_contents);
#else
    add (m_contents);
#endif

    set_title (_(m_app_title.c_str ()));
    set_border_width (2);

#if !defined (IS_HILDON)
    /**
     * AppView is a Bin and thus doesn't have any of the Gtk::Window
     * attributes.
     */
    set_resizable ();
    
    Gdk::Rectangle geom = CONFIG->get_main_window_geometry ();
    set_size_request (geom.get_width (), geom.get_height ());
    
    CONFIG->get_win_position (x, y);
    move (x, y);
#endif

    /** Menu & Toolbar
     */
#ifdef IS_HILDON
	set_menu (m_main_menu);
#endif 

    install_menus_and_toolbar ();

    /** Here go the guts of the main window (6 - spacing between cells).
     */
    Gtk::HBox* hbox = manage (new Gtk::HBox (false, 6));

    Gtk::Frame* frame = manage (new Gtk::Frame);
    frame->set_label (_("CardBox"));
    m_cardbox = manage (new CardBox (*this));
    frame->add (*m_cardbox);
    hbox->pack_start (*frame, Gtk::PACK_SHRINK);

    frame = manage (new Gtk::Frame);
    frame->set_border_width (8);
    m_deck_list = manage (new DeckList);

    m_top_menu_bar.set_deck_sensitivity (false, m_deck_list->size ());
    frame->add (*m_deck_list);
    hbox->pack_end (*frame);
    m_contents.pack_start (*hbox, Gtk::PACK_EXPAND_WIDGET);
    m_top_menu_bar.set_sensitivity (m_state);

#if !defined (IS_HILDON) && !defined (WIN32)
    set_icon_from_file (DATDIR "/pixmaps/granule.png");
#endif

    DL ((GRAPP,"Set Application icon\n"));
	
    signal_size_allocate ().connect (
	sigc::mem_fun (*this, &MainWindow::size_allocate_cb));

	m_deck_list->signal_mouse_clicked ().connect (
		sigc::mem_fun (*m_cardbox, &CardBox::mask_out_unused_boxes));

	signal_delete_event ().connect (
		sigc::mem_fun (*this, &MainWindow::delete_event_cb));

    show_all ();
	m_cardbox->mask_out_unused_boxes ();
}


MainWindow::
~MainWindow ()
{
    trace_with_mask("MainWindow::~MainWindow",GUITRACE);

    if (m_pref_window != NULL) {
		delete m_pref_window;
		m_pref_window = NULL;
    }

    if (m_cb_prefs_window != NULL) {
		delete m_cb_prefs_window;
		m_cb_prefs_window = NULL;
    }
	
    if (m_about != NULL) {
        delete m_about;
        m_about = NULL;
    }
}

void
MainWindow::
init ()
{
    trace_with_mask("MainWindow::init",GUITRACE);

	m_deck_list->init_popup_menu ();
}

void
MainWindow::
about_cb ()
{
    if (m_about == NULL) {
        m_about = new AboutGRAPP;
        m_about->set_transient_for (*this);
    }
    m_about->run ();
}

void
MainWindow::
size_allocate_cb (Gtk::Allocation& allocation_)
{
    trace_with_mask("MainWindow::size_allocate_cb",GEOM);

    CONFIG->set_main_window_geometry (allocation_.get_width (),
				      allocation_.get_height ());
}

void 
MainWindow::
install_menus_and_toolbar ()
{
    trace_with_mask("MainWindow::install_menus_and_toolbar",GUITRACE);

    /** Create top menu bar 
     *  ---------------------------------------
     *   [File]                          [Help]
     *  ---------------------------------------
     */
    m_top_menu_bar.create ();
    m_contents.pack_start (*m_top_menu_bar.get_menu_bar (), Gtk::PACK_SHRINK);
}

bool
MainWindow::
//on_delete_event (GdkEventAny* /*event_*/)
delete_event_cb (GdkEventAny* /*event_*/)
{
//    trace_with_mask("MainWindow::on_delete_event",GUITRACE);
    trace_with_mask("MainWindow::delete_event_cb",GUITRACE);

    exit_cb ();
    this->hide ();
    GRANULE->stop_service ();
    
    return true;
}

//==============================================================================
// Callbacks (external events)
//==============================================================================
void
MainWindow::
new_cb ()
{
    trace_with_mask("MainWindow::new_cb",GUITRACE);

    switch (m_state)
	{
	case Start:	 
	{
		m_cardbox->new_file ();
		go_state (Dirty); 
		Gtk::MessageDialog e0 (
			_("You have just created a new CardFile.\n\n"
			  "Before adding any cards to it,\n"
			  "please, review default card repetition\n"
			  "schedule found under CardFile->Preferences\n"
			  "and adjust it to your liking."));
		e0.run ();
	}
	break;

	case Dirty:  /* ignored */    
	{
		Gtk::MessageDialog e1 (
			_("Project has been modified.\nPlease, save and close it first"),
			MESSAGE_ERROR);
		e1.run ();
	}
	break;

	case Clean:  /* ignored */    
	{
		Gtk::MessageDialog e2 (_("Project is opened.\nPlease, close it first"),
							   MESSAGE_ERROR);
		e2.run ();
	}
	break;

	case Finish: /* ignored */    break;
	}
    print_state ();
}

void
MainWindow::
open_cb ()
{
    trace_with_mask("MainWindow::open_cb",GUITRACE);
    
    // Switch the state
    switch (m_state) {

	case Start:	
		go_state (Clean);
		if (open_file () < 0) {
			go_state (Start);
		}
		m_top_menu_bar.add_history ();
		break;

	case Dirty:  /* ignored */
	{
		Gtk::MessageDialog emsg (
			_("Project has been modified\nPlease, save and close it first"),
			MESSAGE_ERROR);
		emsg.run ();
	}
	break;

	case Clean:  /* ignored */ 
	{
		Gtk::MessageDialog emsg2 (
			_("Project is opened\nPlease, close it first"),
								  MESSAGE_ERROR);
		emsg2.run ();
	}
	break;

	case Finish: /* ignored */    
		break;
	}
    print_state ();
}

void
MainWindow::
open_recent_cb (guint index_)
{
    trace_with_mask("MainWindow::open_recent_cb",GUITRACE);

    // Switch the state
    switch (m_state) {
	case Start:	
	{
		go_state (Clean); 
		const char* doc = (CONFIG->get_document_history () [index_]).c_str ();

		DL((TRACE,"Opening [%d] \"%s\"\n", index_, doc));
		if (m_cardbox->load (doc) < 0) {
			DL((TRACE,"Opening CardFile failed - removing from history\n"));
			Gtk::MessageDialog emsg0 ("CardFile you selected cannot be opened!",
									  Gtk::MESSAGE_ERROR);
			emsg0.run ();
			CONFIG->remove_document_history (doc);
			m_top_menu_bar.refill_history_list ();
			go_state (Start);
		}
		break;
	}
	case Dirty:  /* ignored */    
	{
		Gtk::MessageDialog emsg1 (
			_("Project has been modified.\nPlease, save and close it first"),
			MESSAGE_ERROR);
		emsg1.run ();
	}
	break;
	case Clean:  /* ignored */    
	{
		Gtk::MessageDialog emsg2 (
			_("Project is opened.\nPlease, close it first"),
			MESSAGE_ERROR);
		emsg2.run ();
	}
	break;
	case Finish: /* ignored */    break;
	}
    print_state ();
}

void
MainWindow::
save_cb ()
{
    trace_with_mask("MainWindow::save_cb",GUITRACE);

    switch (m_state) {
    case Start:	 /* ignored */    
	{
		Gtk::MessageDialog e1 (_("Please open or create\nproject first"),
							   MESSAGE_ERROR);
		e1.run ();
	}
	break;

    case Dirty:  
		save_file (); 
		go_state (Clean); 
		set_mw_name ();
		break;

    case Clean:  /* ignored */    
	{
		Gtk::MessageDialog e2 (
			_("Project is not modified.\nClose it to proceed."), MESSAGE_ERROR);
		e2.run ();
	}
	break;

    case Finish: /* ignored */    break;
    }
    print_state ();
}

void
MainWindow::
save_as_cb ()
{
    trace_with_mask("MainWindow::save_as_cb",GUITRACE);

	bool was_dirty = false;

    switch (m_state)
	{
	case Start:	 /* ignored */    
	{
		Gtk::MessageDialog emsg (
			_("Please open or create\nproject first"), MESSAGE_ERROR);
		emsg.run ();
	}
	break;

	case Dirty:  
		was_dirty = true;
		go_state (Clean); 

	case Clean:  
		if (save_file_as () < 0 && was_dirty) {
			go_state (Dirty);
		}
		set_mw_name ();
		break;

	case Finish: /* ignored */    break;
	}
    print_state ();
}

void
MainWindow::
export_sound_cb ()
{
    trace_with_mask("MainWindow::export_sound_cb",GUITRACE);

    switch (m_state) {
	case Start:	 /* ignored */    
	{
		Gtk::MessageDialog emsg (
			_("Please open or create\nCardBox first"), MESSAGE_ERROR);
		emsg.run ();
	}
	break;

	case Dirty:  
	case Clean:
		export_sound_bits ();
		break;

	case Finish: /* ignored */    
		break;
	}

    print_state ();
}

void
MainWindow::
close_cb ()
{
    trace_with_mask("MainWindow::close_cb",GUITRACE);
    // Switch the state

    switch (m_state) {
    case Start:	 /* ignored */ 	break;
		/** 
		 * No 'break' in Dirty state, for the transition Clean->Start
		 * is an internal unconditional event.
		 */
    case Dirty:  
		go_state (Clean); 
		save_file (); 

    case Clean:  
		go_state (Start); 
		m_top_menu_bar.add_history ();
		set_title (_(m_app_title.c_str ())); // clear up title of old project name
		m_cardbox->close ();
		break;

    case Finish: /* ignored */ 	break;
    }
    print_state ();
}

void
MainWindow::
exit_cb ()
{
    trace_with_mask("MainWindow::exit_cb",GUITRACE);

    switch (m_state)
	{
	case Dirty:
	{
		go_state (Clean); 
		save_file (); 
		m_top_menu_bar.add_history ();
	}
	case Start:	case Clean:
	{
		int x, y;
		CONFIG->dont_save_project ();
		DECKMGR->save_all_deck_cb ();
#ifndef IS_HILDON
		get_position (x, y);
		CONFIG->set_win_position (x, y);
#endif
		CONFIG->save_config ();
		destroy_handler (); 
		go_state (Finish); 
	}
	break;

	case Finish: /* ignored */ break;
	}
    print_state ();
}

void 
MainWindow::
pref_cb ()
{
    trace_with_mask("MainWindow::pref_cb",GUITRACE);

	change_preferences (); 
}

void 
MainWindow::
unselect_deck_cb ()
{
    trace_with_mask("MainWindow::unselect_deck_cb",GUITRACE);

	if (m_deck_list) {
		m_deck_list->unselect ();
		m_top_menu_bar.set_deck_sensitivity (false, m_deck_list->size ());
	}
}

void 
MainWindow::
cardbox_prefs_cb ()
{
    trace_with_mask("MainWindow::cardbox_prefs_cb",GUITRACE);

	bool changes_applied;

	if (m_cb_prefs_window == NULL) {
		m_cb_prefs_window = new CardBoxPrefsWindow (*this);
	}

	if (m_cardbox == NULL) {
		DL ((GRAPP, "OOPS, m_cardbox == NULL (expected valid object)!\n"));
		return;
	}

	m_cb_prefs_window->load_from_config (m_cardbox->sched_db ());

	changes_applied = m_cb_prefs_window->run ();

	DL ((GRAPP, "CardBox preferences %s\n", 
		 changes_applied ? "changed" : "unchanged"));

	if (changes_applied) 
	{
		m_cb_prefs_window->save_to_config (m_cardbox->sched_db ());

		if (m_cb_prefs_window->efactor_changed ()) {
			m_cardbox->adjust_efactor ();
		}

		if (m_cb_prefs_window->capacity_changed ()) {
			m_cardbox->adjust_cardbox_tray ();
		}

		/** Move cards around. It is necessary to redistribute
		 *  cards even if the only thing changed was E-Factor.
		 */
		m_cardbox->normalize_cards ();
	}
}

//==============================================================================
//                          Internal Actions
//==============================================================================
int
MainWindow::
open_file ()
{
    trace_with_mask("MainWindow::open_file",GUITRACE);

	FileOpenDialog f (_("Select Card File"), this,
						"CardFile",	"*" CARD_FILE_EXT);

    if (f.run () != Gtk::RESPONSE_OK) {
		return -1;
    }
	
    return (m_cardbox->load (f.get_filename ())); 
}

int
MainWindow::
save_file ()
{
    trace_with_mask("MainWindow::save",GUITRACE);

	string projname = CONFIG->get_proj_name ();

	if (projname == UNKNOWN_FNAME) 
	{
		FileSaveDialog f (_("Choose New CardFile name"), this,
							"CardFile", "*" CARD_FILE_EXT);

		f.set_current_name ("Unknown.cdf");

		if (f.run () != Gtk::RESPONSE_OK) {
			return -1;
		}
		m_cardbox->save_as (f.get_filename ());
	}
	else {
		m_cardbox->save ();
	}
	return 0;
}

/**
 * Set window title
 */
void
MainWindow::
set_mw_name (void) 
{
    trace_with_mask("MainWindow::set_mw_name",GUITRACE);

    string title (m_app_title);
    string p (CONFIG->get_proj_name ());
    DL((TRACE,"project_name = \"%s\"\n",p.c_str ()));
    if (p.size () != 0) {
		title = p + " : " + title;
    }
    set_title (_(title.c_str ()));
}

int
MainWindow::
save_file_as ()
{
    trace_with_mask("MainWindow::save_file_as",GUITRACE);

	FileSaveDialog f (_("Save Card File As ..."), this,
						"CardFile", "*" CARD_FILE_EXT);

	if (f.run () != Gtk::RESPONSE_OK) {
		return -1;
	}

	m_cardbox->save_as (f.get_filename ());
	return 0;
}

int
MainWindow::
export_sound_bits ()
{
    trace_with_mask("MainWindow::export_sound_bits",GUITRACE);

#ifdef IS_HILDON

	Gtk::MessageDialog emsg (
			_("This feature is only\nactive on a desktop."), MESSAGE_ERROR);
	emsg.run ();

#else

	FolderChooseDialog f (_("Select A Folder To Export To"), this);

	if (f.run () != Gtk::RESPONSE_OK) {
		return -1;
	}

	if (!g_file_test (f.get_filename ().c_str (), G_FILE_TEST_IS_DIR)) {
		Gtk::MessageDialog emsg (_("Invalid folder path!"), MESSAGE_ERROR);
		emsg.run ();
		return -1;
	}

	DL((GRAPP,"Copy Sound-Bites to dir: \"%s\"\n", f.get_filename ().c_str ()));
	m_cardbox->export_sound_bits (f.get_filename ());

#endif

	return 0;
}

/**
 * Return: true if preference(s) has been changed; false otherwise
 */
bool
MainWindow::
change_preferences ()
{
    trace_with_mask("MainWindow::change_preferences",GUITRACE);
	bool ret;

    if (m_pref_window == NULL) {
		m_pref_window = new PrefWindow (*this);
    }
    
    if ((ret = m_pref_window->run ()) == true) {
		m_deck_manager.repaint_deck_players ();
		if (m_cardbox) {
			m_cardbox->repaint_deck_players ();
		}
	}
    DL((GRAPP,"Preferences %s\n", ret ? "changed" : "unchanged"));

    return ret;
}

//==============================================================================
// Utilities
//==============================================================================

void
MainWindow::
play_in_box (int idx_)
{
    trace_with_mask("MainWindow::play_in_box",GUITRACE);

	DL((GRAPP,"Starting DeckPlayer for box # %d\n", idx_));
	if (m_cardbox != NULL) 
	{
		hide ();
		m_cardbox->play_deck (idx_);
		show ();
		m_cardbox->mask_out_unused_boxes ();
	}
}

void
MainWindow::
print_state (void) const
{
    DL((APP,"Current state: \"%s\"\n", states [m_state]));
}

void
MainWindow::
go_state (WMState state_)
{
    DL((APP,"Changing state \"%s\" => \"%s\"\n", 
		states [m_state], states [state_]));
    m_state = state_;
    m_top_menu_bar.set_sensitivity (state_);
}

