/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Chat room interface.
 */

#import <Grouch/GrouchClient.h>
#import <Foundation/NSObject.h>

@class NSString, NSWindow, NSScrollView, NSTextView, NSTextField;
@class NSTableView;
@class NSMutableDictionary, NSAttributedString;
@class NSMenu;

@class ClientInstance;

@interface Channel : NSObject <GrouchChannel>
{
	NSWindow *window;
	NSScrollView *scroll;
	NSTextView *output;
	NSTextView *input;
	NSTableView *tableView;

	ClientInstance *cli;
	NSString *room;
	NSMutableDictionary *users;

	BOOL haveLeft;

	NSMenu *contextMenu;
}

+ channelForRoom:(NSString*)roomName andClient:(ClientInstance*)instance;
- initForRoom:(NSString*)roomName andClient:(ClientInstance*)instance;
- (void)dealloc;

- (void)append:(NSAttributedString*)str;
- (void)reloadData;
- (void)removeUsers;

- (void)welcome;
- (void)bye;
- (void)join:(NSString*)user;
- (void)part:(NSString*)user;
- (void)message:(NSString*)msg from:(NSString*)user
	withFlags:(GrouchMessageFlags)flags;

@end
