/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <LoginWindow.h>
#import <ClientInstance.h>
#import <Defaults.h>
#import <ErrorWindow.h>
#import <Loader.h>

#import <Grouch/GrouchStringTool.h>

#import <Renaissance/Renaissance.h>

#import <Foundation/NSCharacterSet.h>

static NSString *selectedUserDefault	= @"Current Login";
static NSString *protocolDefault	= @"Protocol";
static NSString *loginDefault		= @"Login";
static NSString *passwordDefault	= @"Password";
static NSString *hostDefault		= @"Host";
static NSString *portDefault		= @"Port";

static BOOL notInt( NSString *str );

@implementation LoginWindow

- init
{
	[NSBundle loadGSMarkupNamed:@"LoginWindow" owner:self];
	[window orderFront:nil];
	[window makeKeyWindow];
	[protoComboBox addItemsWithObjectValues:[Loader getProtocols]];
	if( [protoComboBox numberOfItems] )
	{
		[protoComboBox selectItemAtIndex:0];
		[protoComboBox setObjectValue:
		 [protoComboBox objectValueOfSelectedItem]];
	}
	[accountComboBox setCompletes:YES];
	{
		NSDictionary *allUsers;
		NSEnumerator *nicks;
		NSString *nick;

		allUsers = [Defaults getSavedUsers];
		nicks = [allUsers keyEnumerator];

		while( (nick=[nicks nextObject]) )
			[accountComboBox addItemWithObjectValue:nick];

		if( (nick=[Defaults get:selectedUserDefault]) )
		{
			[accountComboBox setStringValue:nick];
			[self gotAccount];
			[self gotLogin];
		}
	}
	return self;
}

- (BOOL)windowShouldClose:sender
{
	[window autorelease];
	[hostField release];
	[portField release];
	[protoComboBox release];
	[accountComboBox release];
	[loginField release];
	[passwordField release];
	[saveCheckBox release];
	[self release];
	return YES;
}

- (void)connect
{
	NSString *protocol;
	NSString *account;
	NSString *host, *port;
	NSString *user, *password;
	int portI;
	BOOL save = [saveCheckBox state] == NSOnState;

	protocol = [protoComboBox stringValue];
	account = [accountComboBox stringValue];
	host = [hostField stringValue];
	port = [portField stringValue];
	user = [loginField stringValue];
	password = [passwordField stringValue];

	if( ![account length] || ![host length] || ![port length]
	 || ![user length] )
	{
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"vague-form"]];
		return;
	}
	if( !password )
		password = @"";

	if( notInt(port) )
		goto error;
	portI = [port intValue];
	if( portI < 0 || portI > 65535 )
	{
	error:
		[ErrorWindow errorWithString:
		 [GrouchString getString:@"not-port"]];
		return;
	}

	if( save )
	{
		[Defaults setSavedUserInfo:protocol forKey:protocolDefault
		 andUser:account];
		[Defaults setSavedUserInfo:password forKey:passwordDefault
		 andUser:account];
		[Defaults setSavedUserInfo:host forKey:hostDefault
		 andUser:account];
		[Defaults setSavedUserInfo:port forKey:portDefault
		 andUser:account];
	}
	else
		[Defaults removeSavedUser:user];
	[Defaults set:user forKey:selectedUserDefault];

	[Loader loadProtocol:protocol
	        withHost:host atPort:portI
		withLogin:user andPassword:password];

	[window performClose:self];
}

- (void)gotHost
{
	[window makeFirstResponder:portField];
}
- (void)gotPort
{
	[window makeFirstResponder:accountComboBox];
}
- (void)gotAccount
{
	NSString *protocol, *host, *login, *port, *password;
	NSDictionary *user;

	[window makeFirstResponder:loginField];

	user = [Defaults getSavedUser:[accountComboBox stringValue]];
	if( user )
	{
		protocol = [user objectForKey:protocolDefault];
		host = [user objectForKey:hostDefault];
		port = [user objectForKey:portDefault];
		login = [user objectForKey:loginDefault];
		password = [user objectForKey:passwordDefault];

		if( !protocol )
			protocol = @"Oscar";

		if( protocol )
			[protoComboBox setStringValue:protocol];
		if( host )
			[hostField setStringValue:host];
		if( port )
			[portField setStringValue:port];
		if( login )
			[loginField setStringValue:login];
		if( password )
			[passwordField setStringValue:password];

		[saveCheckBox setState:NSOnState];	
	}
}
- (void)gotLogin
{
	[window makeFirstResponder:passwordField];
}

@end

static BOOL notInt( NSString *str )
{
	int i;
	NSCharacterSet *numeric, *whitespace;
	numeric = [NSCharacterSet decimalDigitCharacterSet];
	whitespace = [NSCharacterSet whitespaceCharacterSet];
	for( i=0; i<[str length]; ++i )
	{
		unichar c = [str characterAtIndex:i];
		if( ![numeric characterIsMember:c] &&
		    ![whitespace characterIsMember:c] )
			return YES;
	}
	return NO;
}
