/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _BALL_H_
#define _BALL_H_

#include <list>

class Element;

class Ball {
public:
   typedef enum {Red, Green, Blue, Yellow} Color;
   typedef enum {NotMoving, MovingLeft, MovingUp, MovingRight, 
		 MovingDown} Direction;
private:
   Element* 		_element;
   Ball::Direction 	_direction;
   Ball::Color		_color;
public:   
   Ball(Ball::Color color);
   void Move();
   void SetElement(Element* element) {_element = element;}
   Ball::Color GetColor() {return _color;}
   Ball::Direction GetDirection() {return _direction;}
   void SetDirection(Ball::Direction direction) {_direction = direction;}
};

class SetOffBalls {
   std::list<Ball*> _set;
public:
   SetOffBalls() {}
   void Add(Ball* ball) {_set.push_back(ball);}
   void MakeEmpty() {_set.erase(_set.begin(), _set.end());}
   bool Move();
};

#endif // _BALL_H_

