/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2001 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <iostream>
#include "score.h"

std::ostream&
operator<<(std::ostream& s, const Score& score)
{
   return s << "(\"" << score._name << "\" " << score._seconds << ')';
}

std::istream&
operator>>(std::istream& s, Score& score)
{
   char c;
   std::ios::fmtflags flag = s.flags();
   s.flags(flag & ~std::ios::skipws);

   score._name = "";
   s >> c >> c;
   do {
      if (c != '\"')
	 score._name += c;
      s >> c;
   } while (c != '\"');
   s.flags(flag);

   s >> score._seconds >> c;
   return s;
}

int
Score::operator<(Score& score)
{
   return _seconds < score._seconds;
}

bool 
ScoreList::IsNewHighScore(int seconds)
{
   std::list<Score>::iterator last = _list.end();
   return _list.size() < 10 || seconds < (*--last).GetSeconds();
}

void 
ScoreList::AddHighScore(Score& score)
{
   std::list<Score>::iterator i;
   for (i = _list.begin(); i != _list.end(); i++)
      if (score < *i)
	 break;
   if (i == _list.end()) {
      _list.push_back(score);
   } else {
      _list.insert(i, score);
      if (_list.size() > 10)
	 _list.pop_back();
   }
}

std::ostream&
operator<<(std::ostream& s, const ScoreList& slist)
{
   s << '(' << std::endl;
   for (std::list<Score>::const_iterator i = slist._list.begin(); 
	i != slist._list.end(); i++)
      s << *i << std::endl;
   return s << ')' << std::endl;
}

std::istream&
operator>>(std::istream& s, ScoreList& slist)
{
   char c;
   s >> c;
   s >> c;
   if (c == '(') {
      do {
	 Score score;
	 s.putback(c);
	 s >> score >> c;
	 slist._list.push_back(score);
      } while (c != ')');
   }
   return s;
}

