/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

/* Project: 	GRUB-CLIENT <http://www.grub.org>
 * module: 	Archive (crawler)
 * Author: 	Ledio Ago(lajesus@grub.org)
 * Date:	Feb 13, 2001	
 * File: 	CrawlerDB.h
 */
#ifndef _CrawlerDB_h_
#define _CrawlerDB_h_	1

#include <stdio.h>
#include <GrubExp.h>
#include "UtilDB.h"

/************************************************************************/

class CrawlerDB : public UtilDB {
public:
	CrawlerDB(char *file_db);

	~CrawlerDB();
	
	/*
	 * Method: 	GetCrawledUrl
	 * Description:	It will access the information stored in the
	 *		first record of the crawled urls table.  After
	 *		the information is obtained, the record will
	 *		be deleted.
	 * Input:	A URLHandler struct pointer.
	 * Return:	It will return a structure with the obtained 
	 *		information.
	 */	
	void GetCrawledUrl( URLHandler *handle )
		throw( GrubExp );

	/*
	 * Method:	InsertCrawledUrl
	 * Description:	It will insert a record in crawled urls table.
	 */
	void InsertCrawledUrl( URLHandler *handle )
		throw( GrubExp );

private:
	/* Table columns specific for this class */
	c4_StringProp 	col_URL;
	c4_BytesProp 	col_content;
	c4_IntProp 	col_CRC;
	c4_IntProp 	col_status;
	c4_StringProp 	col_mime;
	c4_StringProp 	col_redirURL;
};

#endif
