/*
Test program for the ClientDB features
Grub Project  <www.grub.org>
*/
#include <stdio.h>
#include "ClientDB.h"
#include <string.h>
#include <clog.h>
extern "C" {
#include <grubconf.h>
}

#define TestClientDb

Config_Info Config_File_Info;

int main( char *argv[], int argc )
{
	URLHandler *handle = NULL;
	char *url = "http://www.grub.org/";
	int url_len = strlen( url );
	
	char *str = "Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!Grub rules.  America rules!";
	int str_len = strlen( str );

	char *mime = "text/html";
	int mime_len = strlen(mime);

	char *redir_url = "http://www.grub.org/ledio";
	int redir_len = strlen( redir_url );

	Config_Info Config_File_Info;

	/* Create log object */
	clog_init( "testClientDB.log" );

	/* Testing ClientDB class */
	ClientDB *db = new ClientDB();
	

	for ( int j = 0; j < 20; j++ ) {

		/* Inserting records in the database */
		for ( int i = 0; i < 500; i++ ) {

			db->GetInsert( url, str_len,  7777 ); 
		
			if ( handle ) {
				delete handle;
			}
		}

		/* Printing Served urls table */
		printf("\nServed Urls Table\n");
/*		int rec_count = db->recordCount();
		for ( int k = 0; k < rec_count; k++ ) {
*/	
		while ( (handle = db->GetRetrieve()) ) {

			if ( handle )
			{
				printf("URL=[%s]; size=[%d]; CRC=[%d];\n",
					handle->URL,
					handle->size,
					handle->CRC
				);
			}	
			db->CrawlInsert( 
				handle->URL, str, handle->size,handle->CRC, NOSTATUS, mime, redir_url);

			if ( handle ) {
				delete handle; handle = NULL;
			}
		}

		/* Printing Crawled urls table */
		printf("\nCrawled Urls Table\n");
		while( db->recordCount() > 0 ) {
printf( "File = [%s], Line = [%d]\n", __FILE__, __LINE__ );
			handle = NULL;
			db->CrawlRetrieve( &handle );				

printf( "File = [%s], Line = [%d]\n", __FILE__, __LINE__ );
			if ( handle )
			{
				printf("URL=[%s]; content=[]; size=[%d]; CRC=[%d]; "
					"MIME=[%s]; status=[%d]; redirURL=[%s];\n",
					handle->URL,
		//			handle->content,
					handle->size,
					handle->CRC,
					handle->MIME,
					handle->status,
					handle->redirURL
				);
			}
printf( "File = [%s], Line = [%d]\n", __FILE__, __LINE__ );
			if ( handle ) {
				delete handle; handle = NULL;
			}
		}
	}
		return 0;
}

