#ifndef _XmlWrapper_H_
#define _XmlWrapper_H_

#ifdef _MSC_EXTENSIONS
#	undef _MSC_EXTENSIONS
#endif

#ifdef HAVE_LIBEXPAT
#include <expat.h>

#define ASSERT_HAVE_EXPAT() \
	do { \
	} while(0)

#else  /* HAVE_LIBEXPAT */
#define ASSERT_HAVE_EXPAT() \
	do { \
		error_msg = my_strdup( \
			"XML parser non-operational, as it wasn't compiled " \
			"with the Expat library " \
			"(http://expat.sourceforge.net/)" ); \
		error_line = -1; \
		return -1; \
	} while(0)

#endif  /* ! HAVE_LIBEXPAT */

#define TAG_LIST_SIZE 1024
#define TAGMSGS_SIZE 1024

class XmlWrapper {
public:
	XmlWrapper();
	~XmlWrapper();

	void setIndentChar( char new_char );
	const char *getData();
	void resetData();
	const char *lastErrorMsg();
	int lastErrorLineNumber();

	// creating an XML message

	void addSimpleHeader();
	void openElement( const char *el_name );
	void closeElement( const char *el_name );
	void addElementString( const char *el_name, const char *str );
	void addElementInt( const char *el_name, int value );
	void addElementDouble( const char *el_name, double value );

	// parsing an XML message

	// return 0, -1 on XML file error
	int parseData( const char *data );
	// return 0, -1 some overflow
	int parseDataResults( char **& tag_names, char **& tag_name_values,
		int& msgs_count );
//	const char *parsedValue( const char *tag_name );
	int parsedValueString( const char *tag_name, int index, char *& value );
	int parsedValueInteger( const char *tag_name, int index, int& value );
	int parsedValueDouble( const char *tag_name, int index, double& value );

	// private
private:

	void appendString( const char *str );
	void appendTagPair( const char *el_name, const char *str );
	void resetTags();
	const char *getTags();
	void pushTag( const char *tag_name );
	void popTag();
	void resetMsg();
	void appendMsg( const char *tag_name, const char *value );
	void appendIndent();
	// ret = 0 on success, -1 on overflow
	int getMsg( char **& tag_names, char **& tag_name_values,
		int& msgs_count );
	void callbackStartElement( const char *name );
	void callbackDataHandler( const char *data );
	void callbackEndElement();
	char *my_strdup( const char *str );

	char *page;
	unsigned int page_len;
	unsigned int doc_depth;

	char tag_list[TAG_LIST_SIZE];

	struct {

		char *tag_name[TAGMSGS_SIZE];
		char *value[TAGMSGS_SIZE];
	} tagmsgs;
	int tagmsgs_len;

	char indent_char;
#ifdef HAVE_LIBEXPAT
	XML_Parser xml_parser;
#endif

	// error variables
	char *error_msg;
	int error_line;

	friend void xmlw_startElement(
		void *ptr, const char *name, const char **atts);
	friend void xmlw_endElement(
		void *ptr, const char *name );
	friend void xmlw_dataHandler(
		void *ptr, const char *data, int data_len );

};

#endif  /* _XmlWrapper_H_ */
