#include "testgui.h"
#include "msgface.h"
#include "SocketComm.h"
#include "Msg.h"
#include "ConsoleFace.h"
#include "BaseFace.h"
#include <cstdio>
#include <cstdlib>
#include <ctime>
#include <climits>
#ifdef GRUB_UNIX
#include <sys/types.h>
#include <sys/socket.h>
#endif

#ifndef MSLEEP
// millisecond sleep
#ifdef GRUB_UNIX
#	define MSLEEP(t) \
	do { \
		if ( (int)t < 1000 ) \
			usleep(1000 * (int)t); \
		else \
			sleep( (int)t / 1000 ); \
	} while(0)
#else  /* GRUB_UNIX */
#	define MSLEEP(t) ::Sleep((int)t)
#endif  /* ! GRUB_UNIX */
#endif  /* MSLEEP */

#define MAXBUFSIZE 1024

enum GType { G_SLEEP, G_ACT, G_DATASIZE, G_SEND, G_RECV };

static FILE *g_fp = stdout;
static unsigned int g_id = 0;
static SOCKET srv_establish2(unsigned short portnum);

#define G_SLEEP_MIN 1
#define G_SLEEP_MAX 5
#define G_DATASIZE_MIN 1
#define G_DATASIZE_MAX 512
#define G_DISCONNECT_FREQ_MIN 1
#define G_DISCONNECT_FREQ_MAX 10

#define HOST "localhost"
#define PORT 3123

/* returns a number in range of 0 to top_limit-1 */
int g_myrand( int top_limit )
{
	static int g_myrand_init = 0;

	if ( ! g_myrand_init ) {

		g_myrand_init = 1;
		srand( time( NULL ) + g_id );
	}

	return rand() / ( RAND_MAX / top_limit );
}

#define USE_NO_ACK
 
#ifdef USE_NO_ACK
static int g_total_send = 0;
static int g_total_recv = 0;
#endif  /* USE_NO_ACK */

unsigned int g_rand( GType type )
{
	unsigned int ret = 0;
	switch (type) {
	case G_SLEEP:
		ret = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) + G_SLEEP_MIN;
		break;
	case G_ACT:
		ret = (unsigned int)( ( g_myrand(2) == 0 ) ? G_SEND : G_RECV );
//		ret = ((g_id == 0 ) ? G_SEND : G_RECV);
#ifdef USE_NO_ACK
		{
			int diff;
			diff = ( ( ret == (unsigned int)G_SEND ) ?
				g_total_send - g_total_recv :
				g_total_recv - g_total_send );
			if ( diff > 5 )
				ret = (unsigned int)(( ret == (unsigned int)G_SEND ) ?
					G_RECV : G_SEND );

			if ( ret == G_SEND )
				g_total_send++;
			else
				g_total_recv++;
		}
printf( "g_total_send %d, g_total_recv %d\n", g_total_send, g_total_recv );
#endif  /* USE_NO_ACK */
		break;
	case G_DATASIZE:
		ret = g_myrand( G_DATASIZE_MAX - G_DATASIZE_MIN + 1 ) +
			G_DATASIZE_MIN;
		break;
	}  /* end switch */

	return ret;
}

const char *g_datablock( unsigned int size )
{
	static char *block = NULL;

	if ( block )
		delete [] block;

	block = new char[size + 1];
	for ( unsigned int i = 0; i < size; i++ )
		block[i] = '0' + ( i % 10 );

	block[size] = '\0';
printf("g_datablock(): size %u, data '%s'\n", size, block );
	return block;
}

void g_log( unsigned int id, const char *text, int num )
{
	time_t now = time(NULL);

	if ( num > -1 )
		fprintf( g_fp, "%u: id %u: %s: %d\n", now, id, text, num );
	else
		fprintf( g_fp, "%u: id %u: %s\n", now, id, text );
}

void g_log_msg( unsigned int id, const char *text, const char *msg )
{
	time_t now = time(NULL);

	if ( msg )
		fprintf( g_fp, "%u: id %u: %s: %s\n", now, id, text, msg );
	else
		fprintf( g_fp, "%u: id %u: %s\n", now, id, text );
}

void test_loop( unsigned int id )
{
	g_id = id;

	while (1) {
		unsigned int period;
		unsigned int action;

do_sleep:
		period = g_rand(G_SLEEP);
		g_log( id, "sleeping", period );
//		MSLEEP( period * 1000 );
//getchar();

		action = g_rand(G_ACT);
		g_log_msg( id, "action",
			action == G_SEND ? "send" : "recv" );

		if ( action == G_SEND ) {
			int fret;

			if ( ( fret = gmsg_send_ready() ) == GF_SUCCESS ) {
				unsigned int datasize;

				datasize = g_rand(G_DATASIZE);
				if ( gmsg_send( g_datablock(datasize), datasize )
					== GF_SUCCESS )
				{
					g_log( id, "send() data bytes", datasize );
				}
				else {

					/* gmsg_send() failed */
					g_log_msg( id, "gmsg_send failed",
						gmsg_strerror() );
					exit(1);
				}
			}
			else if ( fret == GF_NOTREADY ) {

				g_log( id, "send() not ready", -1 );
				goto do_sleep;
			}
			else {

				/* gmsg_send_ready() failed */
				g_log_msg( id, "gmsg_send_ready failed",
					gmsg_strerror() );
				exit(1);
			}
#if 0
fret = gmsg_send_ready();
if ( fret != GF_SUCCESS ) {
	fprintf(stderr, "stderr: gmsg_send_ready() FAILED!!!\n");
	exit(1);
}
#endif
		}
		else if ( action == G_RECV ) {
			int avail;
			char recv_buf[MAXBUFSIZE];

			if ( ( avail = gmsg_recv_available() ) > 0 ) {

				g_log( id, "gmsg_recv_available bytes to recv", avail );
				if ( gmsg_recv( recv_buf ) == GF_SUCCESS ) {

					g_log( id, "recv success", -1 );
				}
				else {

					/* gmsg_recv() failed */
					g_log_msg( id, "gmsg_recv failed",
						gmsg_strerror() );
					exit(1);
				}
			}
			else if ( avail == GF_NOTREADY ) {

				g_log( id, "gmsg_recv_available nothing to recv", -1 );
			}
			else {

				/* gmsg_recv_available() failed */
				g_log_msg( id, "gmsg_recv_available failed",
					gmsg_strerror() );
				exit(1);
			}
		}
		else {

			g_log_msg( id, "BUG: invalid action", NULL );
			exit(1);
		}
	} /* end while(1) */
}

int test_read_fn( void *arg, const char *buf, unsigned int len )
{
	printf("RECV: %u bytes, message:\n'%s'\n\n", len, buf );

	return 0;
}

void test_error_fn( void *arg, const char *msg )
{
	g_log_msg( g_id, "ERROR", msg );
}

// id = 0 (server), 1 (client)
void test_loop2( unsigned int id )
{
	g_id = id;
	SocketComm *scomm = 0;
	SOCKET srv_sock = INVALID_SOCKET;
	int runs_left = -1;

srand(time(NULL) + id);
	if ( id == 0 ) {
		srv_sock = srv_establish2( PORT );

		if ( srv_sock == INVALID_SOCKET ) {

			printf("srv_establish2 failed\n");
			exit(1);
		}
	}

	while (1) {
		int wait_time;
		int data_size = 0;
		int ret;
		const char *data;

		if ( !scomm ) {
			if ( id == 0 )
{
				// server
				scomm = new SocketComm(
					srv_sock,
					PORT,
					test_read_fn,
					test_error_fn );
//MSLEEP(8000);
}
			else
				// client
				scomm = new SocketComm(
					HOST,
					PORT,
					test_read_fn,
					test_error_fn );
//printf("New scomm CREATED\n");

		}

		if ( scomm ) {
			if ( scomm->initSock() != 0 ) {

				delete scomm;
				scomm = 0;
			}
		}

		if ( runs_left == 0 ) {

			// disconnect
			printf("DISCONNECTING\n");
			if ( id == 0 ) {

				// server

				if ( srv_sock != INVALID_SOCKET )
					closesocket(srv_sock);

				delete scomm;
				scomm = 0;

				srv_sock = srv_establish2( PORT );
				if ( srv_sock == INVALID_SOCKET ) {

					printf("srv_establish2 failed\n");
					exit(1);
				}
			}
			else {

				// client

				delete scomm;
				scomm = 0;
			}
		}

		if ( runs_left > -1 )
			runs_left--;
		
		if ( runs_left == -1 ) {

			runs_left = g_myrand( G_DISCONNECT_FREQ_MAX - G_DISCONNECT_FREQ_MIN + 1 ) +
				G_DISCONNECT_FREQ_MIN;
			// MSG
			printf("Will disconnect after %d runs\n", runs_left );
		}

		wait_time = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) +
			G_SLEEP_MIN;
		printf("SLEEP: %d sec\n", wait_time );
		MSLEEP( wait_time * 1000 );

		data_size = g_myrand( G_DATASIZE_MAX - G_DATASIZE_MIN + 1 ) +
			G_DATASIZE_MIN;
		data = g_datablock( data_size );

		// REPEATING CODE!!!
		if ( !scomm ) {

			if ( id == 0 )
{
				// server
				scomm = new SocketComm(
					srv_sock,
					PORT,
					test_read_fn,
					test_error_fn );
//MSLEEP(8000);
}
			else
				// client
				scomm = new SocketComm(
					HOST,
					PORT,
					test_read_fn,
					test_error_fn );
//printf("New scomm CREATED\n");

			if ( scomm->initSock() != 0 ) {

				delete scomm;
				scomm = 0;
			}
		}

		if ( scomm ) {
			ret = scomm->send( data, data_size );
			if ( ret ) {

//printf("scomm DELETED\n");
				delete scomm;
				scomm = 0;
			}
			else
				printf("SEND: %d bytes\n\n", data_size );
		}
	}

	if ( srv_sock != INVALID_SOCKET )
		closesocket(srv_sock);
}

// ret = a socket, INVALID_SOCKET
static SOCKET srv_establish2(unsigned short portnum)
{
	char myname[256];
	SOCKET s;
	struct sockaddr_in sa;
	struct hostent *hp;

	memset(&sa, 0, sizeof(struct sockaddr_in));
	gethostname(myname, sizeof(myname));
	hp = gethostbyname(myname);
	if (hp == NULL)
		return(INVALID_SOCKET);
	sa.sin_family = hp->h_addrtype;
	sa.sin_port = htons(portnum);
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s == INVALID_SOCKET)
		return INVALID_SOCKET;

	/* bind the socket to the internet address */
	if (bind(s, (struct sockaddr *)&sa, sizeof(struct sockaddr_in)) ==
		SOCKET_ERROR)
	{
		closesocket(s);
		return(INVALID_SOCKET);
	}
	listen(s, 3);

	return s;
}

// id = 0 (server), 1 (client)
// to test, define DEBUG_MSG_MANAGER on top of Msg.cpp
void test_loop_MsgManager( unsigned int id )
{
	g_id = id;
	MsgManager *manager = 0;

	srand(time(NULL) + id);

	while (1) {
		int wait_time;
		int ret = 0;

		if ( !manager ) {
			if ( id == 0 )
				// server
				manager = new MsgManager( 3123 );
			else
				// client
				manager = new MsgManager( 3123, "localhost" );

			manager->setActive(true);
		}

		wait_time = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) +
			G_SLEEP_MIN;
		printf("SLEEP: %d sec\n", wait_time );
		MSLEEP( wait_time * 1000 );

		// REPEATING CODE!!!
		if ( !manager ) {
			if ( id == 0 )
				// server
				manager = new MsgManager( 3123 );
			else
				// client
				manager = new MsgManager( 3123, "localhost" );
		}

		if ( manager ) {

			manager->setMessageType("Post");
			manager->setMessageName("SetBandwidth");
			manager->appendDataInteger("Bandwidth", 1000 + wait_time );
			manager->send();
		}
		else {

			printf("BUG: manager is null!!!\n" );
			exit(1);
		}
	}
}

#define USE_BASEFACE

// id = 0 (server), 1 (client)
void test_loop_ConsoleFace( unsigned int id )
{
	g_id = id;
#ifndef USE_BASEFACE
	MsgManager *manager = 0;
#else
	BaseFace *baseface = 0;
#endif
	ConsoleFace *consoleface = 0;
	
	srand(time(NULL) + id);

	while (1) {
		int wait_time;
		int ret = 0;

#ifndef USE_BASEFACE
		if ( id == 0 && ! manager ) {

			// server
			manager = new MsgManager( 3123 );
			manager->setActive(true);
		}
#else
		if ( id == 0 && ! baseface ) {

			baseface = new BaseFace();
			baseface->SetPort( 3123 );
			baseface->Connect();
		}
#endif
		else if ( id == 1 && ! consoleface ) {

			// client
			consoleface = new ConsoleFace();
			consoleface->SetHost("localhost");
			consoleface->SetPort( 3123 );
			consoleface->Connect();
		}

#ifndef USE_BASEFACE
		// to make sure we reconnect upon errors
		if ( id == 0 )
			manager->setActive(true);
#endif

		wait_time = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) +
			G_SLEEP_MIN;
		printf("SLEEP: %d sec\n", wait_time );
		MSLEEP( wait_time * 1000 );

#ifndef USE_BASEFACE
		if ( manager ) {
			static int number = 100;

			// do nothing
			manager->setMessageType("Post");
			manager->setMessageName("GetBandwidth");
			manager->appendDataInteger("Bandwidth", number++ );
			manager->send();
		}
#else
		if ( baseface ) {

			//baseface->PostGetBandwidth(wait_time + 100);
			//baseface->PostCrawlingBegin();
			baseface->PostGettingURL("http://www.grub.org", 1024, 1231231231);
		}
#endif
		else if ( consoleface ) {

			consoleface->PostSetBandwidth( 1000 + wait_time );
		}
		else {

			printf("BUG: manager/baseface and consoleface are both null!!!\n" );
			exit(1);
		}
	}
}

#define TEST_PRINT_BEGIN(method_name) \
	printf("%4d: Calling %s( ", line_num, method_name );

#define TEST_PRINT_END(method_name) \
	printf(")\n");

#define TEST_PRINT_INT(value) \
	printf("%d ", value );

#define TEST_PRINT_STR(value) \
	printf("\"%s\" ", value );

// id = 0 (server), 1 (client)
void test_server_simulator( unsigned int id, const char *simfile )
{
	g_id = id;
	BaseFace *baseface = 0;
	ConsoleFace *consoleface = 0;
	FILE *fp = NULL;
	char line[1024];
	int test_server_simulator_send(BaseFace *, const char *);

	srand(time(NULL) + id);

	// server only stuff
	// client is not set-up to read from file yet
	if ( id == 0 ) {

		if ( ! simfile || !(*simfile) ) {

			fprintf(stderr,
				"No simulation input filename specified\n");
			exit(1);
		}

		fp = fopen( simfile, "r" );
		if ( !fp ) {

			perror("fopen");
			exit(1);
		}
	}

	while ( id == 1 || fgets(line, 1024, fp) ) {
		int wait_time;
		int ret = 0;

		if ( id == 0 && ! baseface ) {

			baseface = new BaseFace();
			baseface->SetPort( 3123 );
			baseface->Connect();
		}
		else if ( id == 1 && ! consoleface ) {

			// client
			consoleface = new ConsoleFace();
			consoleface->SetHost("localhost");
			consoleface->SetPort( 3123 );
			consoleface->Connect();
		}

		// baseface may sleep ONLY IF instucted in simfile
		if ( consoleface ) {

			consoleface->Refresh();

			wait_time = g_myrand( G_SLEEP_MAX - G_SLEEP_MIN + 1 ) +
				G_SLEEP_MIN;
			printf("SLEEP: %d sec\n", wait_time );
			MSLEEP( wait_time * 1000 );
		}

		if ( baseface ) {

			baseface->Refresh();

			// parse the line and take the action
			// on non-zero, exit
			if ( test_server_simulator_send( baseface, line ) )
				break;
		}
		else if ( consoleface ) {

			consoleface->PostSetBandwidth( 1000 + wait_time );
		}
		else {

			printf("BUG: baseface and consoleface are both null!!!\n" );
			exit(1);
		}
	}

	printf("Press enter to end communication\n");
	getchar();

	if ( fp ) fclose(fp );
	if ( baseface ) delete baseface;
	if ( consoleface ) delete consoleface;
}

// ret = 0, 1 on order to exit
int test_server_simulator_send( BaseFace *baseface, const char *line )
{
	char command[1024];
	void convert_arg_int(const char *, int *, int);
	void convert_arg_char(const char *, char *, int);
	static int line_num = 0;

	line_num++;

	if ( strlen(line) <= 1 ) {

		// blank line; skipping
		return 0;
	}
	else if ( *line == '#' ) {

		// a comment; skipping
		return 0;
	}

	convert_arg_char( line, command, 0 );

	if ( strcmp(command, "SLEEP" ) == 0 ) {
		int msecs;

		printf("Sleeping for ");
		convert_arg_int(line, &msecs, 1);
		printf("milliseconds.\n");

		MSLEEP(msecs);
	}
	else if ( strcmp(command, "PAUSE" ) == 0 ) {

		printf("Paused.  Press enter to continue.\n");
		getchar();
	}
	else if ( strcmp(command, "PostGetBandwidth" ) == 0 ) {
		int Bandwidth;

		TEST_PRINT_BEGIN("PostGetBandwidth");
		convert_arg_int(line, &Bandwidth, 1);
		TEST_PRINT_END("PostGetBandwidth");

		baseface->PostGetBandwidth(Bandwidth);
	}
	else if ( strcmp(command, "PostGetBandwidthLimit" ) == 0 ) {
		int Limit;

		TEST_PRINT_BEGIN("PostGetBandwidthLimit");
		convert_arg_int(line, &Limit, 1);
		TEST_PRINT_END("PostGetBandwidthLimit");

		baseface->PostGetBandwidthLimit(Limit);
	}
	else if ( strcmp(command, "PostGetCrawlerCount" ) == 0 ) {
		int Count;

		TEST_PRINT_BEGIN("PostGetCrawlerCount");
		convert_arg_int(line, &Count, 1);
		TEST_PRINT_END("PostGetCrawlerCount");

		baseface->PostGetCrawlerCount(Count);
	}
	else if ( strcmp(command, "PostGetStatus" ) == 0 ) {
		int Status;

		TEST_PRINT_BEGIN("PostGetStatus");
		convert_arg_int(line, &Status, 1);
		TEST_PRINT_END("PostGetStatus");

		baseface->PostGetStatus(Status);
	}
	else if ( strcmp(command, "PostGettingBegin" ) == 0 ) {

		TEST_PRINT_BEGIN("PostGettingBegin");
		TEST_PRINT_END("PostGettingBegin");

		baseface->PostGettingBegin();
	}
	else if ( strcmp(command, "PostGettingURL" ) == 0 ) {
		char URL[1024];
		int Size;
		int CRC;

		TEST_PRINT_BEGIN("PostGettingURL");
		convert_arg_char(line, URL, 1);
		convert_arg_int(line, &Size, 2);
		convert_arg_int(line, &CRC, 3);
		TEST_PRINT_END("PostGettingURL");

		baseface->PostGettingURL(URL, Size, CRC);
	}
	else if ( strcmp(command, "PostGettingEnd" ) == 0 ) {

		TEST_PRINT_BEGIN("PostGettingEnd");
		TEST_PRINT_END("PostGettingEnd");

		baseface->PostGettingEnd();
	}
	else if ( strcmp(command, "PostCrawlingBegin" ) == 0 ) {

		TEST_PRINT_BEGIN("PostCrawlingBegin");
		TEST_PRINT_END("PostCrawlingBegin");

		baseface->PostCrawlingBegin();
	}
	else if ( strcmp(command, "PostCrawlingURL" ) == 0 ) {
		char URL[1024];
		char Status[1024];
		int Size;
		int CRC;
		int Bandwidth;

		TEST_PRINT_BEGIN("PostCrawlingURL");
		convert_arg_char(line, URL, 1);
		convert_arg_char(line, Status, 2);
		convert_arg_int(line, &Size, 3);
		convert_arg_int(line, &CRC, 4);
		convert_arg_int(line, &Bandwidth, 5);
		TEST_PRINT_END("PostCrawlingURL");

		baseface->PostCrawlingURL( URL, Status, Size, CRC, Bandwidth);
	}
	else if ( strcmp(command, "PostCrawlingURLDone" ) == 0 ) {
		char URL[1024];
		char Status[1024];

		TEST_PRINT_BEGIN("PostCrawlingURLDone");
		convert_arg_char(line, URL, 1);
		convert_arg_char(line, Status, 2);
		TEST_PRINT_END("PostCrawlingURLDone");

		baseface->PostCrawlingURLDone( URL, Status );
	}
	else if ( strcmp(command, "PostCrawlingEnd" ) == 0 ) {

		TEST_PRINT_BEGIN("PostCrawlingEnd");
		TEST_PRINT_END("PostCrawlingEnd");

		baseface->PostCrawlingEnd();
	}
	else if ( strcmp(command, "PostPuttingBegin" ) == 0 ) {

		TEST_PRINT_BEGIN("PostPuttingBegin");
		TEST_PRINT_END("PostPuttingBegin");

		baseface->PostPuttingBegin();
	}
	else if ( strcmp(command, "PostPuttingURL" ) == 0 ) {
		char URL[1024];
		char Status[1024];
		int Size;
		int CRC;

		TEST_PRINT_BEGIN("PostPuttingURL");
		convert_arg_char(line, URL, 1);
		convert_arg_char(line, Status, 2);
		convert_arg_int(line, &Size, 3);
		convert_arg_int(line, &CRC, 4);
		TEST_PRINT_END("PostPuttingURL");

		baseface->PostPuttingURL( URL, Status, Size, CRC);
	}
	else if ( strcmp(command, "PostPuttingEnd" ) == 0 ) {

		TEST_PRINT_BEGIN("PostPuttingEnd");
		TEST_PRINT_END("PostPuttingEnd");

		baseface->PostPuttingEnd();
	}
	else if ( strcmp(command, "PostHostProtect" ) == 0 ) {

		TEST_PRINT_BEGIN("PostHostProtect");
		TEST_PRINT_END("PostHostProtect");

		baseface->PostHostProtect();
	}
	else if ( strcmp(command, "PostHostUnprotect" ) == 0 ) {

		TEST_PRINT_BEGIN("PostHostUnprotect");
		TEST_PRINT_END("PostHostUnprotect");

		baseface->PostHostUnprotect();
	}
	else if ( strcmp(command, "PostSleep" ) == 0 ) {
		int Seconds;

		TEST_PRINT_BEGIN("PostSleep");
		convert_arg_int(line, &Seconds, 1);
		TEST_PRINT_END("PostSleep");

		baseface->PostSleep(Seconds);
	}
	else {

		fprintf(stderr,
			"Unrecognized command in file on line %d.\n",
			line_num );
		exit(1);
	}

	return 0;
}

void convert_arg_int(const char *line, int *var, int index)
{
	char fmt[1024];
	int i;

	fmt[0] = '\0';
	for ( i = 0; i < index; i++ )
		strcat( fmt, "%*s " );

	strcat( fmt, "%d" );

	if ( sscanf( line, fmt, var ) != 1 ) {

		fprintf(stderr, "\n\nconvert_arg_int: sscanf: "
			"Invalid input at index %d: "
			"Line contains:\n  %s\n", index, line);
		exit(1);
	}

	if ( index > 0 ) {

		TEST_PRINT_INT(*var);
	}
}

void convert_arg_char(const char *line, char *var, int index)
{
	char fmt[1024];
	int i;

	fmt[0] = '\0';
	for ( i = 0; i < index; i++ )
		strcat( fmt, "%*s " );

	strcat( fmt, "%s" );

	if ( sscanf( line, fmt, var ) != 1 ) {

		fprintf(stderr, "\n\nconvert_arg_char: sscanf: "
			"Invalid input at index %d: "
			"Line contents:\n  %s\n", index, line);
		exit(1);
	}

	if ( index > 0 ) {

		TEST_PRINT_STR(var);
	}
}
