/* main.c --- main function for gsmssend */

/* Copyright (c) E. Lassauge, 2000-2001.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * mailto:lassauge@mail.dotcom.fr
 * http://lassauge.free.fr/
 *
 * REVISION HISTORY: see Changelog
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "sms.h"
#include "interface.h"
#include "support.h"
#include "signal.h"

static struct poptOption options[] = {
   {
     "scriptpath",
     's',
     POPT_ARG_STRING,
     (void *)&ScriptPath,
     0,
     N_("Path for SmsSend scripts"),
     N_("PATH")
   },
   {
     "scriptfile",
     'f',
     POPT_ARG_STRING,
     (void *)&ScriptFilename,
     0,
     N_("SmsSend script used (only this one)"),
     N_("SCRIPT_FILENAME")
   },
   {
     "user_only",
     'u',
     POPT_ARG_NONE,
     (void *)&MyScripts,
     0,
     N_("Use only user's SmsSend scripts"),
     NULL
   },
   {
     NULL,
     '\0',
     POPT_ARG_NONE,
     NULL,
     0,
     NULL,
     NULL
   }
 };

int main(int argc, char *argv[])
{
    gchar *config_dir;
    gchar *config_file;
    gchar *path;
    //poptContext pctx;
#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain(PACKAGE);
#endif

    /* init GNOME */
    gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, options, 0, NULL); 

    /* init threads */
    g_thread_init(NULL);

    /* RC file stuff */
    gtk_rc_parse(PACKAGE_SHARE_DIR PACKAGE "/gsmssendrc");
    gtk_rc_parse("gsmssendrc");

    /* main UI */
    GnomeSmssend = create_gnome_smssend();

    /*
     * Check configuration directory
     */
    config_dir=gnome_util_prepend_user_home(".smssend");
    if (!g_file_test(config_dir, G_FILE_TEST_ISDIR))
    {
	mkdir(config_dir,S_IRUSR|S_IWUSR|S_IXUSR);	
    }

    g_free(config_dir);

    /*
     * Get configuration values
     */
    config_file=gnome_util_prepend_user_home(".smssend/smssendrc");
    path = g_strdup_printf("=%s=/Proxy/use_proxy=false",config_file);
    UseProxy = gnome_config_get_bool_with_default(path,FALSE);
    g_free(path);
    if (UseProxy)
    {
	gchar *value;
	path = g_strdup_printf("=%s=/Proxy/proxy_host",config_file);
	value = gnome_config_get_string(path);
	if (value && strlen(value))
	    g_snprintf(ProxyHost,P_LENGTH,"%s",value);
	g_free(path);
	g_free(value);
	path = g_strdup_printf("=%s=/Proxy/proxy_port=8080",config_file);
	ProxyPort = gnome_config_get_int_with_default(path,NULL);
	g_free(path);
	path = g_strdup_printf("=%s=/Proxy/proxy_user",config_file);
	value = gnome_config_get_string(path);
	if (value && strlen(value))
	    g_snprintf(ProxyUser,P_LENGTH,"%s",value);
	g_free(path);
	g_free(value);
	path = g_strdup_printf("=%s=/Proxy/proxy_password",config_file);
	value = gnome_config_get_string(path);
	if (value && strlen(value))
	{
	    crypt_password(value);
	    g_snprintf(ProxyPass,P_LENGTH,"%s",value);
	}
	g_free(path);
	g_free(value);
    }
    path = g_strdup_printf("=%s=/Misc/debug_level=0",config_file);
    DebugLevel = gnome_config_get_int_with_default(path,NULL);
    g_free(path);
    path = g_strdup_printf("=%s=/Misc/timeout=0",config_file);
    TimeOut = gnome_config_get_int_with_default(path,NULL);
    g_free(path);
    path = g_strdup_printf("=%s=/Misc/auto_check=false",config_file);
    AutoCheck = gnome_config_get_bool_with_default(path,NULL);
    g_free(path);
    if (AutoCheck)
	gnome_url_show(SMSSEND_URL_SCRIPTS);
    path = g_strdup_printf("=%s=/Misc/keep_pass=false",config_file);
    KeepPass = gnome_config_get_bool_with_default(path,NULL);
    g_free(path);
    path = g_strdup_printf("=%s=/Misc/delay_calls=false",config_file);
    DelaySend = gnome_config_get_bool_with_default(path,NULL);
    g_free(path);
    path = g_strdup_printf("=%s=/Misc/retries=1",config_file);
    Retries = gnome_config_get_int_with_default(path,NULL);
    g_free(path);
    g_free(config_file);

    /*
     * Check for alias file
     */
    path = gnome_util_prepend_user_home(".smssend/aliases"); 
    if (g_file_test(path, G_FILE_TEST_ISFILE))
    {
	FILE *fp;
	gchar line[1024];
	gchar *key,*value;

        fp = fopen(path,"rt");
  	if (fp != (FILE *)NULL)
	{
	    AliasHash       = g_hash_table_new(g_str_hash,g_str_equal);
	    while (SU_ReadLine(fp,line,sizeof(line)))
  	    {
		gchar *tmp;
		gchar **str_array;
		if((line[0] == '#') || (line[0] == '\000'))
		    continue;
		/* add to hash */
		tmp       = g_strdup(g_strstrip(line));
		str_array = g_strsplit (tmp," ",0);
		key   = g_strdup(str_array[KEY_COL]);
		value = g_strdup(str_array[VAL_COL]);
		g_hash_table_insert(AliasHash,(gpointer) key, (gpointer) value);
		g_strfreev(str_array);
		g_free(tmp);
	    }
	    fclose(fp);
	}
    }
    g_free(path);

    /*
     * Check for saved scripts file (only if not --scriptfile or --user_only)
     */
    if (!MyScripts  && !ScriptFilename)
    {
    	path = gnome_util_prepend_user_home(".smssend/scripts"); 
    	if (g_file_test(path, G_FILE_TEST_ISFILE))
    	{
	    FILE *fp;
	    gchar line[1024];

            fp = fopen(path,"rt");
  	    if (fp != (FILE *)NULL)
	    {
	        SavedProviderHash = g_hash_table_new(g_str_hash,g_str_equal);
	        while (SU_ReadLine(fp,line,sizeof(line)))
  	        {
		    gchar *tmp;
		    if((line[0] == '#') || (line[0] == '\000'))
		        continue;
		    /* add to hash: no value, this is just to use the lookup feature of the GHashTable */
		    tmp       = g_strdup(g_strstrip(line));
		    g_hash_table_insert(SavedProviderHash,(gpointer) tmp, (gpointer) SAVED_PROVIDER);
		    /* don't free tmp as neither keys nor values are copied when inserted into the GHashTable */
	        }
	        fclose(fp);
	    }
	}
        g_free(path);
    }

    /* attach a 'ignore' signal handler to SIGCHLD to avoid zombies */
    signal(SIGCHLD,SIG_IGN);

    /*
     * Check for script files and create notebook entries
     */
    ProviderHash      = g_hash_table_new(g_str_hash,g_str_equal);
    ShownProviderHash = g_hash_table_new(g_str_hash,g_str_equal);
    create_notebook();
    gtk_widget_show(GnomeSmssend);
    gtk_main();
    return 0;
}
