//*****************************************************************************
//                               AppGSpiceUI.hpp                              *
//                              -----------------                             *
//  Description : The main application class. It all begins here.             *
//  Started     : 15/08/2003                                                  *
//  Last Update : 14/11/2006                                                  *
//  Copyright   : (C) 2003 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef APPGSPICEUI_HPP
#define APPGSPICEUI_HPP

// System includes

#include <iostream>

// In the following include using <locale.h> instead of <clocale> at the
// request of a user running Solaris 9 on a Ultra SPARC and Sun's C++ compiler.
#include <locale.h>

// wxWindows includes

#include <wx/wx.h>
#include <wx/config.h>

// Application includes

#include "Version.hpp"
#include "CmdLinePcr.hpp"
#include "main/FrmMain.hpp"

// Local constant declarations


//*****************************************************************************

class AppGSpiceUI : public wxApp
{
  private:

    FrmMain   * m_poFrmMain;
    CmdLinePcr  m_oCmdLnPcr;

  public:

    AppGSpiceUI( void );
   ~AppGSpiceUI( );

    virtual  bool  OnInit  ( void );
//  virtual  int   MainLoop( void );
    virtual  int   OnExit  ( void );

    // Event handlers

    // Leave this as the last line as private access is envoked by this macro
//  DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // APPGSPICEUI_HPP
