//*****************************************************************************
//                               PrcSimrBase.cpp                              *
//                              -----------------                             *
//  Started     : 25/04/2004                                                  *
//  Last Update : 05/10/2009                                                  *
//  Copyright   : (C) 2004 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "base/PrcSimrBase.hpp"

//*****************************************************************************
// Constructor.

PrcSimrBase::PrcSimrBase( void ) : PrcBase( wxPROCESS_REDIRECT )
{
  m_eSimEng = eSIMR_NONE;
}

//*****************************************************************************
// Destructor.

PrcSimrBase::~PrcSimrBase( )
{
}

//*****************************************************************************
// Set the simulation results file name.
//
// Argument List :
//   rosFName - A string containing the full path and file name
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bSetResultsFile( const wxString & rosFName )
{
  wxFileName  ofn1;

  ofn1 = rosFName;
  if( ofn1.GetPath( ).IsEmpty( ) ) ofn1.SetPath( wxT(".") );

  if( ! ofn1.IsOk( ) ) return( FALSE );

  m_oFnResults = ofn1;

  return( TRUE );
}

//*****************************************************************************
// Save the console output to file.
//
// Argument List :
//   rosFName - The save file name
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bSaveOutput( const wxString & rosFName )
{
  wxFileName  ofn1;
  wxString    os1, os2;
  wxChar      oc1;

  // Check the validity of the save file name
  if( rosFName.IsEmpty( ) )         return( FALSE );
  ofn1 = rosFName;
  if( ! ofn1.IsOk( ) )              return( FALSE );

  // Open the save file and delete any lines it may contain
  wxTextFile  oFileCct( ofn1.GetFullPath( ) );
  if( oFileCct.Exists( ) )
       { if( ! oFileCct.Open( ) )   return( FALSE ); }
  else { if( ! oFileCct.Create( ) ) return( FALSE ); }
  oFileCct.Clear( );

  wxMicroSleep( 100 );

  // Save the simulator output to file
  while( bIsExec( ) || IsInputAvailable( ) || IsErrorAvailable( ) )
  {
    while( IsInputAvailable( ) )
    { // Input characters from stdout
      oc1 = GetInputStream( )->GetC( );
      if( oc1 == wxT('\n') )
      {
        oFileCct.AddLine( os1 );
        os1 = wxT("");
        continue;
      }
      if( oc1==wxT('\t') || (oc1>31 && oc1!=127) ) os1 << oc1;
    }

    while( IsErrorAvailable( ) )
    { // Input characters from stderr
      oc1 = GetErrorStream( )->GetC( );
      if( oc1 == wxT('\n') )
      {
        oFileCct.AddLine( os2 );
        os2 = wxT("");
        continue;
      }
      if( oc1==wxT('\t') || (oc1>31 && oc1!=127) ) os2 << oc1;
    }

    if( !IsInputAvailable( ) && !IsErrorAvailable( ) )
      wxTheApp->Yield( );  // Release the processor for other tasks
  }

  if( os1.Length( ) > 0 ) oFileCct.AddLine( os1 );
  if( os2.Length( ) > 0 ) oFileCct.AddLine( os2 );
  oFileCct.AddLine( wxT("") );

  oFileCct.Write( ); // Save the changes to disk
  oFileCct.Close( ); // Close the results file

  return( TRUE );
}

//*****************************************************************************
// Make the process argument list based on the contents of a simulation object.
//
// Argument List :
//   roSimn - The simulation object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bMakeArgLst( SimnBase & roSimn )
{
  wxString  os1;
  int       i1;

  // Clear error attributes
  m_osErrMsg.Empty( );

  // Only proceed if the simulator isn't already running
  if( bIsExec( ) )
  {
    SetErrMsg( wxT("Simulator already running") );
    return( FALSE );
  }

  // Create the results file name
  os1 = roSimn.rofnGetLoadFile( ).GetPath( ) + wxT('/')
      + roSimn.rofnGetLoadFile( ).GetName( );
  i1 = os1.Find( wxT(".gspiceui") );
  if( i1 > 0 ) os1 = os1.Truncate( (size_t) i1 );
  os1 << wxT('.') << rofnGetBinary( ).GetName( );
  switch( roSimn.eGetAnaType( ) )
  {
    case eCMD_OP : os1 << wxT(".op"); break;
    case eCMD_DC : os1 << wxT(".dc"); break;
    case eCMD_AC : os1 << wxT(".ac"); break;
    case eCMD_TR : os1 << wxT(".tr"); break;
    case eCMD_FO : os1 << wxT(".fo"); break;
    case eCMD_DI : os1 << wxT(".di"); break;
    case eCMD_NO : os1 << wxT(".no"); break;
    case eCMD_PZ : os1 << wxT(".pz"); break;
    case eCMD_SE : os1 << wxT(".se"); break;
    case eCMD_TF : os1 << wxT(".tf"); break;
    default      : return( FALSE );
  }

  // Set the results file name
  if( ! PrcSimrBase::bSetResultsFile( os1 ) )
  {
    SetErrMsg( wxT("Couldn't set results file name") );
    return( FALSE );
  }

  // Construct the default argument list
  os1 = roSimn.rofnGetSaveFile( ).GetFullPath( );
  if( ! bSetArgLst( os1 ) )
  {
    SetErrMsg( wxT("Couldn't set argument list") );
    return( FALSE );
  }

  return( TRUE );
}

//*****************************************************************************
// Execute a simulation.
//
// Argument List :
//   roSimn - The simulation object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  PrcSimrBase::bExec( void )
{
  wxString  os1, os2;

  // Execute the simulation
  if( ! PrcBase::bExec( ) )      return( FALSE );

  // Save the simulation results to the log file
  os1 = rofnGetLogFile( ).GetFullPath( );
  if( ! bSaveOutput( os1 ) )     return( FALSE );

  // Copy the log file to the results file
  os2 = roGetResultsFile( ).GetFullPath( );
  if( ! wxCopyFile( os1, os2 ) ) return( FALSE );

  return( TRUE );
}

//*****************************************************************************
