/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef CATALOG_LIST_H
#define CATALOG_LIST_H

#include <gtk/gtkwidget.h>

typedef struct {
	gchar *    path;                /* The current dir to show. */

	GList *    dir_list;            /* Contain the full path of the 
					 * sub dirs. */
	GList *    dir_name;            /* Contains only the names of the 
					   dirs. */
	GList *    file_list;           /* Contains the full path of the
					 * catalog files. */
	GList *    file_name;           /* Contains only the names of the 
					 * catalogs. */

	GList *    search_rows;         /* rows that contain a search
					 * result. */

	GtkWidget *clist;
	GtkWidget *root_widget;
} CatalogList;


CatalogList *      catalog_list_new               ();

void               catalog_list_free              (CatalogList *cat_list);

gboolean           catalog_list_refresh           ();

gchar *            catalog_list_path_from_row     (CatalogList *cat_list,
						   gint row);

gboolean           catalog_list_is_search         (CatalogList *cat_list,
						   gint row);

gint               catalog_list_row_from_path     (CatalogList *cat_list,
						   const gchar *path);

void               catalog_list_change_to         (CatalogList *cat_list,
						   gchar *path);


#endif /* CATALOG_LIST_H */
