/*
 * help.c: Help menu contents code
 *
 * This file is part of GTick
 *
 * Copyright (c) 1999, Alex Roberts
 * Copyright (c) 2003, Roland Stigge <stigge@antcom.de>
 *
 * GTick is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GTick is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GTick; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

/* GNU headers */
#include <stdio.h>
#include <sys/ioctl.h>

/* GTK headers*/
#include <gtk/gtk.h>
#include <glib.h>

/* own headers */
#include "globals.h"
#include "metro.h"
#include "help.h"
#include "gtkutil.h"

/* logo */
#include "aboutlogo.xpm"

void about_box(metro_t* metro)
{
  GtkWidget* window;
  GtkWidget* vbox;
  GtkWidget* label;

  GdkPixmap* pixmap;
  GdkBitmap* mask;
  GtkStyle* style;
  GtkWidget* pixmapwidget;

  window = gtk_dialog_new_with_buttons("About GTick", GTK_WINDOW(metro->window),
      GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL,
      GTK_STOCK_OK, GTK_RESPONSE_NONE,
      NULL);

  g_signal_connect(G_OBJECT(window),
                   "destroy",
		   G_CALLBACK(gtk_widget_destroy),
	           window);

  vbox = gtk_vbox_new(FALSE, 10);
  gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), vbox, TRUE, TRUE, 0);
  gtk_widget_show(vbox);

  gtk_widget_realize(window);
  style = gtk_widget_get_style(window);
  pixmap = gdk_pixmap_create_from_xpm_d(window->window,
  				        &mask,
				        NULL,
				        (gchar**) aboutlogo_xpm);
  pixmapwidget = gtk_pixmap_new(pixmap, mask);
  gtk_box_pack_start(GTK_BOX(vbox), pixmapwidget, TRUE, TRUE, 0);
  gtk_widget_show(pixmapwidget);
 
  label = gtk_label_new (_(
    "Copyright (c) 1999, Alex Roberts <bse@dial.pipex.com>\n"
    "Copyright (c) 2003, Roland Stigge <stigge@antcom.de>\n"
    /* TRANSLATORS: actually, "Andrés" with acute accent (/) */
    "Logo by Mario Andres Pagella <mapagella@fitzroy-is.com.ar>\n"
    "\n"
    "Homepage:\n"
    "http://www.antcom.de/gtick/\n"
    "\n"
    "Email bug reports, comments, etc. to\n"
    "Developer's mailing list:\n"
    "gtick-devel@nongnu.org"
  ));
  gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
  gtk_widget_show(label);

  g_signal_connect_swapped(GTK_OBJECT(window),
                           "response",
			   G_CALLBACK(gtk_widget_destroy),
			   GTK_OBJECT(window));
  gtk_widget_show(window);
}

/* the help menu entry callback */
void license_box(void) {
  GtkWidget* window = get_ok_dialog(_("GTick License"),
    _("GTick - The Metronome\n"
      "Copyright (c) 1999, Alex Roberts <bse@dial.pipex.com>\n"
      "Copyright (c) 2003, Roland Stigge <stigge@antcom.de>\n"
      "\n"
      "This program is free software; you can redistribute it and/or\n"
      "modify it under the terms of the GNU General Public License\n"
      "as published by the Free Software Foundation; either version 2\n"
      "of the License, or (at your option) any later version.\n"
      "\n"
      "This program is distributed in the hope that it will be useful,\n"
      "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
      "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
      "GNU General Public License for more details.\n"
      "\n"
      "You should have received a copy of the GNU General Public License\n"
      "along with this program; if not, write to the Free Software\n"
      "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, "
      "USA."), GTK_JUSTIFY_CENTER);

  gtk_widget_show(window);
}

void help_shortcuts(void) {
  GtkWidget* window = gtk_dialog_new();
  GtkWidget* button;
  GtkWidget* table;
  GtkWidget* label;
  
  gtk_window_set_title(GTK_WINDOW(window), _("Shortcuts"));

  /* vbox area */
  gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(window)->vbox), 0);
  table = gtk_table_new(4, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(table), 10);
  
  label = gtk_label_new(_("Ctrl-S"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Ctrl-+"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Ctrl--"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 2, 3,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Ctrl-1 ... Ctrl-9"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 3, 4,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Start/Stop"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Speed: Faster"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 1, 2,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Speed: Slower"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 2, 3,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  label = gtk_label_new(_("Base Meter"));
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_table_attach(GTK_TABLE(table), label, 1, 2, 3, 4,
                   GTK_EXPAND | GTK_FILL, 0, 10, 5);
  gtk_widget_show(label);
  
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), table, TRUE, FALSE, 0);
  gtk_widget_show(table);

  /* OK button */
  button = gtk_button_new_from_stock(GTK_STOCK_OK);
  gtk_box_pack_start_defaults(
      GTK_BOX(GTK_CONTAINER(GTK_DIALOG(window)->action_area)), button);
  g_signal_connect_swapped(G_OBJECT(button),
                           "clicked",
			    G_CALLBACK(gtk_widget_destroy),
			    window);
  gtk_widget_show(button);

  gtk_widget_show(window);
}

