/*  gtk-imonc - imond client for fli4l
 *  Copyright (C) 2001-2002 Stefan Strigler <zeank@x-berg.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <time.h>
#include <sys/types.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <unistd.h>

#include "remote_update.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "imonc.h"
#include "timer.h"

/* -----===== SHARED FUNCTIONS ==== ----- */

/*----------------------------------------------------------------------
 * wrapper for calling functions by reference
 *----------------------------------------------------------------------
 */
void
func_wrapper                            (void (*func)(GtkWidget *button, 
										 gpointer user_data), 
										 GtkWidget *button, 
										 gpointer user_data)
{
	(*func)(button, user_data);
}


void
on_rootpw_ok_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{	
	GtkWidget *rootpw_dialog, *rootpw_entry;

	rootpw_dialog = lookup_widget (GTK_WIDGET (button), "rootpw_dialog");
	rootpw_entry = lookup_widget (GTK_WIDGET (button), "rootpw_entry");

	func_wrapper ((void (*)(GtkWidget *,gpointer))gtk_object_get_data (GTK_OBJECT (rootpw_dialog), "func"),NULL,rootpw_entry);
}

gboolean
on_rootpw_entry_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if (event->keyval == GDK_Return) {
		GtkWidget *rootpw_dialog, *rootpw_ok_button;
	  rootpw_dialog = lookup_widget (widget, "rootpw_dialog");
		rootpw_ok_button = lookup_widget (widget, "rootpw_ok_button");
		on_rootpw_ok_button_clicked (GTK_BUTTON (rootpw_ok_button), user_data);

		gtk_widget_destroy(rootpw_dialog);
	}

  return FALSE;
}

void
on_fileselector_ok_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fileselector = lookup_widget(GTK_WIDGET(button),"fileselector");
	
	func_wrapper ((void (*)(GtkWidget *,gpointer)) gtk_object_get_data (GTK_OBJECT (fileselector), "func"),
								GTK_WIDGET (button),fileselector);
}

/* -----===== FUNCTIONS FOR SYSTEM UPDATE ==== ----- */

/*----------------------------------------------------------------------
 * open fileselection dialog
 *----------------------------------------------------------------------
 */
void
on_browse_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fs,
		*sourcedir_entry;

	sourcedir_entry = lookup_widget (GTK_WIDGET (button), "sourcedir_entry");
	fs = create_remoteupdate_sourcedir_fileselection ();
	gtk_object_set_data (GTK_OBJECT (fs), "entry", sourcedir_entry);
	gtk_widget_show (fs);
}


/*----------------------------------------------------------------------
 * on fileselection ok button clicked
 *----------------------------------------------------------------------
 */
void
on_fs_ok_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *entry, *fs;

	fs = lookup_widget(GTK_WIDGET(button),
						"remoteupdate_sourcedir_fileselection");
	entry = gtk_object_get_data (GTK_OBJECT (fs), "entry");
	gtk_entry_set_text (GTK_ENTRY (entry),
		gtk_file_selection_get_filename (GTK_FILE_SELECTION(fs)));
}

void
on_remoteupdate_go_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *error_dialog,
		*error_label,
		*sourcedir_entry,
		*checkbox_vbox,
		*reboot_checkbutton;
	GList *checkboxes;
	DIR *imgdir;
	int files[5];
	gchar *filenames[5];
	int fidx = 0;
	G_CONST_RETURN gchar *root_pw;
  struct send_files_args *args;

	bzero(&files, sizeof(files));
	bzero(&filenames, sizeof(filenames));

	error_dialog = create_error_dialog();
	error_label = lookup_widget (error_dialog, "error_label");

	sourcedir_entry = lookup_widget (gtk_imonc, "sourcedir_entry");

	/* test if sourcedir is a directory we have access to */
	if ((imgdir = opendir (gtk_entry_get_text (GTK_ENTRY (sourcedir_entry)))) == NULL) {
		gtk_label_set_text (GTK_LABEL(error_label), "Can't open Source Dir!");
		gtk_widget_show (error_dialog);
		return;
	} else 
		closedir (imgdir);
		

	checkbox_vbox = lookup_widget (gtk_imonc, "checkbox_vbox");
	checkboxes = gtk_container_children (GTK_CONTAINER (checkbox_vbox));

	/* iterate all file checkboxes */
	do {
		/* check if toggled */
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (checkboxes->data))) {
			gchar *label;
			gchar *filename;
      gchar *fullpath;
			int file;

			/* get label of toggled checkbox */
			gtk_label_get (GTK_LABEL((gtk_container_children(GTK_CONTAINER (checkboxes->data)))->data), &label);

      /* set filename */
      if (!g_ascii_strncasecmp(label,"kernel",6))
        filename = "kernel";
      if (!g_ascii_strncasecmp(label,"rootfs",6)) {
        if (imond_versionnr >= 11)
          filename = "rootfs.tgz";
/*           filename = "rootfs.bz2"; */
        else
          filename = "rootfs.gz";
      }
      if (!g_ascii_strncasecmp(label,"opt",3)) {
        if (imond_versionnr >= 11)
          filename = "opt_tar.bz2";
        else
          filename = "opt.tgz";
      }
      if (!g_ascii_strncasecmp(label,"rc.cfg",6))
        filename = "rc.cfg";
      if (!g_ascii_strncasecmp(label,"syslinux.cfg",12))
        filename = "syslinux.cfg";
			g_print ("label: %s\n", label);
      
      /* full path to file */
      fullpath = g_build_filename (gtk_entry_get_text (GTK_ENTRY (sourcedir_entry)), filename, NULL);    

 			/* check if file exists */
			if ((file = open (fullpath, O_RDONLY)) < 0) {
				gchar buf[1024];

				snprintf (buf, sizeof(buf), "File not found:\n%s", fullpath);
				gtk_label_set_text (GTK_LABEL(error_label), buf);
				gtk_widget_show (error_dialog);
        g_free (fullpath);
				return;
			} else {
				filenames[fidx] = strdup (fullpath); /* don't forget to free! */
        g_free (fullpath);
				files[fidx++] = file;
			}
		}
	} while ((checkboxes = g_list_next(checkboxes)) != NULL);

	if (!fidx) { /* no files selected */
		gtk_label_set_text (GTK_LABEL(error_label), "No files selected for transmission!");
		gtk_widget_show (error_dialog);
		return;
	}

	reboot_checkbutton = lookup_widget (gtk_imonc, "reboot_checkbutton");
	

	/* get root passwd if required */
	if (user_data == NULL) {
		GtkWidget *rootpw_dialog;

		rootpw_dialog = create_rootpw_dialog();
		gtk_object_set_data (GTK_OBJECT (rootpw_dialog), "func", on_remoteupdate_go_button_clicked);
		gtk_widget_show (rootpw_dialog);
		return;
	} 

	root_pw = gtk_entry_get_text (GTK_ENTRY (user_data));

 	send_files (filenames, files, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (reboot_checkbutton)), root_pw);
	gtk_widget_destroy(error_dialog);
}


/*----------------------------------------------------------------------
 * send all selected files to imond
 *----------------------------------------------------------------------
 */
void send_files (gchar *filenames[], int files[], gboolean reboot, G_CONST_RETURN gchar *pw)
{
	int i;
	gchar buffer[1024];
  GtkWidget *status_dialog;
	GtkWidget *status_dialog_text;
	GtkTextBuffer *status_gbuf;

	status_dialog = create_status_dialog();
	gtk_widget_show(status_dialog);
	status_dialog_text = lookup_widget(status_dialog, "status_dialog_text");
	status_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(status_dialog_text));

	gtk_text_buffer_insert_at_cursor(status_gbuf, "starting transmission of files ...\n", -1);

	for (i=0; i<5; i++) {
		if (files[i] > 0) { /* found file to transfer */
			struct stat fbuf;
			gchar *filename;
			int sentBytes = 0;

			bzero (&fbuf,sizeof(fbuf));
			fstat (files[i], &fbuf);

			sprintf(buffer, "sending %s ...\n", filenames[i]);
			gtk_text_buffer_insert_at_cursor(status_gbuf, buffer, -1);

			filename = strrchr (filenames[i], '/'); /* split on last slash */
			snprintf (buffer, sizeof(buffer), "receive /boot%s %d %s", filename, (int)fbuf.st_size, pw);

			send_command (fd, buffer);

			read(fd, buffer, 3);
			if (!(strncmp(buffer, ACK_STRING, 1) == 0)) {
				gtk_text_buffer_insert_at_cursor(status_gbuf, "An error occured. Aborting ...(password wrong?)\n", -1);

				/* clean up */
				close (files[i]);
				g_free (filenames[i]);
				get_answer(fd);

				return;
			}


			/* now send file */
			while (sentBytes < fbuf.st_size) {
				int len;
				len = read (files[i], buffer, 1024);
				write (fd, buffer, len);
				sentBytes+=len;

				read(fd, buffer, 3);
				if (!(strncmp(buffer, ACK_STRING, 1) == 0)) {
					gtk_text_buffer_insert_at_cursor(status_gbuf, "An error occured. Aborting ...\n", -1);

					/* clean up */
					close (files[i]);
					free (filenames[i]);
 					get_answer(fd);

					return;
				}
			}

			get_answer(fd);

			close (files[i]);
			free (filenames[i]);
			gtk_text_buffer_insert_at_cursor(status_gbuf, "done.\n", -1);
		}
	}

	gtk_text_buffer_insert_at_cursor(status_gbuf, "transmission complete.\n", -1);

	if (reboot) {
		GtkWidget *reboot_warning;
		gtk_text_buffer_insert_at_cursor(status_gbuf, "rebooting ...\n", -1);
		reboot_warning = create_reboot_warning ();
		gtk_widget_show (reboot_warning);	}
}


/* -----===== FUNCTIONS FOR UPDATING /etc/portfw.sh ==== ----- */


void
on_pfw_get_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *pfw_text,
		*status_dialog,
		*status_dialog_text;
	gchar buffer[1025];
	G_CONST_RETURN gchar *root_pw;
	gchar *answer;
	gchar *filename;
	guint bytes_to_receive = 0;
	guint received_bytes = 0;
	gint len;
	GtkTextBuffer *status_gbuf, *pfw_gbuf;
	
	/* get root passwd if required */
	if (user_data == NULL) {
		GtkWidget *rootpw_dialog;

		rootpw_dialog = create_rootpw_dialog();
		gtk_object_set_data (GTK_OBJECT (rootpw_dialog), "func", on_pfw_get_button_clicked);
		gtk_widget_show (rootpw_dialog);
		return;
	}

	root_pw = gtk_entry_get_text (GTK_ENTRY (user_data));
	
	pfw_text = lookup_widget (gtk_imonc, "pfw_text");
	pfw_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pfw_text));
	
	/* clear buffer */
	gtk_text_buffer_set_text(pfw_gbuf,"",0);
	
		
	if (imond_versionnr > 10) {
		filename = PORTFW_CONF;
	} else {
		filename = PORTFW_SH;
	}

	status_dialog = create_status_dialog();
	status_dialog_text = lookup_widget(status_dialog, "status_dialog_text");
	status_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(status_dialog_text));
	gtk_widget_show(status_dialog);

	snprintf (buffer, 1025, "send %s %s", filename, root_pw);

	send_command (fd, buffer);

	snprintf (buffer, 1025, "getting %s ...\n", filename);

	gtk_text_buffer_insert_at_cursor(status_gbuf,buffer,-1);
	answer = get_answer (fd);

	if (answer == NULL || strlen(answer) == 0) {
		gtk_text_buffer_insert_at_cursor(status_gbuf, "An error occured. Aborting ...(password wrong?)\n", -1);
		return;
	}

	bytes_to_receive = atoi (answer);

	while (received_bytes < bytes_to_receive) {
		len = read (fd, buffer, 1024);
		buffer[len] = '\0';
		
		gtk_text_buffer_insert_at_cursor (pfw_gbuf,buffer, len);
		
		received_bytes += len;
		write (fd, ACK_STRING, 1);
	}
	
	get_answer (fd);
	gtk_text_buffer_insert_at_cursor(status_gbuf, "done.\n", -1);
}


void
on_pfw_put_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *pfw_text,
		*status_dialog,
		*status_dialog_text;
	GtkTextBuffer *pfw_gbuf, *status_gbuf;
	GtkTextIter start,end;
	G_CONST_RETURN gchar *root_pw;
	gchar *text_block;
	gchar *filename;
	gchar buffer[1024];
	guint bytes_sent = 0;

	/* get root passwd if required */
	if (user_data == NULL) {
		GtkWidget *rootpw_dialog;

		rootpw_dialog = create_rootpw_dialog();
		gtk_object_set_data(GTK_OBJECT(rootpw_dialog), "func", on_pfw_put_button_clicked);
		gtk_widget_show(rootpw_dialog);
		return;
	}

	root_pw = gtk_entry_get_text (GTK_ENTRY (user_data));

	pfw_text = lookup_widget(gtk_imonc, "pfw_text");
	pfw_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pfw_text));
	
	gtk_text_buffer_get_start_iter(pfw_gbuf,&start);
	gtk_text_buffer_get_end_iter(pfw_gbuf,&end);
	
	text_block = gtk_text_buffer_get_text(pfw_gbuf,&start,&end,TRUE);
	
	status_dialog = create_status_dialog();

	status_dialog_text = lookup_widget(status_dialog,"status_dialog_text");
	status_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(status_dialog_text));

	gtk_widget_show(status_dialog);

	if (imond_versionnr > 10) {
		filename = PORTFW_CONF;
	} else {
		filename = PORTFW_SH;
	}

	snprintf(buffer, sizeof(buffer), "receive %s %d %s", filename, 
					 strlen(text_block), root_pw);

	send_command(fd,buffer);

	snprintf (buffer, 1024, "updating %s ...\n", filename);

	gtk_text_buffer_insert_at_cursor(status_gbuf,buffer,-1);

	read(fd, buffer, 3);
	if (!(strncmp(buffer, ACK_STRING, 1) == 0)) {
		gtk_text_buffer_insert_at_cursor(status_gbuf, "An error occured. Aborting ...(password wrong?)\n", -1);
		get_answer(fd);
		return;
	}

	/* verdammt - hier muss in blöcken zu 1024 bytes gesendet werden und
	 * dann immer schön brav das ACK abgeholt werden *arrr* *arrr*
	 */	

	while (bytes_sent < strlen(text_block)) {
		int bytes_to_send = (strlen(text_block+bytes_sent)<1024) ? strlen(text_block+bytes_sent) : 1024;
		bytes_sent += write(fd, text_block+bytes_sent, bytes_to_send);
		read(fd, buffer, 3);
		if (!(strncmp(buffer, ACK_STRING, 1) == 0)) {
			gtk_text_buffer_insert_at_cursor(status_gbuf, "An error occured. Aborting ...\n", -1);
			get_answer(fd);
			return;
		}
	}

	g_free(text_block);
	get_answer(fd);
	gtk_text_buffer_insert_at_cursor(status_gbuf, "done.\n", -1);
}


void
on_pfw_open_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fileselector;

	fileselector = create_fileselector();

	gtk_object_set_data (GTK_OBJECT (fileselector), "func", pfw_open_file);

	gtk_widget_show (fileselector);
}


void
on_pfw_save_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *fileselector;

	fileselector = create_fileselector();

	gtk_object_set_data (GTK_OBJECT (fileselector), "func", pfw_save_file);
	gtk_widget_show (fileselector);
}

void
pfw_open_file                          (GtkButton *button,
																				gpointer  user_data)
{
	GtkWidget *pfw_text;
	GtkTextBuffer *pfw_gbuf;
	gsize length;
	G_CONST_RETURN gchar *filename;
	gchar *fcontent, *utf8_text;
	GError *error = NULL;
	
	filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(user_data));
	
	pfw_text = lookup_widget (gtk_imonc, "pfw_text");
	pfw_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pfw_text));
	
	if (g_file_get_contents(filename,&fcontent,&length,NULL)) {
		utf8_text = g_convert(fcontent,length,"UTF-8","ISO-8859-1",
													NULL,NULL,&error);
		if (error != NULL) {
			gtk_text_buffer_set_text(pfw_gbuf,fcontent,length);
			g_error_free(error);
		} else
			gtk_text_buffer_set_text(pfw_gbuf,utf8_text,length);
	} else
		g_print("error reading %s\n",filename);
}

void
pfw_save_file                          (GtkButton       *button,
																				gpointer        user_data)
{
	GtkWidget *pfw_text;
	GtkTextBuffer *pfw_gbuf;
	int pfw_fd;
	gchar *text_block;
	GtkTextIter start,end;

	pfw_text = lookup_widget (gtk_imonc, "pfw_text");
	pfw_gbuf = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pfw_text));
	
	gtk_text_buffer_get_start_iter(pfw_gbuf,&start);
	gtk_text_buffer_get_end_iter(pfw_gbuf,&end);
	
	text_block = gtk_text_buffer_get_text(pfw_gbuf,&start,&end,TRUE);
	
	if ((pfw_fd=open(gtk_file_selection_get_filename (GTK_FILE_SELECTION (user_data)), O_WRONLY|O_CREAT|O_TRUNC, 00664)) < 0) {
		perror("open");
		return;
	}

	if (write (pfw_fd,text_block,strlen(text_block)) < 0)
		perror("write");

	g_free (text_block);
	close (pfw_fd);
}
