#include <gtk/gtkrc.h>

typedef struct _MurrineRcStyle MurrineRcStyle;
typedef struct _MurrineRcStyleClass MurrineRcStyleClass;

G_GNUC_INTERNAL extern GType murrine_type_rc_style;

#define MURRINE_TYPE_RC_STYLE              murrine_type_rc_style
#define MURRINE_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), MURRINE_TYPE_RC_STYLE, MurrineRcStyle))
#define MURRINE_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), MURRINE_TYPE_RC_STYLE, MurrineRcStyleClass))
#define MURRINE_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), MURRINE_TYPE_RC_STYLE))
#define MURRINE_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), MURRINE_TYPE_RC_STYLE))
#define MURRINE_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), MURRINE_TYPE_RC_STYLE, MurrineRcStyleClass))

typedef enum {
	MRN_FLAG_CONTRAST = 1 << 0,
	MRN_FLAG_HILIGHT_RATIO = 1 << 1,
	MRN_FLAG_GLAZESTYLE = 1 << 2,
	MRN_FLAG_ROUNDNESS = 1 << 3,
	MRN_FLAG_MENUBARSTYLE = 1 << 4,
	MRN_FLAG_MENUBARITEMSTYLE = 1 << 5,
	MRN_FLAG_MENUSTYLE = 1 << 6,
	MRN_FLAG_MENUITEMSTYLE = 1 << 7,
	MRN_FLAG_LISTVIEWHEADERSTYLE = 1 << 8,
	MRN_FLAG_LISTVIEWSTYLE = 1 << 9,
	MRN_FLAG_SCROLLBARSTYLE = 1 << 10,
	MRN_FLAG_SCROLLBAR_COLOR = 1 << 11,
	MRN_FLAG_ANIMATION = 1 << 12,
	MRN_FLAG_GRADIENTS = 1 << 13,
} MurrineRcFlags;

struct _MurrineRcStyle
{
  GtkRcStyle parent_instance;

	MurrineRcFlags flags;

  GdkColor scrollbar_color;
  gboolean has_scrollbar_color;
  double contrast;
  double hilight_ratio;
  guint8 glazestyle;
  guint8 menubarstyle;
  guint8 menubaritemstyle;
  guint8 menustyle;
  guint8 menuitemstyle;
  guint8 listviewheaderstyle;
  guint8 listviewstyle;
  guint8 scrollbarstyle;
  guint8 roundness;
  gboolean animation;
  gboolean gradients;
};

struct _MurrineRcStyleClass
{
  GtkRcStyleClass parent_class;
};

G_GNUC_INTERNAL void murrine_rc_style_register_type (GTypeModule *module);
