// -*- C++ -*-

/* test_filelist.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <string>

#include "gtk--.h"
#include "gtk--/window.h"
#include "gtkextra--/gtkextra--.h"

using SigC::bind;
using SigC::slot;
using namespace Gtk;
using namespace GtkExtra;

void on_IconFileSel_destroy();
void on_IconFileSel_OK_clicked(GtkExtra::IconFileSel* pIconFileSel);

int main (int argc, char *argv[])
{
    // all GTK applications must have a gtk_main(). Control ends here
   // and waits for an event to occur (like a key press or mouse event).

   Gtk::Main kit(argc, argv);

   GtkExtra::IconFileSel iconFileSel("Open File");
   
   iconFileSel.destroy.connect(slot(&on_IconFileSel_destroy));
   
   Gtk::Button* pButtonOK = wrap(iconFileSel.get_ok_button());
   pButtonOK->clicked.connect(bind(slot(&on_IconFileSel_OK_clicked), &iconFileSel));

   iconFileSel.show();

   kit.run();
   return 0;
}

void
on_IconFileSel_destroy()
{
  Gtk::Main::quit();
}

void
on_IconFileSel_OK_clicked(GtkExtra::IconFileSel* pIconFileSel)
{
  GtkExtra::FileList* pFileList = wrap(pIconFileSel->get_file_list());
  std::string strPath = pFileList->get_path();
  //path = gtk_file_list_get_path(GTK_FILE_LIST(filesel->file_list));

  std::string strFile = pFileList->get_filename();
  //file = gtk_file_list_get_filename(GTK_FILE_LIST(filesel->file_list));

  if(strPath.size())
      printf("PATH: %s\n", strPath.c_str()); 
  if(strFile.size())
      printf("FILE: %s\n", strFile.c_str());
  
}
